/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.configuration2.reloading.CombinedReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCombinedReloadingController {
    private ReloadingController[] subControllers;

    private void initSubControllers() {
        this.subControllers = new ReloadingController[3];
        for (int i = 0; i < this.subControllers.length; ++i) {
            this.subControllers[i] = (ReloadingController)Mockito.mock(ReloadingController.class);
        }
    }

    private CombinedReloadingController setUpController() {
        this.initSubControllers();
        ArrayList<ReloadingController> lstCtrls = new ArrayList<ReloadingController>(Arrays.asList(this.subControllers));
        CombinedReloadingController result = new CombinedReloadingController(lstCtrls);
        lstCtrls.clear();
        return result;
    }

    @Test
    public void testCheckForReloadingFalse() {
        CombinedReloadingController ctrl = this.setUpController();
        for (ReloadingController rc : this.subControllers) {
            Mockito.when((Object)rc.checkForReloading(null)).thenReturn((Object)Boolean.FALSE);
        }
        Assertions.assertFalse((boolean)ctrl.checkForReloading((Object)"someParam"));
        for (ReloadingController rc : this.subControllers) {
            ((ReloadingController)Mockito.verify((Object)rc)).checkForReloading(null);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{rc});
        }
    }

    @Test
    public void testCheckForReloadingTrue() {
        CombinedReloadingController ctrl = this.setUpController();
        Mockito.when((Object)this.subControllers[0].checkForReloading(null)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.subControllers[1].checkForReloading(null)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.subControllers[2].checkForReloading(null)).thenReturn((Object)Boolean.FALSE);
        Assertions.assertTrue((boolean)ctrl.checkForReloading((Object)"someData"));
        for (ReloadingController rc : this.subControllers) {
            ((ReloadingController)Mockito.verify((Object)rc)).checkForReloading(null);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{rc});
        }
    }

    @Test
    public void testGetSubControllers() {
        CombinedReloadingController ctrl = this.setUpController();
        Collection subs = ctrl.getSubControllers();
        Assertions.assertIterableEquals(Arrays.asList(this.subControllers), (Iterable)subs);
    }

    @Test
    public void testGetSubControllersModify() {
        Collection subs = this.setUpController().getSubControllers();
        Assertions.assertThrows(UnsupportedOperationException.class, subs::clear);
    }

    @Test
    public void testInitNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CombinedReloadingController(null));
    }

    @Test
    public void testInitNullEntries() {
        this.initSubControllers();
        ArrayList<ReloadingController> ctrls = new ArrayList<ReloadingController>(Arrays.asList(this.subControllers));
        ctrls.add(null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CombinedReloadingController(ctrls));
    }

    @Test
    public void testResetInitialReloadingState() {
        CombinedReloadingController ctrl = this.setUpController();
        ctrl.resetInitialReloadingState();
        for (ReloadingController rc : this.subControllers) {
            ((ReloadingController)Mockito.verify((Object)rc)).resetReloadingState();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{rc});
        }
    }

    @Test
    public void testResetReloadingState() {
        CombinedReloadingController ctrl = this.setUpController();
        Mockito.when((Object)this.subControllers[0].checkForReloading(null)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.subControllers[1].checkForReloading(null)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.subControllers[2].checkForReloading(null)).thenReturn((Object)Boolean.FALSE);
        ctrl.checkForReloading(null);
        ctrl.resetReloadingState();
        for (ReloadingController rc : this.subControllers) {
            ((ReloadingController)Mockito.verify((Object)rc)).checkForReloading(null);
            ((ReloadingController)Mockito.verify((Object)rc)).resetReloadingState();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{rc});
        }
    }
}

