/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.output.CloseShieldWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class CloseShieldWriterTest {
    private StringBuilderWriter original;
    private Writer shielded;

    CloseShieldWriterTest() {
    }

    @BeforeEach
    public void setUp() {
        this.original = (StringBuilderWriter)Mockito.spy((Object)new StringBuilderWriter());
        this.shielded = CloseShieldWriter.wrap((Writer)this.original);
    }

    @Test
    void testClose() throws IOException {
        this.shielded.close();
        ((StringBuilderWriter)Mockito.verify((Object)this.original, (VerificationMode)Mockito.never())).close();
        Assertions.assertThrows(IOException.class, () -> this.shielded.write(120), (String)"write(c)");
        this.original.write(121);
        Assertions.assertEquals((int)1, (int)this.original.getBuilder().length());
        Assertions.assertEquals((char)'y', (char)this.original.toString().charAt(0));
    }
}

