/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.swing;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.swing.BorderTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TitledBorderTag
extends BorderTagSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$swing$TitledBorderTag == null ? (class$org$apache$commons$jelly$tags$swing$TitledBorderTag = TitledBorderTag.class$("org.apache.commons.jelly.tags.swing.TitledBorderTag")) : class$org$apache$commons$jelly$tags$swing$TitledBorderTag));
    private String title;
    private String titleJustification;
    private String titlePosition;
    private Border border;
    private Font font;
    private Color color;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$swing$TitledBorderTag;

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (this.title == null) {
            throw new MissingAttributeException("title");
        }
        super.doTag(output);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleJustification(String titleJustification) {
        this.titleJustification = titleJustification;
    }

    public void setTitlePosition(String titlePosition) {
        this.titlePosition = titlePosition;
    }

    protected Border createBorder() {
        if (this.border != null) {
            if (this.titleJustification != null && this.titlePosition != null) {
                int justification = this.asTitleJustification(this.titleJustification);
                int position = this.asTitlePosition(this.titlePosition);
                if (this.font != null) {
                    if (this.color != null) {
                        return BorderFactory.createTitledBorder(this.border, this.title, justification, position, this.font, this.color);
                    }
                    return BorderFactory.createTitledBorder(this.border, this.title, justification, position, this.font);
                }
                return BorderFactory.createTitledBorder(this.border, this.title, justification, position);
            }
            return BorderFactory.createTitledBorder(this.border, this.title);
        }
        return BorderFactory.createTitledBorder(this.title);
    }

    protected int asTitleJustification(String text) {
        if (text.equalsIgnoreCase("LEFT")) {
            return 1;
        }
        if (text.equalsIgnoreCase("CENTER")) {
            return 2;
        }
        if (text.equalsIgnoreCase("RIGHT")) {
            return 3;
        }
        if (text.equalsIgnoreCase("LEADING")) {
            return 4;
        }
        if (text.equalsIgnoreCase("TRAILING")) {
            return 5;
        }
        return 0;
    }

    protected int asTitlePosition(String text) {
        if (text.equalsIgnoreCase("ABOVE_TOP")) {
            return 1;
        }
        if (text.equalsIgnoreCase("TOP")) {
            return 2;
        }
        if (text.equalsIgnoreCase("BELOW_TOP")) {
            return 3;
        }
        if (text.equalsIgnoreCase("ABOVE_BOTTOM")) {
            return 4;
        }
        if (text.equalsIgnoreCase("BOTTOM")) {
            return 5;
        }
        if (text.equalsIgnoreCase("BELOW_BOTTOM")) {
            return 6;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

