/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.ThreadUtils;
import org.apache.commons.lang3.function.Predicates;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThreadUtilsTest
extends AbstractLangTest {
    ThreadUtilsTest() {
    }

    @Test
    void testAtLeastOneThreadExists() {
        Assertions.assertFalse((boolean)ThreadUtils.getAllThreads().isEmpty());
    }

    @Test
    void testAtLeastOneThreadGroupsExists() {
        Assertions.assertFalse((boolean)ThreadUtils.getAllThreadGroups().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testComplexThreadGroups() throws Exception {
        ThreadGroup threadGroup1 = new ThreadGroup("thread_group_1__");
        ThreadGroup threadGroup2 = new ThreadGroup("thread_group_2__");
        ThreadGroup threadGroup3 = new ThreadGroup(threadGroup2, "thread_group_3__");
        ThreadGroup threadGroup4 = new ThreadGroup(threadGroup2, "thread_group_4__");
        ThreadGroup threadGroup5 = new ThreadGroup(threadGroup1, "thread_group_5__");
        ThreadGroup threadGroup6 = new ThreadGroup(threadGroup4, "thread_group_6__");
        ThreadGroup threadGroup7 = new ThreadGroup(threadGroup4, "thread_group_7__");
        ThreadGroup threadGroup7Doubled = new ThreadGroup(threadGroup4, "thread_group_7__");
        List<ThreadGroup> threadGroups = Arrays.asList(threadGroup1, threadGroup2, threadGroup3, threadGroup4, threadGroup5, threadGroup6, threadGroup7, threadGroup7Doubled);
        TestThread t1 = new TestThread("thread1_X__");
        TestThread t2 = new TestThread(threadGroup1, "thread2_X__");
        TestThread t3 = new TestThread(threadGroup2, "thread3_X__");
        TestThread t4 = new TestThread(threadGroup3, "thread4_X__");
        TestThread t5 = new TestThread(threadGroup4, "thread5_X__");
        TestThread t6 = new TestThread(threadGroup5, "thread6_X__");
        TestThread t7 = new TestThread(threadGroup6, "thread7_X__");
        TestThread t8 = new TestThread(threadGroup4, "thread8_X__");
        TestThread t9 = new TestThread(threadGroup6, "thread9_X__");
        TestThread t10 = new TestThread(threadGroup3, "thread10_X__");
        TestThread t11 = new TestThread(threadGroup7, "thread11_X__");
        TestThread t11Doubled = new TestThread(threadGroup7Doubled, "thread11_X__");
        List<Thread> threads = Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t11Doubled);
        try {
            for (Thread thread : threads) {
                thread.start();
            }
            Assertions.assertTrue((ThreadUtils.getAllThreadGroups().size() >= 7 ? 1 : 0) != 0, (String)"getAllThreadGroups");
            Assertions.assertTrue((ThreadUtils.getAllThreads().size() >= 11 ? 1 : 0) != 0, (String)"getAllThreads");
            Assertions.assertTrue((ThreadUtils.findThreads((Predicate)Predicates.truePredicate()).size() >= 11 ? 1 : 0) != 0, (String)"findThreads(ThreadUtils.truePredicate())");
            Assertions.assertEquals((int)1, (int)ThreadUtils.findThreadsByName((String)t4.getName(), (String)threadGroup3.getName()).size());
            Assertions.assertEquals((int)0, (int)ThreadUtils.findThreadsByName((String)t4.getName(), (String)threadGroup2.getName()).size());
            Assertions.assertEquals((int)2, (int)ThreadUtils.findThreadsByName((String)t11.getName(), (String)threadGroup7.getName()).size());
        }
        finally {
            for (Thread thread : threads) {
                thread.interrupt();
                thread.join();
            }
            for (ThreadGroup threadGroup : threadGroups) {
                if (threadGroup.isDestroyed()) continue;
                threadGroup.destroy();
            }
        }
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new ThreadUtils());
        Constructor<?>[] cons = ThreadUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(ThreadUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(ThreadUtils.class.getModifiers()));
    }

    @Test
    void testDepreacted() {
        Assertions.assertNotNull((Object)ThreadUtils.ALWAYS_TRUE_PREDICATE);
        ThreadUtils.AlwaysTruePredicate tp = ThreadUtils.ALWAYS_TRUE_PREDICATE;
        Assertions.assertTrue((boolean)tp.test(null));
        Assertions.assertTrue((boolean)tp.test(new Thread()));
        ThreadUtils.AlwaysTruePredicate tgp = ThreadUtils.ALWAYS_TRUE_PREDICATE;
        Assertions.assertTrue((boolean)tgp.test(null));
        Assertions.assertTrue((boolean)tgp.test(new ThreadGroup("")));
    }

    @Test
    void testGetAllThreadGroupsDoesNotReturnNull() {
        Collection threads = ThreadUtils.getAllThreadGroups();
        Assertions.assertEquals((long)0L, (long)threads.stream().filter(Objects::isNull).count());
    }

    @Test
    void testGetAllThreadsDoesNotReturnNull() {
        Collection threads = ThreadUtils.getAllThreads();
        Assertions.assertEquals((long)0L, (long)threads.stream().filter(Objects::isNull).count());
    }

    @Test
    void testInvalidThreadId() {
        LangAssertions.assertIllegalArgumentException(() -> ThreadUtils.findThreadById((long)-5L));
    }

    @Test
    void testJoinDuration() throws InterruptedException {
        ThreadUtils.join((Thread)new Thread(), (Duration)Duration.ZERO);
        ThreadUtils.join((Thread)new Thread(), (Duration)Duration.ofMillis(1L));
    }

    @Test
    void testNoThread() {
        Assertions.assertEquals((int)0, (int)ThreadUtils.findThreadsByName((String)"some_thread_which_does_not_exist_18762ZucTT").size());
    }

    @Test
    void testNoThreadGroup() {
        Assertions.assertEquals((int)0, (int)ThreadUtils.findThreadGroupsByName((String)"some_thread_group_which_does_not_exist_18762ZucTTII").size());
    }

    @Test
    void testNullThreadGroupName() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadGroupsByName(null));
    }

    @Test
    void testNullThreadName() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadsByName(null));
    }

    @Test
    void testNullThreadThreadGroup1() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadsByName((String)"tname", (ThreadGroup)null));
    }

    @Test
    void testNullThreadThreadGroup2() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadById((long)1L, (ThreadGroup)null));
    }

    @Test
    void testNullThreadThreadGroup3() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadsByName(null, (ThreadGroup)null));
    }

    @Test
    void testNullThreadThreadGroupName1() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadsByName(null, (String)"tgname"));
    }

    @Test
    void testNullThreadThreadGroupName2() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadsByName((String)"tname", (String)null));
    }

    @Test
    void testNullThreadThreadGroupName3() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadsByName(null, (String)null));
    }

    @Test
    void testSleepDuration() throws InterruptedException {
        ThreadUtils.sleep((Duration)Duration.ZERO);
        ThreadUtils.sleep((Duration)Duration.ofMillis(1L));
    }

    @Test
    void testSystemThreadGroupExists() {
        ThreadGroup systemThreadGroup = ThreadUtils.getSystemThreadGroup();
        Assertions.assertNotNull((Object)systemThreadGroup);
        Assertions.assertNull((Object)systemThreadGroup.getParent());
        Assertions.assertEquals((Object)"system", (Object)systemThreadGroup.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testThreadGroups() throws InterruptedException {
        String threadGroupName = "thread_group_DDZZ99__for_testThreadGroups";
        ThreadGroup threadGroup = new ThreadGroup("thread_group_DDZZ99__for_testThreadGroups");
        TestThread t1 = new TestThread(threadGroup, "thread1_XXOOPP__");
        TestThread t2 = new TestThread(threadGroup, "thread2_XXOOPP__");
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assertions.assertEquals((int)1, (int)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__").size());
            Assertions.assertEquals((int)1, (int)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__", (String)"thread_group_DDZZ99__for_testThreadGroups").size());
            Assertions.assertEquals((int)1, (int)ThreadUtils.findThreadsByName((String)"thread2_XXOOPP__", (String)"thread_group_DDZZ99__for_testThreadGroups").size());
            Assertions.assertEquals((int)0, (int)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__", (String)"non_existent_thread_group_JJHHZZ__").size());
            Assertions.assertEquals((int)0, (int)ThreadUtils.findThreadsByName((String)"non_existent_thread_BBDDWW__", (String)"thread_group_DDZZ99__for_testThreadGroups").size());
            Assertions.assertEquals((int)1, (int)ThreadUtils.findThreadGroupsByName((String)"thread_group_DDZZ99__for_testThreadGroups").size());
            Assertions.assertEquals((int)0, (int)ThreadUtils.findThreadGroupsByName((String)"non_existent_thread_group_JJHHZZ__").size());
            Assertions.assertNotNull((Object)ThreadUtils.findThreadById((long)t1.getId(), (ThreadGroup)threadGroup));
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
            threadGroup.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testThreadGroupsById() throws InterruptedException {
        String threadGroupName = "thread_group_DDZZ99__for_testThreadGroupsById";
        ThreadGroup threadGroup = new ThreadGroup("thread_group_DDZZ99__for_testThreadGroupsById");
        TestThread t1 = new TestThread(threadGroup, "thread1_XXOOPP__");
        TestThread t2 = new TestThread(threadGroup, "thread2_XXOOPP__");
        long nonExistingId = t1.getId() + t2.getId();
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assertions.assertSame((Object)t1, (Object)ThreadUtils.findThreadById((long)t1.getId(), (String)"thread_group_DDZZ99__for_testThreadGroupsById"));
            Assertions.assertSame((Object)t2, (Object)ThreadUtils.findThreadById((long)t2.getId(), (String)"thread_group_DDZZ99__for_testThreadGroupsById"));
            Assertions.assertNull((Object)ThreadUtils.findThreadById((long)nonExistingId, (String)"non_existent_thread_group_JJHHZZ__"));
            Assertions.assertNull((Object)ThreadUtils.findThreadById((long)nonExistingId, (String)"thread_group_DDZZ99__for_testThreadGroupsById"));
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
            threadGroup.destroy();
        }
    }

    @Test
    void testThreadGroupsByIdFail() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadById((long)Thread.currentThread().getId(), (String)null));
    }

    @Test
    void testThreadGroupsNullParent() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadGroups(null, (boolean)true, (Predicate)Predicates.truePredicate()));
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadGroups(null, (boolean)false, (Predicate)Predicates.truePredicate()));
    }

    @Test
    void testThreadGroupsNullPredicate() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadGroups((ThreadUtils.ThreadGroupPredicate)null));
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadGroups((Predicate)null));
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreadGroups((Predicate)null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testThreadGroupsRef() throws InterruptedException {
        ThreadGroup threadGroup = new ThreadGroup("thread_group_DDZZ99__");
        ThreadGroup deadThreadGroup = new ThreadGroup("dead_thread_group_MMQQSS__");
        deadThreadGroup.destroy();
        TestThread t1 = new TestThread(threadGroup, "thread1_XXOOPP__");
        TestThread t2 = new TestThread(threadGroup, "thread2_XXOOPP__");
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assertions.assertEquals((int)1, (int)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__").size());
            Assertions.assertEquals((int)1, (int)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__", (ThreadGroup)threadGroup).size());
            Assertions.assertEquals((int)1, (int)ThreadUtils.findThreadsByName((String)"thread2_XXOOPP__", (ThreadGroup)threadGroup).size());
            Assertions.assertEquals((int)0, (int)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__", (ThreadGroup)deadThreadGroup).size());
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
            threadGroup.destroy();
            Assertions.assertEquals((int)0, (int)ThreadUtils.findThreadsByName((String)"thread2_XXOOPP__", (ThreadGroup)threadGroup).size());
        }
    }

    @Test
    void testThreads() throws InterruptedException {
        TestThread t1 = new TestThread("thread1_XXOOLL__");
        TestThread t2 = new TestThread("thread2_XXOOLL__");
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assertions.assertEquals((int)1, (int)ThreadUtils.findThreadsByName((String)"thread2_XXOOLL__").size());
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
        }
    }

    @Test
    void testThreadsById() throws InterruptedException {
        TestThread t1 = new TestThread("thread1_XXOOLL__");
        TestThread t2 = new TestThread("thread2_XXOOLL__");
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assertions.assertSame((Object)t1, (Object)ThreadUtils.findThreadById((long)t1.getId()));
            Assertions.assertSame((Object)t2, (Object)ThreadUtils.findThreadById((long)t2.getId()));
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
        }
    }

    @Test
    void testThreadsByIdWrongGroup() throws InterruptedException {
        TestThread t1 = new TestThread("thread1_XXOOLL__");
        ThreadGroup tg = new ThreadGroup("tg__HHEE22");
        try {
            ((Thread)t1).start();
            Assertions.assertNull((Object)ThreadUtils.findThreadById((long)t1.getId(), (ThreadGroup)tg));
        }
        finally {
            t1.interrupt();
            t1.join();
            tg.destroy();
        }
    }

    @Test
    void testThreadsNullPredicate() {
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreads((ThreadUtils.ThreadPredicate)null));
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreads((Predicate)null));
        LangAssertions.assertNullPointerException(() -> ThreadUtils.findThreads((Predicate)null));
    }

    @Test
    void testThreadsSameName() throws InterruptedException {
        TestThread t1 = new TestThread("thread1_XXOOLL__");
        TestThread alsot1 = new TestThread("thread1_XXOOLL__");
        try {
            ((Thread)t1).start();
            ((Thread)alsot1).start();
            Assertions.assertEquals((int)2, (int)ThreadUtils.findThreadsByName((String)"thread1_XXOOLL__").size());
        }
        finally {
            t1.interrupt();
            alsot1.interrupt();
            t1.join();
            alsot1.join();
        }
    }

    private static final class TestThread
    extends Thread {
        private final CountDownLatch latch = new CountDownLatch(1);

        TestThread(String name) {
            super(name);
        }

        TestThread(ThreadGroup group, String name) {
            super(group, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.latch.countDown();
            try {
                TestThread testThread = this;
                synchronized (testThread) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public synchronized void start() {
            super.start();
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

