/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

public final class VersionInfo {
    private final Package pkg;

    public static void main(String[] args) {
        VersionInfo versionInfo = new VersionInfo();
        System.out.println(versionInfo);
        System.out.println("title: " + versionInfo.getTitle());
        System.out.println("version: " + versionInfo.getVersion());
        System.out.println("vendor: " + versionInfo.getVendor());
        System.out.println("spec title: " + versionInfo.getSpecTitle());
        System.out.println("spec version: " + versionInfo.getSpecVersion());
        System.out.println("spec vendor: " + versionInfo.getSpecVendor());
    }

    private String orDefault(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public VersionInfo() {
        this(VersionInfo.class);
    }

    public VersionInfo(Class<?> clazz) {
        this.pkg = clazz.getPackage();
    }

    public String toString() {
        return String.format("%s %s (%s)", this.getTitle(), this.getVersion(), this.getVendor());
    }

    public String getVersion() {
        return this.orDefault(this.pkg.getImplementationVersion(), "VERSION-NUMBER");
    }

    public String getVendor() {
        return this.orDefault(this.pkg.getImplementationVendor(), "VENDOR-NAME");
    }

    public String getTitle() {
        return this.orDefault(this.pkg.getImplementationTitle(), "TITLE");
    }

    public String getSpecVersion() {
        return this.orDefault(this.pkg.getSpecificationVersion(), "SPEC-VERSION");
    }

    public String getSpecVendor() {
        return this.orDefault(this.pkg.getSpecificationVendor(), "SPEC-VENDOR");
    }

    public String getSpecTitle() {
        return this.orDefault(this.pkg.getSpecificationTitle(), "SPEC-TITLE");
    }
}

