/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.configuration.controller.OutletReference;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.control.Checksums;
import org.apache.torque.generator.option.Option;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.option.Options;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.variable.VariableStore;

public class ControllerState {
    private SourceProvider sourceProvider;
    private Output output;
    private final List<Outlet> outlets = new ArrayList<Outlet>();
    private Object modelRoot;
    private Object model;
    private String pathToModel = "/";
    private UnitConfiguration unitConfiguration;
    private OutletReference rootOutletReference;
    private final VariableStore variableStore = new VariableStore();
    private File outputFile;
    private File sourceFile;
    private Namespace outletNamespace;
    private final Checksums lastGeneratedSourceChecksums = new Checksums();
    private final Checksums thisGenerationSourceChecksums = new Checksums();

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    public Output getOutput() {
        return this.output;
    }

    void setOutput(Output output) {
        this.output = output;
    }

    public Outlet getOutlet() {
        if (this.outlets.isEmpty()) {
            return null;
        }
        return this.outlets.get(this.outlets.size() - 1);
    }

    public void pushOutlet(Outlet outlet) {
        if (outlet == null) {
            throw new NullPointerException("outlet must not be null");
        }
        this.outlets.add(outlet);
    }

    public Outlet popOutlet() {
        return this.outlets.remove(this.outlets.size() - 1);
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object model, String newPathToModel) {
        this.model = model;
        if (newPathToModel != null) {
            if (model instanceof SourceElement && newPathToModel.startsWith("/")) {
                int slashIndex = newPathToModel.indexOf(47, 1);
                newPathToModel = slashIndex != -1 ? newPathToModel.substring(slashIndex + 1) : "/";
            }
            this.pathToModel = StringUtils.isEmpty((CharSequence)newPathToModel) ? "/" : newPathToModel;
        }
    }

    public String getPathToModel() {
        return this.pathToModel;
    }

    public void setPathToModel(String pathToModel) {
        if (pathToModel == null) {
            throw new NullPointerException("pathToModel must not be null");
        }
        this.pathToModel = pathToModel;
    }

    public Object getModelRoot() {
        return this.modelRoot;
    }

    public void setModelRoot(Object modelRoot) {
        this.modelRoot = modelRoot;
    }

    public OutletReference getRootOutletReference() {
        return this.rootOutletReference;
    }

    void setRootOutletReference(OutletReference rootOutletReference) {
        this.rootOutletReference = rootOutletReference;
    }

    void setOutletNamespace(Namespace namespace) {
        this.outletNamespace = namespace;
    }

    public Namespace getOutletNamespace() {
        return this.outletNamespace;
    }

    public Object getOption(String name) {
        Options options = this.unitConfiguration.getOptions();
        QualifiedName qualifiedName = this.getQualifiedName(name);
        Option option = options.getInHierarchy(qualifiedName);
        Object result = null;
        if (option != null) {
            result = option.getValue();
        }
        return result;
    }

    public Object getOption(OptionName optionName) {
        return this.getOption(optionName.getName());
    }

    public boolean getBooleanOption(String name) {
        Object option = this.getOption(name);
        if (option == null) {
            return false;
        }
        return Boolean.parseBoolean(option.toString().trim());
    }

    public boolean getBooleanOption(OptionName optionName) {
        return this.getBooleanOption(optionName.getName());
    }

    public String getStringOption(String name) {
        Object option = this.getOption(name);
        if (option == null) {
            return null;
        }
        return option.toString();
    }

    public String getStringOption(OptionName optionName) {
        return this.getStringOption(optionName.getName());
    }

    public Options getVisibleOptions() {
        return this.unitConfiguration.getOptions().getInHierarchy(this.outletNamespace);
    }

    public VariableStore getVariableStore() {
        return this.variableStore;
    }

    public QualifiedName getQualifiedName(String name) {
        QualifiedName qualifiedName = new QualifiedName(name, this.outletNamespace);
        return qualifiedName;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    void setOutputFile(File outputFilePath) {
        this.outputFile = outputFilePath;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public UnitConfiguration getUnitConfiguration() {
        return this.unitConfiguration;
    }

    public void setUnitConfiguration(UnitConfiguration unitConfiguration) {
        this.unitConfiguration = unitConfiguration;
    }

    public Checksums getLastGeneratedSourceChecksums() {
        return this.lastGeneratedSourceChecksums;
    }

    public Checksums getThisGenerationSourceChecksums() {
        return this.thisGenerationSourceChecksums;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("sourceProvider=").append(this.sourceProvider).append("output=").append(this.output).append("outputFilePath=").append(this.outputFile).append("\noutletNamespace=").append(this.outletNamespace).append("\noutlets=").append(this.outlets).append("\nmodelRoot=").append(this.modelRoot).append("\nmodel").append(this.model).append("\nrootOutletReference=").append(this.rootOutletReference).append("\nunitConfiguration=").append(this.unitConfiguration).append("\nvariableStore=").append(this.variableStore);
        return result.toString();
    }
}

