/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.listener.request;

import java.lang.annotation.Annotation;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.impl.scope.DeltaSpikeContextExtension;
import org.apache.deltaspike.core.impl.scope.viewaccess.ViewAccessContext;
import org.apache.deltaspike.core.spi.scope.window.WindowContext;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.jsf.impl.listener.request.JsfRequestBroadcaster;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindow;

class DeltaSpikeLifecycleWrapper
extends Lifecycle {
    private final Lifecycle wrapped;
    private JsfRequestBroadcaster jsfRequestBroadcaster;
    private ClientWindow clientWindow;
    private WindowContext windowContext;
    private DeltaSpikeContextExtension contextExtension;
    private volatile Boolean initialized;

    DeltaSpikeLifecycleWrapper(Lifecycle wrapped) {
        this.wrapped = wrapped;
    }

    Lifecycle getWrapped() {
        return this.wrapped;
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        this.wrapped.addPhaseListener(phaseListener);
    }

    public void execute(FacesContext facesContext) {
        if (facesContext.getResponseComplete()) {
            return;
        }
        this.lazyInit();
        this.broadcastInitializedJsfRequestEvent(facesContext);
        String windowId = this.clientWindow.getWindowId(facesContext);
        if (windowId != null) {
            this.windowContext.activateWindow(windowId);
        }
        if (!FacesContext.getCurrentInstance().getResponseComplete()) {
            this.wrapped.execute(facesContext);
        }
    }

    public PhaseListener[] getPhaseListeners() {
        return this.wrapped.getPhaseListeners();
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        this.wrapped.removePhaseListener(phaseListener);
    }

    public void render(FacesContext facesContext) {
        ViewAccessContext viewAccessContext;
        this.wrapped.render(facesContext);
        if (facesContext.getViewRoot() != null && facesContext.getViewRoot().getViewId() != null && (viewAccessContext = this.contextExtension.getViewAccessScopedContext()) != null) {
            viewAccessContext.onProcessingViewFinished(facesContext.getViewRoot().getViewId());
        }
    }

    private void broadcastInitializedJsfRequestEvent(FacesContext facesContext) {
        if (this.jsfRequestBroadcaster != null) {
            this.jsfRequestBroadcaster.broadcastInitializedJsfRequestEvent(facesContext);
        }
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized == null) {
            if (ClassDeactivationUtils.isActivated(JsfRequestBroadcaster.class)) {
                this.jsfRequestBroadcaster = (JsfRequestBroadcaster)BeanProvider.getContextualReference(JsfRequestBroadcaster.class, (boolean)true, (Annotation[])new Annotation[0]);
            }
            this.clientWindow = (ClientWindow)BeanProvider.getContextualReference(ClientWindow.class, (boolean)true, (Annotation[])new Annotation[0]);
            this.windowContext = (WindowContext)BeanProvider.getContextualReference(WindowContext.class, (boolean)true, (Annotation[])new Annotation[0]);
            this.contextExtension = (DeltaSpikeContextExtension)BeanProvider.getContextualReference(DeltaSpikeContextExtension.class, (boolean)true, (Annotation[])new Annotation[0]);
            this.initialized = true;
        }
    }
}

