/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;

@Typed
public abstract class ServiceUtils {
    private static final Logger LOG = Logger.getLogger(ServiceUtils.class.getName());

    private ServiceUtils() {
    }

    public static <T> List<T> loadServiceImplementations(Class<T> serviceType) {
        return ServiceUtils.loadServiceImplementations(serviceType, false);
    }

    public static <T> List<T> loadServiceImplementations(Class<T> serviceType, boolean ignoreServicesWithMissingDependencies) {
        return ServiceUtils.loadServiceImplementations(serviceType, ignoreServicesWithMissingDependencies, null);
    }

    public static <T> List<T> loadServiceImplementations(Class<T> serviceType, boolean ignoreServicesWithMissingDependencies, ClassLoader classLoader) {
        ArrayList<T> result = new ArrayList<T>();
        Iterator<T> servicesIterator = classLoader != null ? ServiceLoader.load(serviceType, classLoader).iterator() : ServiceLoader.load(serviceType).iterator();
        if (!servicesIterator.hasNext()) {
            ClassLoader fallbackClassLoader = ServiceUtils.class.getClassLoader();
            servicesIterator = ServiceLoader.load(serviceType, fallbackClassLoader).iterator();
        }
        while (servicesIterator.hasNext()) {
            try {
                T service = servicesIterator.next();
                if (service instanceof Deactivatable && !ClassDeactivationUtils.isActivated(service.getClass())) {
                    LOG.info("deactivated service: " + service.getClass().getName());
                    continue;
                }
                result.add(service);
            }
            catch (Throwable t) {
                if (!ignoreServicesWithMissingDependencies) {
                    throw ExceptionUtils.throwAsRuntimeException(t);
                }
                LOG.info("service filtered - caused by " + t.getMessage());
            }
        }
        return result;
    }
}

