/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = File.separator;

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        return this.openNativeChooserDialog();
    }

    String openNativeChooserDialog() {
        int response;
        byte[] titleBytes = Converter.wcsToMbcs(this.title, true);
        long shellHandle = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long handle = 0L;
        handle = GTK.gtk_file_chooser_native_new(titleBytes, shellHandle, 2, null, null);
        if (handle == 0L) {
            this.error(2);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(this.filterPath);
            byte[] buffer = Converter.wcsToMbcs(stringBuilder.toString(), true);
            long ptr = OS.realpath(buffer, null);
            if (ptr != 0L) {
                if (GTK.GTK4) {
                    long file = OS.g_file_new_for_path(buffer);
                    GTK.gtk_file_chooser_set_current_folder(handle, file, 0L);
                    OS.g_object_unref(file);
                } else {
                    GTK.gtk_file_chooser_set_current_folder(handle, ptr);
                }
                OS.g_free(ptr);
            }
        }
        if (this.message.length() > 0) {
            long label;
            byte[] buffer = Converter.wcsToMbcs(this.message, true);
            long box = GTK.gtk_box_new(0, 0);
            if (box == 0L) {
                this.error(2);
            }
            if ((label = GTK.gtk_label_new(buffer)) == 0L) {
                this.error(2);
            }
            if (GTK.GTK4) {
                GTK.gtk_box_append(box, label);
                GTK.gtk_label_set_wrap(label, true);
            } else {
                GTK.gtk_container_add(box, label);
                GTK.gtk_widget_show(label);
                GTK.gtk_label_set_line_wrap(label, true);
            }
            GTK.gtk_box_set_homogeneous(box, false);
            GTK.gtk_label_set_justify(label, 2);
            GTK.gtk_file_chooser_set_extra_widget(handle, box);
        }
        String answer = null;
        display.addIdleProc();
        int signalId = 0;
        long hookId = 0L;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, handle, 0L);
        }
        if (GTK.GTK4) {
            response = SyncDialogUtil.run(display, handle, true);
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            response = GTK.gtk_native_dialog_run(handle);
            GDK.gdk_threads_leave();
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (response == -3) {
            long path;
            if (GTK.GTK4) {
                long file = GTK.gtk_file_chooser_get_file(handle);
                path = OS.g_file_get_path(file);
            } else {
                path = GTK.gtk_file_chooser_get_filename(handle);
            }
            if (path != 0L) {
                long utf8Ptr = OS.g_filename_to_utf8(path, -1L, null, null, null);
                if (utf8Ptr == 0L) {
                    utf8Ptr = OS.g_filename_display_name(path);
                }
                if (path != utf8Ptr) {
                    OS.g_free(path);
                }
                if (utf8Ptr != 0L) {
                    long[] items_written = new long[1];
                    long utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1L, null, items_written, null);
                    OS.g_free(utf8Ptr);
                    if (utf16Ptr != 0L) {
                        int clength = (int)items_written[0];
                        char[] chars = new char[clength];
                        C.memmove(chars, utf16Ptr, (long)(clength * 2));
                        OS.g_free(utf16Ptr);
                        this.filterPath = answer = new String(chars);
                    }
                }
            }
        }
        display.removeIdleProc();
        return answer;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

