/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.jobs;

import javax.net.ssl.SSLSession;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;

public class CheckNetworkParameterRunnable
implements StudioConnectionRunnableWithProgress {
    private Connection connection;
    private SSLSession sslSession;

    public CheckNetworkParameterRunnable(Connection connection) {
        this.connection = connection;
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.connection};
    }

    public String getName() {
        return Messages.jobs__check_network_name;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(Messages.jobs__check_network_task, 3);
        monitor.reportProgress(" ");
        monitor.worked(1);
        this.connection.getConnectionWrapper().connect(monitor);
        this.sslSession = this.connection.getConnectionWrapper().getSslSession();
        this.connection.getConnectionWrapper().disconnect();
    }

    public String getErrorMessage() {
        return Messages.jobs__check_network_error;
    }

    @Override
    public Connection[] getConnections() {
        return null;
    }

    public SSLSession getSslSession() {
        return this.sslSession;
    }
}

