/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JDIDebugBreakpointMessages;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.core.model.MethodResult;
import org.eclipse.osgi.util.NLS;

public class JavaExceptionBreakpoint
extends JavaBreakpoint
implements IJavaExceptionBreakpoint {
    public static final String JAVA_EXCEPTION_BREAKPOINT = "org.eclipse.jdt.debug.javaExceptionBreakpointMarker";
    protected static final String CAUGHT = "org.eclipse.jdt.debug.core.caught";
    protected static final String UNCAUGHT = "org.eclipse.jdt.debug.core.uncaught";
    protected static final String CHECKED = "org.eclipse.jdt.debug.core.checked";
    protected static final String INCLUSION_FILTERS = "org.eclipse.jdt.debug.core.inclusion_filters";
    protected static final String EXCLUSION_FILTERS = "org.eclipse.jdt.debug.core.exclusion_filters";
    protected static final String SUSPEND_ON_SUBCLASSES = "org.eclipse.jdt.debug.core.suspend_on_subclasses";
    protected static final String SUSPEND_ON_RECURRENCE = "org.eclipse.jdt.debug.core.suspend_on_recurrence";
    protected String fExceptionName = null;
    protected String[] fInclusionClassFilters = null;
    protected String[] fExclusionClassFilters = null;
    private ObjectReference fLastException;
    private JDIDebugTarget fLastTarget;

    public JavaExceptionBreakpoint() {
    }

    public JavaExceptionBreakpoint(IResource resource, String exceptionName, boolean caught, boolean uncaught, boolean checked, boolean add, Map<String, Object> attributes) throws DebugException {
        IWorkspaceRunnable wr = monitor -> {
            this.setMarker(resource.createMarker(JAVA_EXCEPTION_BREAKPOINT));
            attributes.put("org.eclipse.debug.core.id", this.getModelIdentifier());
            attributes.put("org.eclipse.jdt.debug.core.typeName", exceptionName);
            attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
            attributes.put(CAUGHT, caught);
            attributes.put(UNCAUGHT, uncaught);
            attributes.put(CHECKED, checked);
            attributes.put("org.eclipse.jdt.debug.core.suspendPolicy", this.getDefaultSuspendPolicy());
            this.ensureMarker().setAttributes(attributes);
            this.register(add);
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    @Override
    protected EventRequest[] newRequests(JDIDebugTarget target, ReferenceType type) throws CoreException {
        if (!this.isCaught() && !this.isUncaught()) {
            return null;
        }
        ExceptionRequest request = null;
        EventRequestManager manager = target.getEventRequestManager();
        if (manager == null) {
            target.requestFailed(JDIDebugBreakpointMessages.JavaExceptionBreakpoint_Unable_to_create_breakpoint_request___VM_disconnected__1, new VMDisconnectedException());
            return null;
        }
        try {
            request = manager.createExceptionRequest(type, this.isCaught(), this.isUncaught());
            this.configureRequest(request, target);
        }
        catch (VMDisconnectedException e) {
            if (target.isAvailable()) {
                JDIDebugPlugin.log(e);
            }
            return null;
        }
        catch (RuntimeException e) {
            target.internalError(e);
            return null;
        }
        return new EventRequest[]{request};
    }

    @Override
    public void setEnabled(boolean enabled) throws CoreException {
        if (enabled && !this.isCaught() && !this.isUncaught()) {
            this.setAttributes(new String[]{CAUGHT, UNCAUGHT}, new Object[]{Boolean.TRUE, Boolean.TRUE});
        }
        super.setEnabled(enabled);
    }

    protected void setCaughtAndUncaught(boolean caught, boolean uncaught) throws CoreException {
        Object[] values = new Object[]{caught, uncaught};
        String[] attributes = new String[]{CAUGHT, UNCAUGHT};
        this.setAttributes(attributes, values);
    }

    @Override
    public boolean isCaught() throws CoreException {
        return this.ensureMarker().getAttribute(CAUGHT, false);
    }

    @Override
    public void setCaught(boolean caught) throws CoreException {
        if (caught == this.isCaught()) {
            return;
        }
        this.setAttribute(CAUGHT, caught);
        if (caught && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!caught && !this.isUncaught()) {
            this.setEnabled(false);
        }
        this.recreate();
    }

    public void setSuspendOnSubclasses(boolean suspend) throws CoreException {
        if (suspend != this.isSuspendOnSubclasses()) {
            this.setAttribute(SUSPEND_ON_SUBCLASSES, suspend);
            this.recreate();
        }
    }

    public boolean isSuspendOnSubclasses() throws CoreException {
        return this.ensureMarker().getAttribute(SUSPEND_ON_SUBCLASSES, false);
    }

    @Override
    public boolean isUncaught() throws CoreException {
        return this.ensureMarker().getAttribute(UNCAUGHT, false);
    }

    @Override
    public void setUncaught(boolean uncaught) throws CoreException {
        if (uncaught == this.isUncaught()) {
            return;
        }
        this.setAttribute(UNCAUGHT, uncaught);
        if (uncaught && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!uncaught && !this.isCaught()) {
            this.setEnabled(false);
        }
        this.recreate();
    }

    @Override
    public IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy getSuspendOnRecurrenceStrategy() throws CoreException {
        IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy defaultStrategy = JavaExceptionBreakpoint.getWorkspaceSuspendOnRecurrenceStrategy();
        int valueIndex = this.ensureMarker().getAttribute(SUSPEND_ON_RECURRENCE, defaultStrategy.ordinal());
        return IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.values()[valueIndex];
    }

    @Override
    public void setSuspendOnRecurrenceStrategy(IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy strategy) throws CoreException {
        this.setAttribute(SUSPEND_ON_RECURRENCE, strategy.ordinal());
    }

    @Override
    public boolean isChecked() throws CoreException {
        return this.ensureMarker().getAttribute(CHECKED, false);
    }

    @Override
    protected void setRequestThreadFilter(EventRequest request, ThreadReference thread) {
        ((ExceptionRequest)request).addThreadFilter(thread);
    }

    @Override
    public boolean handleBreakpointEvent(Event event, JDIThread thread, boolean suspendVote) {
        boolean result = this.handleBreakpointEventInternal(event, thread, suspendVote);
        if (!result && event instanceof ExceptionEvent) {
            ExceptionEvent exceptionEvent = (ExceptionEvent)event;
            thread.setMethodResult(new MethodResult(exceptionEvent.location().method(), -1, exceptionEvent.exception(), MethodResult.ResultType.throwing));
        }
        return result;
    }

    private boolean handleBreakpointEventInternal(Event event, JDIThread thread, boolean suspendVote) {
        if (event instanceof ExceptionEvent) {
            IBreakpoint[] allBreakpoints;
            ObjectReference ex = ((ExceptionEvent)event).exception();
            this.fLastTarget = thread.getJavaDebugTarget();
            this.fLastException = ex;
            String name = null;
            try {
                name = ex.type().name();
                if (!name.equals(this.getTypeName()) && !this.isSuspendOnSubclasses() & this.isSubclass((ClassType)ex.type(), this.getTypeName())) {
                    return true;
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                return true;
            }
            catch (CoreException e) {
                JDIDebugPlugin.log(e);
            }
            catch (RuntimeException e) {
                try {
                    thread.targetRequestFailed(e.getMessage(), e);
                }
                catch (DebugException debugException) {
                    JDIDebugPlugin.log(e);
                    return false;
                }
            }
            this.setExceptionName(name);
            this.disableTriggerPoint(event);
            IBreakpoint[] iBreakpointArray = allBreakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            int n = allBreakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint iBreakpoint = iBreakpointArray[n2];
                if (iBreakpoint instanceof JavaExceptionBreakpoint) {
                    JavaExceptionBreakpoint jExceptionBreakpoint = (JavaExceptionBreakpoint)iBreakpoint;
                    try {
                        if (jExceptionBreakpoint.getTypeName().equals(name) && (jExceptionBreakpoint.getExclusionClassFilters().length >= 1 || jExceptionBreakpoint.getInclusionClassFilters().length >= 1 || this.filtersIncludeDefaultPackage(jExceptionBreakpoint.fInclusionClassFilters) || this.filtersIncludeDefaultPackage(jExceptionBreakpoint.fExclusionClassFilters))) {
                            Location location = ((ExceptionEvent)event).location();
                            String typeName = location.declaringType().name();
                            boolean defaultPackage = typeName.indexOf(46) == -1;
                            boolean included = true;
                            String[] filters = jExceptionBreakpoint.getInclusionClassFilters();
                            if (filters.length > 0) {
                                included = this.matchesFilters(filters, typeName, defaultPackage);
                            }
                            boolean excluded = false;
                            filters = jExceptionBreakpoint.getExclusionClassFilters();
                            if (filters.length > 0) {
                                excluded = this.matchesFilters(filters, typeName, defaultPackage);
                            }
                            if (included && !excluded) {
                                return !this.suspend(thread, suspendVote);
                            }
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            return !this.suspend(thread, suspendVote);
        }
        return true;
    }

    private boolean isSubclass(ClassType type, String typeName) {
        type = type.superclass();
        while (type != null) {
            if (type.name().equals(typeName)) {
                return true;
            }
            type = type.superclass();
        }
        return false;
    }

    @Override
    protected void setInstalledIn(IJavaDebugTarget target, boolean installed) {
        this.fLastException = null;
        this.fLastTarget = null;
        super.setInstalledIn(target, installed);
    }

    protected boolean filtersIncludeDefaultPackage(String[] filters) {
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (filter.length() == 0 || filter.indexOf(46) == -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean matchesFilters(String[] filters, String typeName, boolean defaultPackage) {
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter2;
            String filter = filter2 = stringArray[n2];
            if (defaultPackage && filter.length() == 0) {
                return true;
            }
            filter = filter.replaceAll("\\.", "\\\\.");
            Pattern pattern = Pattern.compile(filter = filter.replaceAll("\\*", "\\.\\*"));
            if (pattern.matcher(typeName).find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void setExceptionName(String name) {
        this.fExceptionName = name;
    }

    @Override
    public String getExceptionTypeName() {
        return this.fExceptionName;
    }

    @Override
    @Deprecated
    public String[] getFilters() {
        String[] iFilters = this.getInclusionFilters();
        String[] eFilters = this.getExclusionFilters();
        String[] filters = new String[iFilters.length + eFilters.length];
        System.arraycopy(iFilters, 0, filters, 0, iFilters.length);
        System.arraycopy(eFilters, 0, filters, iFilters.length, eFilters.length);
        return filters;
    }

    @Override
    @Deprecated
    public void setFilters(String[] filters, boolean inclusive) throws CoreException {
        if (inclusive) {
            this.setInclusionFilters(filters);
        } else {
            this.setExclusionFilters(filters);
        }
        this.recreate();
    }

    @Override
    protected void configureRequest(EventRequest eRequest, JDIDebugTarget target) throws CoreException {
        String[] iFilters = this.getInclusionClassFilters();
        String[] eFilters = this.getExclusionClassFilters();
        ExceptionRequest request = (ExceptionRequest)eRequest;
        if (iFilters.length == 1) {
            if (eFilters.length == 0) {
                request.addClassFilter(iFilters[0]);
            }
        } else if (eFilters.length == 1 && iFilters.length == 0) {
            request.addClassExclusionFilter(eFilters[0]);
        }
        super.configureRequest(eRequest, target);
    }

    protected String serializeList(String[] list) {
        if (list == null) {
            return "";
        }
        HashSet<String> set = new HashSet<String>(list.length);
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            String pattern;
            if (i > 0 && i < list.length) {
                buffer.append(',');
            }
            if (!set.contains(pattern = list[i])) {
                if (pattern.length() == 0) {
                    pattern = ".";
                }
                buffer.append(pattern);
                set.add(pattern);
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(".")) {
                token = "";
            }
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    @Deprecated
    public boolean isInclusiveFiltered() throws CoreException {
        return this.ensureMarker().getAttribute(INCLUSION_FILTERS, "").length() > 0;
    }

    protected String[] getInclusionClassFilters() {
        if (this.fInclusionClassFilters == null) {
            try {
                this.fInclusionClassFilters = this.parseList(this.ensureMarker().getAttribute(INCLUSION_FILTERS, ""));
            }
            catch (CoreException coreException) {
                this.fInclusionClassFilters = new String[0];
            }
        }
        return this.fInclusionClassFilters;
    }

    protected void setInclusionClassFilters(String[] filters) {
        this.fInclusionClassFilters = filters;
    }

    protected String[] getExclusionClassFilters() {
        if (this.fExclusionClassFilters == null) {
            try {
                this.fExclusionClassFilters = this.parseList(this.ensureMarker().getAttribute(EXCLUSION_FILTERS, ""));
            }
            catch (CoreException coreException) {
                this.fExclusionClassFilters = new String[0];
            }
        }
        return this.fExclusionClassFilters;
    }

    protected void setExclusionClassFilters(String[] filters) {
        this.fExclusionClassFilters = filters;
    }

    @Override
    protected boolean installableReferenceType(ReferenceType type, JDIDebugTarget target) throws CoreException {
        String installableType = this.getTypeName();
        String queriedType = type.name();
        if (installableType == null || queriedType == null) {
            return false;
        }
        if (installableType.equals(queriedType)) {
            return this.queryInstallListeners(target, type);
        }
        return false;
    }

    @Override
    public String[] getExclusionFilters() {
        return this.getExclusionClassFilters();
    }

    @Override
    public String[] getInclusionFilters() {
        return this.getInclusionClassFilters();
    }

    @Override
    public void setExclusionFilters(String[] filters) throws CoreException {
        String serializedFilters = this.serializeList(filters);
        if (serializedFilters.equals(this.ensureMarker().getAttribute(EXCLUSION_FILTERS, ""))) {
            return;
        }
        this.setExclusionClassFilters(filters);
        this.setAttribute(EXCLUSION_FILTERS, serializedFilters);
        this.recreate();
    }

    @Override
    public void setInclusionFilters(String[] filters) throws CoreException {
        String serializedFilters = this.serializeList(filters);
        if (serializedFilters.equals(this.ensureMarker().getAttribute(INCLUSION_FILTERS, ""))) {
            return;
        }
        this.setInclusionClassFilters(filters);
        this.setAttribute(INCLUSION_FILTERS, serializedFilters);
        this.recreate();
    }

    @Override
    protected void addInstanceFilter(EventRequest request, ObjectReference object) {
        if (request instanceof ExceptionRequest) {
            ((ExceptionRequest)request).addInstanceFilter(object);
        }
    }

    public IJavaObject getLastException() {
        if (this.fLastException != null) {
            return (IJavaObject)((Object)JDIValue.createValue(this.fLastTarget, this.fLastException));
        }
        return null;
    }

    private static IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy getWorkspaceSuspendOnRecurrenceStrategy() {
        IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy strategy = IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.RECURRENCE_UNCONFIGURED;
        IPreferencesService preferencesService = Platform.getPreferencesService();
        if (preferencesService != null) {
            String preferenceName = JDIDebugModel.PREF_SUSPEND_ON_RECURRENCE_STRATEGY;
            String strategyPreference = preferencesService.getString(JDIDebugModel.getPluginIdentifier(), JDIDebugModel.PREF_SUSPEND_ON_RECURRENCE_STRATEGY, IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.RECURRENCE_UNCONFIGURED.name(), null);
            try {
                strategy = IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.valueOf(strategyPreference);
            }
            catch (IllegalArgumentException e) {
                String message = NLS.bind((String)"Value \"{0}\" of preference \"{1}\" is illegal.", (Object)strategyPreference, (Object)preferenceName);
                Status status = new Status(4, JDIDebugModel.getPluginIdentifier(), message, (Throwable)e);
                JDIDebugPlugin.log((IStatus)status);
            }
        }
        return strategy;
    }
}

