/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.MatchingRuleDescriptionDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class MatchingRuleDescriptionPage
extends SchemaPage {
    public MatchingRuleDescriptionPage(SchemaBrowser schemaBrowser) {
        super(schemaBrowser);
    }

    @Override
    protected String getTitle() {
        return Messages.getString("MatchingRuleDescriptionPage.MatchingRules");
    }

    @Override
    protected String getFilterDescription() {
        return Messages.getString("MatchingRuleDescriptionPage.SelectMatchingRule");
    }

    @Override
    protected IStructuredContentProvider getContentProvider() {
        return new MRDContentProvider();
    }

    @Override
    protected ITableLabelProvider getLabelProvider() {
        return new MRDLabelProvider();
    }

    @Override
    protected ViewerSorter getSorter() {
        return new MRDViewerSorter();
    }

    @Override
    protected ViewerFilter getFilter() {
        return new MRDViewerFilter();
    }

    @Override
    protected SchemaDetailsPage getDetailsPage() {
        return new MatchingRuleDescriptionDetailsPage(this, this.toolkit);
    }

    class MRDContentProvider
    implements IStructuredContentProvider {
        MRDContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Schema schema;
            if (inputElement instanceof Schema && (schema = (Schema)inputElement) != null && schema.getMatchingRuleDescriptions() != null) {
                return schema.getMatchingRuleDescriptions().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class MRDLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MRDLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof MatchingRule) {
                return SchemaUtils.toString((AbstractSchemaObject)((MatchingRule)obj));
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class MRDViewerFilter
    extends ViewerFilter {
        MRDViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof MatchingRule) {
                MatchingRule mrd = (MatchingRule)element;
                boolean matched = Strings.toLowerCase((String)SchemaUtils.toString((AbstractSchemaObject)mrd)).indexOf(Strings.toLowerCase((String)MatchingRuleDescriptionPage.this.filterText.getText())) != -1 || Strings.toLowerCase((String)mrd.getOid()).indexOf(Strings.toLowerCase((String)MatchingRuleDescriptionPage.this.filterText.getText())) != -1;
                return matched;
            }
            return false;
        }
    }

    class MRDViewerSorter
    extends ViewerSorter {
        MRDViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof MatchingRule) {
                e1 = SchemaUtils.toString((AbstractSchemaObject)((MatchingRule)e1));
            }
            if (e2 instanceof MatchingRule) {
                e2 = SchemaUtils.toString((AbstractSchemaObject)((MatchingRule)e2));
            }
            return e1.toString().compareTo(e2.toString());
        }
    }
}

