/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage.view;

import org.eclipse.equinox.internal.security.ui.Activator;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.view.ISecurePreferencesSelection;
import org.eclipse.equinox.internal.security.ui.storage.view.NewValueDialog;
import org.eclipse.equinox.internal.security.ui.storage.view.NodesView;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ValuesView {
    private static boolean inDevelopmentMode = false;
    private static final String ENCRYPTED_SUBSTITUTE = "**********";
    protected ISecurePreferencesSelection parentView;
    protected TableViewer tableViewer;
    protected ISecurePreferences selectedNode = null;
    protected Action addValueAction;
    protected Action removeValueAction;
    protected Action showValueAction = null;
    protected Action encryptValueAction = null;
    protected Action decryptValueAction = null;
    protected Shell shell;

    public ValuesView(Table table, ISecurePreferencesSelection parentView, Shell shell) {
        this.parentView = parentView;
        this.shell = shell;
        TableColumn keysColumn = new TableColumn(table, 16384);
        keysColumn.setText(SecUIMessages.keysColumn);
        TableColumn valuesColumn = new TableColumn(table, 16384);
        valuesColumn.setText(SecUIMessages.valuesColumn);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setComparator(new ViewerComparator());
        if (Activator.getDefault().debugStorageContents()) {
            this.makeActions();
            this.hookContextMenu();
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(SecUIMessages.nodesContextMenu);
        menuMgr.addMenuListener(manager -> {
            StructuredSelection selection;
            Object selected;
            if (this.selectedNode == null) {
                this.addValueAction.setEnabled(false);
                this.removeValueAction.setEnabled(false);
                return;
            }
            boolean isInternal = this.selectedNode.absolutePath().startsWith("/org.eclipse.equinox.secure.storage");
            this.addValueAction.setEnabled(!isInternal);
            this.removeValueAction.setEnabled(!isInternal);
            if (this.encryptValueAction != null) {
                this.encryptValueAction.setEnabled(!isInternal);
            }
            if (this.decryptValueAction != null) {
                this.decryptValueAction.setEnabled(!isInternal);
            }
            if (this.showValueAction != null) {
                this.showValueAction.setEnabled(false);
            }
            if ((selected = (selection = (StructuredSelection)this.tableViewer.getSelection()).getFirstElement()) instanceof TableValuesElement) {
                String key = ((TableValuesElement)selected).getKey();
                try {
                    boolean encrypted = this.selectedNode.isEncrypted(key);
                    if (this.encryptValueAction != null) {
                        this.encryptValueAction.setEnabled(!isInternal && !encrypted);
                    }
                    if (this.decryptValueAction != null) {
                        this.decryptValueAction.setEnabled(!isInternal && encrypted);
                    }
                    if (this.showValueAction != null) {
                        this.showValueAction.setEnabled(encrypted);
                    }
                }
                catch (StorageException e) {
                    Activator.log(4, SecUIMessages.failedDecrypt, null, e);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        menuMgr.add((IAction)this.addValueAction);
        menuMgr.add((IAction)this.removeValueAction);
        if (this.showValueAction != null) {
            menuMgr.add((IContributionItem)new Separator());
            menuMgr.add((IAction)this.showValueAction);
        }
        if (this.encryptValueAction != null) {
            menuMgr.add((IContributionItem)new Separator());
            menuMgr.add((IAction)this.encryptValueAction);
        }
        if (this.decryptValueAction != null) {
            menuMgr.add((IAction)this.decryptValueAction);
        }
    }

    private void makeActions() {
        this.addValueAction = new Action(){

            public void run() {
                if (ValuesView.this.selectedNode == null) {
                    return;
                }
                NewValueDialog newValueDialog = new NewValueDialog(ValuesView.this.selectedNode.keys(), ValuesView.this.tableViewer.getControl().getShell());
                if (newValueDialog.open() != 0) {
                    return;
                }
                String key = newValueDialog.getKey();
                String value = newValueDialog.getValue();
                boolean encrypt = newValueDialog.encrypt();
                try {
                    ValuesView.this.selectedNode.put(key, value, encrypt);
                    ValuesView.this.parentView.modified();
                }
                catch (StorageException e) {
                    Activator.log(4, SecUIMessages.failedEncrypt, null, e);
                }
                ValuesView.this.tableViewer.refresh();
            }
        };
        this.addValueAction.setText(SecUIMessages.addValueCommand);
        this.addValueAction.setToolTipText(SecUIMessages.addValueCommandTmp);
        this.addValueAction.setImageDescriptor(ImageDescriptor.createFromFile(NodesView.class, (String)"/icons/storage/value_new.gif"));
        this.removeValueAction = new Action(){

            public void run() {
                if (ValuesView.this.selectedNode == null) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)ValuesView.this.tableViewer.getSelection();
                Object selected = selection.getFirstElement();
                if (!(selected instanceof TableValuesElement)) {
                    return;
                }
                TableValuesElement node = (TableValuesElement)selected;
                String key = node.getKey();
                MessageBox dialog = new MessageBox(ValuesView.this.shell, 200);
                dialog.setText(SecUIMessages.removeValueTitle);
                String msg = NLS.bind((String)SecUIMessages.removeValueMsg, (Object)key);
                dialog.setMessage(msg);
                if (dialog.open() != 64) {
                    return;
                }
                ValuesView.this.selectedNode.remove(key);
                ValuesView.this.parentView.modified();
                ValuesView.this.tableViewer.refresh();
            }
        };
        this.removeValueAction.setText(SecUIMessages.removeValueCommand);
        this.removeValueAction.setToolTipText(SecUIMessages.removeValueCommandTmp);
        this.removeValueAction.setImageDescriptor(ImageDescriptor.createFromFile(NodesView.class, (String)"/icons/storage/value_delete.gif"));
        if (inDevelopmentMode) {
            this.addDevelopmentMenuOptions();
        }
    }

    private void addDevelopmentMenuOptions() {
        this.showValueAction = new Action(){

            public void run() {
                if (ValuesView.this.selectedNode == null) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)ValuesView.this.tableViewer.getSelection();
                Object selected = selection.getFirstElement();
                if (!(selected instanceof TableValuesElement)) {
                    return;
                }
                TableValuesElement node = (TableValuesElement)selected;
                String key = node.getKey();
                try {
                    String value = ValuesView.this.selectedNode.get(key, null);
                    MessageBox dialog = new MessageBox(ValuesView.this.shell, 34);
                    dialog.setText(SecUIMessages.showValueTitle);
                    String msg = NLS.bind((String)SecUIMessages.showValueMsg, (Object)key, (Object)value);
                    dialog.setMessage(msg);
                    dialog.open();
                }
                catch (StorageException e) {
                    Activator.log(4, SecUIMessages.failedDecrypt, null, e);
                    MessageBox dialog = new MessageBox(ValuesView.this.shell, 40);
                    dialog.setMessage(SecUIMessages.failedDecrypt);
                    dialog.open();
                    return;
                }
            }
        };
        this.showValueAction.setText(SecUIMessages.showValueCommand);
        this.showValueAction.setToolTipText(SecUIMessages.showValueCommandTmp);
        this.showValueAction.setImageDescriptor(ImageDescriptor.createFromFile(NodesView.class, (String)"/icons/storage/value_show.gif"));
        this.encryptValueAction = new Action(){

            public void run() {
                ValuesView.this.reCodeValue(true);
            }
        };
        this.encryptValueAction.setText(SecUIMessages.encryptValueCommand);
        this.encryptValueAction.setToolTipText(SecUIMessages.encryptValueCommandTmp);
        this.encryptValueAction.setImageDescriptor(ImageDescriptor.createFromFile(NodesView.class, (String)"/icons/storage/encrypt.gif"));
        this.decryptValueAction = new Action(){

            public void run() {
                ValuesView.this.reCodeValue(false);
            }
        };
        this.decryptValueAction.setText(SecUIMessages.decryptValueCommand);
        this.decryptValueAction.setToolTipText(SecUIMessages.decryptValueCommandTmp);
        this.decryptValueAction.setImageDescriptor(ImageDescriptor.createFromFile(NodesView.class, (String)"/icons/storage/decrypt.gif"));
    }

    protected void reCodeValue(boolean encrypted) {
        String value;
        if (this.selectedNode == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        Object selected = selection.getFirstElement();
        if (!(selected instanceof TableValuesElement)) {
            return;
        }
        TableValuesElement node = (TableValuesElement)selected;
        String key = node.getKey();
        try {
            value = this.selectedNode.get(key, null);
        }
        catch (StorageException e) {
            MessageBox dialog = new MessageBox(this.shell, 40);
            dialog.setMessage(SecUIMessages.failedDecrypt);
            dialog.open();
            Activator.log(4, SecUIMessages.failedDecrypt, null, e);
            this.tableViewer.refresh();
            return;
        }
        try {
            this.selectedNode.put(key, value, encrypted);
            this.parentView.modified();
        }
        catch (StorageException e) {
            MessageBox dialog = new MessageBox(this.shell, 40);
            dialog.setMessage(SecUIMessages.failedEncrypt);
            dialog.open();
            Activator.log(4, SecUIMessages.failedEncrypt, null, e);
            this.tableViewer.refresh();
            return;
        }
        this.tableViewer.refresh();
    }

    public void setInput(Object input) {
        this.tableViewer.setInput(input);
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            ValuesView.this.selectedNode = (ISecurePreferences)newInput;
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (ValuesView.this.selectedNode == null) {
                return new Object[0];
            }
            String[] keys = ValuesView.this.selectedNode.keys();
            Object[] result = new TableValuesElement[keys.length];
            int i = 0;
            while (i < keys.length) {
                try {
                    result[i] = ValuesView.this.selectedNode.isEncrypted(keys[i]) ? new TableValuesElement(keys[i]) : new TableValuesElement(keys[i], ValuesView.this.selectedNode.get(keys[i], null));
                }
                catch (StorageException e) {
                    Activator.log(4, SecUIMessages.failedDecrypt, null, e);
                }
                ++i;
            }
            return result;
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof TableValuesElement)) {
                return obj.toString();
            }
            switch (index) {
                case 0: {
                    return ((TableValuesElement)obj).getKey();
                }
                case 1: {
                    return ((TableValuesElement)obj).getValue();
                }
            }
            return obj.toString();
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class TableValuesElement {
        private String key;
        private String value;
        private boolean encrypted;

        public TableValuesElement(String key) {
            this.key = key;
            this.value = null;
            this.encrypted = true;
        }

        public TableValuesElement(String key, String value) {
            this.key = key;
            this.value = value;
            this.encrypted = false;
        }

        public String getKey() {
            return this.key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            if (this.value == null) {
                return ValuesView.ENCRYPTED_SUBSTITUTE;
            }
            return this.value;
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }
    }
}

