/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class FrameRectangle {
    private double x;
    private double y;
    private double width;
    private double height;
    private StyleTypeDefinitions.SupportedLinearMeasure linearMeasure;
    private static final String WidthFormat = "#.####";
    private DecimalFormat formater = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.US));

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public StyleTypeDefinitions.SupportedLinearMeasure getLinearMeasure() {
        return this.linearMeasure;
    }

    public void setLinearMeasure(StyleTypeDefinitions.SupportedLinearMeasure newLinearMeasure) {
        if (this.linearMeasure != this.linearMeasure) {
            this.x = newLinearMeasure.convert(this.x, this.linearMeasure);
            this.y = newLinearMeasure.convert(this.y, this.linearMeasure);
            this.width = newLinearMeasure.convert(this.width, this.linearMeasure);
            this.height = newLinearMeasure.convert(this.height, this.linearMeasure);
        }
        this.linearMeasure = newLinearMeasure;
    }

    public FrameRectangle(double x, double y, double width, double height, StyleTypeDefinitions.SupportedLinearMeasure linearMeasure) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.linearMeasure = linearMeasure;
    }

    public FrameRectangle(String xDesc, String yDesc, String widthDesc, String heightDesc) {
        StyleTypeDefinitions.SupportedLinearMeasure tempHMeasure;
        StyleTypeDefinitions.SupportedLinearMeasure tempWMeasure;
        StyleTypeDefinitions.SupportedLinearMeasure tempYMeasure;
        StyleTypeDefinitions.SupportedLinearMeasure tempXMeasure;
        if (xDesc == null || xDesc.length() == 0) {
            this.x = 0.0;
            tempXMeasure = StyleTypeDefinitions.SupportedLinearMeasure.CM;
        } else {
            this.x = this.getLineWidth(xDesc);
            tempXMeasure = this.getLineMeasure(xDesc);
        }
        if (yDesc == null || yDesc.length() == 0) {
            this.y = 0.0;
            tempYMeasure = StyleTypeDefinitions.SupportedLinearMeasure.CM;
        } else {
            this.y = this.getLineWidth(yDesc);
            tempYMeasure = this.getLineMeasure(yDesc);
        }
        if (widthDesc == null || widthDesc.length() == 0) {
            this.width = 0.0;
            tempWMeasure = StyleTypeDefinitions.SupportedLinearMeasure.CM;
        } else {
            this.width = this.getLineWidth(widthDesc);
            tempWMeasure = this.getLineMeasure(widthDesc);
        }
        if (heightDesc == null || heightDesc.length() == 0) {
            this.height = 0.0;
            tempHMeasure = StyleTypeDefinitions.SupportedLinearMeasure.CM;
        } else {
            this.height = this.getLineWidth(heightDesc);
            tempHMeasure = this.getLineMeasure(heightDesc);
        }
        if (tempXMeasure == null && tempYMeasure == null && tempWMeasure == null && tempHMeasure == null) {
            throw new RuntimeException(xDesc + "," + yDesc + "," + widthDesc + "," + heightDesc + "," + " are not valid line description!");
        }
        if (tempXMeasure != null) {
            this.linearMeasure = tempXMeasure;
        } else if (tempYMeasure != null) {
            this.linearMeasure = tempYMeasure;
        } else if (tempWMeasure != null) {
            this.linearMeasure = tempWMeasure;
        } else if (tempHMeasure != null) {
            this.linearMeasure = tempHMeasure;
        }
        if (tempXMeasure != null && tempXMeasure != this.linearMeasure) {
            this.x = this.linearMeasure.convert(this.x, tempXMeasure);
        }
        if (tempYMeasure != null && tempYMeasure != this.linearMeasure) {
            this.y = this.linearMeasure.convert(this.y, tempYMeasure);
        }
        if (tempWMeasure != null && tempWMeasure != this.linearMeasure) {
            this.width = this.linearMeasure.convert(this.width, tempWMeasure);
        }
        if (tempHMeasure != null && tempHMeasure != this.linearMeasure) {
            this.height = this.linearMeasure.convert(this.height, tempHMeasure);
        }
    }

    public String getXDesc() {
        return this.formater.format(this.x) + this.linearMeasure.toString();
    }

    public String getYDesc() {
        return this.formater.format(this.y) + this.linearMeasure.toString();
    }

    public String getWidthDesc() {
        return this.formater.format(this.width) + this.linearMeasure.toString();
    }

    public String getHeigthDesc() {
        return this.formater.format(this.height) + this.linearMeasure.toString();
    }

    private double getLineWidth(String width) {
        String floatValue = width.substring(0, width.length() - 2);
        return Double.parseDouble(floatValue);
    }

    private StyleTypeDefinitions.SupportedLinearMeasure getLineMeasure(String width) {
        for (StyleTypeDefinitions.SupportedLinearMeasure aIter : StyleTypeDefinitions.SupportedLinearMeasure.values()) {
            if (!width.endsWith(aIter.toString())) continue;
            return aIter;
        }
        return null;
    }
}

