/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.request;

import org.apache.directory.api.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.dom4j.Element;

public class BindRequestDsml
extends AbstractResultResponseRequestDsml<BindRequest, BindResponse>
implements BindRequest {
    public BindRequestDsml(LdapApiService codec) {
        super(codec, new BindRequestImpl());
    }

    public BindRequestDsml(LdapApiService codec, BindRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public MessageTypeEnum getType() {
        return ((BindRequest)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        BindRequest request = (BindRequest)this.getDecorated();
        Dn dn = request.getDn();
        if (!Dn.isNullOrEmpty((Dn)dn)) {
            element.addAttribute("principal", dn.getName());
        } else {
            String name = request.getName();
            element.addAttribute("principal", name);
        }
        return element;
    }

    public MessageTypeEnum getResponseType() {
        return ((BindRequest)this.getDecorated()).getResponseType();
    }

    public boolean isSimple() {
        return ((BindRequest)this.getDecorated()).isSimple();
    }

    public boolean getSimple() {
        return ((BindRequest)this.getDecorated()).getSimple();
    }

    public BindRequest setSimple(boolean isSimple) {
        ((BindRequest)this.getDecorated()).setSimple(isSimple);
        return this;
    }

    public byte[] getCredentials() {
        return ((BindRequest)this.getDecorated()).getCredentials();
    }

    public BindRequest setCredentials(String credentials) {
        ((BindRequest)this.getDecorated()).setCredentials(credentials);
        return this;
    }

    public BindRequest setCredentials(byte[] credentials) {
        ((BindRequest)this.getDecorated()).setCredentials(credentials);
        return this;
    }

    public String getName() {
        return ((BindRequest)this.getDecorated()).getName();
    }

    public BindRequest setName(String name) {
        ((BindRequest)this.getDecorated()).setName(name);
        return this;
    }

    public Dn getDn() {
        return ((BindRequest)this.getDecorated()).getDn();
    }

    public BindRequest setDn(Dn dn) {
        ((BindRequest)this.getDecorated()).setDn(dn);
        return this;
    }

    public boolean isVersion3() {
        return ((BindRequest)this.getDecorated()).isVersion3();
    }

    public boolean getVersion3() {
        return ((BindRequest)this.getDecorated()).getVersion3();
    }

    public BindRequest setVersion3(boolean isVersion3) {
        ((BindRequest)this.getDecorated()).setVersion3(isVersion3);
        return this;
    }

    public String getSaslMechanism() {
        return ((BindRequest)this.getDecorated()).getSaslMechanism();
    }

    public BindRequest setSaslMechanism(String saslMechanism) {
        ((BindRequest)this.getDecorated()).setSaslMechanism(saslMechanism);
        return this;
    }

    public BindRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public BindRequest addControl(Control control) {
        return (BindRequest)super.addControl(control);
    }

    public BindRequest addAllControls(Control[] controls) {
        return (BindRequest)super.addAllControls(controls);
    }

    public BindRequest removeControl(Control control) {
        return (BindRequest)super.removeControl(control);
    }
}

