/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.productaccountmapping.service;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.accounting.productaccountmapping.service.LoanProductToGLAccountMappingHelper;
import org.apache.fineract.accounting.productaccountmapping.service.ProductToGLAccountMappingWritePlatformServiceImpl;
import org.apache.fineract.accounting.producttoaccountmapping.serialization.ProductToGLAccountMappingFromApiJsonDeserializer;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingWritePlatformService;
import org.apache.fineract.accounting.producttoaccountmapping.service.SavingsProductToGLAccountMappingHelper;
import org.apache.fineract.accounting.producttoaccountmapping.service.ShareProductToGLAccountMappingHelper;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductToGLAccountMappingWritePlatformServiceImpl
implements ProductToGLAccountMappingWritePlatformService {
    private final FromJsonHelper fromApiJsonHelper;
    private final ProductToGLAccountMappingFromApiJsonDeserializer deserializer;
    private final LoanProductToGLAccountMappingHelper loanProductToGLAccountMappingHelper;
    private final SavingsProductToGLAccountMappingHelper savingsProductToGLAccountMappingHelper;
    private final ShareProductToGLAccountMappingHelper shareProductToGLAccountMappingHelper;

    @Transactional
    public void createLoanProductToGLAccountMapping(Long loanProductId, JsonCommand command) {
        JsonElement element = this.fromApiJsonHelper.parse(command.json());
        Integer accountingRuleTypeId = this.fromApiJsonHelper.extractIntegerNamed("accountingRule", element, Locale.getDefault());
        AccountingRuleType accountingRuleType = AccountingRuleType.fromInt((Integer)accountingRuleTypeId);
        switch (1.$SwitchMap$org$apache$fineract$accounting$common$AccountingRuleType[accountingRuleType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.loanProductToGLAccountMappingHelper.saveLoanToAssetOrLiabilityAccountMapping(element, AccountingConstants.LoanProductAccountingParams.FUND_SOURCE.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToAssetAccountMapping(element, AccountingConstants.LoanProductAccountingParams.LOAN_PORTFOLIO.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToAssetAccountMapping(element, AccountingConstants.LoanProductAccountingParams.TRANSFERS_SUSPENSE.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.TRANSFERS_SUSPENSE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INTEREST_ON_LOANS.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_FEES.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_PENALTIES.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_RECOVERY.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_FEES.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToExpenseAccountMapping(element, AccountingConstants.LoanProductAccountingParams.LOSSES_WRITTEN_OFF.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.LOSSES_WRITTEN_OFF.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToExpenseAccountMapping(element, AccountingConstants.LoanProductAccountingParams.GOODWILL_CREDIT.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.GOODWILL_CREDIT.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToExpenseAccountMapping(element, AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_EXPENSE.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_EXPENSE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToExpenseAccountMapping(element, AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_FRAUD_EXPENSE.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToLiabilityAccountMapping(element, AccountingConstants.LoanProductAccountingParams.OVERPAYMENT.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.savePaymentChannelToFundSourceMappings(command, element, loanProductId, null);
                this.loanProductToGLAccountMappingHelper.saveChargesToIncomeAccountMappings(command, element, loanProductId, null);
                this.loanProductToGLAccountMappingHelper.saveChargeOffReasonToExpenseAccountMappings(command, element, loanProductId, null);
                break;
            }
            case 3: 
            case 4: {
                this.loanProductToGLAccountMappingHelper.saveLoanToAssetOrLiabilityAccountMapping(element, AccountingConstants.LoanProductAccountingParams.FUND_SOURCE.getValue(), loanProductId, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToAssetAccountMapping(element, AccountingConstants.LoanProductAccountingParams.LOAN_PORTFOLIO.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToAssetAccountMapping(element, AccountingConstants.LoanProductAccountingParams.TRANSFERS_SUSPENSE.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.TRANSFERS_SUSPENSE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToAssetAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INTEREST_RECEIVABLE.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToAssetAccountMapping(element, AccountingConstants.LoanProductAccountingParams.FEES_RECEIVABLE.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToAssetAccountMapping(element, AccountingConstants.LoanProductAccountingParams.PENALTIES_RECEIVABLE.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INTEREST_ON_LOANS.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_FEES.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_PENALTIES.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_RECOVERY.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_FEES.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_CAPITALIZATION.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CAPITALIZATION.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToIncomeAccountMapping(element, AccountingConstants.LoanProductAccountingParams.INCOME_FROM_BUY_DOWN.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_BUY_DOWN.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToExpenseAccountMapping(element, AccountingConstants.LoanProductAccountingParams.LOSSES_WRITTEN_OFF.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.LOSSES_WRITTEN_OFF.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToExpenseAccountMapping(element, AccountingConstants.LoanProductAccountingParams.GOODWILL_CREDIT.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.GOODWILL_CREDIT.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToExpenseAccountMapping(element, AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_EXPENSE.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToExpenseAccountMapping(element, AccountingConstants.LoanProductAccountingParams.CHARGE_OFF_FRAUD_EXPENSE.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToExpenseAccountMapping(element, AccountingConstants.LoanProductAccountingParams.BUY_DOWN_EXPENSE.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.BUY_DOWN_EXPENSE.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToLiabilityAccountMapping(element, AccountingConstants.LoanProductAccountingParams.OVERPAYMENT.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.saveLoanToLiabilityAccountMapping(element, AccountingConstants.LoanProductAccountingParams.DEFERRED_INCOME_LIABILITY.getValue(), loanProductId, AccountingConstants.AccrualAccountsForLoan.DEFERRED_INCOME_LIABILITY.getValue().intValue());
                this.loanProductToGLAccountMappingHelper.savePaymentChannelToFundSourceMappings(command, element, loanProductId, null);
                this.loanProductToGLAccountMappingHelper.saveChargesToIncomeAccountMappings(command, element, loanProductId, null);
                this.loanProductToGLAccountMappingHelper.saveChargeOffReasonToExpenseAccountMappings(command, element, loanProductId, null);
            }
        }
    }

    private void saveSavingsBaseAccountMapping(Long savingProductId, DepositAccountType accountType, JsonCommand command, JsonElement element) {
        this.savingsProductToGLAccountMappingHelper.saveSavingsToAssetAccountMapping(element, AccountingConstants.SavingProductAccountingParams.SAVINGS_REFERENCE.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE.getValue().intValue());
        if (!accountType.equals((Object)DepositAccountType.RECURRING_DEPOSIT) && !accountType.equals((Object)DepositAccountType.FIXED_DEPOSIT)) {
            this.savingsProductToGLAccountMappingHelper.saveSavingsToAssetAccountMapping(element, AccountingConstants.SavingProductAccountingParams.OVERDRAFT_PORTFOLIO_CONTROL.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.OVERDRAFT_PORTFOLIO_CONTROL.getValue().intValue());
        }
        this.savingsProductToGLAccountMappingHelper.saveSavingsToIncomeAccountMapping(element, AccountingConstants.SavingProductAccountingParams.INCOME_FROM_FEES.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.INCOME_FROM_FEES.getValue().intValue());
        this.savingsProductToGLAccountMappingHelper.saveSavingsToIncomeAccountMapping(element, AccountingConstants.SavingProductAccountingParams.INCOME_FROM_PENALTIES.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.INCOME_FROM_PENALTIES.getValue().intValue());
        if (!accountType.equals((Object)DepositAccountType.RECURRING_DEPOSIT) && !accountType.equals((Object)DepositAccountType.FIXED_DEPOSIT)) {
            this.savingsProductToGLAccountMappingHelper.saveSavingsToIncomeAccountMapping(element, AccountingConstants.SavingProductAccountingParams.INCOME_FROM_INTEREST.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.INCOME_FROM_INTEREST.getValue().intValue());
        }
        this.savingsProductToGLAccountMappingHelper.saveSavingsToExpenseAccountMapping(element, AccountingConstants.SavingProductAccountingParams.INTEREST_ON_SAVINGS.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.INTEREST_ON_SAVINGS.getValue().intValue());
        if (!accountType.equals((Object)DepositAccountType.RECURRING_DEPOSIT) && !accountType.equals((Object)DepositAccountType.FIXED_DEPOSIT)) {
            this.savingsProductToGLAccountMappingHelper.saveSavingsToExpenseAccountMapping(element, AccountingConstants.SavingProductAccountingParams.LOSSES_WRITTEN_OFF.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.LOSSES_WRITTEN_OFF.getValue().intValue());
        }
        this.savingsProductToGLAccountMappingHelper.saveSavingsToLiabilityAccountMapping(element, AccountingConstants.SavingProductAccountingParams.SAVINGS_CONTROL.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.SAVINGS_CONTROL.getValue().intValue());
        this.savingsProductToGLAccountMappingHelper.saveSavingsToLiabilityAccountMapping(element, AccountingConstants.SavingProductAccountingParams.TRANSFERS_SUSPENSE.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.TRANSFERS_SUSPENSE.getValue().intValue());
        Boolean isDormancyTrackingActive = this.fromApiJsonHelper.extractBooleanNamed("isDormancyTrackingActive", element);
        if (null != isDormancyTrackingActive && isDormancyTrackingActive.booleanValue()) {
            this.savingsProductToGLAccountMappingHelper.saveSavingsToLiabilityAccountMapping(element, AccountingConstants.SavingProductAccountingParams.ESCHEAT_LIABILITY.getValue(), savingProductId, AccountingConstants.CashAccountsForSavings.ESCHEAT_LIABILITY.getValue().intValue());
        }
        this.savingsProductToGLAccountMappingHelper.savePaymentChannelToFundSourceMappings(command, element, savingProductId, null);
        this.savingsProductToGLAccountMappingHelper.saveChargesToIncomeAccountMappings(command, element, savingProductId, null);
    }

    @Transactional
    public void createSavingProductToGLAccountMapping(Long savingProductId, JsonCommand command, DepositAccountType accountType) {
        JsonElement element = this.fromApiJsonHelper.parse(command.json());
        Integer accountingRuleTypeId = this.fromApiJsonHelper.extractIntegerNamed("accountingRule", element, Locale.getDefault());
        AccountingRuleType accountingRuleType = AccountingRuleType.fromInt((Integer)accountingRuleTypeId);
        switch (1.$SwitchMap$org$apache$fineract$accounting$common$AccountingRuleType[accountingRuleType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.saveSavingsBaseAccountMapping(savingProductId, accountType, command, element);
                break;
            }
            case 4: {
                this.saveSavingsBaseAccountMapping(savingProductId, accountType, command, element);
                this.savingsProductToGLAccountMappingHelper.saveSavingsToAssetAccountMapping(element, AccountingConstants.SavingProductAccountingParams.FEES_RECEIVABLE.getValue(), savingProductId, AccountingConstants.AccrualAccountsForSavings.FEES_RECEIVABLE.getValue().intValue());
                this.savingsProductToGLAccountMappingHelper.saveSavingsToAssetAccountMapping(element, AccountingConstants.SavingProductAccountingParams.PENALTIES_RECEIVABLE.getValue(), savingProductId, AccountingConstants.AccrualAccountsForSavings.PENALTIES_RECEIVABLE.getValue().intValue());
                this.savingsProductToGLAccountMappingHelper.saveSavingsToLiabilityAccountMapping(element, AccountingConstants.SavingProductAccountingParams.INTEREST_PAYABLE.getValue(), savingProductId, AccountingConstants.AccrualAccountsForSavings.INTEREST_PAYABLE.getValue().intValue());
                break;
            }
        }
    }

    @Transactional
    public void createShareProductToGLAccountMapping(Long shareProductId, JsonCommand command) {
        this.deserializer.validateForShareProductCreate(command.json());
        JsonElement element = this.fromApiJsonHelper.parse(command.json());
        Integer accountingRuleTypeId = this.fromApiJsonHelper.extractIntegerNamed("accountingRule", element, Locale.getDefault());
        AccountingRuleType accountingRuleType = AccountingRuleType.fromInt((Integer)accountingRuleTypeId);
        switch (1.$SwitchMap$org$apache$fineract$accounting$common$AccountingRuleType[accountingRuleType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.shareProductToGLAccountMappingHelper.saveSharesToAssetAccountMapping(element, AccountingConstants.SharesProductAccountingParams.SHARES_REFERENCE.getValue(), shareProductId, AccountingConstants.CashAccountsForShares.SHARES_REFERENCE.getValue().intValue());
                this.shareProductToGLAccountMappingHelper.saveSharesToIncomeAccountMapping(element, AccountingConstants.SharesProductAccountingParams.INCOME_FROM_FEES.getValue(), shareProductId, AccountingConstants.CashAccountsForShares.INCOME_FROM_FEES.getValue().intValue());
                this.shareProductToGLAccountMappingHelper.saveSharesToEquityAccountMapping(element, AccountingConstants.SharesProductAccountingParams.SHARES_EQUITY.getValue(), shareProductId, AccountingConstants.CashAccountsForShares.SHARES_EQUITY.getValue().intValue());
                this.shareProductToGLAccountMappingHelper.saveSharesToLiabilityAccountMapping(element, AccountingConstants.SharesProductAccountingParams.SHARES_SUSPENSE.getValue(), shareProductId, AccountingConstants.CashAccountsForShares.SHARES_SUSPENSE.getValue().intValue());
                this.savingsProductToGLAccountMappingHelper.savePaymentChannelToFundSourceMappings(command, element, shareProductId, null);
                this.savingsProductToGLAccountMappingHelper.saveChargesToIncomeAccountMappings(command, element, shareProductId, null);
                break;
            }
        }
    }

    @Transactional
    public Map<String, Object> updateLoanProductToGLAccountMapping(Long loanProductId, JsonCommand command, boolean accountingRuleChanged, AccountingRuleType accountingRuleType, boolean enableIncomeCapitalization, boolean enableBuyDownFee) {
        HashMap<String, Object> changes = new HashMap();
        JsonElement element = this.fromApiJsonHelper.parse(command.json());
        if (accountingRuleChanged) {
            this.deserializer.validateForLoanProductCreate(command.json());
            this.loanProductToGLAccountMappingHelper.deleteLoanProductToGLAccountMapping(loanProductId);
            this.createLoanProductToGLAccountMapping(loanProductId, command);
            changes = this.loanProductToGLAccountMappingHelper.populateChangesForNewLoanProductToGLAccountMappingCreation(element, accountingRuleType);
        } else {
            this.loanProductToGLAccountMappingHelper.handleChangesToLoanProductToGLAccountMappings(loanProductId, changes, element, accountingRuleType, enableIncomeCapitalization, enableBuyDownFee);
            this.loanProductToGLAccountMappingHelper.updatePaymentChannelToFundSourceMappings(command, element, loanProductId, changes);
            this.loanProductToGLAccountMappingHelper.updateChargesToIncomeAccountMappings(command, element, loanProductId, changes);
            this.loanProductToGLAccountMappingHelper.updateChargeOffReasonToExpenseAccountMappings(command, element, loanProductId, changes);
        }
        return changes;
    }

    @Transactional
    public Map<String, Object> updateSavingsProductToGLAccountMapping(Long savingsProductId, JsonCommand command, boolean accountingRuleChanged, int accountingRuleTypeId, DepositAccountType accountType) {
        HashMap<String, Object> changes = new HashMap();
        JsonElement element = this.fromApiJsonHelper.parse(command.json());
        AccountingRuleType accountingRuleType = AccountingRuleType.fromInt((Integer)accountingRuleTypeId);
        if (accountingRuleChanged) {
            this.deserializer.validateForSavingsProductCreate(command.json(), accountType);
            this.savingsProductToGLAccountMappingHelper.deleteSavingsProductToGLAccountMapping(savingsProductId);
            this.createSavingProductToGLAccountMapping(savingsProductId, command, accountType);
            changes = this.savingsProductToGLAccountMappingHelper.populateChangesForNewSavingsProductToGLAccountMappingCreation(element, accountingRuleType);
        } else {
            this.savingsProductToGLAccountMappingHelper.handleChangesToSavingsProductToGLAccountMappings(savingsProductId, changes, element, accountingRuleType);
            this.savingsProductToGLAccountMappingHelper.updatePaymentChannelToFundSourceMappings(command, element, savingsProductId, changes);
            this.savingsProductToGLAccountMappingHelper.updateChargesToIncomeAccountMappings(command, element, savingsProductId, changes);
        }
        return changes;
    }

    @Transactional
    public Map<String, Object> updateShareProductToGLAccountMapping(Long shareProductId, JsonCommand command, boolean accountingRuleChanged, int accountingRuleTypeId) {
        HashMap<String, Object> changes = new HashMap();
        JsonElement element = this.fromApiJsonHelper.parse(command.json());
        AccountingRuleType accountingRuleType = AccountingRuleType.fromInt((Integer)accountingRuleTypeId);
        if (accountingRuleChanged) {
            this.shareProductToGLAccountMappingHelper.deleteSharesProductToGLAccountMapping(shareProductId);
            this.createShareProductToGLAccountMapping(shareProductId, command);
            changes = this.shareProductToGLAccountMappingHelper.populateChangesForNewSharesProductToGLAccountMappingCreation(element, accountingRuleType);
        } else {
            this.shareProductToGLAccountMappingHelper.handleChangesToSharesProductToGLAccountMappings(shareProductId, changes, element, accountingRuleType);
            this.shareProductToGLAccountMappingHelper.updatePaymentChannelToFundSourceMappings(command, element, shareProductId, changes);
            this.shareProductToGLAccountMappingHelper.updateChargesToIncomeAccountMappings(command, element, shareProductId, changes);
        }
        return changes;
    }

    @Generated
    public ProductToGLAccountMappingWritePlatformServiceImpl(FromJsonHelper fromApiJsonHelper, ProductToGLAccountMappingFromApiJsonDeserializer deserializer, LoanProductToGLAccountMappingHelper loanProductToGLAccountMappingHelper, SavingsProductToGLAccountMappingHelper savingsProductToGLAccountMappingHelper, ShareProductToGLAccountMappingHelper shareProductToGLAccountMappingHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.deserializer = deserializer;
        this.loanProductToGLAccountMappingHelper = loanProductToGLAccountMappingHelper;
        this.savingsProductToGLAccountMappingHelper = savingsProductToGLAccountMappingHelper;
        this.shareProductToGLAccountMappingHelper = shareProductToGLAccountMappingHelper;
    }
}

