/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import lombok.Generated;
import org.apache.fineract.cob.exceptions.BusinessStepException;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.core.exception.MultiException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AddPeriodicAccrualEntriesBusinessStep
implements LoanCOBBusinessStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddPeriodicAccrualEntriesBusinessStep.class);
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;

    public Loan execute(Loan loan) {
        log.debug("start processing period accrual business step for loan with Id [{}]", (Object)loan.getId());
        try {
            this.loanAccrualsProcessingService.addPeriodicAccruals(DateUtils.getBusinessLocalDate(), loan);
        }
        catch (MultiException e) {
            throw new BusinessStepException(String.format("Fail to process period accrual for loan id [%s]", loan.getId()), (Throwable)e);
        }
        log.debug("end processing period accrual business step for loan Id [{}]", (Object)loan.getId());
        return loan;
    }

    public String getEnumStyledName() {
        return "ADD_PERIODIC_ACCRUAL_ENTRIES";
    }

    public String getHumanReadableName() {
        return "Add periodic accrual entries";
    }

    @Generated
    public AddPeriodicAccrualEntriesBusinessStep(LoanAccrualsProcessingService loanAccrualsProcessingService) {
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
    }
}

