/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.fineract.cob.common.CustomJobParameterResolver;
import org.apache.fineract.cob.data.LoanCOBParameter;
import org.apache.fineract.cob.domain.LoanAccountLock;
import org.apache.fineract.cob.exceptions.LoanLockCannotBeAppliedException;
import org.apache.fineract.cob.loan.LoanLockingService;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.lang.NonNull;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ApplyLoanLockTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplyLoanLockTasklet.class);
    private static final long NUMBER_OF_RETRIES = 3L;
    private final FineractProperties fineractProperties;
    private final LoanLockingService loanLockingService;
    private final RetrieveLoanIdService retrieveLoanIdService;
    private final CustomJobParameterResolver customJobParameterResolver;
    private final TransactionTemplate transactionTemplate;

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public RepeatStatus execute(@NonNull StepContribution contribution, @NonNull ChunkContext chunkContext) throws LoanLockCannotBeAppliedException {
        ExecutionContext executionContext = contribution.getStepExecution().getExecutionContext();
        long numberOfExecutions = contribution.getStepExecution().getCommitCount();
        LoanCOBParameter loanCOBParameter = (LoanCOBParameter)executionContext.get("loanCobParameter");
        List loanIds = Objects.isNull(loanCOBParameter) || Objects.isNull(loanCOBParameter.getMinLoanId()) && Objects.isNull(loanCOBParameter.getMaxLoanId()) || loanCOBParameter.getMinLoanId().equals(0L) && loanCOBParameter.getMaxLoanId().equals(0L) ? Collections.emptyList() : new ArrayList(this.retrieveLoanIdService.retrieveAllNonClosedLoansByLastClosedBusinessDateAndMinAndMaxLoanId(loanCOBParameter, this.customJobParameterResolver.getCustomJobParameterById(contribution.getStepExecution(), "IS_CATCH_UP").map(Boolean::parseBoolean).orElse(false).booleanValue()));
        List loanIdPartitions = Lists.partition(loanIds, (int)this.getInClauseParameterSizeLimit());
        ArrayList accountLocks = new ArrayList();
        loanIdPartitions.forEach(loanIdPartition -> accountLocks.addAll(this.loanLockingService.findAllByLoanIdIn(loanIdPartition)));
        ArrayList toBeProcessedLoanIds = new ArrayList(loanIds);
        List<Long> alreadyLockedAccountIds = accountLocks.stream().map(LoanAccountLock::getLoanId).toList();
        toBeProcessedLoanIds.removeAll(alreadyLockedAccountIds);
        try {
            this.applyLocks(toBeProcessedLoanIds);
        }
        catch (Exception e) {
            if (numberOfExecutions > 3L) {
                String message = "There was an error applying lock to loan accounts.";
                log.error("{}", (Object)message, (Object)e);
                throw new LoanLockCannotBeAppliedException(message, (Throwable)e);
            }
            return RepeatStatus.CONTINUABLE;
        }
        return RepeatStatus.FINISHED;
    }

    private void applyLocks(List<Long> toBeProcessedLoanIds) {
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private int getInClauseParameterSizeLimit() {
        return this.fineractProperties.getQuery().getInClauseParameterSizeLimit();
    }

    @Generated
    public ApplyLoanLockTasklet(FineractProperties fineractProperties, LoanLockingService loanLockingService, RetrieveLoanIdService retrieveLoanIdService, CustomJobParameterResolver customJobParameterResolver, TransactionTemplate transactionTemplate) {
        this.fineractProperties = fineractProperties;
        this.loanLockingService = loanLockingService;
        this.retrieveLoanIdService = retrieveLoanIdService;
        this.customJobParameterResolver = customJobParameterResolver;
        this.transactionTemplate = transactionTemplate;
    }
}

