/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.data.LoanCOBParameter;
import org.apache.fineract.cob.data.LoanCOBPartition;
import org.apache.fineract.cob.data.LoanIdAndExternalIdAndAccountNo;
import org.apache.fineract.cob.data.LoanIdAndLastClosedBusinessDate;
import org.apache.fineract.cob.loan.LoanCOBConstant;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class RetrieveAllNonClosedLoanIdServiceImpl
implements RetrieveLoanIdService {
    private static final Collection<LoanStatus> NON_CLOSED_LOAN_STATUSES = new ArrayList<LoanStatus>(Arrays.asList(LoanStatus.SUBMITTED_AND_PENDING_APPROVAL, LoanStatus.APPROVED, LoanStatus.ACTIVE, LoanStatus.TRANSFER_IN_PROGRESS, LoanStatus.TRANSFER_ON_HOLD));
    private final LoanRepository loanRepository;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<LoanCOBPartition> retrieveLoanCOBPartitions(Long numberOfDays, LocalDate businessDate, boolean isCatchUp, int partitionSize) {
        StringBuilder sql = new StringBuilder();
        sql.append("select min(id) as min, max(id) as max, page, count(id) as count from ");
        sql.append("  (select floor(((row_number() over(order by id))-1) / :pageSize) as page, t.* from ");
        sql.append("      (select id from m_loan where loan_status_id in (:statusIds) and ");
        if (isCatchUp) {
            sql.append("last_closed_business_date = :businessDate ");
        } else {
            sql.append("(last_closed_business_date = :businessDate or last_closed_business_date is null) ");
        }
        sql.append("order by id) t) t2 ");
        sql.append("group by page ");
        sql.append("order by page");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("pageSize", (Object)partitionSize);
        parameters.addValue("statusIds", List.of(Integer.valueOf(100), Integer.valueOf(200), Integer.valueOf(300), Integer.valueOf(303), Integer.valueOf(304)));
        parameters.addValue("businessDate", (Object)businessDate.minusDays(numberOfDays));
        return this.namedParameterJdbcTemplate.query(sql.toString(), (SqlParameterSource)parameters, RetrieveAllNonClosedLoanIdServiceImpl::mapRow);
    }

    private static LoanCOBPartition mapRow(ResultSet rs, int rowNum) throws SQLException {
        return new LoanCOBPartition(Long.valueOf(rs.getLong("min")), Long.valueOf(rs.getLong("max")), Long.valueOf(rs.getLong("page")), Long.valueOf(rs.getLong("count")));
    }

    public List<LoanIdAndLastClosedBusinessDate> retrieveLoanIdsBehindDate(LocalDate businessDate, List<Long> loanIds) {
        return this.loanRepository.findAllLoansBehindByLoanIdsAndStatuses(businessDate, loanIds, NON_CLOSED_LOAN_STATUSES);
    }

    public List<LoanIdAndLastClosedBusinessDate> retrieveLoanIdsBehindDateOrNull(LocalDate businessDate, List<Long> loanIds) {
        return this.loanRepository.findAllLoansBehindOrNullByLoanIdsAndStatuses(businessDate, loanIds, NON_CLOSED_LOAN_STATUSES);
    }

    public List<LoanIdAndLastClosedBusinessDate> retrieveLoanIdsOldestCobProcessed(LocalDate businessDate) {
        return this.loanRepository.findOldestCOBProcessedLoan(businessDate, NON_CLOSED_LOAN_STATUSES);
    }

    public List<Long> retrieveAllNonClosedLoansByLastClosedBusinessDateAndMinAndMaxLoanId(LoanCOBParameter loanCOBParameter, boolean isCatchUp) {
        if (isCatchUp) {
            return this.loanRepository.findAllLoansByLastClosedBusinessDateNotNullAndMinAndMaxLoanIdAndStatuses(loanCOBParameter.getMinLoanId(), loanCOBParameter.getMaxLoanId(), ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE).minusDays(LoanCOBConstant.NUMBER_OF_DAYS_BEHIND), NON_CLOSED_LOAN_STATUSES);
        }
        return this.loanRepository.findAllLoansByLastClosedBusinessDateAndMinAndMaxLoanIdAndStatuses(loanCOBParameter.getMinLoanId(), loanCOBParameter.getMaxLoanId(), ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE).minusDays(LoanCOBConstant.NUMBER_OF_DAYS_BEHIND), NON_CLOSED_LOAN_STATUSES);
    }

    public List<LoanIdAndExternalIdAndAccountNo> findAllStayedLockedByCobBusinessDate(LocalDate cobBusinessDate) {
        return this.loanRepository.findAllStayedLockedByCobBusinessDate(cobBusinessDate);
    }

    @Generated
    public RetrieveAllNonClosedLoanIdServiceImpl(LoanRepository loanRepository, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.loanRepository = loanRepository;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

