/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.helper;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.fineract.infrastructure.campaigns.sms.data.MessageGatewayConfigurationData;
import org.apache.fineract.infrastructure.configuration.service.ExternalServicesPropertiesReadPlatformService;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class SmsConfigUtils {
    @Autowired
    private ExternalServicesPropertiesReadPlatformService propertiesReadPlatformService;

    public Map<String, Object> getMessageGateWayRequestURI(String apiEndPoint, String apiQueueResourceDatas) {
        HashMap<String, Object> httpRequestdetails = new HashMap<String, Object>();
        MessageGatewayConfigurationData messageGatewayConfigurationData = this.propertiesReadPlatformService.getSMSGateway();
        FineractPlatformTenant tenant = ThreadLocalContextUtil.getTenant();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Fineract-Platform-TenantId", tenant.getTenantIdentifier());
        headers.add("Fineract-Tenant-App-Key", messageGatewayConfigurationData.tenantAppKey());
        StringBuilder pathBuilder = new StringBuilder();
        String endPoint = messageGatewayConfigurationData.endPoint() == null || messageGatewayConfigurationData.endPoint().equals("/") ? "" : messageGatewayConfigurationData.endPoint();
        pathBuilder = messageGatewayConfigurationData.endPoint() == null || messageGatewayConfigurationData.endPoint().equals("/") ? pathBuilder.append("{apiEndPoint}") : pathBuilder.append("{endPoint}/{apiEndPoint}");
        UriBuilder builder = UriBuilder.fromPath((String)pathBuilder.toString()).host(messageGatewayConfigurationData.hostName()).scheme("http").port(messageGatewayConfigurationData.portNumber());
        URI uri = messageGatewayConfigurationData.endPoint() == null || messageGatewayConfigurationData.endPoint().equals("/") ? builder.build(new Object[]{apiEndPoint}) : builder.build(new Object[]{endPoint, apiEndPoint});
        HttpEntity entity = null;
        entity = apiQueueResourceDatas != null ? new HttpEntity((Object)apiQueueResourceDatas, (MultiValueMap)headers) : new HttpEntity((MultiValueMap)headers);
        httpRequestdetails.put("uri", uri);
        httpRequestdetails.put("entity", entity);
        return httpRequestdetails;
    }
}

