/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.service.StreamUtil;
import org.apache.fineract.infrastructure.dataqueries.data.ReportExportType;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableExportTargetParameter;
import org.apache.fineract.infrastructure.dataqueries.service.export.DatatableReportExportService;
import org.apache.fineract.infrastructure.dataqueries.service.export.ResponseHolder;
import org.apache.fineract.infrastructure.report.annotation.ReportService;
import org.apache.fineract.infrastructure.report.service.AbstractReportingProcessService;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ReportService(type={"Table", "Chart", "SMS"})
public class DatatableReportingProcessService
extends AbstractReportingProcessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatatableReportingProcessService.class);
    private final List<DatatableReportExportService> exportServices;

    public DatatableReportingProcessService(List<DatatableReportExportService> exportServices, SqlValidator sqlValidator) {
        super(sqlValidator);
        this.exportServices = exportServices;
    }

    public Response processRequest(String reportName, MultivaluedMap<String, String> queryParams) {
        boolean isSelfServiceUserReport = Boolean.parseBoolean((String)((List)queryParams.getOrDefault((Object)"isSelfServiceUserReport", List.of("false"))).get(0));
        DatatableExportTargetParameter exportMode = DatatableExportTargetParameter.resolverExportTarget(queryParams);
        String parameterTypeValue = ApiParameterHelper.parameterType(queryParams) ? "parameter" : "report";
        Map reportParams = this.getReportParams(queryParams);
        ResponseHolder response = ((DatatableReportExportService)this.findReportExportService(exportMode).orElseThrow(() -> new IllegalArgumentException("Unsupported export target: " + String.valueOf(exportMode)))).export(reportName, queryParams, reportParams, isSelfServiceUserReport, parameterTypeValue);
        Response.ResponseBuilder builder = Response.status((int)response.status().getStatusCode());
        if (StringUtils.isNotBlank((CharSequence)response.contentType())) {
            builder = builder.type(response.contentType());
        }
        if (StringUtils.isNotBlank((CharSequence)response.fileName())) {
            builder = builder.header("Content-Disposition", (Object)("attachment; filename=" + response.fileName()));
        }
        if (response.entity() != null) {
            builder = builder.entity(response.entity());
        }
        if (response.headers() != null && !response.headers().isEmpty()) {
            builder = (Response.ResponseBuilder)response.headers().stream().collect(StreamUtil.foldLeft((Object)builder, (b, h) -> b.header(h.getKey(), (Object)h.getValue())));
        }
        return builder.build();
    }

    public List<ReportExportType> getAvailableExportTargets() {
        return Arrays.stream(DatatableExportTargetParameter.values()).filter(target -> this.findReportExportService(target).isPresent()).map(target -> new ReportExportType(target.name(), target.getValue())).toList();
    }

    private Optional<DatatableReportExportService> findReportExportService(DatatableExportTargetParameter target) {
        return this.exportServices.stream().filter(service -> service.supports(target)).findFirst();
    }
}

