/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.data.ReportData;
import org.apache.fineract.infrastructure.dataqueries.data.ReportParameterData;
import org.apache.fineract.infrastructure.dataqueries.data.ReportParameterJoinData;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetColumnHeaderData;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetRowData;
import org.apache.fineract.infrastructure.dataqueries.exception.ReportNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingServiceImpl;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlInjectionPreventerService;
import org.apache.fineract.infrastructure.security.utils.LogParameterEscapeUtil;
import org.apache.fineract.useradministration.domain.AppUser;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.UnixCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class ReadReportingServiceImpl
implements ReadReportingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadReportingServiceImpl.class);
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final GenericDataService genericDataService;
    private final SqlInjectionPreventerService sqlInjectionPreventerService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final FineractProperties fineractProperties;

    public StreamingOutput retrieveReportCSV(String name, String type, Map<String, String> queryParams, boolean isSelfServiceUserReport) {
        return out -> {
            try {
                GenericResultsetData result = this.retrieveGenericResultset(name, type, queryParams, isSelfServiceUserReport);
                this.generateCsvFileBuffer(result, out);
            }
            catch (Exception e) {
                throw ErrorHandler.getMappable((Throwable)e);
            }
        };
    }

    private void generateCsvFileBuffer(GenericResultsetData result, OutputStream out) throws IOException {
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter(out, StandardCharsets.UTF_8), CSVFormat.EXCEL);){
            List columnHeaders = result.getColumnHeaders();
            List data = result.getData();
            ArrayList<String> header = new ArrayList<String>();
            for (ResultsetColumnHeaderData columnHeader : columnHeaders) {
                header.add(columnHeader.getColumnName());
            }
            printer.printRecord(header);
            for (ResultsetRowData row : data) {
                printer.printRecord((Iterable)row.getRow());
            }
        }
    }

    public GenericResultsetData retrieveGenericResultset(String name, String type, Map<String, String> queryParams, boolean isSelfServiceUserReport) {
        long startTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("STARTING REPORT: {}   Type: {}", (Object)LogParameterEscapeUtil.escapeLogParameter((String)name), (Object)LogParameterEscapeUtil.escapeLogParameter((String)type));
        }
        String sql = this.getSQLtoRun(name, type, queryParams, isSelfServiceUserReport);
        GenericResultsetData result = this.genericDataService.fillGenericResultSet(sql);
        long elapsed = System.currentTimeMillis() - startTime;
        if (log.isDebugEnabled()) {
            log.debug("FINISHING Report/Request Name: {} - {}     Elapsed Time: {}", new Object[]{LogParameterEscapeUtil.escapeLogParameter((String)name), type.replaceAll("[\n\r\t]", "_"), elapsed});
        }
        return result;
    }

    private String getSQLtoRun(String name, String type, Map<String, String> queryParams, boolean isSelfServiceUserReport) {
        String sql = this.getSql(name, type);
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            sql = this.genericDataService.replace(sql, entry.getKey(), entry.getValue());
        }
        AppUser currentUser = this.context.authenticatedUser();
        sql = this.genericDataService.replace(sql, "${currentUserHierarchy}", currentUser.getOffice().getHierarchy());
        sql = this.genericDataService.replace(sql, "${currentUserId}", ((Long)currentUser.getId()).toString());
        sql = this.genericDataService.replace(sql, "${isSelfServiceUser}", Boolean.toString(isSelfServiceUserReport));
        sql = this.genericDataService.replace(sql, "${currentDate}", this.sqlGenerator.currentBusinessDate());
        sql = StringUtils.replaceIgnoreCase((String)sql, (String)"NOW()", (String)this.sqlGenerator.currentTenantDateTime());
        sql = StringUtils.replaceIgnoreCase((String)sql, (String)"curdate()", (String)this.sqlGenerator.currentBusinessDate());
        sql = StringUtils.replaceIgnoreCase((String)sql, (String)"CURRENT_DATE", (String)this.sqlGenerator.currentBusinessDate());
        sql = this.genericDataService.wrapSQL(sql);
        return sql;
    }

    private String getSql(String name, String type) {
        String encodedName = this.sqlInjectionPreventerService.encodeSql(name);
        String encodedType = this.sqlInjectionPreventerService.encodeSql(type);
        String inputSql = "select " + encodedType + "_sql as the_sql from stretchy_" + encodedType + " where " + encodedType + "_name = ?";
        String inputSqlWrapped = this.genericDataService.wrapSQL(inputSql);
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(inputSqlWrapped, new Object[]{encodedName});
        if (rs.next() && rs.getString("the_sql") != null) {
            return rs.getString("the_sql");
        }
        throw new ReportNotFoundException(encodedName);
    }

    public String getReportType(String reportName, boolean isSelfServiceUserReport, boolean isParameterType) {
        if (isParameterType) {
            return "Table";
        }
        String sql = "SELECT coalesce(report_type,'') AS report_type FROM stretchy_report WHERE report_name = ? AND self_service_user_report = ?";
        String sqlWrapped = this.genericDataService.wrapSQL("SELECT coalesce(report_type,'') AS report_type FROM stretchy_report WHERE report_name = ? AND self_service_user_report = ?");
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sqlWrapped, new Object[]{reportName, isSelfServiceUserReport});
        if (rs.next()) {
            return rs.getString("report_type");
        }
        throw new ReportNotFoundException(reportName);
    }

    public String retrieveReportPDF(String reportName, String type, Map<String, String> queryParams, boolean isSelfServiceUserReport) {
        String fileLocation = this.fineractProperties.getContent().getFilesystem().getRootFolder() + File.separator;
        if (!new File(fileLocation).isDirectory()) {
            new File(fileLocation).mkdirs();
        }
        String genaratePdf = fileLocation + File.separator + reportName + ".pdf";
        try {
            GenericResultsetData result = this.retrieveGenericResultset(reportName, type, queryParams, isSelfServiceUserReport);
            List columnHeaders = result.getColumnHeaders();
            List data = result.getData();
            log.debug("NO. of Columns: {}", (Object)columnHeaders.size());
            Integer chSize = columnHeaders.size();
            Document document = new Document(PageSize.B0.rotate());
            String validatedFileName = ESAPI.encoder().encodeForOS((Codec)new UnixCodec(), reportName);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileLocation + validatedFileName + ".pdf"));
            document.open();
            PdfPTable table = new PdfPTable(chSize.intValue());
            table.setWidthPercentage(100.0f);
            for (int i = 0; i < chSize; ++i) {
                table.addCell(((ResultsetColumnHeaderData)columnHeaders.get(i)).getColumnName());
            }
            table.completeRow();
            log.debug("NO. of Rows: {}", (Object)data.size());
            for (ResultsetRowData element : data) {
                List row = element.getRow();
                Integer rSize = row.size();
                for (int j = 0; j < rSize; ++j) {
                    String currVal = (String)row.get(j);
                    if (currVal == null) continue;
                    table.addCell(currVal);
                }
            }
            table.completeRow();
            document.add((Element)table);
            document.close();
            return genaratePdf;
        }
        catch (Exception e) {
            log.error("error.msg.reporting.error:", (Throwable)e);
            throw ErrorHandler.getMappable((Throwable)e);
        }
    }

    public ReportData retrieveReport(Long id) {
        Collection reports = this.retrieveReports(id);
        Iterator iterator = reports.iterator();
        if (iterator.hasNext()) {
            ReportData report = (ReportData)iterator.next();
            return report;
        }
        return null;
    }

    public Collection<ReportData> retrieveReportList() {
        return this.retrieveReports(null);
    }

    private Collection<ReportData> retrieveReports(Long id) {
        Object[] objectArray;
        ReportParameterJoinMapper rm = new ReportParameterJoinMapper();
        String sql = rm.schema(id);
        if (id != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = id;
        } else {
            objectArray = new Object[]{};
        }
        List rpJoins = this.jdbcTemplate.query(sql, (RowMapper)rm, objectArray);
        ArrayList<ReportData> reportList = new ArrayList<ReportData>();
        if (rpJoins == null || rpJoins.size() == 0) {
            return reportList;
        }
        ArrayList<ReportParameterData> reportParameters = null;
        Long reportId = null;
        String reportName = null;
        String reportType = null;
        String reportSubType = null;
        String reportCategory = null;
        String description = null;
        Boolean coreReport = null;
        Boolean useReport = null;
        String reportSql = null;
        Long prevReportId = -1234L;
        Boolean firstReport = true;
        for (ReportParameterJoinData rpJoin : rpJoins) {
            if (rpJoin.getReportId().equals(prevReportId)) {
                if (reportParameters == null) {
                    reportParameters = new ArrayList<ReportParameterData>();
                }
                reportParameters.add(new ReportParameterData(rpJoin.getReportParameterId(), rpJoin.getParameterId(), rpJoin.getReportParameterName(), rpJoin.getParameterName()));
                continue;
            }
            if (firstReport.booleanValue()) {
                firstReport = false;
            } else {
                reportList.add(new ReportData(reportId, reportName, reportType, reportSubType, reportCategory, description, reportSql, coreReport, useReport, reportParameters));
            }
            prevReportId = rpJoin.getReportId();
            reportId = rpJoin.getReportId();
            reportName = rpJoin.getReportName();
            reportType = rpJoin.getReportType();
            reportSubType = rpJoin.getReportSubType();
            reportCategory = rpJoin.getReportCategory();
            description = rpJoin.getDescription();
            reportSql = rpJoin.getReportSql();
            coreReport = rpJoin.getCoreReport();
            useReport = rpJoin.getUseReport();
            if (rpJoin.getReportParameterId() != null) {
                reportParameters = new ArrayList();
                reportParameters.add(new ReportParameterData(rpJoin.getReportParameterId(), rpJoin.getParameterId(), rpJoin.getReportParameterName(), rpJoin.getParameterName()));
                continue;
            }
            reportParameters = null;
        }
        reportList.add(new ReportData(reportId, reportName, reportType, reportSubType, reportCategory, description, reportSql, coreReport, useReport, reportParameters));
        return reportList;
    }

    public Collection<ReportParameterData> getAllowedParameters() {
        ReportParameterMapper rm = new ReportParameterMapper();
        String sql = rm.schema();
        List parameters = this.jdbcTemplate.query(sql, (RowMapper)rm);
        return parameters;
    }

    public GenericResultsetData retrieveGenericResultSetForSmsEmailCampaign(String name, String type, Map<String, String> queryParams) {
        long startTime = System.currentTimeMillis();
        log.debug("STARTING REPORT: {}   Type: {}", (Object)name, (Object)type);
        String sql = this.sqlToRunForSmsEmailCampaign(name, type, queryParams);
        GenericResultsetData result = this.genericDataService.fillGenericResultSet(sql);
        long elapsed = System.currentTimeMillis() - startTime;
        log.debug("FINISHING Report/Request Name: {} - {}     Elapsed Time: {}", new Object[]{name, type, elapsed});
        return result;
    }

    private String sqlToRunForSmsEmailCampaign(String name, String type, Map<String, String> queryParams) {
        String sql = this.getSql(name, type);
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            sql = this.genericDataService.replace(sql, "${" + entry.getKey() + "}", entry.getValue());
        }
        sql = this.genericDataService.wrapSQL(sql);
        return sql;
    }

    public ByteArrayOutputStream generatePentahoReportAsOutputStream(String reportName, String outputTypeParam, Map<String, String> queryParams, Locale locale, AppUser runReportAsUser, StringBuilder errorLog) {
        return null;
    }

    @Generated
    public ReadReportingServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, GenericDataService genericDataService, SqlInjectionPreventerService sqlInjectionPreventerService, DatabaseSpecificSQLGenerator sqlGenerator, FineractProperties fineractProperties) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.genericDataService = genericDataService;
        this.sqlInjectionPreventerService = sqlInjectionPreventerService;
        this.sqlGenerator = sqlGenerator;
        this.fineractProperties = fineractProperties;
    }
}

