/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.service;

import javax.sql.DataSource;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.tenant.TenantMapper;
import org.apache.fineract.infrastructure.security.exception.InvalidTenantIdentifierException;
import org.apache.fineract.infrastructure.security.service.BasicAuthTenantDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class BasicAuthTenantDetailsServiceJdbc
implements BasicAuthTenantDetailsService {
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public BasicAuthTenantDetailsServiceJdbc(@Qualifier(value="hikariTenantDataSource") DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Cacheable(value={"tenantsById"})
    public FineractPlatformTenant loadTenantById(String tenantIdentifier, boolean isReport) {
        try {
            TenantMapper rm = new TenantMapper(isReport);
            String sql = "select  " + rm.schema() + " where t.identifier = ?";
            return (FineractPlatformTenant)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{tenantIdentifier});
        }
        catch (EmptyResultDataAccessException e) {
            throw new InvalidTenantIdentifierException("The tenant identifier: " + tenantIdentifier + " is not valid.", e);
        }
    }
}

