/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.batch.command.CommandHandlerRegistry;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.account.api.StandingInstructionApiResourceSwagger;
import org.apache.fineract.portfolio.account.data.StandingInstructionDTO;
import org.apache.fineract.portfolio.account.data.StandingInstructionData;
import org.apache.fineract.portfolio.account.data.request.StandingInstructionCreationRequest;
import org.apache.fineract.portfolio.account.data.request.StandingInstructionSearchParam;
import org.apache.fineract.portfolio.account.data.request.StandingInstructionUpdatesRequest;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.apache.fineract.portfolio.account.service.StandingInstructionReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/standinginstructions")
@Component
@Tag(name="Standing Instructions", description="Standing instructions (or standing orders) refer to instructions a bank account holder (\"the payer\") gives to his or her bank to pay a set amount at regular intervals to another's (\"the payee's\") account.\n\nNote: At present only savings account to savings account and savings account to Loan account transfers are permitted.")
public class StandingInstructionApiResource {
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<StandingInstructionData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final StandingInstructionReadPlatformService standingInstructionReadPlatformService;
    private final AccountTransfersReadPlatformService accountTransfersReadPlatformService;
    private final SqlValidator sqlValidator;
    private static final CommandHandlerRegistry<String, Long, String, CommandWrapper> COMMAND_HANDLER_REGISTRY = new CommandHandlerRegistry(Map.of("update", (id, json) -> new CommandWrapperBuilder().updateStandingInstruction(id).withJson(json).build(), "delete", (id, json) -> new CommandWrapperBuilder().deleteStandingInstruction(id).withJson(json).build()));

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Standing Instruction Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\nExample Requests:\n\nstandinginstructions/template?fromAccountType=2&fromOfficeId=1\n\nstandinginstructions/template?fromAccountType=2&fromOfficeId=1&fromClientId=1&transferType=1\n\nstandinginstructions/template?fromClientId=1&fromAccountType=2&fromAccountId=1&transferType=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=StandingInstructionApiResourceSwagger.GetStandingInstructionsTemplateResponse.class))})})
    public StandingInstructionData template(@BeanParam StandingInstructionSearchParam instructionParam) {
        this.context.authenticatedUser().validateHasReadPermission("standinginstruction");
        return this.standingInstructionReadPlatformService.retrieveTemplate(instructionParam.getFromOfficeId(), instructionParam.getFromClientId(), instructionParam.getFromAccountId(), instructionParam.getFromAccountType(), instructionParam.getToOfficeId(), instructionParam.getToClientId(), instructionParam.getToAccountId(), instructionParam.getToAccountType(), instructionParam.getTransferType());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create new Standing Instruction", description="Ability to create new instruction for transfer of monetary funds from one account to another")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=StandingInstructionCreationRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=StandingInstructionApiResourceSwagger.PostStandingInstructionsResponse.class))})})
    public CommandProcessingResult create(@Parameter(hidden=true) StandingInstructionCreationRequest creationRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createStandingInstruction().withJson(this.toApiJsonSerializer.serialize((Object)creationRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @PUT
    @Path(value="{standingInstructionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Standing Instruction | Delete Standing Instruction", description="Ability to modify existing instruction for transfer of monetary funds from one account to another.\n\nPUT https://DomainName/api/v1/standinginstructions/1?command=update\n\n\nAbility to modify existing instruction for transfer of monetary funds from one account to another.\n\nPUT https://DomainName/api/v1/standinginstructions/1?command=delete")
    @RequestBody(content={@Content(schema=@Schema(implementation=StandingInstructionUpdatesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=StandingInstructionApiResourceSwagger.PutStandingInstructionsStandingInstructionIdResponse.class))})})
    public CommandProcessingResult update(@PathParam(value="standingInstructionId") @Parameter(description="standingInstructionId") Long standingInstructionId, @Parameter(hidden=true) StandingInstructionUpdatesRequest updatesRequest, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        String serializedUpdatesRequest = this.toApiJsonSerializer.serialize((Object)updatesRequest);
        CommandWrapper commandRequest = (CommandWrapper)COMMAND_HANDLER_REGISTRY.execute((Object)commandParam, (Object)standingInstructionId, (Object)serializedUpdatesRequest, (RuntimeException)new UnrecognizedQueryParamException("command", commandParam, new Object[0]));
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Standing Instructions", description="Example Requests:\n\nstandinginstructions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=StandingInstructionApiResourceSwagger.GetStandingInstructionsResponse.class))})})
    public Page<StandingInstructionData> retrieveAll(@QueryParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="transferType") @Parameter(description="transferType") Integer transferType, @QueryParam(value="clientName") @Parameter(description="clientName") String clientName, @QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="fromAccountId") @Parameter(description="fromAccountId") Long fromAccount, @QueryParam(value="fromAccountType") @Parameter(description="fromAccountType") Integer fromAccountType) {
        this.context.authenticatedUser().validateHasReadPermission("standinginstruction");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        this.sqlValidator.validate(externalId);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).externalId(externalId).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        LocalDate startDateRange = null;
        LocalDate endDateRange = null;
        StandingInstructionDTO standingInstructionDTO = new StandingInstructionDTO(searchParameters, transferType, clientName, clientId, fromAccount, fromAccountType, startDateRange, endDateRange);
        return this.standingInstructionReadPlatformService.retrieveAll(standingInstructionDTO);
    }

    @GET
    @Path(value="{standingInstructionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Standing Instruction", description="Example Requests :\n\nstandinginstructions/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=StandingInstructionApiResourceSwagger.GetStandingInstructionsStandingInstructionIdResponse.class))})})
    public StandingInstructionData retrieveOne(@PathParam(value="standingInstructionId") @Parameter(description="standingInstructionId") Long standingInstructionId, @Context UriInfo uriInfo, @QueryParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        this.context.authenticatedUser().validateHasReadPermission("standinginstruction");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        StandingInstructionData standingInstructionData = this.standingInstructionReadPlatformService.retrieveOne(standingInstructionId);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).externalId(externalId).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty()) {
            if (associationParameters.contains("all")) {
                associationParameters.addAll(Arrays.asList("transactions", "template"));
            }
            if (associationParameters.contains("transactions")) {
                Page transfers = this.accountTransfersReadPlatformService.retrieveByStandingInstruction(standingInstructionId, searchParameters);
                standingInstructionData = StandingInstructionData.withTransferData((StandingInstructionData)standingInstructionData, (Page)transfers);
            }
            if (associationParameters.contains("template")) {
                StandingInstructionData templateData = this.standingInstructionReadPlatformService.retrieveTemplate(standingInstructionData.getFromClient().getOfficeId(), standingInstructionData.getFromClient().getId(), standingInstructionData.getFromAccount().getId(), standingInstructionData.getFromAccountType().getValue(), standingInstructionData.getToClient().getOfficeId(), standingInstructionData.getToClient().getId(), standingInstructionData.getToAccount().getId(), standingInstructionData.getToAccountType().getValue(), standingInstructionData.getTransferType().getValue());
                standingInstructionData = StandingInstructionData.withTemplateData((StandingInstructionData)standingInstructionData, (StandingInstructionData)templateData);
            }
        }
        return standingInstructionData;
    }

    @Generated
    public StandingInstructionApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<StandingInstructionData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, StandingInstructionReadPlatformService standingInstructionReadPlatformService, AccountTransfersReadPlatformService accountTransfersReadPlatformService, SqlValidator sqlValidator) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.standingInstructionReadPlatformService = standingInstructionReadPlatformService;
        this.accountTransfersReadPlatformService = accountTransfersReadPlatformService;
        this.sqlValidator = sqlValidator;
    }
}

