/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.service;

import com.google.gson.JsonElement;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrency;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepository;
import org.apache.fineract.portfolio.collateralmanagement.api.CollateralManagementJsonInputParams;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.collateralmanagement.domain.CollateralManagementDomain;
import org.apache.fineract.portfolio.collateralmanagement.domain.CollateralManagementRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.exception.CollateralCannotBeDeletedException;
import org.apache.fineract.portfolio.collateralmanagement.exception.CollateralNotFoundException;
import org.apache.fineract.portfolio.collateralmanagement.service.CollateralManagementWritePlatformService;
import org.springframework.transaction.annotation.Transactional;

public class CollateralManagementWritePlatformServiceImpl
implements CollateralManagementWritePlatformService {
    private final CollateralManagementRepositoryWrapper collateralManagementRepositoryWrapper;
    private final ApplicationCurrencyRepository applicationCurrencyRepository;
    private final FromJsonHelper fromApiJsonHelper;

    @Transactional
    public CommandProcessingResult createCollateral(JsonCommand jsonCommand) {
        this.validateForCreation(jsonCommand);
        String currencyParamName = jsonCommand.stringValueOfParameterNamed(CollateralManagementJsonInputParams.CURRENCY.getValue());
        ApplicationCurrency applicationCurrency = this.applicationCurrencyRepository.findOneByCode(currencyParamName);
        CollateralManagementDomain collateral = CollateralManagementDomain.createNew((JsonCommand)jsonCommand, (ApplicationCurrency)applicationCurrency);
        this.collateralManagementRepositoryWrapper.create(collateral);
        return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId((Long)collateral.getId()).build();
    }

    private void validateForCreation(JsonCommand jsonCommand) {
        String unitType;
        BigDecimal basePrice;
        JsonElement jsonElement = this.fromApiJsonHelper.parse(jsonCommand.json());
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("collateral-management");
        if (!jsonCommand.parameterExists("locale")) {
            baseDataValidator.reset().parameter("locale").notNull().failWithCode("locale.not.exists", new Object[0]);
        } else {
            String locale = this.fromApiJsonHelper.extractStringNamed("locale", jsonElement);
            baseDataValidator.reset().parameter("locale").value((Object)locale).notNull();
        }
        if (!jsonCommand.parameterExists(CollateralManagementJsonInputParams.CURRENCY.getValue())) {
            baseDataValidator.reset().parameter(CollateralManagementJsonInputParams.CURRENCY.getValue()).notNull().failWithCode("currency.not.exists", new Object[0]);
        } else {
            String currency = this.fromApiJsonHelper.extractStringNamed("currency", jsonElement);
            baseDataValidator.reset().parameter("currency").value((Object)currency).notNull();
        }
        if (!jsonCommand.parameterExists("quality")) {
            baseDataValidator.reset().parameter(CollateralManagementJsonInputParams.QUALITY.getValue()).notNull().failWithCode("quality.not.exists", new Object[0]);
        } else {
            String quality = this.fromApiJsonHelper.extractStringNamed("quality", jsonElement);
            baseDataValidator.reset().parameter("quality").value((Object)quality).notNull();
        }
        if (!jsonCommand.parameterExists("basePrice")) {
            baseDataValidator.reset().parameter("basePrice").notNull().notBlank().failWithCode("basePrice.not.exists", new Object[0]);
        } else {
            basePrice = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("basePrice", jsonElement);
            baseDataValidator.reset().parameter("basePrice").value((Object)basePrice).notNull().positiveAmount();
        }
        if (!jsonCommand.parameterExists("unitType")) {
            baseDataValidator.reset().parameter("unitType").notNull().notBlank().failWithCode("unitType.not.exists", new Object[0]);
        } else {
            unitType = this.fromApiJsonHelper.extractStringNamed("unitType", jsonElement);
            baseDataValidator.reset().parameter("unitType").value((Object)unitType).notNull();
        }
        if (!jsonCommand.parameterExists("pctToBase")) {
            baseDataValidator.reset().parameter("pctToBase").notNull().notBlank().failWithCode("pctToBase.not.exists", new Object[0]);
        } else {
            basePrice = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("pctToBase", jsonElement);
            baseDataValidator.reset().parameter("pctToBase").value((Object)basePrice).notNull().positiveAmount();
        }
        if (!jsonCommand.parameterExists("name")) {
            baseDataValidator.reset().parameter("name").notNull().notBlank().failWithCode("name.not.exists", new Object[0]);
        } else {
            unitType = this.fromApiJsonHelper.extractStringNamed("name", jsonElement);
            baseDataValidator.reset().parameter("name").value((Object)unitType).notNull();
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    @Transactional
    public CommandProcessingResult updateCollateral(Long collateralId, JsonCommand jsonCommand) {
        ApplicationCurrency applicationCurrency;
        CollateralManagementDomain collateral = this.collateralManagementRepositoryWrapper.getCollateral(collateralId);
        String currencyParamName = CollateralManagementJsonInputParams.CURRENCY.getValue();
        if (jsonCommand.isChangeInStringParameterNamed(currencyParamName, (applicationCurrency = this.applicationCurrencyRepository.findOneByCode(jsonCommand.stringValueOfParameterNamed(currencyParamName))).getCode())) {
            String newValue = jsonCommand.stringValueOfParameterNamed(currencyParamName);
            applicationCurrency.setCode(newValue);
        }
        Map changes = collateral.update(jsonCommand, applicationCurrency);
        this.collateralManagementRepositoryWrapper.update(collateral);
        return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(jsonCommand.entityId()).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult deleteCollateral(Long collateralId) {
        CollateralManagementDomain collateralManagementDomain = this.collateralManagementRepositoryWrapper.getCollateral(collateralId);
        this.validateForDeletion(collateralManagementDomain, collateralId);
        this.collateralManagementRepositoryWrapper.delete(collateralId);
        return new CommandProcessingResultBuilder().withEntityId(collateralId).build();
    }

    private void validateForDeletion(CollateralManagementDomain collateralManagementDomain, Long collateralId) {
        if (collateralManagementDomain == null) {
            throw new CollateralNotFoundException(collateralId);
        }
        if (collateralManagementDomain.getClientCollateralManagements().size() > 0) {
            for (ClientCollateralManagement clientCollateralManagement : collateralManagementDomain.getClientCollateralManagements()) {
                if (clientCollateralManagement.getQuantity().compareTo(BigDecimal.ZERO) <= 0) continue;
                throw new CollateralCannotBeDeletedException(CollateralCannotBeDeletedException.CollateralCannotBeDeletedReason.COLLATERAL_IS_ALREADY_ATTACHED, collateralId);
            }
        }
    }

    @Generated
    public CollateralManagementWritePlatformServiceImpl(CollateralManagementRepositoryWrapper collateralManagementRepositoryWrapper, ApplicationCurrencyRepository applicationCurrencyRepository, FromJsonHelper fromApiJsonHelper) {
        this.collateralManagementRepositoryWrapper = collateralManagementRepositoryWrapper;
        this.applicationCurrencyRepository = applicationCurrencyRepository;
        this.fromApiJsonHelper = fromApiJsonHelper;
    }
}

