/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.loanschedule.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.holiday.domain.Holiday;
import org.apache.fineract.organisation.holiday.domain.HolidayRepository;
import org.apache.fineract.organisation.holiday.domain.HolidayStatusType;
import org.apache.fineract.organisation.holiday.service.HolidayUtil;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrency;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.organisation.workingdays.service.WorkingDaysUtil;
import org.apache.fineract.portfolio.accountdetails.domain.AccountType;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarFrequencyType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.exception.CalendarNotFoundException;
import org.apache.fineract.portfolio.calendar.exception.MeetingFrequencyMismatchException;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.common.domain.DayOfWeekType;
import org.apache.fineract.portfolio.common.domain.DaysInMonthType;
import org.apache.fineract.portfolio.common.domain.DaysInYearCustomStrategyType;
import org.apache.fineract.portfolio.common.domain.DaysInYearType;
import org.apache.fineract.portfolio.common.domain.NthDayType;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.floatingrates.data.FloatingRateDTO;
import org.apache.fineract.portfolio.floatingrates.data.FloatingRatePeriodData;
import org.apache.fineract.portfolio.floatingrates.exception.FloatingRateNotFoundException;
import org.apache.fineract.portfolio.floatingrates.service.FloatingRatesReadPlatformService;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.data.DisbursementData;
import org.apache.fineract.portfolio.loanaccount.data.HolidayDetailDTO;
import org.apache.fineract.portfolio.loanaccount.data.LoanTermVariationsData;
import org.apache.fineract.portfolio.loanaccount.data.OutstandingAmountsDTO;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargeOffBehaviour;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanEvent;
import org.apache.fineract.portfolio.loanaccount.domain.LoanLifecycleStateMachine;
import org.apache.fineract.portfolio.loanaccount.domain.LoanOfficerAssignmentHistory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTermVariationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTermVariations;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.exception.LoanApplicationDateException;
import org.apache.fineract.portfolio.loanaccount.exception.MinDaysBetweenDisbursalAndFirstRepaymentViolationException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.AprCalculator;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanApplicationTerms;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleGenerator;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleGeneratorFactory;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleModel;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleModelDisbursementPeriod;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleModelPeriod;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleProcessingType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleAssembler;
import org.apache.fineract.portfolio.loanaccount.serialization.VariableLoanScheduleFromApiJsonValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeService;
import org.apache.fineract.portfolio.loanaccount.service.LoanDisbursementDetailsAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanDisbursementService;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductRelatedDetailUpdateUtil;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanproduct.domain.AmortizationMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestCalculationPeriodMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestRecalculationCompoundingMethod;
import org.apache.fineract.portfolio.loanproduct.domain.LoanPreCloseInterestCalculationStrategy;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductInterestRecalculationDetails;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRelatedDetail;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductVariableInstallmentConfig;
import org.apache.fineract.portfolio.loanproduct.domain.RecalculationFrequencyType;
import org.apache.fineract.portfolio.loanproduct.domain.RepaymentStartDateType;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;
import org.apache.fineract.portfolio.loanproduct.service.LoanEnumerations;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.stereotype.Service;

@Service
public class LoanScheduleAssembler {
    private final FromJsonHelper fromApiJsonHelper;
    private final LoanProductRepository loanProductRepository;
    private final ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository;
    private final LoanChargeAssembler loanChargeAssembler;
    private final LoanScheduleGeneratorFactory loanScheduleFactory;
    private final AprCalculator aprCalculator;
    private final CalendarRepository calendarRepository;
    private final HolidayRepository holidayRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final ClientRepositoryWrapper clientRepository;
    private final GroupRepositoryWrapper groupRepository;
    private final WorkingDaysRepositoryWrapper workingDaysRepository;
    private final FloatingRatesReadPlatformService floatingRatesReadPlatformService;
    private final VariableLoanScheduleFromApiJsonValidator variableLoanScheduleFromApiJsonValidator;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final LoanUtilService loanUtilService;
    private final LoanDisbursementDetailsAssembler loanDisbursementDetailsAssembler;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanLifecycleStateMachine loanLifecycleStateMachine;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final LoanDisbursementService loanDisbursementService;
    private final LoanChargeService loanChargeService;
    private final LoanScheduleService loanScheduleService;
    private final LoanProductRelatedDetailUpdateUtil relatedDetailUpdateUtil;

    public LoanApplicationTerms assembleLoanTerms(JsonElement element) {
        Long loanProductId = this.fromApiJsonHelper.extractLongNamed("productId", element);
        LoanProduct loanProduct = (LoanProduct)this.loanProductRepository.findById((Object)loanProductId).orElseThrow(() -> new LoanProductNotFoundException(loanProductId));
        return this.assembleLoanApplicationTermsFrom(element, loanProduct);
    }

    private LoanApplicationTerms assembleLoanApplicationTermsFrom(JsonElement element, LoanProduct loanProduct) {
        LocalDate tmpCalculatedRepaymentsStartingFromDate;
        Boolean allowOverridingAmortization = loanProduct.getLoanConfigurableAttributes().getAmortizationBoolean();
        Boolean allowOverridingArrearsTolerance = loanProduct.getLoanConfigurableAttributes().getArrearsToleranceBoolean();
        Boolean allowOverridingGraceOnArrearsAging = loanProduct.getLoanConfigurableAttributes().getGraceOnArrearsAgingBoolean();
        Boolean allowOverridingInterestCalcPeriod = loanProduct.getLoanConfigurableAttributes().getInterestCalcPeriodBoolean();
        Boolean allowOverridingInterestMethod = loanProduct.getLoanConfigurableAttributes().getInterestMethodBoolean();
        Boolean allowOverridingGraceOnPrincipalAndInterestPayment = loanProduct.getLoanConfigurableAttributes().getGraceOnPrincipalAndInterestPaymentBoolean();
        Boolean allowOverridingRepaymentEvery = loanProduct.getLoanConfigurableAttributes().getRepaymentEveryBoolean();
        MonetaryCurrency currency = loanProduct.getCurrency();
        ApplicationCurrency applicationCurrency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(currency);
        Integer loanTermFrequency = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("loanTermFrequency", element);
        Integer loanTermFrequencyType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("loanTermFrequencyType", element);
        PeriodFrequencyType loanTermPeriodFrequencyType = PeriodFrequencyType.fromInt((Integer)loanTermFrequencyType);
        Integer numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("numberOfRepayments", element);
        Integer repaymentEvery = allowOverridingRepaymentEvery != false ? this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentEvery", element) : loanProduct.getLoanProductRelatedDetail().getRepayEvery();
        Integer repaymentFrequencyType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentFrequencyType", element);
        PeriodFrequencyType repaymentPeriodFrequencyType = PeriodFrequencyType.fromInt((Integer)repaymentFrequencyType);
        Integer nthDay = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentFrequencyNthDayType", element);
        Integer dayOfWeek = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentFrequencyDayOfWeekType", element);
        DayOfWeekType weekDayType = DayOfWeekType.fromInt((Integer)dayOfWeek);
        Integer amortizationType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("amortizationType", element);
        AmortizationMethod amortizationMethod = allowOverridingAmortization != false ? AmortizationMethod.fromInt((Integer)amortizationType) : loanProduct.getLoanProductRelatedDetail().getAmortizationMethod();
        boolean isEqualAmortization = false;
        if (this.fromApiJsonHelper.parameterExists("isEqualAmortization", element)) {
            isEqualAmortization = this.fromApiJsonHelper.extractBooleanNamed("isEqualAmortization", element);
        }
        BigDecimal fixedPrincipalPercentagePerInstallment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedPrincipalPercentagePerInstallment", element);
        Integer interestType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("interestType", element);
        InterestMethod interestMethod = allowOverridingInterestMethod != false ? InterestMethod.fromInt((Integer)interestType) : loanProduct.getLoanProductRelatedDetail().getInterestMethod();
        Integer interestCalculationPeriodType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("interestCalculationPeriodType", element);
        InterestCalculationPeriodMethod interestCalculationPeriodMethod = allowOverridingInterestCalcPeriod != false ? InterestCalculationPeriodMethod.fromInt((Integer)interestCalculationPeriodType) : loanProduct.getLoanProductRelatedDetail().getInterestCalculationPeriodMethod();
        Boolean allowPartialPeriodInterestCalcualtion = this.fromApiJsonHelper.extractBooleanNamed("allowPartialPeriodInterestCalcualtion", element);
        if (allowPartialPeriodInterestCalcualtion == null) {
            allowPartialPeriodInterestCalcualtion = loanProduct.getLoanProductRelatedDetail().isAllowPartialPeriodInterestCalculation();
        }
        BigDecimal interestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("interestRatePerPeriod", element);
        PeriodFrequencyType interestRatePeriodFrequencyType = loanProduct.getInterestPeriodFrequencyType();
        if (this.fromApiJsonHelper.parameterExists("interestRateFrequencyType", element)) {
            Integer interestRateFrequencyType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("interestRateFrequencyType", element);
            interestRatePeriodFrequencyType = PeriodFrequencyType.fromInt((Integer)interestRateFrequencyType);
        }
        BigDecimal annualNominalInterestRate = BigDecimal.ZERO;
        if (interestRatePerPeriod != null) {
            annualNominalInterestRate = this.aprCalculator.calculateFrom(interestRatePeriodFrequencyType, interestRatePerPeriod, numberOfRepayments, repaymentEvery, repaymentPeriodFrequencyType);
        }
        BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principal", element);
        Money principalMoney = Money.of((MonetaryCurrency)currency, (BigDecimal)principal);
        LocalDate expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", element);
        LocalDate repaymentsStartingFromDate = this.fromApiJsonHelper.extractLocalDateNamed("repaymentsStartingFromDate", element);
        LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
        RepaymentStartDateType repaymentStartDateType = loanProduct.getRepaymentStartDateType();
        LocalDate calculatedRepaymentsStartingFromDate = repaymentsStartingFromDate;
        Long calendarId = this.fromApiJsonHelper.extractLongNamed("calendarId", element);
        Calendar calendar = null;
        String loanTypeParameterName = "loanType";
        String loanTypeStr = this.fromApiJsonHelper.extractStringNamed("loanType", element);
        AccountType loanType = AccountType.fromName((String)loanTypeStr);
        if ((loanType.isJLGAccount() || loanType.isGroupAccount()) && calendarId != null) {
            calendar = (Calendar)this.calendarRepository.findById((Object)calendarId).orElseThrow(() -> new CalendarNotFoundException(calendarId));
            PeriodFrequencyType meetingPeriodFrequency = CalendarUtils.getMeetingPeriodFrequencyType((String)calendar.getRecurrence());
            this.validateRepaymentFrequencyIsSameAsMeetingFrequency(meetingPeriodFrequency.getValue(), repaymentFrequencyType, Integer.valueOf(CalendarUtils.getInterval((String)calendar.getRecurrence())), repaymentEvery);
        } else if (repaymentPeriodFrequencyType == PeriodFrequencyType.MONTHS && nthDay != null && !nthDay.equals(NthDayType.INVALID.getValue())) {
            LocalDate calendarStartDate = repaymentsStartingFromDate;
            if (calendarStartDate == null) {
                calendarStartDate = RepaymentStartDateType.DISBURSEMENT_DATE.equals((Object)repaymentStartDateType) ? expectedDisbursementDate : submittedOnDate;
            }
            calendar = this.createLoanCalendar(calendarStartDate, repaymentEvery, CalendarFrequencyType.MONTHLY, dayOfWeek, nthDay);
        }
        if (calculatedRepaymentsStartingFromDate == null && !(tmpCalculatedRepaymentsStartingFromDate = this.deriveFirstRepaymentDate(loanType, repaymentEvery, expectedDisbursementDate, repaymentPeriodFrequencyType, Integer.valueOf(0), calendar, submittedOnDate, repaymentStartDateType)).equals(calculatedRepaymentsStartingFromDate = this.deriveFirstRepaymentDate(loanType, repaymentEvery, expectedDisbursementDate, repaymentPeriodFrequencyType, loanProduct.getMinimumDaysBetweenDisbursalAndFirstRepayment(), calendar, submittedOnDate, repaymentStartDateType))) {
            repaymentsStartingFromDate = calculatedRepaymentsStartingFromDate;
        }
        Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
        Group group = null;
        if (groupId != null) {
            group = this.groupRepository.findOneWithNotFoundDetection(groupId);
        }
        Boolean isSkipMeetingOnFirstDay = false;
        Integer numberOfDays = 0;
        boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
        if (isSkipRepaymentOnFirstMonthEnabled && (isSkipMeetingOnFirstDay = this.loanUtilService.isLoanRepaymentsSyncWithMeeting(group, calendar)).booleanValue()) {
            numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
        }
        if ((loanType.isJLGAccount() || loanType.isGroupAccount()) && calendar != null) {
            this.validateRepaymentsStartDateWithMeetingDates(calculatedRepaymentsStartingFromDate, calendar, isSkipMeetingOnFirstDay.booleanValue(), numberOfDays);
        }
        if (RepaymentStartDateType.DISBURSEMENT_DATE.equals((Object)repaymentStartDateType)) {
            this.validateMinimumDaysBetweenDisbursalAndFirstRepayment(expectedDisbursementDate, calculatedRepaymentsStartingFromDate, loanProduct.getMinimumDaysBetweenDisbursalAndFirstRepayment());
        }
        Integer graceOnPrincipalPayment = allowOverridingGraceOnPrincipalAndInterestPayment != false ? this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnPrincipalPayment", element) : loanProduct.getLoanProductRelatedDetail().getGraceOnPrincipalPayment();
        Integer recurringMoratoriumOnPrincipalPeriods = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("recurringMoratoriumOnPrincipalPeriods", element);
        Integer graceOnInterestPayment = allowOverridingGraceOnPrincipalAndInterestPayment != false ? this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnInterestPayment", element) : loanProduct.getLoanProductRelatedDetail().getGraceOnInterestPayment();
        Integer graceOnInterestCharged = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnInterestCharged", element);
        LocalDate interestChargedFromDate = this.fromApiJsonHelper.extractLocalDateNamed("interestChargedFromDate", element);
        Boolean isInterestChargedFromDateSameAsDisbursalDateEnabled = this.configurationDomainService.isInterestChargedFromDateSameAsDisbursementDate();
        Integer graceOnArrearsAgeing = allowOverridingGraceOnArrearsAging != false ? this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnArrearsAgeing", element) : loanProduct.getLoanProductRelatedDetail().getGraceOnArrearsAgeing();
        BigDecimal inArrearsTolerance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("inArrearsTolerance", element);
        Money inArrearsToleranceMoney = allowOverridingArrearsTolerance != false ? Money.of((MonetaryCurrency)currency, (BigDecimal)inArrearsTolerance) : loanProduct.getLoanProductRelatedDetail().getInArrearsTolerance();
        BigDecimal emiAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedEmiAmount", element);
        BigDecimal maxOutstandingBalance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("maxOutstandingLoanBalance", element);
        List disbursementDatas = this.fetchDisbursementData(element.getAsJsonObject());
        DaysInMonthType daysInMonthType = loanProduct.fetchDaysInMonthType();
        DaysInYearType daysInYearType = null;
        Integer daysInYearTypeIntFromApplication = this.fromApiJsonHelper.extractIntegerNamed("daysInYearType", element, Locale.getDefault());
        daysInYearType = daysInYearTypeIntFromApplication != null ? DaysInYearType.fromInt((Integer)daysInYearTypeIntFromApplication) : loanProduct.fetchDaysInYearType();
        boolean isInterestRecalculationEnabled = loanProduct.isInterestRecalculationEnabled();
        RecalculationFrequencyType recalculationFrequencyType = null;
        CalendarInstance restCalendarInstance = null;
        RecalculationFrequencyType compoundingFrequencyType = null;
        CalendarInstance compoundingCalendarInstance = null;
        InterestRecalculationCompoundingMethod compoundingMethod = null;
        boolean allowCompoundingOnEod = false;
        Boolean isFloatingInterestRate = this.fromApiJsonHelper.extractBooleanNamed("isFloatingInterestRate", element);
        if (isInterestRecalculationEnabled) {
            LoanProductInterestRecalculationDetails loanProductInterestRecalculationDetails = loanProduct.getProductInterestRecalculationDetails();
            recalculationFrequencyType = loanProductInterestRecalculationDetails.getRestFrequencyType();
            Integer repeatsOnDay = null;
            Integer recalculationFrequencyNthDay = loanProductInterestRecalculationDetails.getRestFrequencyOnDay();
            if (recalculationFrequencyNthDay == null) {
                recalculationFrequencyNthDay = loanProductInterestRecalculationDetails.getRestFrequencyNthDay();
                repeatsOnDay = loanProductInterestRecalculationDetails.getRestFrequencyWeekday();
            }
            Integer frequency = loanProductInterestRecalculationDetails.getRestInterval();
            if (recalculationFrequencyType.isSameAsRepayment()) {
                restCalendarInstance = this.createCalendarForSameAsRepayment(repaymentEvery, repaymentPeriodFrequencyType, expectedDisbursementDate);
            } else {
                LocalDate calendarStartDate = expectedDisbursementDate;
                restCalendarInstance = this.createInterestRecalculationCalendarInstance(calendarStartDate, recalculationFrequencyType, frequency, recalculationFrequencyNthDay, repeatsOnDay);
            }
            compoundingMethod = InterestRecalculationCompoundingMethod.fromInt((Integer)loanProductInterestRecalculationDetails.getInterestRecalculationCompoundingMethod());
            if (compoundingMethod.isCompoundingEnabled()) {
                Integer compoundingRepeatsOnDay = null;
                Integer recalculationCompoundingFrequencyNthDay = loanProductInterestRecalculationDetails.getCompoundingFrequencyOnDay();
                if (recalculationCompoundingFrequencyNthDay == null) {
                    recalculationCompoundingFrequencyNthDay = loanProductInterestRecalculationDetails.getCompoundingFrequencyNthDay();
                    compoundingRepeatsOnDay = loanProductInterestRecalculationDetails.getCompoundingFrequencyWeekday();
                }
                if ((compoundingFrequencyType = loanProductInterestRecalculationDetails.getCompoundingFrequencyType()).isSameAsRepayment()) {
                    compoundingCalendarInstance = this.createCalendarForSameAsRepayment(repaymentEvery, repaymentPeriodFrequencyType, expectedDisbursementDate);
                } else {
                    LocalDate calendarStartDate = expectedDisbursementDate;
                    compoundingCalendarInstance = this.createInterestRecalculationCalendarInstance(calendarStartDate, compoundingFrequencyType, loanProductInterestRecalculationDetails.getCompoundingInterval(), recalculationCompoundingFrequencyNthDay, compoundingRepeatsOnDay);
                }
                allowCompoundingOnEod = loanProductInterestRecalculationDetails.getAllowCompoundingOnEod();
            }
        }
        BigDecimal principalThresholdForLastInstalment = loanProduct.getPrincipalThresholdForLastInstallment();
        ArrayList<LoanTermVariationsData> loanTermVariations = new ArrayList<LoanTermVariationsData>();
        if (loanProduct.isLinkedToFloatingInterestRate()) {
            BigDecimal interestRateDiff = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("interestRateDifferential", element);
            List baseLendingRatePeriods = null;
            try {
                baseLendingRatePeriods = this.floatingRatesReadPlatformService.retrieveBaseLendingRate().getRatePeriods();
            }
            catch (FloatingRateNotFoundException compoundingRepeatsOnDay) {
                // empty catch block
            }
            FloatingRateDTO floatingRateDTO = new FloatingRateDTO(isFloatingInterestRate.booleanValue(), expectedDisbursementDate, interestRateDiff, (Collection)baseLendingRatePeriods);
            Collection applicableRates = loanProduct.fetchInterestRates(floatingRateDTO);
            LocalDate interestRateStartDate = DateUtils.getBusinessLocalDate();
            LocalDate dateValue = null;
            boolean isSpecificToInstallment = false;
            for (FloatingRatePeriodData periodData : applicableRates) {
                LoanTermVariationsData loanTermVariation = new LoanTermVariationsData(LoanEnumerations.loanVariationType((LoanTermVariationType)LoanTermVariationType.INTEREST_RATE), periodData.getFromDateAsLocalDate(), periodData.getInterestRate(), dateValue, false);
                if (!DateUtils.isBefore((LocalDate)interestRateStartDate, (LocalDate)periodData.getFromDateAsLocalDate())) {
                    interestRateStartDate = periodData.getFromDateAsLocalDate();
                    annualNominalInterestRate = periodData.getInterestRate();
                }
                loanTermVariations.add(loanTermVariation);
            }
        }
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        Client client = null;
        Long officeId = null;
        if (clientId != null) {
            client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            officeId = (Long)client.getOffice().getId();
        } else if (groupId != null) {
            group = this.groupRepository.findOneWithNotFoundDetection(groupId);
            officeId = (Long)group.getOffice().getId();
        }
        boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(officeId, expectedDisbursementDate, HolidayStatusType.ACTIVE.getValue());
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        HolidayDetailDTO detailDTO = new HolidayDetailDTO(isHolidayEnabled, holidays, workingDays);
        boolean isInterestToBeRecoveredFirstWhenGreaterThanEMI = this.configurationDomainService.isInterestToBeRecoveredFirstWhenGreaterThanEMI();
        boolean isPrincipalCompoundingDisabledForOverdueLoans = this.configurationDomainService.isPrincipalCompoundingDisabledForOverdueLoans();
        boolean isDownPaymentEnabled = loanProduct.getLoanProductRelatedDetail().isEnableDownPayment();
        if (this.fromApiJsonHelper.parameterExists("enableDownPayment", element)) {
            isDownPaymentEnabled = this.fromApiJsonHelper.extractBooleanNamed("enableDownPayment", element);
        }
        BigDecimal disbursedAmountPercentageForDownPayment = null;
        boolean isAutoRepaymentForDownPaymentEnabled = false;
        if (isDownPaymentEnabled) {
            isAutoRepaymentForDownPaymentEnabled = loanProduct.getLoanProductRelatedDetail().isEnableAutoRepaymentForDownPayment();
            if (this.fromApiJsonHelper.parameterExists("enableAutoRepaymentForDownPayment", element)) {
                isAutoRepaymentForDownPaymentEnabled = this.fromApiJsonHelper.extractBooleanNamed("enableAutoRepaymentForDownPayment", element);
            }
            disbursedAmountPercentageForDownPayment = loanProduct.getLoanProductRelatedDetail().getDisbursedAmountPercentageForDownPayment();
            if (this.fromApiJsonHelper.parameterExists("disbursedAmountPercentageForDownPayment", element)) {
                disbursedAmountPercentageForDownPayment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("disbursedAmountPercentageForDownPayment", element);
            }
        }
        LoanScheduleType loanScheduleType = loanProduct.getLoanProductRelatedDetail().getLoanScheduleType();
        if (this.fromApiJsonHelper.parameterExists("loanScheduleType", element)) {
            loanScheduleType = LoanScheduleType.valueOf((String)this.fromApiJsonHelper.extractStringNamed("loanScheduleType", element));
        }
        LoanScheduleProcessingType loanScheduleProcessingType = loanProduct.getLoanProductRelatedDetail().getLoanScheduleProcessingType();
        if (this.fromApiJsonHelper.parameterExists("loanScheduleProcessingType", element)) {
            loanScheduleProcessingType = LoanScheduleProcessingType.valueOf((String)this.fromApiJsonHelper.extractStringNamed("loanScheduleProcessingType", element));
        }
        Integer fixedLength = loanProduct.getLoanProductRelatedDetail().getFixedLength();
        if (this.fromApiJsonHelper.parameterExists("fixedLength", element)) {
            fixedLength = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("fixedLength", element);
        }
        Boolean interestRecognitionOnDisbursementDate = loanProduct.getLoanProductRelatedDetail().isInterestRecognitionOnDisbursementDate();
        if (this.fromApiJsonHelper.parameterExists("interestRecognitionOnDisbursementDate", element)) {
            interestRecognitionOnDisbursementDate = this.fromApiJsonHelper.extractBooleanNamed("interestRecognitionOnDisbursementDate", element);
        }
        return LoanApplicationTerms.assembleFrom((CurrencyData)applicationCurrency.toData(), (Integer)loanTermFrequency, (PeriodFrequencyType)loanTermPeriodFrequencyType, (Integer)numberOfRepayments, (Integer)repaymentEvery, (PeriodFrequencyType)repaymentPeriodFrequencyType, (Integer)nthDay, (DayOfWeekType)weekDayType, (AmortizationMethod)amortizationMethod, (InterestMethod)interestMethod, (BigDecimal)interestRatePerPeriod, (PeriodFrequencyType)interestRatePeriodFrequencyType, (BigDecimal)annualNominalInterestRate, (InterestCalculationPeriodMethod)interestCalculationPeriodMethod, (boolean)allowPartialPeriodInterestCalcualtion, (Money)principalMoney, (LocalDate)expectedDisbursementDate, (LocalDate)repaymentsStartingFromDate, (LocalDate)calculatedRepaymentsStartingFromDate, (Integer)graceOnPrincipalPayment, (Integer)recurringMoratoriumOnPrincipalPeriods, (Integer)graceOnInterestPayment, (Integer)graceOnInterestCharged, (LocalDate)interestChargedFromDate, (Money)inArrearsToleranceMoney, (boolean)loanProduct.isMultiDisburseLoan(), (BigDecimal)emiAmount, (List)disbursementDatas, (BigDecimal)maxOutstandingBalance, (Integer)graceOnArrearsAgeing, (DaysInMonthType)daysInMonthType, (DaysInYearType)daysInYearType, (boolean)isInterestRecalculationEnabled, (RecalculationFrequencyType)recalculationFrequencyType, (CalendarInstance)restCalendarInstance, (InterestRecalculationCompoundingMethod)compoundingMethod, (CalendarInstance)compoundingCalendarInstance, (RecalculationFrequencyType)compoundingFrequencyType, (BigDecimal)principalThresholdForLastInstalment, (Integer)loanProduct.getLoanProductRelatedDetail().getInstallmentAmountInMultiplesOf(), (LoanPreCloseInterestCalculationStrategy)loanProduct.preCloseInterestCalculationStrategy(), (Calendar)calendar, (BigDecimal)BigDecimal.ZERO, loanTermVariations, (Boolean)isInterestChargedFromDateSameAsDisbursalDateEnabled, (Integer)numberOfDays, (boolean)isSkipMeetingOnFirstDay, (HolidayDetailDTO)detailDTO, (boolean)allowCompoundingOnEod, (boolean)isEqualAmortization, (boolean)isInterestToBeRecoveredFirstWhenGreaterThanEMI, (BigDecimal)fixedPrincipalPercentagePerInstallment, (boolean)isPrincipalCompoundingDisabledForOverdueLoans, (Boolean)isDownPaymentEnabled, (BigDecimal)disbursedAmountPercentageForDownPayment, (Boolean)isAutoRepaymentForDownPaymentEnabled, (RepaymentStartDateType)repaymentStartDateType, (LocalDate)submittedOnDate, (LoanScheduleType)loanScheduleType, (LoanScheduleProcessingType)loanScheduleProcessingType, (Integer)fixedLength, (boolean)loanProduct.getLoanProductRelatedDetail().isEnableAccrualActivityPosting(), (List)loanProduct.getLoanProductRelatedDetail().getSupportedInterestRefundTypes(), (LoanChargeOffBehaviour)loanProduct.getLoanProductRelatedDetail().getChargeOffBehaviour(), (boolean)interestRecognitionOnDisbursementDate, (DaysInYearCustomStrategyType)loanProduct.getLoanProductRelatedDetail().getDaysInYearCustomStrategy(), (boolean)loanProduct.getLoanProductRelatedDetail().isEnableIncomeCapitalization(), (LoanCapitalizedIncomeCalculationType)loanProduct.getLoanProductRelatedDetail().getCapitalizedIncomeCalculationType(), (LoanCapitalizedIncomeStrategy)loanProduct.getLoanProductRelatedDetail().getCapitalizedIncomeStrategy(), (LoanCapitalizedIncomeType)loanProduct.getLoanProductRelatedDetail().getCapitalizedIncomeType(), (boolean)loanProduct.getLoanProductRelatedDetail().isEnableBuyDownFee(), (LoanBuyDownFeeCalculationType)loanProduct.getLoanProductRelatedDetail().getBuyDownFeeCalculationType(), (LoanBuyDownFeeStrategy)loanProduct.getLoanProductRelatedDetail().getBuyDownFeeStrategy(), (LoanBuyDownFeeIncomeType)loanProduct.getLoanProductRelatedDetail().getBuyDownFeeIncomeType());
    }

    private CalendarInstance createCalendarForSameAsRepayment(Integer repaymentEvery, PeriodFrequencyType repaymentPeriodFrequencyType, LocalDate expectedDisbursementDate) {
        Integer recalculationFrequencyNthDay = null;
        Integer repeatsOnDay = expectedDisbursementDate.get(ChronoField.DAY_OF_WEEK);
        CalendarInstance restCalendarInstance = this.createInterestRecalculationCalendarInstance(expectedDisbursementDate, repaymentEvery, CalendarFrequencyType.from((PeriodFrequencyType)repaymentPeriodFrequencyType), recalculationFrequencyNthDay, repeatsOnDay);
        return restCalendarInstance;
    }

    private CalendarInstance createInterestRecalculationCalendarInstance(LocalDate calendarStartDate, RecalculationFrequencyType recalculationFrequencyType, Integer frequency, Integer recalculationFrequencyNthDay, Integer repeatsOnDay) {
        CalendarFrequencyType calendarFrequencyType = CalendarFrequencyType.INVALID;
        switch (1.$SwitchMap$org$apache$fineract$portfolio$loanproduct$domain$RecalculationFrequencyType[recalculationFrequencyType.ordinal()]) {
            case 1: {
                calendarFrequencyType = CalendarFrequencyType.DAILY;
                break;
            }
            case 2: {
                calendarFrequencyType = CalendarFrequencyType.MONTHLY;
                break;
            }
            case 3: {
                calendarFrequencyType = CalendarFrequencyType.WEEKLY;
                break;
            }
        }
        return this.createInterestRecalculationCalendarInstance(calendarStartDate, frequency, calendarFrequencyType, recalculationFrequencyNthDay, repeatsOnDay);
    }

    private CalendarInstance createInterestRecalculationCalendarInstance(LocalDate calendarStartDate, Integer frequency, CalendarFrequencyType calendarFrequencyType, Integer recalculationFrequencyNthDay, Integer repeatsOnDay) {
        String title = "loan_recalculation_detail";
        Calendar calendar = Calendar.createRepeatingCalendar((String)"loan_recalculation_detail", (LocalDate)calendarStartDate, (Integer)CalendarType.COLLECTION.getValue(), (CalendarFrequencyType)calendarFrequencyType, (Integer)frequency, (Integer)repeatsOnDay, (Integer)recalculationFrequencyNthDay);
        return CalendarInstance.from((Calendar)calendar, null, (Integer)CalendarEntityType.LOAN_RECALCULATION_REST_DETAIL.getValue());
    }

    private Calendar createLoanCalendar(LocalDate calendarStartDate, Integer frequency, CalendarFrequencyType calendarFrequencyType, Integer repeatsOnDay, Integer repeatsOnNthDayOfMonth) {
        String title = "loan_schedule";
        Calendar calendar = Calendar.createRepeatingCalendar((String)"loan_schedule", (LocalDate)calendarStartDate, (Integer)CalendarType.COLLECTION.getValue(), (CalendarFrequencyType)calendarFrequencyType, (Integer)frequency, (Integer)repeatsOnDay, (Integer)repeatsOnNthDayOfMonth);
        return calendar;
    }

    private List<DisbursementData> fetchDisbursementData(JsonObject command) {
        JsonArray disbursementDataArray;
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(command);
        String dateFormat = this.fromApiJsonHelper.extractDateFormatParameter(command);
        ArrayList<DisbursementData> disbursementDatas = new ArrayList<DisbursementData>();
        if (command.has("disbursementData") && (disbursementDataArray = command.getAsJsonArray("disbursementData")) != null && disbursementDataArray.size() > 0) {
            int i = 0;
            do {
                JsonObject jsonObject = disbursementDataArray.get(i).getAsJsonObject();
                LocalDate expectedDisbursementDate = null;
                BigDecimal principal = null;
                BigDecimal netDisbursalAmount = null;
                if (jsonObject.has("expectedDisbursementDate")) {
                    expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", (JsonElement)jsonObject, dateFormat, locale);
                }
                if (jsonObject.has("principal") && jsonObject.get("principal").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("principal").getAsString())) {
                    principal = jsonObject.getAsJsonPrimitive("principal").getAsBigDecimal();
                }
                if (jsonObject.has("netDisbursalAmount") && jsonObject.get("netDisbursalAmount").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("netDisbursalAmount").getAsString())) {
                    netDisbursalAmount = jsonObject.getAsJsonPrimitive("netDisbursalAmount").getAsBigDecimal();
                }
                BigDecimal waivedChargeAmount = null;
                disbursementDatas.add(new DisbursementData(null, expectedDisbursementDate, null, principal, netDisbursalAmount, null, null, waivedChargeAmount));
            } while (++i < disbursementDataArray.size());
        }
        return disbursementDatas;
    }

    private void validateRepaymentsStartDateWithMeetingDates(LocalDate repaymentsStartingFromDate, Calendar calendar, boolean isSkipRepaymentOnFirstDayOfMonth, Integer numberOfDays) {
        if (repaymentsStartingFromDate != null && !CalendarUtils.isValidRecurringDate((String)calendar.getRecurrence(), (LocalDate)calendar.getStartDateLocalDate(), (LocalDate)repaymentsStartingFromDate, (boolean)isSkipRepaymentOnFirstDayOfMonth, (Integer)numberOfDays)) {
            String errorMessage = "First repayment date '" + String.valueOf(repaymentsStartingFromDate) + "' do not fall on a meeting date";
            throw new LoanApplicationDateException("first.repayment.date.do.not.match.meeting.date", errorMessage, new Object[]{repaymentsStartingFromDate});
        }
    }

    private void validateRepaymentFrequencyIsSameAsMeetingFrequency(Integer meetingFrequency, Integer repaymentFrequency, Integer meetingInterval, Integer repaymentInterval) {
        if (!PeriodFrequencyType.DAYS.getValue().equals(meetingFrequency)) {
            if (!meetingFrequency.equals(repaymentFrequency)) {
                throw new MeetingFrequencyMismatchException("loanapplication.repayment.frequency", "Loan repayment frequency period must match that of meeting frequency period", new Object[]{repaymentFrequency});
            }
            if (repaymentInterval % meetingInterval != 0) {
                throw new MeetingFrequencyMismatchException("loanapplication.repayment.interval", "Loan repayment repaid every # must equal or multiple of meeting interval " + meetingInterval, new Object[]{meetingInterval, repaymentInterval});
            }
        }
    }

    public LoanProductRelatedDetail assembleLoanProductRelatedDetail(LoanApplicationTerms loanApplicationTerms, JsonElement element) {
        LoanProductRelatedDetail loanProductRelatedDetail = loanApplicationTerms.toLoanProductRelatedDetail();
        String interestRateFrequencyTypeParamName = "interestRateFrequencyType";
        if (this.fromApiJsonHelper.parameterExists("interestRateFrequencyType", element)) {
            Integer newValue = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestRateFrequencyType", element);
            loanProductRelatedDetail.setInterestPeriodFrequencyType(PeriodFrequencyType.fromInt((Integer)newValue));
        }
        return loanProductRelatedDetail;
    }

    public LoanProductRelatedDetail assembleLoanProductRelatedDetail(JsonElement element, LoanProduct loanProduct) {
        return this.assembleLoanProductRelatedDetail(this.assembleLoanApplicationTermsFrom(element, loanProduct), element);
    }

    public LoanScheduleModel assembleLoanScheduleFrom(JsonElement element) {
        LoanApplicationTerms loanApplicationTerms = this.assembleLoanTerms(element);
        boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
        Client client = null;
        Group group = null;
        Long officeId = null;
        if (clientId != null) {
            client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            officeId = (Long)client.getOffice().getId();
        } else if (groupId != null) {
            group = this.groupRepository.findOneWithNotFoundDetection(groupId);
            officeId = (Long)group.getOffice().getId();
        }
        LocalDate expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", element);
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(officeId, expectedDisbursementDate, HolidayStatusType.ACTIVE.getValue());
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        this.validateDisbursementDateIsOnNonWorkingDay(loanApplicationTerms.getExpectedDisbursementDate(), workingDays);
        this.validateDisbursementDateIsOnHoliday(loanApplicationTerms.getExpectedDisbursementDate(), isHolidayEnabled, holidays);
        List loanDisbursementDetails = this.loanDisbursementDetailsAssembler.fetchDisbursementData(element.getAsJsonObject());
        return this.assembleLoanScheduleFrom(loanApplicationTerms, isHolidayEnabled, holidays, workingDays, element, loanDisbursementDetails);
    }

    public LoanScheduleModel assembleLoanScheduleFrom(LoanApplicationTerms loanApplicationTerms, boolean isHolidayEnabled, List<Holiday> holidays, WorkingDays workingDays, JsonElement element, List<LoanDisbursementDetails> disbursementDetails) {
        Set loanCharges = this.loanChargeAssembler.fromParsedJson(element, disbursementDetails);
        Set nonCompoundingCharges = this.validateDisbursementPercentageCharges(loanCharges);
        loanCharges.removeAll(nonCompoundingCharges);
        MathContext mc = MoneyHelper.getMathContext();
        HolidayDetailDTO detailDTO = new HolidayDetailDTO(isHolidayEnabled, holidays, workingDays);
        LoanScheduleGenerator loanScheduleGenerator = this.loanScheduleFactory.create(loanApplicationTerms.getLoanScheduleType(), loanApplicationTerms.getInterestMethod());
        if (loanApplicationTerms.isEqualAmortization()) {
            if (loanApplicationTerms.getInterestMethod().isDecliningBalance()) {
                LoanScheduleGenerator decliningLoanScheduleGenerator = this.loanScheduleFactory.create(loanApplicationTerms.getLoanScheduleType(), InterestMethod.DECLINING_BALANCE);
                LoanScheduleModel loanSchedule = decliningLoanScheduleGenerator.generate(mc, loanApplicationTerms, loanCharges, detailDTO);
                loanApplicationTerms.updateTotalInterestDue(Money.of((CurrencyData)loanApplicationTerms.getCurrency(), (BigDecimal)loanSchedule.getTotalInterestCharged()));
            }
            loanScheduleGenerator = this.loanScheduleFactory.create(loanApplicationTerms.getLoanScheduleType(), InterestMethod.FLAT);
        } else {
            loanScheduleGenerator = this.loanScheduleFactory.create(loanApplicationTerms.getLoanScheduleType(), loanApplicationTerms.getInterestMethod());
        }
        LoanScheduleModel loanScheduleModel = loanScheduleGenerator.generate(mc, loanApplicationTerms, loanCharges, detailDTO);
        if (!nonCompoundingCharges.isEmpty()) {
            this.updateDisbursementWithCharges(loanApplicationTerms.getPrincipal().getAmount(), (Collection)loanScheduleModel.getPeriods(), nonCompoundingCharges);
        }
        return loanScheduleModel;
    }

    public LoanScheduleModel assembleForInterestRecalculation(LoanApplicationTerms loanApplicationTerms, Long officeId, Loan loan, LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor, LocalDate rescheduleFrom) {
        MathContext mc = MoneyHelper.getMathContext();
        boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(officeId, loanApplicationTerms.getExpectedDisbursementDate(), HolidayStatusType.ACTIVE.getValue());
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        LoanScheduleGenerator loanScheduleGenerator = this.loanScheduleFactory.create(loanApplicationTerms.getLoanScheduleType(), loanApplicationTerms.getInterestMethod());
        HolidayDetailDTO detailDTO = new HolidayDetailDTO(isHolidayEnabled, holidays, workingDays);
        return loanScheduleGenerator.rescheduleNextInstallments(mc, loanApplicationTerms, loan, detailDTO, loanRepaymentScheduleTransactionProcessor, rescheduleFrom).getLoanScheduleModel();
    }

    public OutstandingAmountsDTO calculatePrepaymentAmount(MonetaryCurrency currency, LocalDate onDate, LoanApplicationTerms loanApplicationTerms, Loan loan, Long officeId, LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor) {
        LoanScheduleGenerator loanScheduleGenerator = this.loanScheduleFactory.create(loanApplicationTerms.getLoanScheduleType(), loanApplicationTerms.getInterestMethod());
        MathContext mc = MoneyHelper.getMathContext();
        boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(officeId, loanApplicationTerms.getExpectedDisbursementDate(), HolidayStatusType.ACTIVE.getValue());
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        HolidayDetailDTO holidayDetailDTO = new HolidayDetailDTO(isHolidayEnabled, holidays, workingDays);
        return loanScheduleGenerator.calculatePrepaymentAmount(currency, onDate, loanApplicationTerms, mc, loan, holidayDetailDTO, loanRepaymentScheduleTransactionProcessor);
    }

    public void assempleVariableScheduleFrom(Loan loan, String json) {
        this.variableLoanScheduleFromApiJsonValidator.validateSchedule(json, loan);
        List variations = loan.getLoanTermVariations();
        List newVariations = new ArrayList();
        this.extractLoanTermVariations(loan, json, newVariations);
        HashMap adjustDueDateVariations = new HashMap();
        if (!variations.isEmpty()) {
            List retainVariations = this.adjustExistingVariations(variations, newVariations, adjustDueDateVariations);
            newVariations = retainVariations;
        }
        variations.addAll(newVariations);
        List installments = loan.getRepaymentScheduleInstallments();
        TreeSet<LocalDate> dueDates = new TreeSet<LocalDate>();
        LocalDate graceApplicable = loan.getExpectedDisbursedOnLocalDate();
        Integer graceOnPrincipal = loan.getLoanProductRelatedDetail().getGraceOnPrincipalPayment();
        if (graceOnPrincipal == null) {
            graceOnPrincipal = 0;
        }
        LocalDate lastDate = loan.getExpectedDisbursedOnLocalDate();
        for (LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment : installments) {
            dueDates.add(loanRepaymentScheduleInstallment.getDueDate());
            if (DateUtils.isBefore((LocalDate)lastDate, (LocalDate)loanRepaymentScheduleInstallment.getDueDate())) {
                lastDate = loanRepaymentScheduleInstallment.getDueDate();
            }
            if (!graceOnPrincipal.equals(loanRepaymentScheduleInstallment.getInstallmentNumber())) continue;
            graceApplicable = loanRepaymentScheduleInstallment.getDueDate();
        }
        dueDates.addAll(adjustDueDateVariations.keySet());
        for (Map.Entry entry : adjustDueDateVariations.entrySet()) {
            LocalDate removeDate = (LocalDate)entry.getValue();
            if (removeDate == null) continue;
            dueDates.remove(removeDate);
        }
        TreeSet actualDueDates = new TreeSet(dueDates);
        ArrayList arrayList = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(arrayList).resource("loan");
        ArrayList<LocalDate> overlappings = new ArrayList<LocalDate>();
        for (LoanTermVariations termVariations : variations) {
            switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanTermVariationType[termVariations.getTermType().ordinal()]) {
                case 1: {
                    if (dueDates.contains(termVariations.fetchTermApplicaDate())) {
                        overlappings.add(termVariations.fetchTermApplicaDate());
                    } else {
                        dueDates.add(termVariations.fetchTermApplicaDate());
                    }
                    if (!DateUtils.isBefore((LocalDate)graceApplicable, (LocalDate)termVariations.fetchTermApplicaDate())) {
                        baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.insert.not.allowed.before.grace.period", new Object[]{"Loan schedule insert request invalid"});
                    }
                    if (DateUtils.isAfter((LocalDate)termVariations.fetchTermApplicaDate(), (LocalDate)lastDate)) {
                        baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.insert.not.allowed.after.last.period.date", new Object[]{"Loan schedule insert request invalid"});
                        break;
                    }
                    if (!DateUtils.isBefore((LocalDate)termVariations.fetchTermApplicaDate(), (LocalDate)loan.getExpectedDisbursedOnLocalDate())) break;
                    baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.insert.not.allowed.before.disbursement.date", new Object[]{"Loan schedule insert request invalid"});
                    break;
                }
                case 2: {
                    if (dueDates.contains(termVariations.fetchTermApplicaDate())) {
                        dueDates.remove(termVariations.fetchTermApplicaDate());
                    } else {
                        baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.remove.date.invalid", new Object[]{"Loan schedule remove request invalid"});
                    }
                    if (!DateUtils.isEqual((LocalDate)lastDate, (LocalDate)termVariations.fetchTermApplicaDate())) break;
                    baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.delete.not.allowed.for.last.period.date", new Object[]{"Loan schedule remove request invalid"});
                    break;
                }
                case 3: {
                    if (dueDates.contains(termVariations.fetchTermApplicaDate())) {
                        if (overlappings.contains(termVariations.fetchTermApplicaDate())) {
                            overlappings.remove(termVariations.fetchTermApplicaDate());
                        } else {
                            dueDates.remove(termVariations.fetchTermApplicaDate());
                        }
                    } else {
                        baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.modify.date.invalid", new Object[]{"Loan schedule modify due date request invalid"});
                    }
                    if (dueDates.contains(termVariations.fetchDateValue())) {
                        overlappings.add(termVariations.fetchDateValue());
                    } else {
                        dueDates.add(termVariations.fetchDateValue());
                    }
                    if (DateUtils.isBefore((LocalDate)termVariations.fetchDateValue(), (LocalDate)loan.getExpectedDisbursedOnLocalDate())) {
                        baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.insert.not.allowed.before.disbursement.date", new Object[]{"Loan schedule insert request invalid"});
                    }
                    if (!DateUtils.isEqual((LocalDate)lastDate, (LocalDate)termVariations.fetchTermApplicaDate())) break;
                    lastDate = termVariations.fetchDateValue();
                    break;
                }
                case 4: 
                case 5: {
                    if (!DateUtils.isBefore((LocalDate)graceApplicable, (LocalDate)termVariations.fetchTermApplicaDate())) {
                        baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.amount.update.not.allowed.before.grace.period", new Object[]{"Loan schedule modify request invalid"});
                    }
                    if (!dueDates.contains(termVariations.fetchTermApplicaDate())) {
                        baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.amount.update.from.date.invalid", new Object[]{"Loan schedule modify request invalid"});
                    }
                    if (!DateUtils.isEqual((LocalDate)termVariations.fetchTermApplicaDate(), (LocalDate)lastDate)) break;
                    baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.amount.update.not.allowed.for.last.period", new Object[]{"Loan schedule modify request invalid"});
                    break;
                }
            }
        }
        if (!overlappings.isEmpty()) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("variable.schedule.modify.date.can.not.be.due.date", new Object[]{overlappings});
        }
        LoanProductVariableInstallmentConfig installmentConfig = loan.loanProduct().loanProductVariableInstallmentConfig();
        CalendarInstance loanCalendarInstance = this.calendarInstanceRepository.findCalendarInstanceByEntityId((Long)loan.getId(), CalendarEntityType.LOANS.getValue());
        Calendar loanCalendar = null;
        if (loanCalendarInstance != null) {
            loanCalendar = loanCalendarInstance.getCalendar();
        }
        Boolean isSkipRepaymentOnFirstMonth = false;
        Integer numberOfDays = 0;
        boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
        if (isSkipRepaymentOnFirstMonthEnabled && (isSkipRepaymentOnFirstMonth = this.loanUtilService.isLoanRepaymentsSyncWithMeeting(loan.group(), loanCalendar)).booleanValue()) {
            numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
        }
        Integer minGap = installmentConfig.getMinimumGap();
        Integer maxGap = installmentConfig.getMaximumGap();
        LocalDate previousDate = loan.getDisbursementDate();
        for (LocalDate duedate : dueDates) {
            int gap = DateUtils.getExactDifferenceInDays((LocalDate)previousDate, (LocalDate)duedate);
            previousDate = duedate;
            if (gap < minGap || maxGap != null && gap > maxGap) {
                baseDataValidator.reset().value((Object)duedate).failWithCodeNoParameterAddedToErrorCode("variable.schedule.date.must.be.in.min.max.range", new Object[]{"Loan schedule date invalid"});
                continue;
            }
            if (loanCalendar == null || actualDueDates.contains(duedate) || loanCalendar.isValidRecurringDate(duedate, isSkipRepaymentOnFirstMonth, numberOfDays)) continue;
            baseDataValidator.reset().value((Object)duedate).failWithCodeNoParameterAddedToErrorCode("variable.schedule.date.not.meeting.date", new Object[]{"Loan schedule date not in sync with meeting date"});
        }
        if (!arrayList.isEmpty()) {
            throw new PlatformApiDataValidationException(arrayList);
        }
        if (loan.getExpectedFirstRepaymentOnDate() == null) {
            loan.setExpectedFirstRepaymentOnDate(loan.fetchRepaymentScheduleInstallment(Integer.valueOf(1)).getDueDate());
        }
        LocalDate recalculateFrom = null;
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loan);
    }

    private List<LoanTermVariations> adjustExistingVariations(List<LoanTermVariations> variations, List<LoanTermVariations> newVariations, Map<LocalDate, LocalDate> adjustDueDateVariations) {
        HashMap<LocalDate, LoanTermVariations> amountVariations = new HashMap<LocalDate, LoanTermVariations>();
        HashMap<LocalDate, LoanTermVariations> dueDateVariations = new HashMap<LocalDate, LoanTermVariations>();
        HashMap<LocalDate, LoanTermVariations> insertVariations = new HashMap<LocalDate, LoanTermVariations>();
        for (LoanTermVariations loanTermVariations : variations) {
            switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanTermVariationType[loanTermVariations.getTermType().ordinal()]) {
                case 4: 
                case 5: {
                    amountVariations.put(loanTermVariations.fetchTermApplicaDate(), loanTermVariations);
                    break;
                }
                case 3: {
                    dueDateVariations.put(loanTermVariations.fetchDateValue(), loanTermVariations);
                    adjustDueDateVariations.put(loanTermVariations.fetchTermApplicaDate(), loanTermVariations.fetchDateValue());
                    break;
                }
                case 1: {
                    insertVariations.put(loanTermVariations.fetchTermApplicaDate(), loanTermVariations);
                    adjustDueDateVariations.put(loanTermVariations.fetchTermApplicaDate(), loanTermVariations.fetchTermApplicaDate());
                    break;
                }
                case 2: {
                    adjustDueDateVariations.put(loanTermVariations.fetchTermApplicaDate(), null);
                    break;
                }
            }
        }
        ArrayList<LoanTermVariations> retainVariations = new ArrayList<LoanTermVariations>();
        for (LoanTermVariations loanTermVariations : newVariations) {
            boolean retain = true;
            switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanTermVariationType[loanTermVariations.getTermType().ordinal()]) {
                case 3: {
                    if (amountVariations.containsKey(loanTermVariations.fetchTermApplicaDate())) {
                        ((LoanTermVariations)amountVariations.get(loanTermVariations.fetchTermApplicaDate())).setTermApplicableFrom(loanTermVariations.getDateValue());
                    } else if (insertVariations.containsKey(loanTermVariations.fetchTermApplicaDate())) {
                        ((LoanTermVariations)insertVariations.get(loanTermVariations.fetchTermApplicaDate())).setTermApplicableFrom(loanTermVariations.getDateValue());
                        retain = false;
                    }
                    if (!dueDateVariations.containsKey(loanTermVariations.fetchTermApplicaDate())) break;
                    LoanTermVariations existingVariation = (LoanTermVariations)dueDateVariations.get(loanTermVariations.fetchTermApplicaDate());
                    if (DateUtils.isEqual((LocalDate)existingVariation.fetchTermApplicaDate(), (LocalDate)loanTermVariations.fetchDateValue())) {
                        variations.remove(existingVariation);
                    } else {
                        existingVariation.setTermApplicableFrom(loanTermVariations.getDateValue());
                    }
                    retain = false;
                    break;
                }
                case 4: 
                case 5: {
                    if (amountVariations.containsKey(loanTermVariations.fetchTermApplicaDate())) {
                        ((LoanTermVariations)amountVariations.get(loanTermVariations.fetchTermApplicaDate())).setDecimalValue(loanTermVariations.getTermValue());
                        retain = false;
                        break;
                    }
                    if (!insertVariations.containsKey(loanTermVariations.fetchTermApplicaDate())) break;
                    ((LoanTermVariations)insertVariations.get(loanTermVariations.fetchTermApplicaDate())).setDecimalValue(loanTermVariations.getTermValue());
                    retain = false;
                    break;
                }
                case 2: {
                    if (amountVariations.containsKey(loanTermVariations.fetchTermApplicaDate())) {
                        variations.remove(amountVariations.get(loanTermVariations.fetchTermApplicaDate()));
                    } else if (insertVariations.containsKey(loanTermVariations.fetchTermApplicaDate())) {
                        variations.remove(insertVariations.get(loanTermVariations.fetchTermApplicaDate()));
                        retain = false;
                    }
                    if (!dueDateVariations.containsKey(loanTermVariations.fetchTermApplicaDate())) break;
                    variations.remove(amountVariations.get(loanTermVariations.fetchTermApplicaDate()));
                    break;
                }
            }
            if (!retain) continue;
            retainVariations.add(loanTermVariations);
        }
        return retainVariations;
    }

    private void extractLoanTermVariations(Loan loan, String json, List<LoanTermVariations> loanTermVariations) {
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (loan.loanProduct().isAllowVariabeInstallments() && element.isJsonObject() && this.fromApiJsonHelper.parameterExists("exceptions", element)) {
            JsonArray array;
            JsonObject topLevelJsonElement = element.getAsJsonObject();
            String dateFormat = this.fromApiJsonHelper.extractDateFormatParameter(topLevelJsonElement);
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
            JsonObject exceptionObject = topLevelJsonElement.getAsJsonObject("exceptions");
            if (this.fromApiJsonHelper.parameterExists("modifiedinstallments", (JsonElement)exceptionObject) && exceptionObject.get("modifiedinstallments").isJsonArray()) {
                JsonArray modificationsArray = exceptionObject.get("modifiedinstallments").getAsJsonArray();
                this.extractLoanTermVariations(loan, dateFormat, locale, modificationsArray, false, false, loanTermVariations);
            }
            if (this.fromApiJsonHelper.parameterExists("newinstallments", (JsonElement)exceptionObject) && exceptionObject.get("newinstallments").isJsonArray()) {
                array = exceptionObject.get("newinstallments").getAsJsonArray();
                this.extractLoanTermVariations(loan, dateFormat, locale, array, true, false, loanTermVariations);
            }
            if (this.fromApiJsonHelper.parameterExists("deletedinstallments", (JsonElement)exceptionObject) && exceptionObject.get("deletedinstallments").isJsonArray()) {
                array = exceptionObject.get("deletedinstallments").getAsJsonArray();
                this.extractLoanTermVariations(loan, dateFormat, locale, array, false, true, loanTermVariations);
            }
        }
    }

    private void extractLoanTermVariations(Loan loan, String dateFormat, Locale locale, JsonArray modificationsArray, boolean isInsertInstallment, boolean isDeleteInstallment, List<LoanTermVariations> loanTermVariations) {
        for (int i = 1; i <= modificationsArray.size(); ++i) {
            LoanTermVariations data;
            LoanTermVariations data2;
            JsonObject arrayElement = modificationsArray.get(i - 1).getAsJsonObject();
            BigDecimal decimalValue = null;
            LoanTermVariationType decimalValueVariationType = LoanTermVariationType.INVALID;
            if (loan.getLoanProductRelatedDetail().getAmortizationMethod().isEqualInstallment() && loan.getLoanProductRelatedDetail().getInterestMethod().isDecliningBalance()) {
                decimalValue = this.fromApiJsonHelper.extractBigDecimalNamed("installmentAmount", (JsonElement)arrayElement, locale);
                decimalValueVariationType = LoanTermVariationType.EMI_AMOUNT;
            } else {
                decimalValue = this.fromApiJsonHelper.extractBigDecimalNamed("principal", (JsonElement)arrayElement, locale);
                decimalValueVariationType = LoanTermVariationType.PRINCIPAL_AMOUNT;
            }
            LocalDate dueDate = this.fromApiJsonHelper.extractLocalDateNamed("dueDate", (JsonElement)arrayElement, dateFormat, locale);
            LocalDate modifiedDuedateLocalDate = this.fromApiJsonHelper.extractLocalDateNamed("modifiedDueDate", (JsonElement)arrayElement, dateFormat, locale);
            LocalDate modifiedDuedate = null;
            if (modifiedDuedateLocalDate != null) {
                modifiedDuedate = modifiedDuedateLocalDate;
            }
            boolean isSpecificToInstallment = true;
            if (isInsertInstallment) {
                data2 = new LoanTermVariations(LoanTermVariationType.INSERT_INSTALLMENT.getValue(), dueDate, decimalValue, modifiedDuedate, isSpecificToInstallment, loan);
                loanTermVariations.add(data2);
                continue;
            }
            if (isDeleteInstallment) {
                data2 = new LoanTermVariations(LoanTermVariationType.DELETE_INSTALLMENT.getValue(), dueDate, decimalValue, modifiedDuedate, isSpecificToInstallment, loan);
                loanTermVariations.add(data2);
                continue;
            }
            if (modifiedDuedate != null) {
                BigDecimal amountData = null;
                data = new LoanTermVariations(LoanTermVariationType.DUE_DATE.getValue(), dueDate, amountData, modifiedDuedate, isSpecificToInstallment, loan);
                loanTermVariations.add(data);
            }
            if (decimalValue == null) continue;
            if (modifiedDuedate == null) {
                modifiedDuedate = dueDate;
            }
            LocalDate date = null;
            data = new LoanTermVariations(decimalValueVariationType.getValue(), modifiedDuedate, decimalValue, date, isSpecificToInstallment, loan);
            loanTermVariations.add(data);
        }
    }

    private void validateDisbursementDateIsOnNonWorkingDay(LocalDate disbursementDate, WorkingDays workingDays) {
        if (!WorkingDaysUtil.isWorkingDay((WorkingDays)workingDays, (LocalDate)disbursementDate)) {
            String errorMessage = "The expected disbursement date cannot be on a non working day";
            throw new LoanApplicationDateException("disbursement.date.on.non.working.day", "The expected disbursement date cannot be on a non working day", new Object[]{disbursementDate});
        }
    }

    private void validateDisbursementDateIsOnHoliday(LocalDate disbursementDate, boolean isHolidayEnabled, List<Holiday> holidays) {
        if (isHolidayEnabled && HolidayUtil.isHoliday((LocalDate)disbursementDate, holidays)) {
            String errorMessage = "The expected disbursement date cannot be on a holiday";
            throw new LoanApplicationDateException("disbursement.date.on.holiday", "The expected disbursement date cannot be on a holiday", new Object[]{disbursementDate});
        }
    }

    private LocalDate deriveFirstRepaymentDate(AccountType loanType, Integer repaymentEvery, LocalDate expectedDisbursementDate, PeriodFrequencyType repaymentPeriodFrequencyType, Integer minimumDaysBetweenDisbursalAndFirstRepayment, Calendar calendar, LocalDate submittedOnDate, RepaymentStartDateType repaymentStartDateType) {
        LocalDate seedDate;
        LocalDate derivedFirstRepayment = null;
        LocalDate dateBasedOnMinimumDaysBetweenDisbursalAndFirstRepayment = expectedDisbursementDate.plusDays(minimumDaysBetweenDisbursalAndFirstRepayment.intValue());
        LocalDate localDate = seedDate = repaymentStartDateType.isDisbursementDate() ? expectedDisbursementDate : submittedOnDate;
        if (calendar != null) {
            derivedFirstRepayment = this.deriveFirstRepaymentDateForLoans(repaymentEvery, expectedDisbursementDate, seedDate, repaymentPeriodFrequencyType, minimumDaysBetweenDisbursalAndFirstRepayment, calendar, submittedOnDate);
        } else {
            LocalDate dateBasedOnRepaymentFrequency = repaymentPeriodFrequencyType.isDaily() ? seedDate.plusDays(repaymentEvery.intValue()) : (repaymentPeriodFrequencyType.isWeekly() ? seedDate.plusWeeks(repaymentEvery.intValue()) : (repaymentPeriodFrequencyType.isMonthly() ? seedDate.plusMonths(repaymentEvery.intValue()) : seedDate.plusYears(repaymentEvery.intValue())));
            derivedFirstRepayment = DateUtils.isAfter((LocalDate)dateBasedOnRepaymentFrequency, (LocalDate)dateBasedOnMinimumDaysBetweenDisbursalAndFirstRepayment) ? dateBasedOnRepaymentFrequency : dateBasedOnMinimumDaysBetweenDisbursalAndFirstRepayment;
        }
        return derivedFirstRepayment;
    }

    private LocalDate deriveFirstRepaymentDateForLoans(Integer repaymentEvery, LocalDate expectedDisbursementDate, LocalDate refernceDateForCalculatingFirstRepaymentDate, PeriodFrequencyType repaymentPeriodFrequencyType, Integer minimumDaysBetweenDisbursalAndFirstRepayment, Calendar calendar, LocalDate submittedOnDate) {
        boolean isMeetingSkipOnFirstDayOfMonth = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
        int numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
        String frequency = CalendarUtils.getMeetingFrequencyFromPeriodFrequencyType((PeriodFrequencyType)repaymentPeriodFrequencyType);
        LocalDate derivedFirstRepayment = CalendarUtils.getFirstRepaymentMeetingDate((Calendar)calendar, (LocalDate)refernceDateForCalculatingFirstRepaymentDate, (Integer)repaymentEvery, (String)frequency, (boolean)isMeetingSkipOnFirstDayOfMonth, (Integer)numberOfDays);
        LocalDate minimumFirstRepaymentDate = expectedDisbursementDate.plusDays(minimumDaysBetweenDisbursalAndFirstRepayment.intValue());
        return DateUtils.isBefore((LocalDate)minimumFirstRepaymentDate, (LocalDate)derivedFirstRepayment) ? derivedFirstRepayment : this.deriveFirstRepaymentDateForLoans(repaymentEvery, expectedDisbursementDate, derivedFirstRepayment, repaymentPeriodFrequencyType, minimumDaysBetweenDisbursalAndFirstRepayment, calendar, submittedOnDate);
    }

    private void validateMinimumDaysBetweenDisbursalAndFirstRepayment(LocalDate disbursalDate, LocalDate firstRepaymentDate, Integer minimumDaysBetweenDisbursalAndFirstRepayment) {
        LocalDate minimumFirstRepaymentDate = disbursalDate.plusDays(minimumDaysBetweenDisbursalAndFirstRepayment.intValue());
        if (DateUtils.isBefore((LocalDate)firstRepaymentDate, (LocalDate)minimumFirstRepaymentDate)) {
            throw new MinDaysBetweenDisbursalAndFirstRepaymentViolationException(disbursalDate, firstRepaymentDate, minimumDaysBetweenDisbursalAndFirstRepayment);
        }
    }

    public void updateProductRelatedDetails(LoanProductRelatedDetail productRelatedDetail, Loan loan) {
        Boolean amortization = loan.loanProduct().getLoanConfigurableAttributes().getAmortizationBoolean();
        Boolean arrearsTolerance = loan.loanProduct().getLoanConfigurableAttributes().getArrearsToleranceBoolean();
        Boolean graceOnArrearsAging = loan.loanProduct().getLoanConfigurableAttributes().getGraceOnArrearsAgingBoolean();
        Boolean interestCalcPeriod = loan.loanProduct().getLoanConfigurableAttributes().getInterestCalcPeriodBoolean();
        Boolean interestMethod = loan.loanProduct().getLoanConfigurableAttributes().getInterestMethodBoolean();
        Boolean graceOnPrincipalAndInterestPayment = loan.loanProduct().getLoanConfigurableAttributes().getGraceOnPrincipalAndInterestPaymentBoolean();
        Boolean repaymentEvery = loan.loanProduct().getLoanConfigurableAttributes().getRepaymentEveryBoolean();
        if (!amortization.booleanValue()) {
            productRelatedDetail.setAmortizationMethod(loan.loanProduct().getLoanProductRelatedDetail().getAmortizationMethod());
        }
        if (!arrearsTolerance.booleanValue()) {
            productRelatedDetail.setInArrearsTolerance(loan.loanProduct().getLoanProductRelatedDetail().getInArrearsTolerance().getAmount());
        }
        if (!graceOnArrearsAging.booleanValue()) {
            productRelatedDetail.setGraceOnArrearsAgeing(loan.loanProduct().getLoanProductRelatedDetail().getGraceOnArrearsAgeing());
        }
        if (!interestCalcPeriod.booleanValue()) {
            productRelatedDetail.setInterestCalculationPeriodMethod(loan.loanProduct().getLoanProductRelatedDetail().getInterestCalculationPeriodMethod());
        }
        if (!interestMethod.booleanValue()) {
            productRelatedDetail.setInterestMethod(loan.loanProduct().getLoanProductRelatedDetail().getInterestMethod());
        }
        if (!graceOnPrincipalAndInterestPayment.booleanValue()) {
            productRelatedDetail.setGraceOnInterestPayment(loan.loanProduct().getLoanProductRelatedDetail().getGraceOnInterestPayment());
            productRelatedDetail.setGraceOnPrincipalPayment(loan.loanProduct().getLoanProductRelatedDetail().getGraceOnPrincipalPayment());
        }
        if (!repaymentEvery.booleanValue()) {
            productRelatedDetail.setRepayEvery(loan.loanProduct().getLoanProductRelatedDetail().getRepayEvery());
        }
    }

    public void updateLoanApplicationAttributes(JsonCommand command, Loan loan, Map<String, Object> changes) {
        Integer newValue;
        Integer newValue2;
        String localeAsInput = command.locale();
        String principalParamName = "principal";
        LoanProductRelatedDetail loanProductRelatedDetail = loan.getLoanRepaymentScheduleDetail();
        if (command.isChangeInBigDecimalParameterNamed("principal", loanProductRelatedDetail.getPrincipal().getAmount())) {
            BigDecimal newValue3 = command.bigDecimalValueOfParameterNamed("principal");
            changes.put("principal", newValue3);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setPrincipal(newValue3);
        }
        String repaymentEveryParamName = "repaymentEvery";
        if (command.isChangeInIntegerParameterNamed("repaymentEvery", loanProductRelatedDetail.getRepayEvery())) {
            Integer newValue4 = command.integerValueOfParameterNamed("repaymentEvery");
            changes.put("repaymentEvery", newValue4);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setRepayEvery(newValue4);
        }
        String repaymentFrequencyTypeParamName = "repaymentFrequencyType";
        if (command.isChangeInIntegerParameterNamed("repaymentFrequencyType", loanProductRelatedDetail.getRepaymentPeriodFrequencyType().getValue())) {
            Integer newValue5 = command.integerValueOfParameterNamed("repaymentFrequencyType");
            changes.put("repaymentFrequencyType", newValue5);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setRepaymentPeriodFrequencyType(PeriodFrequencyType.fromInt((Integer)newValue5));
        }
        if (PeriodFrequencyType.MONTHS.equals((Object)loanProductRelatedDetail.getRepaymentPeriodFrequencyType())) {
            String repaymentFrequencyNthDayTypeParamName = "repaymentFrequencyNthDayType";
            newValue2 = command.integerValueOfParameterNamed("repaymentFrequencyNthDayType");
            changes.put("repaymentFrequencyNthDayType", newValue2);
            String repaymentFrequencyDayOfWeekTypeParamName = "repaymentFrequencyDayOfWeekType";
            newValue2 = command.integerValueOfParameterNamed("repaymentFrequencyDayOfWeekType");
            changes.put("repaymentFrequencyDayOfWeekType", newValue2);
            changes.put("locale", localeAsInput);
        }
        String numberOfRepaymentsParamName = "numberOfRepayments";
        if (command.isChangeInIntegerParameterNamed("numberOfRepayments", loanProductRelatedDetail.getNumberOfRepayments())) {
            newValue2 = command.integerValueOfParameterNamed("numberOfRepayments");
            changes.put("numberOfRepayments", newValue2);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setNumberOfRepayments(newValue2);
        }
        String amortizationTypeParamName = "amortizationType";
        if (command.isChangeInIntegerParameterNamed("amortizationType", loanProductRelatedDetail.getAmortizationMethod().getValue())) {
            Integer newValue6 = command.integerValueOfParameterNamed("amortizationType");
            changes.put("amortizationType", newValue6);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setAmortizationMethod(AmortizationMethod.fromInt((Integer)newValue6));
        }
        String inArrearsToleranceParamName = "inArrearsTolerance";
        if (command.isChangeInBigDecimalParameterNamed("inArrearsTolerance", loanProductRelatedDetail.getInArrearsTolerance().getAmount())) {
            BigDecimal newValue7 = command.bigDecimalValueOfParameterNamed("inArrearsTolerance");
            changes.put("inArrearsTolerance", newValue7);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setInArrearsTolerance(newValue7);
        }
        String interestRatePerPeriodParamName = "interestRatePerPeriod";
        if (command.isChangeInBigDecimalParameterNamed("interestRatePerPeriod", loanProductRelatedDetail.getNominalInterestRatePerPeriod())) {
            BigDecimal newValue8 = command.bigDecimalValueOfParameterNamed("interestRatePerPeriod");
            changes.put("interestRatePerPeriod", newValue8);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setNominalInterestRatePerPeriod(newValue8);
            this.relatedDetailUpdateUtil.updateInterestRateDerivedFields(loanProductRelatedDetail, this.aprCalculator);
        }
        String interestRateFrequencyTypeParamName = "interestRateFrequencyType";
        int interestPeriodFrequencyType = loanProductRelatedDetail.getInterestPeriodFrequencyType() == null ? PeriodFrequencyType.INVALID.getValue() : loanProductRelatedDetail.getInterestPeriodFrequencyType().getValue();
        if (command.isChangeInIntegerParameterNamed("interestRateFrequencyType", Integer.valueOf(interestPeriodFrequencyType))) {
            Integer newValue9 = command.integerValueOfParameterNamed("interestRateFrequencyType");
            changes.put("interestRateFrequencyType", newValue9);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setInterestPeriodFrequencyType(PeriodFrequencyType.fromInt((Integer)newValue9));
            this.relatedDetailUpdateUtil.updateInterestRateDerivedFields(loanProductRelatedDetail, this.aprCalculator);
        }
        String interestTypeParamName = "interestType";
        if (command.isChangeInIntegerParameterNamed("interestType", loanProductRelatedDetail.getInterestMethod().getValue())) {
            Integer newValue10 = command.integerValueOfParameterNamed("interestType");
            changes.put("interestType", newValue10);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setInterestMethod(InterestMethod.fromInt((Integer)newValue10));
        }
        String interestCalculationPeriodTypeParamName = "interestCalculationPeriodType";
        if (command.isChangeInIntegerParameterNamed("interestCalculationPeriodType", loanProductRelatedDetail.getInterestCalculationPeriodMethod().getValue())) {
            Integer newValue11 = command.integerValueOfParameterNamed("interestCalculationPeriodType");
            changes.put("interestCalculationPeriodType", newValue11);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setInterestCalculationPeriodMethod(InterestCalculationPeriodMethod.fromInt((Integer)newValue11));
        }
        if (command.isChangeInBooleanParameterNamed("allowPartialPeriodInterestCalcualtion", Boolean.valueOf(loanProductRelatedDetail.isAllowPartialPeriodInterestCalculation()))) {
            boolean newValue12 = command.booleanPrimitiveValueOfParameterNamed("allowPartialPeriodInterestCalcualtion");
            changes.put("allowPartialPeriodInterestCalcualtion", newValue12);
            loanProductRelatedDetail.setAllowPartialPeriodInterestCalculation(newValue12);
        }
        if (loanProductRelatedDetail.getInterestCalculationPeriodMethod().isDaily()) {
            loanProductRelatedDetail.setAllowPartialPeriodInterestCalculation(false);
        }
        String graceOnPrincipalPaymentParamName = "graceOnPrincipalPayment";
        if (command.isChangeInIntegerParameterNamed("graceOnPrincipalPayment", loanProductRelatedDetail.getGraceOnPrincipalPayment())) {
            Integer newValue13 = command.integerValueOfParameterNamed("graceOnPrincipalPayment");
            changes.put("graceOnPrincipalPayment", newValue13);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setGraceOnPrincipalPayment(newValue13);
        }
        String recurringMoratoriumOnPrincipalPeriodsParamName = "recurringMoratoriumOnPrincipalPeriods";
        if (command.isChangeInIntegerParameterNamed("recurringMoratoriumOnPrincipalPeriods", loanProductRelatedDetail.getRecurringMoratoriumOnPrincipalPeriods())) {
            Integer newValue14 = command.integerValueOfParameterNamed("recurringMoratoriumOnPrincipalPeriods");
            changes.put("recurringMoratoriumOnPrincipalPeriods", newValue14);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setRecurringMoratoriumOnPrincipalPeriods(newValue14);
        }
        String graceOnInterestPaymentParamName = "graceOnInterestPayment";
        if (command.isChangeInIntegerParameterNamed("graceOnInterestPayment", loanProductRelatedDetail.getGraceOnInterestPayment())) {
            Integer newValue15 = command.integerValueOfParameterNamed("graceOnInterestPayment");
            changes.put("graceOnInterestPayment", newValue15);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setGraceOnInterestPayment(newValue15);
        }
        String graceOnInterestChargedParamName = "graceOnInterestCharged";
        if (command.isChangeInIntegerParameterNamed("graceOnInterestCharged", loanProductRelatedDetail.getGraceOnInterestCharged())) {
            newValue = command.integerValueOfParameterNamed("graceOnInterestCharged");
            changes.put("graceOnInterestCharged", newValue);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setGraceOnInterestCharged(newValue);
        }
        if (command.isChangeInIntegerParameterNamed("graceOnArrearsAgeing", loanProductRelatedDetail.getGraceOnArrearsAgeing())) {
            newValue = command.integerValueOfParameterNamed("graceOnArrearsAgeing");
            changes.put("graceOnArrearsAgeing", newValue);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setGraceOnArrearsAgeing(newValue);
        }
        if (command.isChangeInIntegerParameterNamed("daysInMonthType", loanProductRelatedDetail.fetchDaysInMonthType().getValue())) {
            newValue = command.integerValueOfParameterNamed("daysInMonthType");
            changes.put("daysInMonthType", newValue);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setDaysInMonthType(newValue);
        }
        if (command.isChangeInIntegerParameterNamed("daysInYearType", loanProductRelatedDetail.fetchDaysInYearType().getValue())) {
            newValue = command.integerValueOfParameterNamed("daysInYearType");
            changes.put("daysInYearType", newValue);
            changes.put("locale", localeAsInput);
            loanProductRelatedDetail.setDaysInYearType(newValue);
        }
        if (command.isChangeInBooleanParameterNamed("isInterestRecalculationEnabled", Boolean.valueOf(loanProductRelatedDetail.isInterestRecalculationEnabled()))) {
            boolean newValue16 = command.booleanPrimitiveValueOfParameterNamed("isInterestRecalculationEnabled");
            changes.put("isInterestRecalculationEnabled", newValue16);
            loanProductRelatedDetail.setInterestRecalculationEnabled(newValue16);
        }
        if (command.isChangeInBooleanParameterNamed("isEqualAmortization", Boolean.valueOf(loanProductRelatedDetail.isEqualAmortization()))) {
            boolean newValue17 = command.booleanPrimitiveValueOfParameterNamed("isEqualAmortization");
            changes.put("isEqualAmortization", newValue17);
            loanProductRelatedDetail.setEqualAmortization(newValue17);
        }
        if (command.isChangeInBooleanParameterNamed("enableDownPayment", Boolean.valueOf(loanProductRelatedDetail.isEnableDownPayment()))) {
            boolean newValue18 = command.booleanPrimitiveValueOfParameterNamed("enableDownPayment");
            changes.put("enableDownPayment", newValue18);
            loanProductRelatedDetail.setEnableDownPayment(newValue18);
            if (!newValue18) {
                loanProductRelatedDetail.setEnableAutoRepaymentForDownPayment(false);
                loanProductRelatedDetail.setDisbursedAmountPercentageForDownPayment(null);
            }
        }
        if (loanProductRelatedDetail.isEnableDownPayment()) {
            Boolean enableAutoRepaymentForDownPayment = loan.loanProduct().getLoanProductRelatedDetail().isEnableAutoRepaymentForDownPayment();
            if (this.fromApiJsonHelper.parameterExists("enableAutoRepaymentForDownPayment", command.parsedJson()) && command.isChangeInBooleanParameterNamed("enableAutoRepaymentForDownPayment", Boolean.valueOf(loanProductRelatedDetail.isEnableAutoRepaymentForDownPayment()))) {
                enableAutoRepaymentForDownPayment = command.booleanObjectValueOfParameterNamed("enableAutoRepaymentForDownPayment");
                changes.put("enableAutoRepaymentForDownPayment", enableAutoRepaymentForDownPayment);
            }
            loanProductRelatedDetail.setEnableAutoRepaymentForDownPayment(enableAutoRepaymentForDownPayment.booleanValue());
            BigDecimal disbursedAmountPercentageDownPayment = loan.loanProduct().getLoanProductRelatedDetail().getDisbursedAmountPercentageForDownPayment();
            if (this.fromApiJsonHelper.parameterExists("disbursedAmountPercentageForDownPayment", command.parsedJson()) && command.isChangeInBigDecimalParameterNamed("disbursedAmountPercentageForDownPayment", loanProductRelatedDetail.getDisbursedAmountPercentageForDownPayment())) {
                disbursedAmountPercentageDownPayment = command.bigDecimalValueOfParameterNamed("disbursedAmountPercentageForDownPayment");
                changes.put("disbursedAmountPercentageForDownPayment", disbursedAmountPercentageDownPayment);
            }
            loanProductRelatedDetail.setDisbursedAmountPercentageForDownPayment(disbursedAmountPercentageDownPayment);
        }
        if (command.isChangeInBooleanParameterNamed("interestRecognitionOnDisbursementDate", Boolean.valueOf(loanProductRelatedDetail.isInterestRecognitionOnDisbursementDate()))) {
            boolean newValue19 = command.booleanPrimitiveValueOfParameterNamed("interestRecognitionOnDisbursementDate");
            changes.put("interestRecognitionOnDisbursementDate", newValue19);
            loanProductRelatedDetail.updateInterestRecognitionOnDisbursementDate(newValue19);
        }
    }

    public Pair<Loan, Map<String, Object>> assembleLoanApproval(AppUser currentUser, JsonCommand command, Long loanId) {
        JsonArray disbursementDataArray = command.arrayOfParameterNamed("disbursementData");
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        this.loanLifecycleStateMachine.transition(LoanEvent.LOAN_APPROVED, loan);
        actualChanges.put("status", LoanEnumerations.status((LoanStatus)loan.getStatus()));
        LocalDate approvedOn = command.localDateValueOfParameterNamed("approvedOnDate");
        String approvedOnDateChange = command.stringValueOfParameterNamed("approvedOnDate");
        if (approvedOn == null) {
            approvedOn = command.localDateValueOfParameterNamed("eventDate");
            approvedOnDateChange = command.stringValueOfParameterNamed("eventDate");
        }
        LocalDate expectedDisbursementDate = command.localDateValueOfParameterNamed("expectedDisbursementDate");
        BigDecimal approvedLoanAmount = command.bigDecimalValueOfParameterNamed("approvedLoanAmount");
        if (approvedLoanAmount != null) {
            loan.setApprovedPrincipal(approvedLoanAmount);
            loan.getLoanRepaymentScheduleDetail().setPrincipal(approvedLoanAmount);
            actualChanges.put("approvedLoanAmount", approvedLoanAmount);
            actualChanges.put("principal", approvedLoanAmount);
            actualChanges.put("netDisbursalAmount", loan.getNetDisbursalAmount());
            if (disbursementDataArray != null) {
                this.loanDisbursementService.updateDisbursementDetails(loan, command, actualChanges);
            }
        }
        this.loanChargeService.recalculateAllCharges(loan);
        loan.setApprovedOnDate(approvedOn);
        loan.setApprovedBy(currentUser);
        actualChanges.put("locale", command.locale());
        actualChanges.put("dateFormat", command.dateFormat());
        actualChanges.put("approvedOnDate", approvedOnDateChange);
        if (expectedDisbursementDate != null) {
            loan.setExpectedDisbursementDate(expectedDisbursementDate);
            actualChanges.put("expectedDisbursementDate", expectedDisbursementDate);
        }
        if (loan.getLoanOfficer() != null) {
            LoanOfficerAssignmentHistory loanOfficerAssignmentHistory = LoanOfficerAssignmentHistory.createNew((Loan)loan, (Staff)loan.getLoanOfficer(), (LocalDate)approvedOn);
            loan.getLoanOfficerHistory().add(loanOfficerAssignmentHistory);
        }
        loan.adjustNetDisbursalAmount(loan.getApprovedPrincipal());
        if (!actualChanges.isEmpty() && (actualChanges.containsKey("approvedLoanAmount") || actualChanges.containsKey("recalculateLoanSchedule") || actualChanges.containsKey("expectedDisbursementDate"))) {
            this.loanScheduleService.regenerateRepaymentSchedule(loan, this.loanUtilService.buildScheduleGeneratorDTO(loan, null));
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan);
        }
        return Pair.of((Object)loan, actualChanges);
    }

    private Set<LoanCharge> validateDisbursementPercentageCharges(Set<LoanCharge> loanCharges) {
        HashSet<LoanCharge> interestCharges = new HashSet<LoanCharge>();
        if (loanCharges != null) {
            for (LoanCharge loanCharge : loanCharges) {
                if (!loanCharge.isDisbursementCharge() || !loanCharge.getChargeCalculation().isPercentageOfInterest() && !loanCharge.getChargeCalculation().isPercentageOfAmountAndInterest()) continue;
                interestCharges.add(loanCharge);
            }
        }
        return interestCharges;
    }

    private void updateDisbursementWithCharges(BigDecimal principal, Collection<LoanScheduleModelPeriod> periods, Set<LoanCharge> nonCompoundingCharges) {
        BigDecimal totalInterest = periods.stream().filter(p -> p.isRepaymentPeriod()).map(LoanScheduleModelPeriod::interestDue).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (LoanScheduleModelPeriod loanScheduleModelPeriod : periods) {
            if (!(loanScheduleModelPeriod instanceof LoanScheduleModelDisbursementPeriod)) continue;
            for (LoanCharge loanCharge : nonCompoundingCharges) {
                BigDecimal amountAppliedTo = loanCharge.getChargeCalculation().isPercentageOfAmountAndInterest() ? principal.add(totalInterest) : totalInterest;
                this.loanChargeService.populateDerivedFields(loanCharge, amountAppliedTo, loanCharge.amountOrPercentage(), null, BigDecimal.ZERO);
                loanScheduleModelPeriod.addLoanCharges(loanCharge.getAmountOutstanding(), BigDecimal.ZERO);
            }
        }
    }

    @Generated
    public LoanScheduleAssembler(FromJsonHelper fromApiJsonHelper, LoanProductRepository loanProductRepository, ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository, LoanChargeAssembler loanChargeAssembler, LoanScheduleGeneratorFactory loanScheduleFactory, AprCalculator aprCalculator, CalendarRepository calendarRepository, HolidayRepository holidayRepository, ConfigurationDomainService configurationDomainService, ClientRepositoryWrapper clientRepository, GroupRepositoryWrapper groupRepository, WorkingDaysRepositoryWrapper workingDaysRepository, FloatingRatesReadPlatformService floatingRatesReadPlatformService, VariableLoanScheduleFromApiJsonValidator variableLoanScheduleFromApiJsonValidator, CalendarInstanceRepository calendarInstanceRepository, LoanUtilService loanUtilService, LoanDisbursementDetailsAssembler loanDisbursementDetailsAssembler, LoanRepositoryWrapper loanRepositoryWrapper, LoanLifecycleStateMachine loanLifecycleStateMachine, LoanAccrualsProcessingService loanAccrualsProcessingService, LoanDisbursementService loanDisbursementService, LoanChargeService loanChargeService, LoanScheduleService loanScheduleService, LoanProductRelatedDetailUpdateUtil relatedDetailUpdateUtil) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.loanProductRepository = loanProductRepository;
        this.applicationCurrencyRepository = applicationCurrencyRepository;
        this.loanChargeAssembler = loanChargeAssembler;
        this.loanScheduleFactory = loanScheduleFactory;
        this.aprCalculator = aprCalculator;
        this.calendarRepository = calendarRepository;
        this.holidayRepository = holidayRepository;
        this.configurationDomainService = configurationDomainService;
        this.clientRepository = clientRepository;
        this.groupRepository = groupRepository;
        this.workingDaysRepository = workingDaysRepository;
        this.floatingRatesReadPlatformService = floatingRatesReadPlatformService;
        this.variableLoanScheduleFromApiJsonValidator = variableLoanScheduleFromApiJsonValidator;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.loanUtilService = loanUtilService;
        this.loanDisbursementDetailsAssembler = loanDisbursementDetailsAssembler;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanLifecycleStateMachine = loanLifecycleStateMachine;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.loanDisbursementService = loanDisbursementService;
        this.loanChargeService = loanChargeService;
        this.loanScheduleService = loanScheduleService;
        this.relatedDetailUpdateUtil = relatedDetailUpdateUtil;
    }
}

