/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationProperty;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationRepositoryWrapper;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.UnsupportedParameterException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksWritePlatformService;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityAccessType;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityRelation;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityRelationRepository;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityToEntityMapping;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityToEntityMappingRepository;
import org.apache.fineract.infrastructure.entityaccess.exception.NotOfficeSpecificProductException;
import org.apache.fineract.organisation.holiday.domain.HolidayRepository;
import org.apache.fineract.organisation.holiday.domain.HolidayStatusType;
import org.apache.fineract.organisation.holiday.service.HolidayUtil;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.organisation.workingdays.service.WorkingDaysUtil;
import org.apache.fineract.portfolio.accountdetails.domain.AccountType;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagementRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.domain.CollateralManagementDomain;
import org.apache.fineract.portfolio.collateralmanagement.service.LoanCollateralAssembler;
import org.apache.fineract.portfolio.common.domain.DaysInYearCustomStrategyType;
import org.apache.fineract.portfolio.common.domain.DaysInYearType;
import org.apache.fineract.portfolio.common.service.Validator;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.group.exception.ClientNotInGroupException;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.loanaccount.data.DisbursementData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagement;
import org.apache.fineract.portfolio.loanaccount.domain.LoanEvent;
import org.apache.fineract.portfolio.loanaccount.domain.LoanLifecycleStateMachine;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.exception.ExceedingTrancheCountException;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidAmountOfCollateralQuantity;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidAmountOfCollaterals;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanStateTransitionException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanApplicationDateException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanApplicationNotInSubmittedAndPendingApprovalStateCannotBeModified;
import org.apache.fineract.portfolio.loanaccount.exception.MultiDisbursementDataNotAllowedException;
import org.apache.fineract.portfolio.loanaccount.exception.MultiDisbursementDataRequiredException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleProcessingType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.mapper.LoanMapper;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeApiJsonValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanScheduleValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.domain.AdvancedPaymentAllocationsValidator;
import org.apache.fineract.portfolio.loanproduct.domain.AmortizationMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestCalculationPeriodMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestMethod;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.loanproduct.exception.EqualAmortizationUnsupportedFeatureException;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;
import org.apache.fineract.portfolio.loanproduct.serialization.LoanProductDataValidator;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public final class LoanApplicationValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanApplicationValidator.class);
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("dateFormat", "locale", "id", "clientId", "groupId", "loanType", "productId", "principal", "totalLoan", "isParentAccount", "loanTermFrequency", "loanTermFrequencyType", "numberOfRepayments", "repaymentEvery", "repaymentFrequencyType", "repaymentFrequencyNthDayType", "repaymentFrequencyDayOfWeekType", "interestRatePerPeriod", "amortizationType", "amortizationTypeOptions", "interestType", "isFloatingInterestRate", "interestRateDifferential", "interestCalculationPeriodType", "allowPartialPeriodInterestCalcualtion", "interestRateFrequencyType", "expectedDisbursementDate", "repaymentsStartingFromDate", "graceOnPrincipalPayment", "graceOnInterestPayment", "graceOnInterestCharged", "interestChargedFromDate", "submittedOnDate", "submittedOnNote", "accountNo", "externalId", "fundId", "loanOfficerId", "loanPurposeId", "inArrearsTolerance", "charges", "collateral", "transactionProcessingStrategyCode", "calendarId", "syncDisbursementWithMeeting", "linkAccountId", "disbursementData", "fixedEmiAmount", "maxOutstandingLoanBalance", "graceOnArrearsAgeing", "createStandingInstructionAtDisbursement", "isTopup", "loanIdToClose", "datatables", "isEqualAmortization", "rates", "applicationId", "lastApplication", "daysInYearType", "fixedPrincipalPercentagePerInstallment", "disallowExpectedDisbursements", "fraud", "loanScheduleProcessingType", "fixedLength", "enableInstallmentLevelDelinquency", "enableDownPayment", "enableAutoRepaymentForDownPayment", "disbursedAmountPercentageForDownPayment", "interestRecognitionOnDisbursementDate", "daysInYearCustomStrategy"));
    public static final String LOANAPPLICATION_UNDO = "loanapplication.undo";
    private final FromJsonHelper fromApiJsonHelper;
    private final LoanScheduleValidator loanScheduleValidator;
    private final ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper;
    private final LoanChargeApiJsonValidator loanChargeApiJsonValidator;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;
    private final AdvancedPaymentAllocationsValidator advancedPaymentAllocationsValidator;
    private final ConfigurationDomainService configurationDomainService;
    private final LoanProductRepository loanProductRepository;
    private final ClientRepositoryWrapper clientRepository;
    private final GroupRepositoryWrapper groupRepository;
    private final LoanReadPlatformService loanReadPlatformService;
    private final LoanProductDataValidator loanProductDataValidator;
    private final GlobalConfigurationRepositoryWrapper globalConfigurationRepository;
    private final FineractEntityToEntityMappingRepository entityMappingRepository;
    private final FineractEntityRelationRepository fineractEntityRelationRepository;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final LoanCollateralAssembler collateralAssembler;
    private final WorkingDaysRepositoryWrapper workingDaysRepository;
    private final HolidayRepository holidayRepository;
    private final SavingsAccountRepositoryWrapper savingsAccountRepository;
    private final LoanLifecycleStateMachine loanLifecycleStateMachine;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final LoanUtilService loanUtilService;
    private final EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService;
    private final LoanMapper loanMapper;

    public void validateForCreate(Loan loan) {
        LocalDate expectedFirstRepaymentOnDate = loan.getExpectedFirstRepaymentOnDate();
        LocalDate submittedOnDate = loan.getSubmittedOnDate();
        if (expectedFirstRepaymentOnDate != null && DateUtils.isAfter((LocalDate)submittedOnDate, (LocalDate)expectedFirstRepaymentOnDate)) {
            throw new LoanApplicationDateException("submitted.on.date.cannot.be.after.the.loan.expected.first.repayment.date", "submittedOnDate cannot be after the loans  expectedFirstRepaymentOnDate.", new Object[]{submittedOnDate, expectedFirstRepaymentOnDate});
        }
        LoanApplicationValidator.validateCumulativeMultiDisburse((Loan)loan);
        this.validateLoanTermAndRepaidEveryValues(loan.getTermFrequency(), loan.getTermPeriodFrequencyType().getValue(), loan.getLoanProductRelatedDetail().getNumberOfRepayments(), loan.getLoanProductRelatedDetail().getRepayEvery(), loan.getLoanProductRelatedDetail().getRepaymentPeriodFrequencyType().getValue(), loan);
    }

    public void validateForModify(Loan loan) {
        LocalDate expectedFirstRepaymentOnDate = loan.getExpectedFirstRepaymentOnDate();
        LocalDate submittedOnDate = loan.getSubmittedOnDate();
        if (expectedFirstRepaymentOnDate != null && DateUtils.isAfter((LocalDate)submittedOnDate, (LocalDate)expectedFirstRepaymentOnDate)) {
            throw new LoanApplicationDateException("submitted.on.date.cannot.be.after.the.loan.expected.first.repayment.date", "submittedOnDate cannot be after the loans  expectedFirstRepaymentOnDate.", new Object[]{submittedOnDate, expectedFirstRepaymentOnDate});
        }
        LoanApplicationValidator.validateCumulativeMultiDisburse((Loan)loan);
        this.validateLoanTermAndRepaidEveryValues(loan.getTermFrequency(), loan.getTermPeriodFrequencyType().getValue(), loan.getLoanProductRelatedDetail().getNumberOfRepayments(), loan.getLoanProductRelatedDetail().getRepayEvery(), loan.getLoanProductRelatedDetail().getRepaymentPeriodFrequencyType().getValue(), loan);
    }

    public void validateForCreate(JsonCommand command) {
        String json = command.json();
        LoanApplicationValidator.validateRequestBody((String)json);
        this.validateForSupportedParameters(json);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateForCreate(element);
    }

    public void validateForCreate(JsonQuery query) {
        String json = query.json();
        LoanApplicationValidator.validateRequestBody((String)json);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateForSupportedParameters(json);
        this.validateForCreate(element);
    }

    private void validateForCreate(JsonElement element) {
        boolean isMeetingMandatoryForJLGLoans = this.configurationDomainService.isMeetingMandatoryForJLGLoans();
        Long productId = this.fromApiJsonHelper.extractLongNamed("productId", element);
        if (productId == null) {
            this.throwMandatoryParameterError("productId");
        }
        LoanProduct loanProduct = (LoanProduct)this.loanProductRepository.findById((Object)productId).orElseThrow(() -> new LoanProductNotFoundException(productId));
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
        Client client = clientId != null ? this.clientRepository.findOneWithNotFoundDetection(clientId) : null;
        Group group = groupId != null ? this.groupRepository.findOneWithNotFoundDetection(groupId) : null;
        this.validateClientOrGroup(client, group, productId);
        Validator.validateOrThrow((String)"loan", baseDataValidator -> {
            DaysInYearCustomStrategyType daysInYearCustomStrategy;
            boolean existByExternalId;
            AccountType loanType;
            String loanTypeStr = this.fromApiJsonHelper.extractStringNamed("loanType", element);
            baseDataValidator.reset().parameter("loanType").value((Object)loanTypeStr).notNull();
            if (!StringUtils.isBlank((CharSequence)loanTypeStr)) {
                AccountType loanType2 = AccountType.fromName((String)loanTypeStr);
                baseDataValidator.reset().parameter("loanType").value((Object)loanType2.getValue()).inMinMaxRange(Integer.valueOf(1), Integer.valueOf(4));
                if (loanType2.isIndividualAccount()) {
                    baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().longGreaterThanZero();
                    baseDataValidator.reset().parameter("groupId").value((Object)groupId).mustBeBlankWhenParameterProvided("clientId", (Object)clientId);
                }
                if (loanType2.isGroupAccount()) {
                    baseDataValidator.reset().parameter("groupId").value((Object)groupId).notNull().longGreaterThanZero();
                    baseDataValidator.reset().parameter("clientId").value((Object)clientId).mustBeBlankWhenParameterProvided("groupId", (Object)groupId);
                }
                if (loanType2.isJLGAccount()) {
                    baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().integerGreaterThanZero();
                    baseDataValidator.reset().parameter("groupId").value((Object)groupId).notNull().longGreaterThanZero();
                    if (isMeetingMandatoryForJLGLoans) {
                        Long calendarId = this.fromApiJsonHelper.extractLongNamed("calendarId", element);
                        baseDataValidator.reset().parameter("calendarId").value((Object)calendarId).notNull().integerGreaterThanZero();
                        Boolean syncDisbursement = this.fromApiJsonHelper.extractBooleanNamed("syncDisbursementWithMeeting", element);
                        if (syncDisbursement == null) {
                            baseDataValidator.reset().parameter("syncDisbursementWithMeeting").value((Object)syncDisbursement).trueOrFalseRequired((Object)false);
                        }
                    }
                }
            }
            boolean isEqualAmortization = false;
            if (this.fromApiJsonHelper.parameterExists("isEqualAmortization", element)) {
                isEqualAmortization = this.fromApiJsonHelper.extractBooleanNamed("isEqualAmortization", element);
                baseDataValidator.reset().parameter("isEqualAmortization").value((Object)isEqualAmortization).ignoreIfNull().validateForBooleanValue();
                if (isEqualAmortization && loanProduct.isInterestRecalculationEnabled()) {
                    throw new EqualAmortizationUnsupportedFeatureException("interest.recalculation", "interest recalculation");
                }
            }
            BigDecimal fixedPrincipalPercentagePerInstallment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedPrincipalPercentagePerInstallment", element);
            baseDataValidator.reset().parameter("fixedPrincipalPercentagePerInstallment").value((Object)fixedPrincipalPercentagePerInstallment).notLessThanMin(BigDecimal.ONE).notGreaterThanMax(BigDecimal.valueOf(100L));
            baseDataValidator.reset().parameter("productId").value((Object)productId).notNull().integerGreaterThanZero();
            if (this.fromApiJsonHelper.parameterExists("accountNo", element)) {
                String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
                baseDataValidator.reset().parameter("accountNo").value((Object)accountNo).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(20));
            }
            if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
                String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
                baseDataValidator.reset().parameter("externalId").value((Object)externalId).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(100));
            }
            if (this.fromApiJsonHelper.parameterExists("fundId", element)) {
                Long fundId = this.fromApiJsonHelper.extractLongNamed("fundId", element);
                baseDataValidator.reset().parameter("fundId").value((Object)fundId).ignoreIfNull().integerGreaterThanZero();
            }
            if (this.fromApiJsonHelper.parameterExists("loanOfficerId", element)) {
                Long loanOfficerId = this.fromApiJsonHelper.extractLongNamed("loanOfficerId", element);
                baseDataValidator.reset().parameter("loanOfficerId").value((Object)loanOfficerId).ignoreIfNull().integerGreaterThanZero();
            }
            if (this.fromApiJsonHelper.parameterExists("loanPurposeId", element)) {
                Long loanPurposeId = this.fromApiJsonHelper.extractLongNamed("loanPurposeId", element);
                baseDataValidator.reset().parameter("loanPurposeId").value((Object)loanPurposeId).ignoreIfNull().integerGreaterThanZero();
            }
            Integer loanTermFrequency = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("loanTermFrequency", element);
            baseDataValidator.reset().parameter("loanTermFrequency").value((Object)loanTermFrequency).notNull().integerGreaterThanZero();
            Integer loanTermFrequencyType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("loanTermFrequencyType", element);
            baseDataValidator.reset().parameter("loanTermFrequencyType").value((Object)loanTermFrequencyType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
            Integer numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("numberOfRepayments", element);
            baseDataValidator.reset().parameter("numberOfRepayments").value((Object)numberOfRepayments).notNull().integerGreaterThanZero();
            Integer repaymentEvery = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentEvery", element);
            baseDataValidator.reset().parameter("repaymentEvery").value((Object)repaymentEvery).notNull().integerGreaterThanZero();
            Integer repaymentEveryType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("repaymentFrequencyType", element);
            baseDataValidator.reset().parameter("repaymentFrequencyType").value((Object)repaymentEveryType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
            CalendarUtils.validateNthDayOfMonthFrequency((DataValidatorBuilder)baseDataValidator, (String)"repaymentFrequencyNthDayType", (String)"repaymentFrequencyDayOfWeekType", (JsonElement)element, (FromJsonHelper)this.fromApiJsonHelper);
            Integer interestType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestType", element);
            baseDataValidator.reset().parameter("interestType").value((Object)interestType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
            Integer interestCalculationPeriodType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCalculationPeriodType", element);
            baseDataValidator.reset().parameter("interestCalculationPeriodType").value((Object)interestCalculationPeriodType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
            if (loanProduct.isLinkedToFloatingInterestRate()) {
                if (isEqualAmortization) {
                    throw new EqualAmortizationUnsupportedFeatureException("floating.interest.rate", "floating interest rate");
                }
                if (this.fromApiJsonHelper.parameterExists("interestRatePerPeriod", element)) {
                    baseDataValidator.reset().parameter("interestRatePerPeriod").failWithCode("not.supported.loanproduct.linked.to.floating.rate", new Object[]{"interestRatePerPeriod param is not supported, selected Loan Product is linked with floating interest rate."});
                }
                if (this.fromApiJsonHelper.parameterExists("isFloatingInterestRate", element)) {
                    Boolean isFloatingInterestRate = this.fromApiJsonHelper.extractBooleanNamed("isFloatingInterestRate", element);
                    if (isFloatingInterestRate != null && isFloatingInterestRate.booleanValue() && !loanProduct.getFloatingRates().isFloatingInterestRateCalculationAllowed()) {
                        baseDataValidator.reset().parameter("isFloatingInterestRate").failWithCode("true.not.supported.for.selected.loanproduct", new Object[]{"isFloatingInterestRate value of true not supported for selected Loan Product."});
                    }
                } else {
                    baseDataValidator.reset().parameter("isFloatingInterestRate").trueOrFalseRequired((Object)false);
                }
                if (InterestMethod.FLAT.getValue().equals(interestType)) {
                    baseDataValidator.reset().parameter("interestType").failWithCode("should.be.0.for.selected.loan.product", new Object[]{"interestType should be DECLINING_BALANCE for selected Loan Product as it is linked to floating rates."});
                }
                String interestRateDifferentialParameterName = "interestRateDifferential";
                BigDecimal interestRateDifferential = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("interestRateDifferential", element);
                baseDataValidator.reset().parameter("interestRateDifferential").value((Object)interestRateDifferential).notNull().zeroOrPositiveAmount().inMinAndMaxAmountRange(loanProduct.getFloatingRates().getMinDifferentialLendingRate(), loanProduct.getFloatingRates().getMaxDifferentialLendingRate());
            } else {
                if (this.fromApiJsonHelper.parameterExists("isFloatingInterestRate", element)) {
                    baseDataValidator.reset().parameter("isFloatingInterestRate").failWithCode("not.supported.loanproduct.not.linked.to.floating.rate", new Object[]{"isFloatingInterestRate param is not supported, selected Loan Product is not linked with floating interest rate."});
                }
                if (this.fromApiJsonHelper.parameterExists("interestRateDifferential", element)) {
                    baseDataValidator.reset().parameter("interestRateDifferential").failWithCode("not.supported.loanproduct.not.linked.to.floating.rate", new Object[]{"interestRateDifferential param is not supported, selected Loan Product is not linked with floating interest rate."});
                }
                BigDecimal interestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("interestRatePerPeriod", element);
                baseDataValidator.reset().parameter("interestRatePerPeriod").value((Object)interestRatePerPeriod).notNull().zeroOrPositiveAmount();
            }
            Integer amortizationType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("amortizationType", element);
            baseDataValidator.reset().parameter("amortizationType").value((Object)amortizationType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
            if (!AmortizationMethod.EQUAL_PRINCIPAL.getValue().equals(amortizationType) && fixedPrincipalPercentagePerInstallment != null) {
                baseDataValidator.reset().parameter("fixedPrincipalPercentagePerInstallment").failWithCode("not.supported.principal.fixing.not.allowed.with.equal.installments", new Object[]{"Principal fixing cannot be done with equal installment amortization"});
            }
            LocalDate expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", element);
            baseDataValidator.reset().parameter("expectedDisbursementDate").value((Object)expectedDisbursementDate).notNull();
            Integer graceOnPrincipalPayment = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnPrincipalPayment", element);
            baseDataValidator.reset().parameter("graceOnPrincipalPayment").value((Object)graceOnPrincipalPayment).zeroOrPositiveAmount();
            Integer graceOnInterestPayment = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnInterestPayment", element);
            baseDataValidator.reset().parameter("graceOnInterestPayment").value((Object)graceOnInterestPayment).zeroOrPositiveAmount();
            Integer graceOnInterestCharged = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnInterestCharged", element);
            baseDataValidator.reset().parameter("graceOnInterestCharged").value((Object)graceOnInterestCharged).zeroOrPositiveAmount();
            Integer graceOnArrearsAgeing = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnArrearsAgeing", element);
            baseDataValidator.reset().parameter("graceOnArrearsAgeing").value((Object)graceOnArrearsAgeing).zeroOrPositiveAmount();
            if (this.fromApiJsonHelper.parameterExists("interestChargedFromDate", element)) {
                LocalDate interestChargedFromDate = this.fromApiJsonHelper.extractLocalDateNamed("interestChargedFromDate", element);
                baseDataValidator.reset().parameter("interestChargedFromDate").value((Object)interestChargedFromDate).ignoreIfNull().notNull();
            }
            if (this.fromApiJsonHelper.parameterExists("repaymentsStartingFromDate", element)) {
                LocalDate repaymentsStartingFromDate = this.fromApiJsonHelper.extractLocalDateNamed("repaymentsStartingFromDate", element);
                baseDataValidator.reset().parameter("repaymentsStartingFromDate").value((Object)repaymentsStartingFromDate).ignoreIfNull().notNull();
            }
            if (this.fromApiJsonHelper.parameterExists("inArrearsTolerance", element)) {
                BigDecimal inArrearsTolerance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("inArrearsTolerance", element);
                baseDataValidator.reset().parameter("inArrearsTolerance").value((Object)inArrearsTolerance).ignoreIfNull().zeroOrPositiveAmount();
            }
            LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
            baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedOnDate).notNull();
            if (this.fromApiJsonHelper.parameterExists("submittedOnNote", element)) {
                String submittedOnNote = this.fromApiJsonHelper.extractStringNamed("submittedOnNote", element);
                baseDataValidator.reset().parameter("submittedOnNote").value((Object)submittedOnNote).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(500));
            }
            String transactionProcessingStrategy = this.fromApiJsonHelper.extractStringNamed("transactionProcessingStrategyCode", element);
            baseDataValidator.reset().parameter("transactionProcessingStrategyCode").value((Object)transactionProcessingStrategy).notNull();
            this.validateLinkedSavingsAccount(element, baseDataValidator);
            if (this.fromApiJsonHelper.parameterExists("createStandingInstructionAtDisbursement", element)) {
                Boolean createStandingInstructionAtDisbursement = this.fromApiJsonHelper.extractBooleanNamed("createStandingInstructionAtDisbursement", element);
                Long linkAccountId = this.fromApiJsonHelper.extractLongNamed("linkAccountId", element);
                if (createStandingInstructionAtDisbursement.booleanValue()) {
                    baseDataValidator.reset().parameter("linkAccountId").value((Object)linkAccountId).notNull().longGreaterThanZero();
                }
            }
            this.loanChargeApiJsonValidator.validateLoanCharges(element, loanProduct, baseDataValidator);
            if (!StringUtils.isBlank((CharSequence)loanTypeStr) && (loanType = AccountType.fromName((String)loanTypeStr)).isIndividualAccount() && element.isJsonObject() && this.fromApiJsonHelper.parameterExists("collateral", element)) {
                JsonObject topLevelJsonElement = element.getAsJsonObject();
                Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
                if (topLevelJsonElement.get("collateral").isJsonArray()) {
                    Type collateralParameterTypeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
                    HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("clientCollateralId", "quantity"));
                    JsonArray array = topLevelJsonElement.get("collateral").getAsJsonArray();
                    for (int i = 1; i <= array.size(); ++i) {
                        JsonObject collateralItemElement = array.get(i - 1).getAsJsonObject();
                        String collateralJson = this.fromApiJsonHelper.toJson((JsonElement)collateralItemElement);
                        this.fromApiJsonHelper.checkForUnsupportedParameters(collateralParameterTypeOfMap, collateralJson, supportedParameters);
                        Long clientCollateralId = this.fromApiJsonHelper.extractLongNamed("clientCollateralId", (JsonElement)collateralItemElement);
                        baseDataValidator.reset().parameter("collateral").parameterAtIndexArray("clientCollateralId", Integer.valueOf(i)).value((Object)clientCollateralId).notNull().integerGreaterThanZero();
                        BigDecimal quantity = this.fromApiJsonHelper.extractBigDecimalNamed("quantity", (JsonElement)collateralItemElement, locale);
                        baseDataValidator.reset().parameter("collateral").parameterAtIndexArray("quantity", Integer.valueOf(i)).value((Object)quantity).notNull().positiveAmount();
                        ClientCollateralManagement clientCollateralManagement = this.clientCollateralManagementRepositoryWrapper.getCollateral(clientCollateralId);
                        if (clientCollateralId == null || BigDecimal.valueOf(0L).compareTo(clientCollateralManagement.getQuantity()) < 0) continue;
                        throw new InvalidAmountOfCollateralQuantity(clientCollateralManagement.getQuantity());
                    }
                } else {
                    baseDataValidator.reset().parameter("collateral").expectedArrayButIsNot();
                }
            }
            if (this.fromApiJsonHelper.parameterExists("fixedEmiAmount", element)) {
                if (!loanProduct.isCanDefineInstallmentAmount() && !loanProduct.isMultiDisburseLoan()) {
                    ArrayList<String> unsupportedParameterList = new ArrayList<String>();
                    unsupportedParameterList.add("fixedEmiAmount");
                    throw new UnsupportedParameterException(unsupportedParameterList);
                }
                if (isEqualAmortization) {
                    throw new EqualAmortizationUnsupportedFeatureException("fixed.emi", "fixed emi");
                }
                BigDecimal emiAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedEmiAmount", element);
                baseDataValidator.reset().parameter("fixedEmiAmount").value((Object)emiAmount).ignoreIfNull().positiveAmount();
            }
            if (this.fromApiJsonHelper.parameterExists("maxOutstandingLoanBalance", element)) {
                BigDecimal maxOutstandingBalance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("maxOutstandingLoanBalance", element);
                baseDataValidator.reset().parameter("maxOutstandingLoanBalance").value((Object)maxOutstandingBalance).ignoreIfNull().positiveAmount();
            }
            BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principal", element);
            if (loanProduct.isCanUseForTopup() && this.fromApiJsonHelper.parameterExists("isTopup", element)) {
                Boolean isTopup = this.fromApiJsonHelper.extractBooleanNamed("isTopup", element);
                baseDataValidator.reset().parameter("isTopup").value((Object)isTopup).validateForBooleanValue();
                if (isTopup != null && isTopup.booleanValue()) {
                    Long loanId = this.fromApiJsonHelper.extractLongNamed("loanIdToClose", element);
                    baseDataValidator.reset().parameter("loanIdToClose").value((Object)loanId).notNull().longGreaterThanZero();
                    if (clientId != null) {
                        Long loanIdToClose = this.fromApiJsonHelper.extractLongNamed("loanIdToClose", element);
                        Loan loanToClose = this.loanRepositoryWrapper.findNonClosedLoanThatBelongsToClient(loanIdToClose, clientId);
                        if (loanToClose == null) {
                            throw new GeneralPlatformDomainRuleException("error.msg.loan.loanIdToClose.no.active.loan.associated.to.client.found", "loanIdToClose is invalid, No Active Loan associated with the given Client ID found.", new Object[0]);
                        }
                        if (loanToClose.isMultiDisburmentLoan() && !loanToClose.getLoanProductRelatedDetail().isInterestRecalculationEnabled()) {
                            throw new GeneralPlatformDomainRuleException("error.msg.loan.topup.on.multi.tranche.loan.without.interest.recalculation.not.supported", "Topup on loan with multi-tranche disbursal and without interest recalculation is not supported.", new Object[0]);
                        }
                        LocalDate disbursalDateOfLoanToClose = loanToClose.getDisbursementDate();
                        if (!DateUtils.isAfter((LocalDate)submittedOnDate, (LocalDate)disbursalDateOfLoanToClose)) {
                            throw new GeneralPlatformDomainRuleException("error.msg.loan.submitted.date.should.be.after.topup.loan.disbursal.date", "Submitted date of this loan application " + String.valueOf(submittedOnDate) + " should be after the disbursed date of loan to be closed " + String.valueOf(disbursalDateOfLoanToClose), new Object[0]);
                        }
                        if (!loanToClose.getCurrencyCode().equals(loanProduct.getCurrency().getCode())) {
                            throw new GeneralPlatformDomainRuleException("error.msg.loan.to.be.closed.has.different.currency", "loanIdToClose is invalid, Currency code is different.", new Object[0]);
                        }
                        LocalDate lastUserTransactionOnLoanToClose = loanToClose.getLastUserTransactionDate();
                        if (DateUtils.isBefore((LocalDate)expectedDisbursementDate, (LocalDate)lastUserTransactionOnLoanToClose)) {
                            throw new GeneralPlatformDomainRuleException("error.msg.loan.disbursal.date.should.be.after.last.transaction.date.of.loan.to.be.closed", "Disbursal date of this loan application " + String.valueOf(expectedDisbursementDate) + " should be after last transaction date of loan to be closed " + String.valueOf(lastUserTransactionOnLoanToClose), new Object[0]);
                        }
                        BigDecimal loanOutstanding = this.loanReadPlatformService.retrieveLoanPrePaymentTemplate(LoanTransactionType.REPAYMENT, loanIdToClose, expectedDisbursementDate).getAmount();
                        if (loanOutstanding.compareTo(principal) > 0) {
                            throw new GeneralPlatformDomainRuleException("error.msg.loan.amount.less.than.outstanding.of.loan.to.be.closed", "Topup loan amount should be greater than outstanding amount of loan to be closed.", new Object[0]);
                        }
                    }
                }
            }
            if (this.fromApiJsonHelper.parameterExists("datatables", element)) {
                JsonArray datatables = this.fromApiJsonHelper.extractJsonArrayNamed("datatables", element);
                baseDataValidator.reset().parameter("datatables").value((Object)datatables).notNull().jsonArrayNotEmpty();
            }
            if (this.fromApiJsonHelper.parameterExists("daysInYearType", element)) {
                Integer daysInYearType = this.fromApiJsonHelper.extractIntegerNamed("daysInYearType", element, Locale.getDefault());
                baseDataValidator.reset().parameter("daysInYearType").value((Object)daysInYearType).notNull().isOneOfTheseValues(new Object[]{1, 360, 364, 365});
            }
            this.validateLoanMultiDisbursementDate(element, baseDataValidator, expectedDisbursementDate, principal);
            String loanScheduleProcessingType = loanProduct.getLoanProductRelatedDetail().getLoanScheduleProcessingType().name();
            if (this.fromApiJsonHelper.parameterExists("loanScheduleProcessingType", element)) {
                loanScheduleProcessingType = this.fromApiJsonHelper.extractStringNamed("loanScheduleProcessingType", element);
                baseDataValidator.reset().parameter("loanScheduleProcessingType").value((Object)loanScheduleProcessingType).isOneOfEnumValues(LoanScheduleProcessingType.class);
            }
            if (LoanScheduleProcessingType.VERTICAL.equals((Object)LoanScheduleProcessingType.valueOf((String)loanScheduleProcessingType)) && !"advanced-payment-allocation-strategy".equals(transactionProcessingStrategy)) {
                baseDataValidator.reset().parameter("loanScheduleProcessingType").failWithCode("supported.only.with.advanced.payment.allocation.strategy", new Object[]{"Vertical repayment schedule processing is only available with `Advanced payment allocation` strategy"});
            }
            List allocationRules = loanProduct.getPaymentAllocationRules();
            if (LoanScheduleProcessingType.HORIZONTAL.name().equals(loanScheduleProcessingType) && "advanced-payment-allocation-strategy".equals(transactionProcessingStrategy)) {
                this.advancedPaymentAllocationsValidator.checkGroupingOfAllocationRules(allocationRules);
            }
            this.validatePartialPeriodSupport(interestCalculationPeriodType, baseDataValidator, element, loanProduct);
            if (this.fromApiJsonHelper.parameterExists("enableInstallmentLevelDelinquency", element)) {
                Boolean isEnableInstallmentLevelDelinquency = this.fromApiJsonHelper.extractBooleanNamed("enableInstallmentLevelDelinquency", element);
                baseDataValidator.reset().parameter("enableInstallmentLevelDelinquency").value((Object)isEnableInstallmentLevelDelinquency).validateForBooleanValue();
                if (loanProduct.getDelinquencyBucket() == null && isEnableInstallmentLevelDelinquency.booleanValue()) {
                    baseDataValidator.reset().parameter("enableInstallmentLevelDelinquency").failWithCode("can.be.enabled.for.loan.with.loan.product.having.valid.delinquency.bucket", new Object[]{"Installment level delinquency cannot be enabled for a loan if Delinquency bucket is not configured for loan product"});
                }
            }
            this.validateBorrowerCycle(element, loanProduct, clientId, groupId, baseDataValidator);
            String externalIdStr = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            ExternalId externalId = ExternalIdFactory.produce((String)externalIdStr);
            if (!externalId.isEmpty() && (existByExternalId = this.loanRepositoryWrapper.existLoanByExternalId(externalId))) {
                throw new GeneralPlatformDomainRuleException("error.msg.loan.with.externalId.already.used", "Loan with externalId is already registered.", new Object[0]);
            }
            this.loanScheduleValidator.validateDownPaymentAttribute(loanProduct.getLoanProductRelatedDetail().isEnableDownPayment(), element);
            this.checkForProductMixRestrictions(element);
            this.validateDisbursementDetails(loanProduct, element);
            this.validateCollateral(element);
            this.validateDisbursementDateIsOnNonWorkingDay(expectedDisbursementDate);
            Long officeId = this.resolveOfficeId(client, group);
            this.validateDisbursementDateIsOnHoliday(expectedDisbursementDate, officeId);
            Integer recurringMoratoriumOnPrincipalPeriods = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("recurringMoratoriumOnPrincipalPeriods", element);
            if (numberOfRepayments != null) {
                this.loanProductDataValidator.validateRepaymentPeriodWithGraceSettings(numberOfRepayments, graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, recurringMoratoriumOnPrincipalPeriods, baseDataValidator);
            }
            if (this.fromApiJsonHelper.parameterExists("daysInYearCustomStrategy", element) && (daysInYearCustomStrategy = (DaysInYearCustomStrategyType)this.fromApiJsonHelper.enumValueOfParameterNamed("daysInYearCustomStrategyParameterName", element, DaysInYearCustomStrategyType.class)) != null) {
                if (!LoanScheduleType.PROGRESSIVE.equals((Object)loanProduct.getLoanProductRelatedDetail().getLoanScheduleType())) {
                    baseDataValidator.reset().parameter("daysInYearCustomStrategy").failWithCode("days.in.year.custom.strategy.is.only.supported.for.progressive.loan.schedule.type", new Object[]{"daysInYearCustomStrategy is only supported for progressive loan schedule type"});
                }
                if (!DaysInYearType.ACTUAL.getValue().equals(loanProduct.getLoanProductRelatedDetail().getDaysInYearType())) {
                    baseDataValidator.reset().parameter("daysInYearCustomStrategy").failWithCode("days.in.year.custom.strategy.is.only.applicable.for.actual.days.in.year.type", new Object[]{"daysInYearCustomStrategy is only applicable for ACTUAL days in year type"});
                }
            }
        });
        this.validateSubmittedOnDate(element, null, null, loanProduct);
        String transactionProcessingStrategy = this.fromApiJsonHelper.extractStringNamed("transactionProcessingStrategyCode", element);
        this.validateTransactionProcessingStrategy(transactionProcessingStrategy, loanProduct);
        this.fixedLengthValidations(element);
        if (this.fromApiJsonHelper.parameterExists("interestRecognitionOnDisbursementDate", element) && !LoanScheduleType.PROGRESSIVE.equals((Object)loanProduct.getLoanProductRelatedDetail().getLoanScheduleType())) {
            ArrayList<String> unsupportedParameterList = new ArrayList<String>();
            unsupportedParameterList.add("interestRecognitionOnDisbursementDate");
            throw new UnsupportedParameterException(unsupportedParameterList);
        }
    }

    private void fixedLengthValidations(JsonElement element) {
        Validator.validateOrThrow((String)"loan", baseDataValidator -> {
            String transactionProcessingStrategy = this.fromApiJsonHelper.extractStringNamed("transactionProcessingStrategyCode", element);
            Integer numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("numberOfRepayments", element);
            Integer repaymentEvery = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentEvery", element);
            BigDecimal interestRatePerPeriod = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("interestRatePerPeriod", element);
            boolean isInterestBearing = interestRatePerPeriod != null && interestRatePerPeriod.compareTo(BigDecimal.ZERO) > 0;
            this.loanProductDataValidator.fixedLengthValidations(transactionProcessingStrategy, isInterestBearing, numberOfRepayments, repaymentEvery, element, baseDataValidator);
        });
    }

    private void validateBorrowerCycle(JsonElement element, LoanProduct loanProduct, Long clientId, Long groupId, DataValidatorBuilder baseDataValidator) {
        if (loanProduct.isUseBorrowerCycle()) {
            Integer cycleNumber = 0;
            if (clientId != null) {
                cycleNumber = this.loanReadPlatformService.retriveLoanCounter(clientId, (Long)loanProduct.getId());
            } else if (groupId != null) {
                cycleNumber = this.loanReadPlatformService.retriveLoanCounter(groupId, AccountType.GROUP.getValue(), (Long)loanProduct.getId());
            }
            this.loanProductDataValidator.validateMinMaxConstraints(element, baseDataValidator, loanProduct, cycleNumber);
        } else {
            this.loanProductDataValidator.validateMinMaxConstraints(element, baseDataValidator, loanProduct);
        }
    }

    private void validateDisbursementDateIsOnNonWorkingDay(LocalDate expectedDisbursementDate) {
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        boolean allowTransactionsOnNonWorkingDay = this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled();
        if (expectedDisbursementDate != null && !allowTransactionsOnNonWorkingDay && !WorkingDaysUtil.isWorkingDay((WorkingDays)workingDays, (LocalDate)expectedDisbursementDate)) {
            String errorMessage = "Expected disbursement date cannot be on a non working day";
            throw new LoanApplicationDateException("disbursement.date.on.non.working.day", "Expected disbursement date cannot be on a non working day", new Object[]{expectedDisbursementDate});
        }
    }

    private void validateDisbursementDateIsOnHoliday(LocalDate expectedDisbursementDate, Long officeId) {
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(officeId, expectedDisbursementDate, HolidayStatusType.ACTIVE.getValue());
        boolean allowTransactionsOnHoliday = this.configurationDomainService.allowTransactionsOnHolidayEnabled();
        if (!allowTransactionsOnHoliday && HolidayUtil.isHoliday((LocalDate)expectedDisbursementDate, (List)holidays)) {
            String errorMessage = "Expected disbursement date cannot be on a holiday";
            throw new LoanApplicationDateException("disbursement.date.on.holiday", "Expected disbursement date cannot be on a holiday", new Object[]{expectedDisbursementDate});
        }
    }

    private void validateCollateral(JsonElement element) {
        Set collateral;
        AccountType loanAccountType;
        BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principal", element);
        String loanTypeStr = this.fromApiJsonHelper.extractStringNamed("loanType", element);
        if (!StringUtils.isBlank((CharSequence)loanTypeStr) && (loanAccountType = AccountType.fromName((String)loanTypeStr)).isIndividualAccount() && !(collateral = this.collateralAssembler.fromParsedJson(element)).isEmpty()) {
            BigDecimal totalValue = BigDecimal.ZERO;
            for (LoanCollateralManagement collateralManagement : collateral) {
                CollateralManagementDomain collateralManagementDomain = collateralManagement.getClientCollateralManagement().getCollaterals();
                BigDecimal totalCollateral = collateralManagement.getQuantity().multiply(collateralManagementDomain.getBasePrice()).multiply(collateralManagementDomain.getPctToBase()).divide(BigDecimal.valueOf(100L), MoneyHelper.getMathContext());
                totalValue = totalValue.add(totalCollateral);
            }
            if (amount.compareTo(totalValue) > 0) {
                throw new InvalidAmountOfCollaterals(totalValue);
            }
        }
    }

    public void validateForModify(JsonCommand command, Loan loan) {
        String json = command.json();
        LoanApplicationValidator.validateRequestBody((String)json);
        this.validateForSupportedParameters(json);
        if (!loan.isSubmittedAndPendingApproval()) {
            throw new LoanApplicationNotInSubmittedAndPendingApprovalStateCannotBeModified((Long)loan.getId());
        }
        String productIdParamName = "productId";
        Long productId = command.longValueOfParameterNamed("productId");
        LoanProduct loanProduct = productId == null || productId.equals(loan.getLoanProduct().getId()) ? loan.getLoanProduct() : (LoanProduct)this.loanProductRepository.findById((Object)productId).orElseThrow(() -> new LoanProductNotFoundException(productId));
        Validator.validateOrThrow((String)"loan", baseDataValidator -> {
            Long groupId;
            Long clientId;
            JsonElement element = this.fromApiJsonHelper.parse(json);
            boolean atLeastOneParameterPassedForUpdate = false;
            Long l = clientId = loan.getClient() != null ? (Long)loan.getClient().getId() : null;
            if (this.fromApiJsonHelper.parameterExists("clientId", element)) {
                atLeastOneParameterPassedForUpdate = true;
                clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
                baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().integerGreaterThanZero();
            }
            Client client = null;
            if (clientId != null) {
                client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            }
            Long l2 = groupId = loan.getGroup() != null ? (Long)loan.getGroup().getId() : null;
            if (this.fromApiJsonHelper.parameterExists("groupId", element)) {
                atLeastOneParameterPassedForUpdate = true;
                groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
                baseDataValidator.reset().parameter("groupId").value((Object)groupId).notNull().integerGreaterThanZero();
            }
            Group group = null;
            if (groupId != null) {
                group = this.groupRepository.findOneWithNotFoundDetection(groupId);
            }
            if (productId != null) {
                atLeastOneParameterPassedForUpdate = true;
                baseDataValidator.reset().parameter("productId").value((Object)productId).notNull().integerGreaterThanZero();
            }
            if (this.fromApiJsonHelper.parameterExists("accountNo", element)) {
                atLeastOneParameterPassedForUpdate = true;
                String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
                baseDataValidator.reset().parameter("accountNo").value((Object)accountNo).notBlank().notExceedingLengthOf(Integer.valueOf(20));
            }
            boolean isEqualAmortization = loan.getLoanProductRelatedDetail().isEqualAmortization();
            if (this.fromApiJsonHelper.parameterExists("isEqualAmortization", element)) {
                isEqualAmortization = this.fromApiJsonHelper.extractBooleanNamed("isEqualAmortization", element);
                baseDataValidator.reset().parameter("isEqualAmortization").value((Object)isEqualAmortization).ignoreIfNull().validateForBooleanValue();
                if (isEqualAmortization && loanProduct.isInterestRecalculationEnabled()) {
                    throw new EqualAmortizationUnsupportedFeatureException("interest.recalculation", "interest recalculation");
                }
            }
            BigDecimal fixedPrincipalPercentagePerInstallment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedPrincipalPercentagePerInstallment", element);
            baseDataValidator.reset().parameter("fixedPrincipalPercentagePerInstallment").value((Object)fixedPrincipalPercentagePerInstallment).notLessThanMin(BigDecimal.ONE).notGreaterThanMax(BigDecimal.valueOf(100L));
            if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
                atLeastOneParameterPassedForUpdate = true;
                String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
                baseDataValidator.reset().parameter("externalId").value((Object)externalId).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(100));
            }
            if (this.fromApiJsonHelper.parameterExists("fundId", element)) {
                atLeastOneParameterPassedForUpdate = true;
                Long fundId = this.fromApiJsonHelper.extractLongNamed("fundId", element);
                baseDataValidator.reset().parameter("fundId").value((Object)fundId).ignoreIfNull().integerGreaterThanZero();
            }
            if (this.fromApiJsonHelper.parameterExists("loanOfficerId", element)) {
                atLeastOneParameterPassedForUpdate = true;
                Long loanOfficerId = this.fromApiJsonHelper.extractLongNamed("loanOfficerId", element);
                baseDataValidator.reset().parameter("loanOfficerId").value((Object)loanOfficerId).ignoreIfNull().integerGreaterThanZero();
            }
            String transactionProcessingStrategy = loan.getTransactionProcessingStrategyCode();
            if (this.fromApiJsonHelper.parameterExists("transactionProcessingStrategyCode", element)) {
                atLeastOneParameterPassedForUpdate = true;
                transactionProcessingStrategy = this.fromApiJsonHelper.extractStringNamed("transactionProcessingStrategyCode", element);
                baseDataValidator.reset().parameter("transactionProcessingStrategyCode").value((Object)transactionProcessingStrategy).notNull();
                this.validateTransactionProcessingStrategy(transactionProcessingStrategy, loanProduct);
            }
            if (!"advanced-payment-allocation-strategy".equals(loanProduct.getTransactionProcessingStrategyCode()) && "advanced-payment-allocation-strategy".equals(transactionProcessingStrategy)) {
                baseDataValidator.reset().parameter("transactionProcessingStrategyCode").failWithCode("strategy.cannot.be.advanced.payment.allocation.if.not.configured", new Object[]{"Loan transaction processing strategy cannot be Advanced Payment Allocation Strategy if it's not configured on loan product"});
            }
            BigDecimal principal = null;
            if (this.fromApiJsonHelper.parameterExists("principal", element)) {
                atLeastOneParameterPassedForUpdate = true;
                principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principal", element);
                baseDataValidator.reset().parameter("principal").value((Object)principal).notNull().positiveAmount();
            }
            if (this.fromApiJsonHelper.parameterExists("inArrearsTolerance", element)) {
                atLeastOneParameterPassedForUpdate = true;
                BigDecimal inArrearsTolerance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("inArrearsTolerance", element);
                baseDataValidator.reset().parameter("inArrearsTolerance").value((Object)inArrearsTolerance).ignoreIfNull().zeroOrPositiveAmount();
            }
            if (this.fromApiJsonHelper.parameterExists("loanTermFrequency", element)) {
                atLeastOneParameterPassedForUpdate = true;
                Integer loanTermFrequency = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("loanTermFrequency", element);
                baseDataValidator.reset().parameter("loanTermFrequency").value((Object)loanTermFrequency).notNull().integerGreaterThanZero();
            }
            if (this.fromApiJsonHelper.parameterExists("loanTermFrequencyType", element)) {
                atLeastOneParameterPassedForUpdate = true;
                Integer loanTermFrequencyType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("loanTermFrequencyType", element);
                baseDataValidator.reset().parameter("loanTermFrequencyType").value((Object)loanTermFrequencyType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
            }
            Integer numberOfRepayments = loan.getNumberOfRepayments();
            if (this.fromApiJsonHelper.parameterExists("numberOfRepayments", element)) {
                atLeastOneParameterPassedForUpdate = true;
                numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("numberOfRepayments", element);
                baseDataValidator.reset().parameter("numberOfRepayments").value((Object)numberOfRepayments).notNull().integerGreaterThanZero();
            }
            if (this.fromApiJsonHelper.parameterExists("repaymentEvery", element)) {
                atLeastOneParameterPassedForUpdate = true;
                Integer repaymentEvery = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentEvery", element);
                baseDataValidator.reset().parameter("repaymentEvery").value((Object)repaymentEvery).notNull().integerGreaterThanZero();
            }
            if (this.fromApiJsonHelper.parameterExists("repaymentFrequencyType", element)) {
                atLeastOneParameterPassedForUpdate = true;
                Integer repaymentEveryType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentFrequencyType", element);
                baseDataValidator.reset().parameter("repaymentFrequencyType").value((Object)repaymentEveryType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
            }
            CalendarUtils.validateNthDayOfMonthFrequency((DataValidatorBuilder)baseDataValidator, (String)"repaymentFrequencyNthDayType", (String)"repaymentFrequencyDayOfWeekType", (JsonElement)element, (FromJsonHelper)this.fromApiJsonHelper);
            Integer interestType = null;
            if (this.fromApiJsonHelper.parameterExists("interestType", element)) {
                atLeastOneParameterPassedForUpdate = true;
                interestType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("interestType", element);
                baseDataValidator.reset().parameter("interestType").value((Object)interestType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
            }
            if (loanProduct.isLinkedToFloatingInterestRate()) {
                if (isEqualAmortization) {
                    throw new EqualAmortizationUnsupportedFeatureException("floating.interest.rate", "floating interest rate");
                }
                if (this.fromApiJsonHelper.parameterExists("interestRatePerPeriod", element)) {
                    baseDataValidator.reset().parameter("interestRatePerPeriod").failWithCode("not.supported.loanproduct.linked.to.floating.rate", new Object[]{"interestRatePerPeriod param is not supported, selected Loan Product is linked with floating interest rate."});
                }
                Boolean isFloatingInterestRate = loan.getIsFloatingInterestRate();
                if (this.fromApiJsonHelper.parameterExists("isFloatingInterestRate", element)) {
                    isFloatingInterestRate = this.fromApiJsonHelper.extractBooleanNamed("isFloatingInterestRate", element);
                    atLeastOneParameterPassedForUpdate = true;
                }
                if (isFloatingInterestRate != null) {
                    if (isFloatingInterestRate.booleanValue() && !loanProduct.getFloatingRates().isFloatingInterestRateCalculationAllowed()) {
                        baseDataValidator.reset().parameter("isFloatingInterestRate").failWithCode("true.not.supported.for.selected.loanproduct", new Object[]{"isFloatingInterestRate value of true not supported for selected Loan Product."});
                    }
                } else {
                    baseDataValidator.reset().parameter("isFloatingInterestRate").trueOrFalseRequired((Object)false);
                }
                if (interestType == null) {
                    interestType = loan.getLoanProductRelatedDetail().getInterestMethod().getValue();
                }
                if (InterestMethod.FLAT.getValue().equals(interestType)) {
                    baseDataValidator.reset().parameter("interestType").failWithCode("should.be.0.for.selected.loan.product", new Object[]{"interestType should be DECLINING_BALANCE for selected Loan Product as it is linked to floating rates."});
                }
                BigDecimal interestRateDifferential = loan.getInterestRateDifferential();
                if (this.fromApiJsonHelper.parameterExists("interestRateDifferential", element)) {
                    interestRateDifferential = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("interestRateDifferential", element);
                    atLeastOneParameterPassedForUpdate = true;
                }
                baseDataValidator.reset().parameter("interestRateDifferential").value((Object)interestRateDifferential).notNull().zeroOrPositiveAmount().inMinAndMaxAmountRange(loanProduct.getFloatingRates().getMinDifferentialLendingRate(), loanProduct.getFloatingRates().getMaxDifferentialLendingRate());
            } else {
                if (this.fromApiJsonHelper.parameterExists("isFloatingInterestRate", element)) {
                    baseDataValidator.reset().parameter("isFloatingInterestRate").failWithCode("not.supported.loanproduct.not.linked.to.floating.rate", new Object[]{"isFloatingInterestRate param is not supported, selected Loan Product is not linked with floating interest rate."});
                }
                if (this.fromApiJsonHelper.parameterExists("interestRateDifferential", element)) {
                    baseDataValidator.reset().parameter("interestRateDifferential").failWithCode("not.supported.loanproduct.not.linked.to.floating.rate", new Object[]{"interestRateDifferential param is not supported, selected Loan Product is not linked with floating interest rate."});
                }
                BigDecimal interestRatePerPeriod = loan.getLoanProductRelatedDetail().getNominalInterestRatePerPeriod();
                if (this.fromApiJsonHelper.parameterExists("interestRatePerPeriod", element)) {
                    this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("interestRatePerPeriod", element);
                    atLeastOneParameterPassedForUpdate = true;
                }
                baseDataValidator.reset().parameter("interestRatePerPeriod").value((Object)interestRatePerPeriod).notNull().zeroOrPositiveAmount();
            }
            Integer interestCalculationPeriodType = loanProduct.getLoanProductRelatedDetail().getInterestCalculationPeriodMethod().getValue();
            if (this.fromApiJsonHelper.parameterExists("interestCalculationPeriodType", element)) {
                atLeastOneParameterPassedForUpdate = true;
                interestCalculationPeriodType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("interestCalculationPeriodType", element);
                baseDataValidator.reset().parameter("interestCalculationPeriodType").value((Object)interestCalculationPeriodType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
            }
            Integer amortizationType = null;
            if (this.fromApiJsonHelper.parameterExists("amortizationType", element)) {
                atLeastOneParameterPassedForUpdate = true;
                amortizationType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("amortizationType", element);
                baseDataValidator.reset().parameter("amortizationType").value((Object)amortizationType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
            }
            if (!AmortizationMethod.EQUAL_PRINCIPAL.getValue().equals(amortizationType) && fixedPrincipalPercentagePerInstallment != null) {
                baseDataValidator.reset().parameter("fixedPrincipalPercentagePerInstallment").failWithCode("not.supported.principal.fixing.not.allowed.with.equal.installments", new Object[]{"Principal fixing cannot be done with equal installment amortization"});
            }
            LocalDate expectedDisbursementDate = loan.getExpectedDisbursementDate();
            if (this.fromApiJsonHelper.parameterExists("expectedDisbursementDate", element)) {
                atLeastOneParameterPassedForUpdate = true;
                String expectedDisbursementDateStr = this.fromApiJsonHelper.extractStringNamed("expectedDisbursementDate", element);
                baseDataValidator.reset().parameter("expectedDisbursementDate").value((Object)expectedDisbursementDateStr).notBlank();
                expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", element);
                baseDataValidator.reset().parameter("expectedDisbursementDate").value((Object)expectedDisbursementDate).notNull();
            }
            Integer graceOnPrincipalPayment = loan.getLoanProductRelatedDetail().getGraceOnPrincipalPayment();
            if (this.fromApiJsonHelper.parameterExists("graceOnPrincipalPayment", element)) {
                graceOnPrincipalPayment = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnPrincipalPayment", element);
                baseDataValidator.reset().parameter("graceOnPrincipalPayment").value((Object)graceOnPrincipalPayment).zeroOrPositiveAmount();
            }
            Integer graceOnInterestPayment = loan.getLoanProductRelatedDetail().getGraceOnInterestPayment();
            if (this.fromApiJsonHelper.parameterExists("graceOnInterestPayment", element)) {
                graceOnInterestPayment = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnInterestPayment", element);
                baseDataValidator.reset().parameter("graceOnInterestPayment").value((Object)graceOnInterestPayment).zeroOrPositiveAmount();
            }
            Integer graceOnInterestCharged = loan.getLoanProductRelatedDetail().getGraceOnInterestCharged();
            if (this.fromApiJsonHelper.parameterExists("graceOnInterestCharged", element)) {
                graceOnInterestCharged = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnInterestCharged", element);
                baseDataValidator.reset().parameter("graceOnInterestCharged").value((Object)graceOnInterestCharged).zeroOrPositiveAmount();
            }
            if (this.fromApiJsonHelper.parameterExists("graceOnArrearsAgeing", element)) {
                Integer graceOnArrearsAgeing = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("graceOnArrearsAgeing", element);
                baseDataValidator.reset().parameter("graceOnArrearsAgeing").value((Object)graceOnArrearsAgeing).zeroOrPositiveAmount();
            }
            if (this.fromApiJsonHelper.parameterExists("interestChargedFromDate", element)) {
                atLeastOneParameterPassedForUpdate = true;
                LocalDate interestChargedFromDate = this.fromApiJsonHelper.extractLocalDateNamed("interestChargedFromDate", element);
                baseDataValidator.reset().parameter("interestChargedFromDate").value((Object)interestChargedFromDate).ignoreIfNull();
            }
            if (this.fromApiJsonHelper.parameterExists("repaymentsStartingFromDate", element)) {
                atLeastOneParameterPassedForUpdate = true;
                LocalDate repaymentsStartingFromDate = this.fromApiJsonHelper.extractLocalDateNamed("repaymentsStartingFromDate", element);
                baseDataValidator.reset().parameter("repaymentsStartingFromDate").value((Object)repaymentsStartingFromDate).ignoreIfNull();
                if (!loan.getLoanTermVariations().isEmpty()) {
                    baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("cannot.modify.application.due.to.variable.installments", new Object[0]);
                }
            }
            if (this.fromApiJsonHelper.parameterExists("submittedOnDate", element)) {
                atLeastOneParameterPassedForUpdate = true;
                LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
                baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedOnDate).notNull();
            }
            if (this.fromApiJsonHelper.parameterExists("submittedOnNote", element)) {
                atLeastOneParameterPassedForUpdate = true;
                String submittedOnNote = this.fromApiJsonHelper.extractStringNamed("submittedOnNote", element);
                baseDataValidator.reset().parameter("submittedOnNote").value((Object)submittedOnNote).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(500));
            }
            this.validateLinkedSavingsAccount(element, baseDataValidator);
            this.loanChargeApiJsonValidator.validateLoanCharges(element, loanProduct, baseDataValidator);
            String loanTypeStr = this.fromApiJsonHelper.extractStringNamed("loanType", element);
            baseDataValidator.reset().parameter("loanType").value((Object)loanTypeStr).notNull();
            if (!StringUtils.isBlank((CharSequence)loanTypeStr)) {
                AccountType loanType = AccountType.fromName((String)loanTypeStr);
                if (loanType.isInvalid()) {
                    baseDataValidator.reset().parameter("loanType").value((Object)loanType.getValue()).isOneOfEnumValues(AccountType.class);
                }
                if (!loanType.isInvalid() && loanType.isIndividualAccount()) {
                    String collateralParameterName = "collateral";
                    if (element.isJsonObject() && this.fromApiJsonHelper.parameterExists("collateral", element)) {
                        JsonObject topLevelJsonElement = element.getAsJsonObject();
                        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
                        if (topLevelJsonElement.get("collateral").isJsonArray()) {
                            Type collateralParameterTypeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
                            HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("id", "clientCollateralId", "quantity"));
                            JsonArray array = topLevelJsonElement.get("collateral").getAsJsonArray();
                            if (!array.isEmpty()) {
                                BigDecimal totalAmount = BigDecimal.ZERO;
                                for (int i = 1; i <= array.size(); ++i) {
                                    JsonObject collateralItemElement = array.get(i - 1).getAsJsonObject();
                                    String collateralJson = this.fromApiJsonHelper.toJson((JsonElement)collateralItemElement);
                                    this.fromApiJsonHelper.checkForUnsupportedParameters(collateralParameterTypeOfMap, collateralJson, supportedParameters);
                                    Long id = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)collateralItemElement);
                                    baseDataValidator.reset().parameter("collateral").parameterAtIndexArray("id", Integer.valueOf(i)).value((Object)id).ignoreIfNull();
                                    Long clientCollateralId = this.fromApiJsonHelper.extractLongNamed("clientCollateralId", (JsonElement)collateralItemElement);
                                    baseDataValidator.reset().parameter("collateral").parameterAtIndexArray("clientCollateralId", Integer.valueOf(i)).value((Object)clientCollateralId).notNull().integerGreaterThanZero();
                                    BigDecimal quantity = this.fromApiJsonHelper.extractBigDecimalNamed("quantity", (JsonElement)collateralItemElement, locale);
                                    baseDataValidator.reset().parameter("collateral").parameterAtIndexArray("quantity", Integer.valueOf(i)).value((Object)quantity).notNull().positiveAmount();
                                    if (clientCollateralId == null && quantity == null) continue;
                                    BigDecimal baseAmount = this.clientCollateralManagementRepositoryWrapper.getCollateral(clientCollateralId).getCollaterals().getBasePrice();
                                    BigDecimal pctToBase = this.clientCollateralManagementRepositoryWrapper.getCollateral(clientCollateralId).getCollaterals().getPctToBase();
                                    BigDecimal total = baseAmount.multiply(pctToBase).multiply(quantity);
                                    totalAmount = totalAmount.add(total);
                                }
                                if (principal != null && principal.compareTo(totalAmount) > 0) {
                                    throw new InvalidAmountOfCollaterals(totalAmount);
                                }
                            }
                        } else {
                            baseDataValidator.reset().parameter("collateral").expectedArrayButIsNot();
                        }
                    }
                }
            }
            boolean meetingIdRequired = false;
            if (this.fromApiJsonHelper.parameterExists("syncDisbursementWithMeeting", element)) {
                Boolean syncDisbursement = this.fromApiJsonHelper.extractBooleanNamed("syncDisbursementWithMeeting", element);
                if (syncDisbursement == null) {
                    baseDataValidator.reset().parameter("syncDisbursementWithMeeting").value((Object)syncDisbursement).trueOrFalseRequired((Object)false);
                } else if (syncDisbursement.booleanValue()) {
                    meetingIdRequired = true;
                }
            }
            if (meetingIdRequired || this.fromApiJsonHelper.parameterExists("calendarId", element)) {
                Long calendarId = this.fromApiJsonHelper.extractLongNamed("calendarId", element);
                baseDataValidator.reset().parameter("calendarId").value((Object)calendarId).notNull().integerGreaterThanZero();
            }
            if (!atLeastOneParameterPassedForUpdate) {
                Object forceError = null;
                baseDataValidator.reset().anyOfNotNull(new Object[]{forceError});
            }
            if (this.fromApiJsonHelper.parameterExists("fixedEmiAmount", element)) {
                if (!loanProduct.isCanDefineInstallmentAmount() && !loanProduct.isMultiDisburseLoan()) {
                    ArrayList<String> unsupportedParameterList = new ArrayList<String>();
                    unsupportedParameterList.add("fixedEmiAmount");
                    throw new UnsupportedParameterException(unsupportedParameterList);
                }
                if (isEqualAmortization) {
                    throw new EqualAmortizationUnsupportedFeatureException("fixed.emi", "fixed emi");
                }
                BigDecimal emiAnount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedEmiAmount", element);
                baseDataValidator.reset().parameter("fixedEmiAmount").value((Object)emiAnount).ignoreIfNull().positiveAmount();
            }
            if (this.fromApiJsonHelper.parameterExists("maxOutstandingLoanBalance", element)) {
                BigDecimal maxOutstandingBalance = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("maxOutstandingLoanBalance", element);
                baseDataValidator.reset().parameter("maxOutstandingLoanBalance").value((Object)maxOutstandingBalance).ignoreIfNull().positiveAmount();
            }
            if (loanProduct.isCanUseForTopup() && this.fromApiJsonHelper.parameterExists("isTopup", element)) {
                Boolean isTopup = this.fromApiJsonHelper.extractBooleanNamed("isTopup", element);
                baseDataValidator.reset().parameter("isTopup").value((Object)isTopup).ignoreIfNull().validateForBooleanValue();
                if (isTopup != null && isTopup.booleanValue()) {
                    BigDecimal firstDisbursalAmount;
                    Long loanIdToClose;
                    Loan loanToClose;
                    Long loanId = this.fromApiJsonHelper.extractLongNamed("loanIdToClose", element);
                    baseDataValidator.reset().parameter("loanIdToClose").value((Object)loanId).notNull().longGreaterThanZero();
                    LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
                    if (submittedOnDate == null) {
                        submittedOnDate = loan.getSubmittedOnDate();
                    }
                    if ((loanToClose = this.loanRepositoryWrapper.findNonClosedLoanThatBelongsToClient(loanIdToClose = command.longValueOfParameterNamed("loanIdToClose"), clientId)) == null) {
                        throw new GeneralPlatformDomainRuleException("error.msg.loan.loanIdToClose.no.active.loan.associated.to.client.found", "loanIdToClose is invalid, No Active Loan associated with the given Client ID found.", new Object[0]);
                    }
                    if (loanToClose.isMultiDisburmentLoan() && !loanToClose.getLoanProductRelatedDetail().isInterestRecalculationEnabled()) {
                        throw new GeneralPlatformDomainRuleException("error.msg.loan.topup.on.multi.tranche.loan.without.interest.recalculation.not.supported", "Topup on loan with multi-tranche disbursal and without interest recalculation is not supported.", new Object[0]);
                    }
                    LocalDate disbursalDateOfLoanToClose = loanToClose.getDisbursementDate();
                    if (!DateUtils.isAfter((LocalDate)submittedOnDate, (LocalDate)disbursalDateOfLoanToClose)) {
                        throw new GeneralPlatformDomainRuleException("error.msg.loan.submitted.date.should.be.after.topup.loan.disbursal.date", "Submitted date of this loan application " + String.valueOf(submittedOnDate) + " should be after the disbursed date of loan to be closed " + String.valueOf(disbursalDateOfLoanToClose), new Object[0]);
                    }
                    if (!loanToClose.getCurrencyCode().equals(loanProduct.getCurrency().getCode())) {
                        throw new GeneralPlatformDomainRuleException("error.msg.loan.to.be.closed.has.different.currency", "loanIdToClose is invalid, Currency code is different.", new Object[0]);
                    }
                    LocalDate lastUserTransactionOnLoanToClose = loanToClose.getLastUserTransactionDate();
                    if (DateUtils.isBefore((LocalDate)expectedDisbursementDate, (LocalDate)lastUserTransactionOnLoanToClose)) {
                        throw new GeneralPlatformDomainRuleException("error.msg.loan.disbursal.date.should.be.after.last.transaction.date.of.loan.to.be.closed", "Disbursal date of this loan application " + String.valueOf(expectedDisbursementDate) + " should be after last transaction date of loan to be closed " + String.valueOf(lastUserTransactionOnLoanToClose), new Object[0]);
                    }
                    BigDecimal loanOutstanding = this.loanReadPlatformService.retrieveLoanPrePaymentTemplate(LoanTransactionType.REPAYMENT, loanIdToClose, expectedDisbursementDate).getAmount();
                    if (loanOutstanding.compareTo(firstDisbursalAmount = this.getFirstDisbursalAmount(loan)) > 0) {
                        throw new GeneralPlatformDomainRuleException("error.msg.loan.amount.less.than.outstanding.of.loan.to.be.closed", "Topup loan amount should be greater than outstanding amount of loan to be closed.", new Object[0]);
                    }
                }
            }
            this.validateLoanMultiDisbursementDate(element, baseDataValidator, expectedDisbursementDate, principal);
            this.validatePartialPeriodSupport(interestCalculationPeriodType, baseDataValidator, element, loanProduct);
            String loanScheduleProcessingType = loan.getLoanRepaymentScheduleDetail().getLoanScheduleProcessingType().name();
            if (this.fromApiJsonHelper.parameterExists("loanScheduleProcessingType", element)) {
                loanScheduleProcessingType = this.fromApiJsonHelper.extractStringNamed("loanScheduleProcessingType", element);
                baseDataValidator.reset().parameter("loanScheduleProcessingType").value((Object)loanScheduleProcessingType).ignoreIfNull().isOneOfEnumValues(LoanScheduleProcessingType.class);
            }
            if (LoanScheduleProcessingType.VERTICAL.equals((Object)LoanScheduleProcessingType.valueOf((String)loanScheduleProcessingType)) && !"advanced-payment-allocation-strategy".equals(transactionProcessingStrategy)) {
                baseDataValidator.reset().parameter("loanScheduleProcessingType").failWithCode("supported.only.with.advanced.payment.allocation.strategy", new Object[]{"Vertical repayment schedule processing is only available with `Advanced payment allocation` strategy"});
            }
            List allocationRules = loanProduct.getPaymentAllocationRules();
            if (LoanScheduleProcessingType.HORIZONTAL.name().equals(loanScheduleProcessingType) && "advanced-payment-allocation-strategy".equals(transactionProcessingStrategy)) {
                this.advancedPaymentAllocationsValidator.checkGroupingOfAllocationRules(allocationRules);
            }
            if (this.fromApiJsonHelper.parameterExists("enableInstallmentLevelDelinquency", element)) {
                Boolean isEnableInstallmentLevelDelinquency = this.fromApiJsonHelper.extractBooleanNamed("enableInstallmentLevelDelinquency", element);
                baseDataValidator.reset().parameter("enableInstallmentLevelDelinquency").value((Object)isEnableInstallmentLevelDelinquency).validateForBooleanValue();
                if (loanProduct.getDelinquencyBucket() == null && isEnableInstallmentLevelDelinquency.booleanValue()) {
                    baseDataValidator.reset().parameter("enableInstallmentLevelDelinquency").failWithCode("can.be.enabled.for.loan.with.loan.product.having.valid.delinquency.bucket", new Object[]{"Installment level delinquency cannot be enabled for a loan if Delinquency bucket is not configured for loan product"});
                }
            }
            this.loanScheduleValidator.validateDownPaymentAttribute(loanProduct.getLoanProductRelatedDetail().isEnableDownPayment(), element);
            this.validateDisbursementDetails(loanProduct, element);
            this.validateSubmittedOnDate(element, loan.getSubmittedOnDate(), loan.getExpectedDisbursementDate(), loanProduct);
            this.validateClientOrGroup(client, group, productId);
            this.validateDisbursementDateIsOnNonWorkingDay(expectedDisbursementDate);
            Long officeId = this.resolveOfficeId(client, group);
            this.validateDisbursementDateIsOnHoliday(expectedDisbursementDate, officeId);
            Integer recurringMoratoriumOnPrincipalPeriods = loan.getLoanProductRelatedDetail().getRecurringMoratoriumOnPrincipalPeriods();
            if (this.fromApiJsonHelper.parameterExists("recurringMoratoriumOnPrincipalPeriods", element)) {
                recurringMoratoriumOnPrincipalPeriods = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("recurringMoratoriumOnPrincipalPeriods", element);
            }
            this.validateBorrowerCycle(element, loanProduct, clientId, groupId, baseDataValidator);
            this.loanProductDataValidator.validateRepaymentPeriodWithGraceSettings(numberOfRepayments, graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, recurringMoratoriumOnPrincipalPeriods, baseDataValidator);
            if (this.fromApiJsonHelper.parameterExists("interestRecognitionOnDisbursementDate", element) && !LoanScheduleType.PROGRESSIVE.equals((Object)loanProduct.getLoanProductRelatedDetail().getLoanScheduleType())) {
                ArrayList<String> unsupportedParameterList = new ArrayList<String>();
                unsupportedParameterList.add("interestRecognitionOnDisbursementDate");
                throw new UnsupportedParameterException(unsupportedParameterList);
            }
        });
    }

    private void validateClientOrGroup(Client client, Group group, Long productId) {
        Validator.validateOrThrow((String)"loan", baseDataValidator -> {
            if (client == null && group == null) {
                baseDataValidator.reset().parameter("clientId").value((Object)client).notNull();
            } else {
                if (client != null) {
                    this.officeSpecificLoanProductValidation(productId, (Long)client.getOffice().getId());
                    if (client.isNotActive()) {
                        throw new ClientNotActiveException((Long)client.getId());
                    }
                }
                if (group != null) {
                    this.officeSpecificLoanProductValidation(productId, (Long)group.getOffice().getId());
                    if (group.isNotActive()) {
                        throw new GroupNotActiveException((Long)group.getId());
                    }
                }
                if (client != null && group != null && !group.hasClientAsMember(client)) {
                    throw new ClientNotInGroupException((Long)client.getId(), (Long)group.getId());
                }
            }
        });
    }

    private void validateDisbursementDetails(LoanProduct loanProduct, JsonElement element) {
        if (loanProduct.isMultiDisburseLoan()) {
            int disbursementDataSize;
            JsonArray disbursementDataArray = this.fromApiJsonHelper.extractJsonArrayNamed("disbursementData", element);
            int n = disbursementDataSize = disbursementDataArray != null ? disbursementDataArray.size() : 0;
            if (loanProduct.isDisallowExpectedDisbursements()) {
                if (disbursementDataSize > 0) {
                    String errorMessage = "For this loan product, disbursement details are not allowed";
                    throw new MultiDisbursementDataNotAllowedException("disbursementData", "For this loan product, disbursement details are not allowed", new Object[0]);
                }
            } else if (disbursementDataSize == 0) {
                String errorMessage = "For this loan product, disbursement details must be provided";
                throw new MultiDisbursementDataRequiredException("disbursementData", "For this loan product, disbursement details must be provided", new Object[0]);
            }
            if (disbursementDataSize > loanProduct.maxTrancheCount()) {
                String errorMessage = "Number of tranche shouldn't be greater than " + loanProduct.maxTrancheCount();
                throw new ExceedingTrancheCountException("disbursementData", errorMessage, new Object[]{loanProduct.maxTrancheCount(), disbursementDataSize});
            }
        }
    }

    public void validateForUndo(String json) {
        LoanApplicationValidator.validateRequestBody((String)json);
        HashSet<String> undoSupportedParameters = new HashSet<String>(List.of("note"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, undoSupportedParameters);
        Validator.validateOrThrow((String)"loanapplication.undo", baseDataValidator -> {
            JsonElement element = this.fromApiJsonHelper.parse(json);
            String note = "note";
            if (this.fromApiJsonHelper.parameterExists("note", element)) {
                String noteText = this.fromApiJsonHelper.extractStringNamed("note", element);
                baseDataValidator.reset().parameter("note").value((Object)noteText).notExceedingLengthOf(Integer.valueOf(1000));
            }
        });
    }

    public void validateMinMaxConstraintValues(JsonElement element, LoanProduct loanProduct) {
        Validator.validateOrThrow((String)"loan", baseDataValidator -> {
            BigDecimal minPrincipal = loanProduct.getMinPrincipalAmount().getAmount();
            BigDecimal maxPrincipal = loanProduct.getMaxPrincipalAmount().getAmount();
            String principalParameterName = "principal";
            if (this.fromApiJsonHelper.parameterExists("principal", element)) {
                BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("principal", element);
                baseDataValidator.reset().parameter("principal").value((Object)principal).notNull().positiveAmount().inMinAndMaxAmountRange(minPrincipal, maxPrincipal);
            }
        });
    }

    private void validateLoanTermAndRepaidEveryValues(Integer loanTermFrequency, Integer loanTermFrequencyType, Integer numberOfRepayments, Integer repaymentEvery, Integer repaymentEveryType, Loan loan) {
        ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
        this.loanScheduleValidator.validateSelectedPeriodFrequencyTypeIsTheSame(dataValidationErrors, loanTermFrequency, loanTermFrequencyType, numberOfRepayments, repaymentEvery, repaymentEveryType);
        if (loan.getFixedEmiAmount() != null) {
            ApiParameterError error;
            Integer minimumNoOfRepayments = loan.loanProduct().getMinNumberOfRepayments();
            Integer maximumNoOfRepayments = loan.loanProduct().getMaxNumberOfRepayments();
            Integer actualNumberOfRepayments = loan.getLoanRepaymentScheduleInstallmentsSize();
            if (minimumNoOfRepayments != null && minimumNoOfRepayments != 0 && actualNumberOfRepayments < minimumNoOfRepayments) {
                error = ApiParameterError.generalError((String)"validation.msg.loan.numberOfRepayments.lesser.than.minimumNumberOfRepayments", (String)("The total number of calculated repayments for this loan " + actualNumberOfRepayments + " is lesser than the allowed minimum of " + minimumNoOfRepayments), (Object[])new Object[]{actualNumberOfRepayments, minimumNoOfRepayments});
                dataValidationErrors.add(error);
            }
            if (maximumNoOfRepayments != null && maximumNoOfRepayments != 0 && actualNumberOfRepayments > maximumNoOfRepayments) {
                error = ApiParameterError.generalError((String)"validation.msg.loan.numberOfRepayments.greater.than.maximumNumberOfRepayments", (String)("The total number of calculated repayments for this loan " + actualNumberOfRepayments + " is greater than the allowed maximum of " + maximumNoOfRepayments), (Object[])new Object[]{actualNumberOfRepayments, maximumNoOfRepayments});
                dataValidationErrors.add(error);
            }
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public void validateLinkedSavingsAccount(JsonElement element, DataValidatorBuilder baseDataValidator) {
        Long linkedAccountId = this.fromApiJsonHelper.extractLongNamed("linkAccountId", element);
        if (linkedAccountId != null) {
            baseDataValidator.reset().parameter("linkAccountId").value((Object)linkedAccountId).ignoreIfNull().longGreaterThanZero();
            SavingsAccount savingsAccount = this.savingsAccountRepository.findOneWithNotFoundDetection(linkedAccountId);
            Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
            if (savingsAccount.isNotActive()) {
                ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.loan.linked.savings.account.is.not.active", (String)("Linked Savings account with id:" + String.valueOf(savingsAccount.getId()) + " is not in active state"), (String)"linkAccountId", (Object[])new Object[]{savingsAccount.getId()});
                baseDataValidator.getDataValidationErrors().add(error);
            } else if (!clientId.equals(savingsAccount.clientId())) {
                ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.loan.linked.savings.account.not.belongs.to.same.client", (String)("Linked Savings account with id:" + String.valueOf(savingsAccount.getId()) + " is not belongs to the same client"), (String)"linkAccountId", (Object[])new Object[]{savingsAccount.getId()});
                baseDataValidator.getDataValidationErrors().add(error);
            }
        }
    }

    private void validateDisbursementsAreDatewiseOrdered(JsonElement element, DataValidatorBuilder baseDataValidator) {
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        String dateFormat = this.fromApiJsonHelper.extractDateFormatParameter(topLevelJsonElement);
        JsonArray variationArray = this.fromApiJsonHelper.extractJsonArrayNamed("disbursementData", element);
        if (variationArray != null) {
            for (int i = 0; i < variationArray.size(); ++i) {
                JsonObject jsonObject1 = variationArray.get(i).getAsJsonObject();
                if (!jsonObject1.has("expectedDisbursementDate")) continue;
                LocalDate date1 = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", (JsonElement)jsonObject1, dateFormat, locale);
                for (int j = i + 1; j < variationArray.size(); ++j) {
                    LocalDate date2;
                    JsonObject jsonObject2 = variationArray.get(j).getAsJsonObject();
                    if (!jsonObject2.has("expectedDisbursementDate") || !DateUtils.isAfter((LocalDate)date1, (LocalDate)(date2 = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", (JsonElement)jsonObject2, dateFormat, locale)))) continue;
                    baseDataValidator.reset().parameter("disbursementData").failWithCode("disbursements.should.be.ordered.based.on.their.disbursement.dates", new Object[0]);
                }
            }
        }
    }

    public void validateLoanMultiDisbursementDate(JsonElement element, LocalDate expectedDisbursementDate, BigDecimal principal, Loan loan) {
        Validator.validateOrThrow((String)"loan", baseDataValidator -> this.validateLoanMultiDisbursementDate(element, baseDataValidator, expectedDisbursementDate, principal, loan));
    }

    public void validateLoanMultiDisbursementDate(JsonElement element, DataValidatorBuilder baseDataValidator, LocalDate expectedDisbursement, BigDecimal totalPrincipal) {
        this.validateLoanMultiDisbursementDate(element, baseDataValidator, expectedDisbursement, totalPrincipal, null);
    }

    public void validateLoanMultiDisbursementDate(JsonElement element, DataValidatorBuilder baseDataValidator, LocalDate expectedDisbursement, BigDecimal totalPrincipal, Loan loan) {
        this.validateDisbursementsAreDatewiseOrdered(element, baseDataValidator);
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        String dateFormat = this.fromApiJsonHelper.extractDateFormatParameter(topLevelJsonElement);
        if (this.fromApiJsonHelper.parameterExists("disbursementData", element) && expectedDisbursement != null && totalPrincipal != null) {
            BigDecimal tatalDisbursement = BigDecimal.ZERO;
            JsonArray variationArray = this.fromApiJsonHelper.extractJsonArrayNamed("disbursementData", element);
            ArrayList<LocalDate> expectedDisbursementDates = new ArrayList<LocalDate>();
            if (variationArray != null && !variationArray.isEmpty()) {
                boolean isEqualAmortization;
                if (this.fromApiJsonHelper.parameterExists("isEqualAmortization", element) && (isEqualAmortization = this.fromApiJsonHelper.extractBooleanNamed("isEqualAmortization", element).booleanValue())) {
                    throw new EqualAmortizationUnsupportedFeatureException("tranche.disbursal", "tranche disbursal");
                }
                int i = 0;
                do {
                    JsonObject jsonObject = variationArray.get(i).getAsJsonObject();
                    LocalDate expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", (JsonElement)jsonObject, dateFormat, locale);
                    baseDataValidator.reset().parameter("disbursementData").parameterAtIndexArray("expectedDisbursementDate", Integer.valueOf(i)).value((Object)expectedDisbursementDate).notNull();
                    if (i == 0 && expectedDisbursementDate != null && !expectedDisbursement.equals(expectedDisbursementDate)) {
                        baseDataValidator.reset().parameter("expectedDisbursementDate").failWithCode("first.disbursement.date.must.start.with.expected.disbursement.date", new Object[0]);
                    } else if (i > 0 && expectedDisbursementDate != null && DateUtils.isBefore((LocalDate)expectedDisbursementDate, (LocalDate)expectedDisbursement)) {
                        baseDataValidator.reset().parameter("disbursementData").failWithCode("disbursement.date.of.tranche.cannot.be.before.expected.disbursement.date", new Object[0]);
                    }
                    if (expectedDisbursementDate != null && expectedDisbursementDates.contains(expectedDisbursementDate)) {
                        baseDataValidator.reset().parameter("expectedDisbursementDate").failWithCode("disbursement.date.must.be.unique.for.tranches", new Object[0]);
                    }
                    expectedDisbursementDates.add(expectedDisbursementDate);
                    BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalNamed("principal", (JsonElement)jsonObject, locale);
                    baseDataValidator.reset().parameter("disbursementData").parameterAtIndexArray("principal", Integer.valueOf(i)).value((Object)principal).notBlank();
                    if (principal == null) continue;
                    tatalDisbursement = tatalDisbursement.add(principal);
                } while (++i < variationArray.size());
                if (tatalDisbursement.compareTo(totalPrincipal) > 0) {
                    baseDataValidator.reset().parameter("principal").failWithCode("sum.of.multi.disburse.amounts.must.be.equal.to.or.lesser.than.approved.principal", new Object[0]);
                }
                if (loan == null) {
                    String transactionProcessingStrategyCode = this.fromApiJsonHelper.extractStringNamed("transactionProcessingStrategyCode", element);
                    if (transactionProcessingStrategyCode != null) {
                        Integer interestType = this.fromApiJsonHelper.extractIntegerNamed("interestType", element, Locale.getDefault());
                        String processorCode = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(transactionProcessingStrategyCode).getCode();
                        boolean isProgressive = "advanced-payment-allocation-strategy".equals(processorCode);
                        if (isProgressive) {
                            baseDataValidator.reset().parameter("interestType").value((Object)interestType).ignoreIfNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(1));
                        } else {
                            baseDataValidator.reset().parameter("interestType").value((Object)interestType).ignoreIfNull().integerSameAsNumber(InterestMethod.DECLINING_BALANCE.getValue());
                        }
                    }
                } else if (loan.isCumulativeSchedule()) {
                    baseDataValidator.reset().parameter("interestType").value((Object)loan.getLoanProductRelatedDetail().getInterestMethod()).ignoreIfNull().value((Object)InterestMethod.DECLINING_BALANCE);
                }
            }
        }
    }

    public void validateLoanForCollaterals(Loan loan, BigDecimal total) {
        Validator.validateOrThrow((String)"loan", baseDataValidator -> {
            if (loan.getProposedPrincipal().compareTo(total) >= 0) {
                String errorCode = "sum.of.multi.collateral.values.must.equal.or.greater.than.principal.amount";
                baseDataValidator.reset().parameter("collaterals").failWithCode(errorCode, new Object[0]);
            }
        });
    }

    private void validatePartialPeriodSupport(Integer interestCalculationPeriodType, DataValidatorBuilder baseDataValidator, JsonElement element, LoanProduct loanProduct) {
        if (interestCalculationPeriodType != null) {
            boolean considerPartialPeriodUpdates;
            InterestCalculationPeriodMethod interestCalculationPeriodMethod = InterestCalculationPeriodMethod.fromInt((Integer)interestCalculationPeriodType);
            boolean bl = considerPartialPeriodUpdates = interestCalculationPeriodMethod.isDaily() ? interestCalculationPeriodMethod.isDaily() : loanProduct.getLoanProductRelatedDetail().isAllowPartialPeriodInterestCalculation();
            if (this.fromApiJsonHelper.parameterExists("allowPartialPeriodInterestCalcualtion", element)) {
                boolean considerPartialPeriods;
                Boolean considerPartialInterestEnabled = this.fromApiJsonHelper.extractBooleanNamed("allowPartialPeriodInterestCalcualtion", element);
                baseDataValidator.reset().parameter("allowPartialPeriodInterestCalcualtion").value((Object)considerPartialInterestEnabled).notNull().isOneOfTheseValues(new Object[]{true, false});
                boolean bl2 = considerPartialPeriods = considerPartialInterestEnabled != null && considerPartialInterestEnabled != false;
                if (interestCalculationPeriodMethod.isDaily()) {
                    if (considerPartialPeriods) {
                        baseDataValidator.reset().parameter("allowPartialPeriodInterestCalcualtion").failWithCode("not.supported.for.daily.calcualtions", new Object[0]);
                    }
                } else {
                    considerPartialPeriodUpdates = considerPartialPeriods;
                }
            }
            if (!considerPartialPeriodUpdates) {
                if (loanProduct.isInterestRecalculationEnabled()) {
                    baseDataValidator.reset().parameter("isInterestRecalculationEnabled").failWithCode("not.supported.for.selected.interest.calcualtion.type", new Object[0]);
                }
                if (loanProduct.isMultiDisburseLoan() && !"advanced-payment-allocation-strategy".equals(loanProduct.getTransactionProcessingStrategyCode())) {
                    baseDataValidator.reset().parameter("multiDisburseLoan").failWithCode("not.supported.for.selected.interest.calcualtion.type", new Object[0]);
                }
                if (loanProduct.isAllowVariabeInstallments()) {
                    baseDataValidator.reset().parameter("allowVariableInstallments").failWithCode("not.supported.for.selected.interest.calcualtion.type", new Object[0]);
                }
                if (loanProduct.isLinkedToFloatingInterestRate()) {
                    baseDataValidator.reset().parameter("isLinkedToFloatingInterestRates").failWithCode("not.supported.for.selected.interest.calcualtion.type", new Object[0]);
                }
            }
        }
    }

    private void officeSpecificLoanProductValidation(Long productId, Long officeId) {
        FineractEntityRelation fineractEntityRelation;
        FineractEntityToEntityMapping officeToLoanProductMappingList;
        GlobalConfigurationProperty restrictToUserOfficeProperty = this.globalConfigurationRepository.findOneByNameWithNotFoundDetection("office-specific-products-enabled");
        if (restrictToUserOfficeProperty.isEnabled() && (officeToLoanProductMappingList = this.entityMappingRepository.findListByProductId(fineractEntityRelation = this.fineractEntityRelationRepository.findOneByCodeName(FineractEntityAccessType.OFFICE_ACCESS_TO_LOAN_PRODUCTS.getStr()), productId, officeId)) == null) {
            throw new NotOfficeSpecificProductException(productId, officeId);
        }
    }

    private void validateTransactionProcessingStrategy(String transactionProcessingStrategy, LoanProduct loanProduct) {
        if (!"advanced-payment-allocation-strategy".equals(loanProduct.getTransactionProcessingStrategyCode()) && "advanced-payment-allocation-strategy".equals(transactionProcessingStrategy)) {
            throw new GeneralPlatformDomainRuleException("strategy.cannot.be.advanced.payment.allocation.if.not.configured", "Loan transaction processing strategy cannot be Advanced Payment Allocation Strategy if it's not configured on loan product", new Object[0]);
        }
        if (LoanScheduleType.PROGRESSIVE.equals((Object)loanProduct.getLoanProductRelatedDetail().getLoanScheduleType())) {
            if (!"advanced-payment-allocation-strategy".equals(transactionProcessingStrategy)) {
                throw new GeneralPlatformDomainRuleException("error.msg.loan.repayment.strategy.can.not.be.different.than.advanced.payment.allocation", "Loan repayment strategy can not be different than Advanced Payment Allocation", new Object[0]);
            }
        } else if (LoanScheduleType.CUMULATIVE.equals((Object)loanProduct.getLoanProductRelatedDetail().getLoanScheduleType()) && "advanced-payment-allocation-strategy".equals(transactionProcessingStrategy)) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.repayment.strategy.can.not.be.equal.to.advanced.payment.allocation", "Loan repayment strategy can not be equal to Advanced Payment Allocation", new Object[0]);
        }
        this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(transactionProcessingStrategy);
    }

    public void checkForProductMixRestrictions(JsonElement element) {
        Long productId = this.fromApiJsonHelper.extractLongNamed("productId", element);
        Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        List activeLoansLoanProductIds = groupId != null ? this.loanRepositoryWrapper.findActiveLoansLoanProductIdsByGroup(groupId, LoanStatus.ACTIVE) : this.loanRepositoryWrapper.findActiveLoansLoanProductIdsByClient(clientId, LoanStatus.ACTIVE);
        this.checkForProductMixRestrictions(activeLoansLoanProductIds, productId);
    }

    private void checkForProductMixRestrictions(List<Long> activeLoansLoanProductIds, Long productId) {
        if (!CollectionUtils.isEmpty(activeLoansLoanProductIds)) {
            Collection restrictedProductsList = this.loanProductReadPlatformService.retrieveRestrictedProductsForMix(productId);
            for (LoanProductData restrictedProduct : restrictedProductsList) {
                if (!activeLoansLoanProductIds.contains(restrictedProduct.getId())) continue;
                throw new GeneralPlatformDomainRuleException("error.msg.loan.applied.or.to.be.disbursed.can.not.co-exist.with.the.loan.already.active.to.this.client", "This loan could not be applied/disbursed as the loan and `" + restrictedProduct.getName() + "` are not allowed to co-exist", new Object[0]);
            }
        }
    }

    private void validateSubmittedOnDate(JsonElement element, LocalDate originalSubmittedOnDate, LocalDate originalExpectedDisbursementDate, LoanProduct loanProduct) {
        Group group;
        LocalDate expectedDisbursementDate;
        LocalDate startDate = loanProduct.getStartDate();
        LocalDate closeDate = loanProduct.getCloseDate();
        LocalDate submittedOnDate = this.fromApiJsonHelper.parameterExists("submittedOnDate", element) ? this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element) : originalSubmittedOnDate;
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
        LocalDate localDate = expectedDisbursementDate = this.fromApiJsonHelper.parameterExists("expectedDisbursementDate", element) ? this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", element) : originalExpectedDisbursementDate;
        if (DateUtils.isBefore((LocalDate)submittedOnDate, (LocalDate)startDate)) {
            String defaultUserMessage = "submittedOnDate cannot be before the loan product startDate.";
            throw new LoanApplicationDateException("submitted.on.date.cannot.be.before.the.loan.product.start.date", defaultUserMessage, new Object[]{submittedOnDate.toString(), startDate.toString()});
        }
        if (closeDate != null && DateUtils.isAfter((LocalDate)submittedOnDate, (LocalDate)closeDate)) {
            String defaultUserMessage = "submittedOnDate cannot be after the loan product closeDate.";
            throw new LoanApplicationDateException("submitted.on.date.cannot.be.after.the.loan.product.close.date", defaultUserMessage, new Object[]{submittedOnDate.toString(), closeDate.toString()});
        }
        if (DateUtils.isDateInTheFuture((LocalDate)submittedOnDate)) {
            String errorMessage = "The date on which a loan is submitted cannot be in the future.";
            throw new InvalidLoanStateTransitionException("submittal", "cannot.be.a.future.date", "The date on which a loan is submitted cannot be in the future.", new Object[]{submittedOnDate, DateUtils.getBusinessLocalDate()});
        }
        if (clientId != null) {
            Client client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            if (client != null && client.isActivatedAfter(submittedOnDate)) {
                String errorMessage = "The date on which a loan is submitted cannot be earlier than client's activation date.";
                throw new InvalidLoanStateTransitionException("submittal", "cannot.be.before.client.activation.date", "The date on which a loan is submitted cannot be earlier than client's activation date.", new Object[]{submittedOnDate, client.getActivationDate()});
            }
            if (client != null && client.getOfficeJoiningDate() != null && DateUtils.isBefore((LocalDate)submittedOnDate, (LocalDate)client.getOfficeJoiningDate())) {
                throw new InvalidLoanStateTransitionException("submittal", "cannot.be.before.client.transfer.date", "The date on which a loan is submitted cannot be earlier than client's transfer date to this office", new Object[]{client.getOfficeJoiningDate()});
            }
        }
        if (groupId != null && (group = this.groupRepository.findOneWithNotFoundDetection(groupId)) != null && group.isActivatedAfter(submittedOnDate)) {
            String errorMessage = "The date on which a loan is submitted cannot be earlier than group's activation date.";
            throw new InvalidLoanStateTransitionException("submittal", "cannot.be.before.group.activation.date", "The date on which a loan is submitted cannot be earlier than group's activation date.", new Object[]{submittedOnDate, group.getActivationDate()});
        }
        if (DateUtils.isAfter((LocalDate)submittedOnDate, (LocalDate)expectedDisbursementDate)) {
            String errorMessage = "The date on which a loan is submitted cannot be after its expected disbursement date: " + String.valueOf(expectedDisbursementDate);
            throw new InvalidLoanStateTransitionException("submittal", "cannot.be.after.expected.disbursement.date", errorMessage, new Object[]{submittedOnDate, expectedDisbursementDate});
        }
    }

    private static void validateRequestBody(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
    }

    private void validateForSupportedParameters(String json) {
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
    }

    public BigDecimal validateTopupLoan(Loan loan, LocalDate disbursementDate) {
        BigDecimal firstDisbursalAmount;
        Long loanIdToClose = loan.getTopupLoanDetails().getLoanIdToClose();
        Loan loanToClose = this.loanRepositoryWrapper.findNonClosedLoanThatBelongsToClient(loanIdToClose, loan.getClientId());
        if (loanToClose == null) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.to.be.closed.with.topup.is.not.active", "Loan to be closed with this topup is not active.", new Object[0]);
        }
        LocalDate lastUserTransactionOnLoanToClose = loanToClose.getLastUserTransactionDate();
        if (DateUtils.isBefore((LocalDate)loan.getDisbursementDate(), (LocalDate)lastUserTransactionOnLoanToClose)) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.disbursal.date.should.be.after.last.transaction.date.of.loan.to.be.closed", "Disbursal date of this loan application " + String.valueOf(loan.getDisbursementDate()) + " should be after last transaction date of loan to be closed " + String.valueOf(lastUserTransactionOnLoanToClose), new Object[0]);
        }
        BigDecimal loanOutstanding = this.loanReadPlatformService.retrieveLoanPrePaymentTemplate(LoanTransactionType.REPAYMENT, loanIdToClose, disbursementDate).getAmount();
        if (loanOutstanding.compareTo(firstDisbursalAmount = this.getFirstDisbursalAmount(loan)) > 0) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.amount.less.than.outstanding.of.loan.to.be.closed", "Topup loan amount should be greater than outstanding amount of loan to be closed.", new Object[0]);
        }
        return loanOutstanding;
    }

    public void validateApproval(JsonCommand command, Long loanId) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> disbursementParameters = new HashSet<String>(Arrays.asList("loanId", "approvedLoanAmount", "approvedOnDate", "netDisbursalAmount", "note", "locale", "dateFormat", "disbursementData", "expectedDisbursementDate"));
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, disbursementParameters);
        Validator.validateOrThrow((String)"loanapplication", baseDataValidator -> {
            LocalDate clientOfficeJoiningDate;
            Object errorMessage;
            BigDecimal approvedLoanAmount;
            JsonElement element = this.fromApiJsonHelper.parse(json);
            BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("approvedLoanAmount", element);
            baseDataValidator.reset().parameter("approvedLoanAmount").value((Object)principal).ignoreIfNull().positiveAmount();
            BigDecimal netDisbursalAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("netDisbursalAmount", element);
            baseDataValidator.reset().parameter("netDisbursalAmount").value((Object)netDisbursalAmount).ignoreIfNull().positiveAmount();
            LocalDate approvedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("approvedOnDate", element);
            baseDataValidator.reset().parameter("approvedOnDate").value((Object)approvedOnDate).notNull();
            LocalDate expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", element);
            baseDataValidator.reset().parameter("expectedDisbursementDate").value((Object)expectedDisbursementDate).ignoreIfNull();
            String note = this.fromApiJsonHelper.extractStringNamed("note", element);
            baseDataValidator.reset().parameter("note").value((Object)note).notExceedingLengthOf(Integer.valueOf(1000));
            Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
            Client client = loan.client();
            if (client != null && client.isNotActive()) {
                throw new ClientNotActiveException((Long)client.getId());
            }
            Group group = loan.group();
            if (group != null && group.isNotActive()) {
                throw new GroupNotActiveException((Long)group.getId());
            }
            if (expectedDisbursementDate == null) {
                expectedDisbursementDate = loan.getExpectedDisbursedOnLocalDate();
            }
            if (approvedOnDate != null && DateUtils.isBefore((LocalDate)approvedOnDate, (LocalDate)loan.getSubmittedOnDate())) {
                String errorMessage2 = "Loan approval date " + String.valueOf(approvedOnDate) + " can not be before its submittal date: " + String.valueOf(loan.getSubmittedOnDate());
                throw new InvalidLoanStateTransitionException("approval", "cannot.be.before.submittal.date", errorMessage2, new Object[]{approvedOnDate, loan.getSubmittedOnDate()});
            }
            LoanProduct loanProduct = loan.loanProduct();
            if (loanProduct.isMultiDisburseLoan()) {
                int disbursementDataSize;
                this.validateLoanMultiDisbursementDate(element, expectedDisbursementDate, principal, loan);
                JsonArray disbursementDataArray = this.fromApiJsonHelper.extractJsonArrayNamed("disbursementData", element);
                int n = disbursementDataSize = disbursementDataArray != null ? disbursementDataArray.size() : 0;
                if (disbursementDataSize > loanProduct.maxTrancheCount()) {
                    String errorMessage3 = "Number of tranche shouldn't be greater than " + loanProduct.maxTrancheCount();
                    throw new ExceedingTrancheCountException("disbursementData", errorMessage3, new Object[]{loanProduct.maxTrancheCount(), disbursementDataSize});
                }
            }
            int numberOfDays = 0;
            if (loan.isSyncDisbursementWithMeeting() && (loan.isGroupLoan() || loan.isJLGLoan())) {
                Calendar calendar = this.getCalendarInstance(loan);
                boolean isSkipRepaymentOnFirstMonth = this.isLoanRepaymentsSyncWithMeeting(loan, calendar);
                if (isSkipRepaymentOnFirstMonth) {
                    numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
                }
                this.validateDisbursementDateWithMeetingDates(expectedDisbursementDate, calendar, Boolean.valueOf(isSkipRepaymentOnFirstMonth), Integer.valueOf(numberOfDays));
            }
            this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(loanId, EntityTables.LOAN.getName(), StatusEnum.APPROVE.getValue(), EntityTables.LOAN.getForeignKeyColumnNameOnDatatable(), loan.productId().longValue());
            if (loan.isTopup() && loan.getClientId() != null) {
                BigDecimal loanOutstanding = this.validateTopupLoan(loan, expectedDisbursementDate);
                BigDecimal netDisbursalAmountAdjusted = loan.getApprovedPrincipal().subtract(loanOutstanding);
                loan.adjustNetDisbursalAmount(netDisbursalAmountAdjusted);
            }
            if (!loan.getStatus().isSubmittedAndPendingApproval()) {
                String defaultUserMessage = "Loan Account Approval is not allowed. Loan Account is not in submitted and pending approval state.";
                ApiParameterError error = ApiParameterError.generalError((String)"error.msg.loan.approve.account.is.not.submitted.and.pending.state", (String)"Loan Account Approval is not allowed. Loan Account is not in submitted and pending approval state.", (Object[])new Object[0]);
                baseDataValidator.getDataValidationErrors().add(error);
            }
            if ((approvedLoanAmount = command.bigDecimalValueOfParameterNamed("approvedLoanAmount")) != null) {
                this.compareApprovedToProposedPrincipal(loan, approvedLoanAmount);
            }
            if (approvedOnDate != null && expectedDisbursementDate != null && DateUtils.isBefore((LocalDate)expectedDisbursementDate, (LocalDate)approvedOnDate)) {
                errorMessage = "The expected disbursement date " + String.valueOf(expectedDisbursementDate) + " should be either on or after the approval date: " + String.valueOf(approvedOnDate);
                throw new InvalidLoanStateTransitionException("expecteddisbursal", "should.be.on.or.after.approval.date", (String)errorMessage, new Object[]{approvedOnDate, expectedDisbursementDate});
            }
            if (client != null && client.getOfficeJoiningDate() != null && approvedOnDate != null && DateUtils.isBefore((LocalDate)approvedOnDate, (LocalDate)(clientOfficeJoiningDate = client.getOfficeJoiningDate()))) {
                throw new InvalidLoanStateTransitionException("approval", "cannot.be.before.client.transfer.date", "The date on which a loan is approved cannot be earlier than client's transfer date to this office", new Object[]{clientOfficeJoiningDate});
            }
            if (approvedOnDate != null && DateUtils.isDateInTheFuture((LocalDate)approvedOnDate)) {
                errorMessage = "The date on which a loan is approved cannot be in the future.";
                throw new InvalidLoanStateTransitionException("approval", "cannot.be.a.future.date", "The date on which a loan is approved cannot be in the future.", new Object[]{approvedOnDate});
            }
            LoanStatus newStatus = this.loanLifecycleStateMachine.dryTransition(LoanEvent.LOAN_APPROVED, loan);
            if (newStatus.hasStateOf(loan.getStatus())) {
                String defaultUserMessage = "Loan is already approved.";
                ApiParameterError error = ApiParameterError.generalError((String)"error.msg.loan.approve.account.is.not.submitted.and.pending.state", (String)"Loan is already approved.", (Object[])new Object[0]);
                baseDataValidator.getDataValidationErrors().add(error);
            }
        });
    }

    private void compareApprovedToProposedPrincipal(Loan loan, BigDecimal approvedLoanAmount) {
        if (loan.loanProduct().isAllowApprovedDisbursedAmountsOverApplied()) {
            BigDecimal maxApprovedLoanAmount = this.getOverAppliedMax(loan);
            if (approvedLoanAmount.compareTo(maxApprovedLoanAmount) > 0) {
                String errorMessage = "Loan approved amount can't be greater than maximum applied loan amount calculation.";
                throw new InvalidLoanStateTransitionException("approval", "amount.can't.be.greater.than.maximum.applied.loan.amount.calculation", "Loan approved amount can't be greater than maximum applied loan amount calculation.", new Object[]{approvedLoanAmount, maxApprovedLoanAmount});
            }
        } else if (approvedLoanAmount.compareTo(loan.getProposedPrincipal()) > 0) {
            String errorMessage = "Loan approved amount can't be greater than loan amount demanded.";
            throw new InvalidLoanStateTransitionException("approval", "amount.can't.be.greater.than.loan.amount.demanded", "Loan approved amount can't be greater than loan amount demanded.", new Object[]{loan.getProposedPrincipal(), approvedLoanAmount});
        }
    }

    public BigDecimal getOverAppliedMax(Loan loan) {
        LoanProduct loanProduct = loan.getLoanProduct();
        if ("percentage".equals(loanProduct.getOverAppliedCalculationType())) {
            BigDecimal overAppliedNumber = BigDecimal.valueOf(loanProduct.getOverAppliedNumber().intValue());
            BigDecimal totalPercentage = BigDecimal.valueOf(1L).add(overAppliedNumber.divide(BigDecimal.valueOf(100L)));
            return loan.getProposedPrincipal().multiply(totalPercentage);
        }
        return loan.getProposedPrincipal().add(BigDecimal.valueOf(loanProduct.getOverAppliedNumber().intValue()));
    }

    public void validateDisbursementDateWithMeetingDates(LocalDate expectedDisbursementDate, Calendar calendar, Boolean isSkipRepaymentOnFirstMonth, Integer numberOfDays) {
        if (calendar != null && !calendar.isValidRecurringDate(expectedDisbursementDate, isSkipRepaymentOnFirstMonth, numberOfDays)) {
            String errorMessage = "Expected disbursement date '" + String.valueOf(expectedDisbursementDate) + "' do not fall on a meeting date";
            throw new LoanApplicationDateException("disbursement.date.do.not.match.meeting.date", errorMessage, new Object[]{expectedDisbursementDate});
        }
    }

    private static void validateCumulativeMultiDisburse(Loan loan) {
        if (loan.isCumulativeSchedule() && loan.isMultiDisburmentLoan() && loan.getLoanProductRelatedDetail().getInterestMethod().isFlat()) {
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            ApiParameterError error = ApiParameterError.generalError((String)"validation.msg.loan.cumulative.multidisburse.does.not.support.flat.interest.mode", (String)"Cumulative multidisburse loan does NOT support FLAT interest mode.", (Object[])new Object[0]);
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    private Calendar getCalendarInstance(Loan loan) {
        CalendarInstance calendarInstance = this.calendarInstanceRepository.findCalendarInstanceByEntityId((Long)loan.getId(), CalendarEntityType.LOANS.getValue());
        return calendarInstance != null ? calendarInstance.getCalendar() : null;
    }

    private boolean isLoanRepaymentsSyncWithMeeting(Loan loan, Calendar calendar) {
        return this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled() && this.loanUtilService.isLoanRepaymentsSyncWithMeeting(loan.group(), calendar) != false;
    }

    public Long resolveOfficeId(Client client, Group group) {
        if (client != null) {
            return (Long)client.getOffice().getId();
        }
        if (group != null) {
            return (Long)group.getOffice().getId();
        }
        return null;
    }

    private void throwMandatoryParameterError(String parameterName) {
        ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
        dataValidationErrors.add(DataValidatorBuilder.buildValidationParameterApiError((String)"loans", (String)parameterName, (String)".cannot.be.blank", (String)"is mandatory.", (Object[])new Object[]{0}));
        throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
    }

    private BigDecimal getFirstDisbursalAmount(Loan loan) {
        BigDecimal firstDisbursalAmount;
        if (loan.isMultiDisburmentLoan()) {
            List disbursementData = this.loanMapper.getDisbursementData(loan);
            Collections.sort(disbursementData);
            firstDisbursalAmount = ((DisbursementData)disbursementData.get(disbursementData.size() - 1)).getPrincipal();
        } else {
            firstDisbursalAmount = loan.getLoanRepaymentScheduleDetail().getPrincipal().getAmount();
        }
        return firstDisbursalAmount;
    }

    @Generated
    public LoanApplicationValidator(FromJsonHelper fromApiJsonHelper, LoanScheduleValidator loanScheduleValidator, ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper, LoanChargeApiJsonValidator loanChargeApiJsonValidator, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory, AdvancedPaymentAllocationsValidator advancedPaymentAllocationsValidator, ConfigurationDomainService configurationDomainService, LoanProductRepository loanProductRepository, ClientRepositoryWrapper clientRepository, GroupRepositoryWrapper groupRepository, LoanReadPlatformService loanReadPlatformService, LoanProductDataValidator loanProductDataValidator, GlobalConfigurationRepositoryWrapper globalConfigurationRepository, FineractEntityToEntityMappingRepository entityMappingRepository, FineractEntityRelationRepository fineractEntityRelationRepository, LoanRepositoryWrapper loanRepositoryWrapper, LoanProductReadPlatformService loanProductReadPlatformService, LoanCollateralAssembler collateralAssembler, WorkingDaysRepositoryWrapper workingDaysRepository, HolidayRepository holidayRepository, SavingsAccountRepositoryWrapper savingsAccountRepository, LoanLifecycleStateMachine loanLifecycleStateMachine, CalendarInstanceRepository calendarInstanceRepository, LoanUtilService loanUtilService, EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService, LoanMapper loanMapper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.loanScheduleValidator = loanScheduleValidator;
        this.clientCollateralManagementRepositoryWrapper = clientCollateralManagementRepositoryWrapper;
        this.loanChargeApiJsonValidator = loanChargeApiJsonValidator;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
        this.advancedPaymentAllocationsValidator = advancedPaymentAllocationsValidator;
        this.configurationDomainService = configurationDomainService;
        this.loanProductRepository = loanProductRepository;
        this.clientRepository = clientRepository;
        this.groupRepository = groupRepository;
        this.loanReadPlatformService = loanReadPlatformService;
        this.loanProductDataValidator = loanProductDataValidator;
        this.globalConfigurationRepository = globalConfigurationRepository;
        this.entityMappingRepository = entityMappingRepository;
        this.fineractEntityRelationRepository = fineractEntityRelationRepository;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.collateralAssembler = collateralAssembler;
        this.workingDaysRepository = workingDaysRepository;
        this.holidayRepository = holidayRepository;
        this.savingsAccountRepository = savingsAccountRepository;
        this.loanLifecycleStateMachine = loanLifecycleStateMachine;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.loanUtilService = loanUtilService;
        this.entityDatatableChecksWritePlatformService = entityDatatableChecksWritePlatformService;
        this.loanMapper = loanMapper;
    }
}

