/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.portfolio.common.domain.DaysInYearCustomStrategyType;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.AprCalculator;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleProcessingType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanproduct.domain.AmortizationMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestCalculationPeriodMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestMethod;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRelatedDetail;
import org.springframework.stereotype.Service;

@Service
public class LoanProductRelatedDetailUpdateUtil {
    public Map<String, Object> updateLoanRepaymentSchedule(LoanProductRelatedDetail loanRepaymentScheduleDetail, JsonCommand command, AprCalculator aprCalculator) {
        Integer newValue;
        Integer newValue2;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(20);
        String localeAsInput = command.locale();
        String currencyCode = loanRepaymentScheduleDetail.getCurrency().getCode();
        Integer digitsAfterDecimal = loanRepaymentScheduleDetail.getCurrency().getDigitsAfterDecimal();
        Integer inMultiplesOf = loanRepaymentScheduleDetail.getCurrency().getInMultiplesOf();
        String digitsAfterDecimalParamName = "digitsAfterDecimal";
        if (command.isChangeInIntegerParameterNamed("digitsAfterDecimal", digitsAfterDecimal)) {
            Integer newValue3 = command.integerValueOfParameterNamed("digitsAfterDecimal");
            actualChanges.put("digitsAfterDecimal", newValue3);
            actualChanges.put("locale", localeAsInput);
            digitsAfterDecimal = newValue3;
            loanRepaymentScheduleDetail.setCurrency(new MonetaryCurrency(currencyCode, digitsAfterDecimal.intValue(), inMultiplesOf));
        }
        String currencyCodeParamName = "currencyCode";
        if (command.isChangeInStringParameterNamed("currencyCode", currencyCode)) {
            String newValue4 = command.stringValueOfParameterNamed("currencyCode");
            actualChanges.put("currencyCode", newValue4);
            currencyCode = newValue4;
            loanRepaymentScheduleDetail.setCurrency(new MonetaryCurrency(currencyCode, digitsAfterDecimal.intValue(), inMultiplesOf));
        }
        String inMultiplesOfParamName = "inMultiplesOf";
        if (command.isChangeInStringParameterNamed("inMultiplesOf", currencyCode)) {
            Integer newValue5 = command.integerValueOfParameterNamed("inMultiplesOf");
            actualChanges.put("inMultiplesOf", newValue5);
            inMultiplesOf = newValue5;
            loanRepaymentScheduleDetail.setCurrency(new MonetaryCurrency(currencyCode, digitsAfterDecimal.intValue(), inMultiplesOf));
        }
        String loanScheduleTypeParamName = "loanScheduleType";
        if (command.isChangeInStringParameterNamed("loanScheduleType", loanRepaymentScheduleDetail.getLoanScheduleType().toString())) {
            LoanScheduleType newLoanScheduleType = LoanScheduleType.valueOf((String)command.stringValueOfParameterNamed("loanScheduleType"));
            actualChanges.put("loanScheduleType", newLoanScheduleType);
            loanRepaymentScheduleDetail.setLoanScheduleType(newLoanScheduleType);
        }
        String loanScheduleProcessingTypeParamName = "loanScheduleProcessingType";
        if (command.isChangeInStringParameterNamed("loanScheduleProcessingType", loanRepaymentScheduleDetail.getLoanScheduleProcessingType().toString())) {
            LoanScheduleProcessingType newLoanScheduleProcessingType = LoanScheduleProcessingType.valueOf((String)command.stringValueOfParameterNamed("loanScheduleProcessingType"));
            actualChanges.put("loanScheduleProcessingType", newLoanScheduleProcessingType);
            loanRepaymentScheduleDetail.setLoanScheduleProcessingType(newLoanScheduleProcessingType);
        }
        String principalParamName = "principal";
        if (command.isChangeInBigDecimalParameterNamed("principal", loanRepaymentScheduleDetail.getPrincipal().getAmount())) {
            BigDecimal newValue6 = command.bigDecimalValueOfParameterNamed("principal");
            actualChanges.put("principal", newValue6);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setPrincipal(newValue6);
        }
        String repaymentEveryParamName = "repaymentEvery";
        if (command.isChangeInIntegerParameterNamed("repaymentEvery", loanRepaymentScheduleDetail.getRepayEvery())) {
            Integer newValue7 = command.integerValueOfParameterNamed("repaymentEvery");
            actualChanges.put("repaymentEvery", newValue7);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setRepayEvery(newValue7);
        }
        String repaymentFrequencyTypeParamName = "repaymentFrequencyType";
        if (command.isChangeInIntegerParameterNamed("repaymentFrequencyType", loanRepaymentScheduleDetail.getRepaymentPeriodFrequencyType().getValue())) {
            Integer newValue8 = command.integerValueOfParameterNamed("repaymentFrequencyType");
            actualChanges.put("repaymentFrequencyType", newValue8);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setRepaymentPeriodFrequencyType(PeriodFrequencyType.fromInt((Integer)newValue8));
        }
        if (loanRepaymentScheduleDetail.getRepaymentPeriodFrequencyType() == PeriodFrequencyType.MONTHS) {
            String repaymentFrequencyNthDayTypeParamName = "repaymentFrequencyNthDayType";
            newValue2 = command.integerValueOfParameterNamed("repaymentFrequencyNthDayType");
            actualChanges.put("repaymentFrequencyNthDayType", newValue2);
            String repaymentFrequencyDayOfWeekTypeParamName = "repaymentFrequencyDayOfWeekType";
            newValue2 = command.integerValueOfParameterNamed("repaymentFrequencyDayOfWeekType");
            actualChanges.put("repaymentFrequencyDayOfWeekType", newValue2);
            actualChanges.put("locale", localeAsInput);
        }
        String numberOfRepaymentsParamName = "numberOfRepayments";
        if (command.isChangeInIntegerParameterNamed("numberOfRepayments", loanRepaymentScheduleDetail.getNumberOfRepayments())) {
            newValue2 = command.integerValueOfParameterNamed("numberOfRepayments");
            actualChanges.put("numberOfRepayments", newValue2);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setNumberOfRepayments(newValue2);
        }
        String amortizationTypeParamName = "amortizationType";
        if (command.isChangeInIntegerParameterNamed("amortizationType", loanRepaymentScheduleDetail.getAmortizationMethod().getValue())) {
            Integer newValue9 = command.integerValueOfParameterNamed("amortizationType");
            actualChanges.put("amortizationType", newValue9);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setAmortizationMethod(AmortizationMethod.fromInt((Integer)newValue9));
        }
        String inArrearsToleranceParamName = "inArrearsTolerance";
        if (command.isChangeInBigDecimalParameterNamed("inArrearsTolerance", loanRepaymentScheduleDetail.getInArrearsTolerance().getAmount())) {
            BigDecimal newValue10 = command.bigDecimalValueOfParameterNamed("inArrearsTolerance");
            actualChanges.put("inArrearsTolerance", newValue10);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setInArrearsTolerance(newValue10);
        }
        String interestRatePerPeriodParamName = "interestRatePerPeriod";
        if (command.isChangeInBigDecimalParameterNamed("interestRatePerPeriod", loanRepaymentScheduleDetail.getNominalInterestRatePerPeriod())) {
            BigDecimal newValue11 = command.bigDecimalValueOfParameterNamed("interestRatePerPeriod");
            actualChanges.put("interestRatePerPeriod", newValue11);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setNominalInterestRatePerPeriod(newValue11);
            this.updateInterestRateDerivedFields(loanRepaymentScheduleDetail, aprCalculator);
        }
        String interestRateFrequencyTypeParamName = "interestRateFrequencyType";
        int interestPeriodFrequencyType = loanRepaymentScheduleDetail.getInterestPeriodFrequencyType() == null ? PeriodFrequencyType.INVALID.getValue() : loanRepaymentScheduleDetail.getInterestPeriodFrequencyType().getValue();
        if (command.isChangeInIntegerParameterNamed("interestRateFrequencyType", Integer.valueOf(interestPeriodFrequencyType))) {
            Integer newValue12 = command.integerValueOfParameterNamed("interestRateFrequencyType");
            actualChanges.put("interestRateFrequencyType", newValue12);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setInterestPeriodFrequencyType(PeriodFrequencyType.fromInt((Integer)newValue12));
            this.updateInterestRateDerivedFields(loanRepaymentScheduleDetail, aprCalculator);
        }
        String interestTypeParamName = "interestType";
        if (command.isChangeInIntegerParameterNamed("interestType", loanRepaymentScheduleDetail.getInterestMethod().getValue())) {
            Integer newValue13 = command.integerValueOfParameterNamed("interestType");
            actualChanges.put("interestType", newValue13);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setInterestMethod(InterestMethod.fromInt((Integer)newValue13));
        }
        String interestCalculationPeriodTypeParamName = "interestCalculationPeriodType";
        if (command.isChangeInIntegerParameterNamed("interestCalculationPeriodType", loanRepaymentScheduleDetail.getInterestCalculationPeriodMethod().getValue())) {
            Integer newValue14 = command.integerValueOfParameterNamed("interestCalculationPeriodType");
            actualChanges.put("interestCalculationPeriodType", newValue14);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setInterestCalculationPeriodMethod(InterestCalculationPeriodMethod.fromInt((Integer)newValue14));
        }
        if (command.isChangeInBooleanParameterNamed("allowPartialPeriodInterestCalcualtion", Boolean.valueOf(loanRepaymentScheduleDetail.isAllowPartialPeriodInterestCalculation()))) {
            boolean newValue15 = command.booleanPrimitiveValueOfParameterNamed("allowPartialPeriodInterestCalcualtion");
            actualChanges.put("allowPartialPeriodInterestCalcualtion", newValue15);
            loanRepaymentScheduleDetail.setAllowPartialPeriodInterestCalculation(newValue15);
        }
        if (loanRepaymentScheduleDetail.getInterestCalculationPeriodMethod().isDaily()) {
            loanRepaymentScheduleDetail.setAllowPartialPeriodInterestCalculation(false);
        }
        String graceOnPrincipalPaymentParamName = "graceOnPrincipalPayment";
        if (command.isChangeInIntegerParameterNamed("graceOnPrincipalPayment", loanRepaymentScheduleDetail.getGraceOnPrincipalPayment())) {
            Integer newValue16 = command.integerValueOfParameterNamed("graceOnPrincipalPayment");
            actualChanges.put("graceOnPrincipalPayment", newValue16);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setGraceOnPrincipalPayment(newValue16);
        }
        String recurringMoratoriumOnPrincipalPeriodsParamName = "recurringMoratoriumOnPrincipalPeriods";
        if (command.isChangeInIntegerParameterNamed("recurringMoratoriumOnPrincipalPeriods", loanRepaymentScheduleDetail.getRecurringMoratoriumOnPrincipalPeriods())) {
            Integer newValue17 = command.integerValueOfParameterNamed("recurringMoratoriumOnPrincipalPeriods");
            actualChanges.put("recurringMoratoriumOnPrincipalPeriods", newValue17);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setRecurringMoratoriumOnPrincipalPeriods(newValue17);
        }
        String graceOnInterestPaymentParamName = "graceOnInterestPayment";
        if (command.isChangeInIntegerParameterNamed("graceOnInterestPayment", loanRepaymentScheduleDetail.getGraceOnInterestPayment())) {
            Integer newValue18 = command.integerValueOfParameterNamed("graceOnInterestPayment");
            actualChanges.put("graceOnInterestPayment", newValue18);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setGraceOnInterestPayment(newValue18);
        }
        String graceOnInterestChargedParamName = "graceOnInterestCharged";
        if (command.isChangeInIntegerParameterNamed("graceOnInterestCharged", loanRepaymentScheduleDetail.getGraceOnInterestCharged())) {
            newValue = command.integerValueOfParameterNamed("graceOnInterestCharged");
            actualChanges.put("graceOnInterestCharged", newValue);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setGraceOnInterestCharged(newValue);
        }
        if (command.isChangeInIntegerParameterNamed("graceOnArrearsAgeing", loanRepaymentScheduleDetail.getGraceOnArrearsAgeing())) {
            newValue = command.integerValueOfParameterNamed("graceOnArrearsAgeing");
            actualChanges.put("graceOnArrearsAgeing", newValue);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setGraceOnArrearsAgeing(newValue);
        }
        if (command.isChangeInIntegerParameterNamed("daysInMonthType", loanRepaymentScheduleDetail.getDaysInMonthType())) {
            newValue = command.integerValueOfParameterNamed("daysInMonthType");
            actualChanges.put("daysInMonthType", newValue);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setDaysInMonthType(newValue);
        }
        if (command.isChangeInIntegerParameterNamed("daysInYearType", loanRepaymentScheduleDetail.getDaysInYearType())) {
            newValue = command.integerValueOfParameterNamed("daysInYearType");
            actualChanges.put("daysInYearType", newValue);
            actualChanges.put("locale", localeAsInput);
            loanRepaymentScheduleDetail.setDaysInYearType(newValue);
        }
        if (command.parameterExists("daysInYearCustomStrategy")) {
            newValue = DaysInYearCustomStrategyType.valueOf((String)command.stringValueOfParameterNamed("daysInYearCustomStrategy"));
            actualChanges.put("daysInYearCustomStrategy", newValue.name());
            loanRepaymentScheduleDetail.setDaysInYearCustomStrategy((DaysInYearCustomStrategyType)newValue);
        }
        if (command.isChangeInBooleanParameterNamed("isInterestRecalculationEnabled", Boolean.valueOf(loanRepaymentScheduleDetail.isInterestRecalculationEnabled()))) {
            boolean newValue19 = command.booleanPrimitiveValueOfParameterNamed("isInterestRecalculationEnabled");
            actualChanges.put("isInterestRecalculationEnabled", newValue19);
            loanRepaymentScheduleDetail.setInterestRecalculationEnabled(newValue19);
        }
        if (command.isChangeInBooleanParameterNamed("isEqualAmortization", Boolean.valueOf(loanRepaymentScheduleDetail.isEqualAmortization()))) {
            boolean newValue20 = command.booleanPrimitiveValueOfParameterNamed("isEqualAmortization");
            actualChanges.put("isEqualAmortization", newValue20);
            loanRepaymentScheduleDetail.setEqualAmortization(newValue20);
        }
        if (command.isChangeInBooleanParameterNamed("interestRecognitionOnDisbursementDate", Boolean.valueOf(loanRepaymentScheduleDetail.isInterestRecognitionOnDisbursementDate()))) {
            boolean newValue21 = command.booleanPrimitiveValueOfParameterNamed("interestRecognitionOnDisbursementDate");
            actualChanges.put("interestRecognitionOnDisbursementDate", newValue21);
            loanRepaymentScheduleDetail.updateInterestRecognitionOnDisbursementDate(newValue21);
        }
        if (command.isChangeInBooleanParameterNamed("enableIncomeCapitalization", Boolean.valueOf(loanRepaymentScheduleDetail.isEnableIncomeCapitalization()))) {
            boolean newValue22 = command.booleanPrimitiveValueOfParameterNamed("enableIncomeCapitalization");
            actualChanges.put("enableIncomeCapitalization", newValue22);
            loanRepaymentScheduleDetail.setEnableIncomeCapitalization(newValue22);
        }
        if (command.parameterExists("capitalizedIncomeCalculationType")) {
            LoanCapitalizedIncomeCalculationType newValue23 = (LoanCapitalizedIncomeCalculationType)command.enumValueOfParameterNamed("capitalizedIncomeCalculationType", LoanCapitalizedIncomeCalculationType.class);
            actualChanges.put("capitalizedIncomeCalculationType", newValue23);
            loanRepaymentScheduleDetail.setCapitalizedIncomeCalculationType(newValue23);
        }
        if (command.parameterExists("capitalizedIncomeStrategy")) {
            LoanCapitalizedIncomeStrategy newValue24 = (LoanCapitalizedIncomeStrategy)command.enumValueOfParameterNamed("capitalizedIncomeStrategy", LoanCapitalizedIncomeStrategy.class);
            actualChanges.put("capitalizedIncomeStrategy", newValue24);
            loanRepaymentScheduleDetail.setCapitalizedIncomeStrategy(newValue24);
        }
        if (command.parameterExists("capitalizedIncomeType")) {
            LoanCapitalizedIncomeType newValue25 = (LoanCapitalizedIncomeType)command.enumValueOfParameterNamed("capitalizedIncomeType", LoanCapitalizedIncomeType.class);
            actualChanges.put("capitalizedIncomeType", newValue25);
            loanRepaymentScheduleDetail.setCapitalizedIncomeType(newValue25);
        }
        if (command.isChangeInBooleanParameterNamed("enableBuyDownFee", Boolean.valueOf(loanRepaymentScheduleDetail.isEnableBuyDownFee()))) {
            boolean newValue26 = command.booleanPrimitiveValueOfParameterNamed("enableBuyDownFee");
            actualChanges.put("enableBuyDownFee", newValue26);
            loanRepaymentScheduleDetail.setEnableBuyDownFee(newValue26);
        }
        if (command.parameterExists("buyDownFeeCalculationType")) {
            LoanBuyDownFeeCalculationType newValue27 = (LoanBuyDownFeeCalculationType)command.enumValueOfParameterNamed("buyDownFeeCalculationType", LoanBuyDownFeeCalculationType.class);
            actualChanges.put("buyDownFeeCalculationType", newValue27);
            loanRepaymentScheduleDetail.setBuyDownFeeCalculationType(newValue27);
        }
        if (command.parameterExists("buyDownFeeStrategy")) {
            LoanBuyDownFeeStrategy newValue28 = (LoanBuyDownFeeStrategy)command.enumValueOfParameterNamed("buyDownFeeStrategy", LoanBuyDownFeeStrategy.class);
            actualChanges.put("buyDownFeeStrategy", newValue28);
            loanRepaymentScheduleDetail.setBuyDownFeeStrategy(newValue28);
        }
        if (command.parameterExists("buyDownFeeIncomeType")) {
            LoanBuyDownFeeIncomeType newValue29 = (LoanBuyDownFeeIncomeType)command.enumValueOfParameterNamed("buyDownFeeIncomeType", LoanBuyDownFeeIncomeType.class);
            actualChanges.put("buyDownFeeIncomeType", newValue29);
            loanRepaymentScheduleDetail.setBuyDownFeeIncomeType(newValue29);
        }
        return actualChanges;
    }

    public void updateInterestRateDerivedFields(LoanProductRelatedDetail loanRepaymentScheduleDetail, AprCalculator aprCalculator) {
        BigDecimal annualNominalInterestRate = aprCalculator.calculateFrom(loanRepaymentScheduleDetail.getInterestPeriodFrequencyType(), loanRepaymentScheduleDetail.getNominalInterestRatePerPeriod(), loanRepaymentScheduleDetail.getNumberOfRepayments(), loanRepaymentScheduleDetail.getRepayEvery(), loanRepaymentScheduleDetail.getRepaymentPeriodFrequencyType());
        loanRepaymentScheduleDetail.setAnnualNominalInterestRate(annualNominalInterestRate);
    }

    @Generated
    public LoanProductRelatedDetailUpdateUtil() {
    }
}

