/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.service.PaymentDetailWritePlatformService;

public class LoanTransactionAssembler {
    private final ExternalIdFactory externalIdFactory;
    private final PaymentDetailWritePlatformService paymentDetailWritePlatformService;

    LoanTransaction assembleTransactionAndCalculateChanges(Loan loan, JsonCommand command, Map<String, Object> changes) {
        String noteText = command.stringValueOfParameterNamed("note");
        ExternalId txnExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        changes.put("transactionDate", command.stringValueOfParameterNamed("transactionDate"));
        changes.put("transactionAmount", command.stringValueOfParameterNamed("transactionAmount"));
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        changes.put("paymentTypeId", command.longValueOfParameterNamed("paymentTypeId"));
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
        }
        if (!txnExternalId.isEmpty()) {
            changes.put("externalId", txnExternalId);
        }
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        LoanTransactionType repaymentTransactionType = LoanTransactionType.INTEREST_PAYMENT_WAIVER;
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        Money repaymentAmount = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        return LoanTransaction.repaymentType((LoanTransactionType)repaymentTransactionType, (Office)loan.getOffice(), (Money)repaymentAmount, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId, null);
    }

    public LoanTransaction assembleAccrualActivityTransaction(@NotNull Loan loan, @NotNull LoanRepaymentScheduleInstallment installment, @NotNull LocalDate transactionDate) {
        ExternalId externalId = this.externalIdFactory.create();
        BigDecimal interestPortion = installment.getInterestCharged();
        BigDecimal feeChargesPortion = installment.getFeeChargesCharged();
        BigDecimal penaltyChargesPortion = installment.getPenaltyCharges();
        BigDecimal transactionAmount = MathUtil.add((BigDecimal[])new BigDecimal[]{interestPortion, feeChargesPortion, penaltyChargesPortion});
        return MathUtil.isGreaterThanZero((BigDecimal)transactionAmount) ? new LoanTransaction(loan, loan.getOffice(), LoanTransactionType.ACCRUAL_ACTIVITY, transactionDate, transactionAmount, null, interestPortion, feeChargesPortion, penaltyChargesPortion, null, false, null, externalId) : null;
    }

    @Generated
    public LoanTransactionAssembler(ExternalIdFactory externalIdFactory, PaymentDetailWritePlatformService paymentDetailWritePlatformService) {
        this.externalIdFactory = externalIdFactory;
        this.paymentDetailWritePlatformService = paymentDetailWritePlatformService;
    }
}

