/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanproduct.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import jakarta.persistence.PersistenceException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityAccessType;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.product.LoanProductCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.exception.InvalidCurrencyException;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.delinquency.domain.DelinquencyBucket;
import org.apache.fineract.portfolio.delinquency.domain.DelinquencyBucketRepository;
import org.apache.fineract.portfolio.delinquency.exception.DelinquencyBucketNotFoundException;
import org.apache.fineract.portfolio.floatingrates.domain.FloatingRate;
import org.apache.fineract.portfolio.floatingrates.domain.FloatingRateRepositoryWrapper;
import org.apache.fineract.portfolio.fund.domain.Fund;
import org.apache.fineract.portfolio.fund.domain.FundRepository;
import org.apache.fineract.portfolio.fund.exception.FundNotFoundException;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargeOffBehaviour;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.AprCalculator;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductUpdateUtil;
import org.apache.fineract.portfolio.loanproduct.domain.AdvancedPaymentAllocationsJsonParser;
import org.apache.fineract.portfolio.loanproduct.domain.CreditAllocationsJsonParser;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.loanproduct.domain.LoanSupportedInterestRefundTypes;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductCannotBeModifiedDueToNonClosedLoansException;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductDateException;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;
import org.apache.fineract.portfolio.loanproduct.serialization.LoanProductDataValidator;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductCreditAllocationRuleMerger;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductPaymentAllocationRuleMerger;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductWritePlatformService;
import org.apache.fineract.portfolio.rate.domain.Rate;
import org.apache.fineract.portfolio.rate.domain.RateRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoanProductWritePlatformServiceJpaRepositoryImpl
implements LoanProductWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanProductWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final LoanProductDataValidator fromApiJsonDeserializer;
    private final LoanProductRepository loanProductRepository;
    private final AprCalculator aprCalculator;
    private final FundRepository fundRepository;
    private final ChargeRepositoryWrapper chargeRepository;
    private final RateRepositoryWrapper rateRepository;
    private final ProductToGLAccountMappingWritePlatformService accountMappingWritePlatformService;
    private final FineractEntityAccessUtil fineractEntityAccessUtil;
    private final FloatingRateRepositoryWrapper floatingRateRepository;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final DelinquencyBucketRepository delinquencyBucketRepository;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;
    private final AdvancedPaymentAllocationsJsonParser advancedPaymentJsonParser;
    private final CreditAllocationsJsonParser creditAllocationsJsonParser;
    private final LoanProductAssembler loanProductAssembler;
    private final LoanProductUpdateUtil loanProductUpdateUtil;
    private final LoanProductPaymentAllocationRuleMerger loanProductPaymentAllocationRuleMerger = new LoanProductPaymentAllocationRuleMerger();
    private final LoanProductCreditAllocationRuleMerger loanProductCreditAllocationRuleMerger = new LoanProductCreditAllocationRuleMerger();

    @Transactional
    public CommandProcessingResult createLoanProduct(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command);
            this.validateInputDates(command);
            Fund fund = this.findFundByIdIfProvided(command.longValueOfParameterNamed("fundId"));
            String loanTransactionProcessingStrategyCode = command.stringValueOfParameterNamed("transactionProcessingStrategyCode");
            String currencyCode = command.stringValueOfParameterNamed("currencyCode");
            List charges = this.assembleListOfProductCharges(command, currencyCode);
            List rates = this.assembleListOfProductRates(command);
            List loanProductPaymentAllocationRules = this.advancedPaymentJsonParser.assembleLoanProductPaymentAllocationRules(command, loanTransactionProcessingStrategyCode);
            List loanProductCreditAllocationRules = this.creditAllocationsJsonParser.assembleLoanProductCreditAllocationRules(command, loanTransactionProcessingStrategyCode);
            FloatingRate floatingRate = null;
            if (command.parameterExists("floatingRatesId")) {
                floatingRate = this.floatingRateRepository.findOneWithNotFoundDetection(command.longValueOfParameterNamed("floatingRatesId"));
            }
            LoanProduct loanProduct = this.loanProductAssembler.assembleFromJson(fund, loanTransactionProcessingStrategyCode, charges, command, this.aprCalculator, floatingRate, rates, loanProductPaymentAllocationRules, loanProductCreditAllocationRules);
            loanProduct.updateLoanProductInRelatedClasses();
            loanProduct.setTransactionProcessingStrategyName(this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(loanTransactionProcessingStrategyCode).getName());
            if (command.parameterExists("delinquencyBucketId")) {
                loanProduct.setDelinquencyBucket(this.findDelinquencyBucketIdIfProvided(command.longValueOfParameterNamed("delinquencyBucketId")));
            }
            this.loanProductRepository.saveAndFlush((Object)loanProduct);
            this.accountMappingWritePlatformService.createLoanProductToGLAccountMapping((Long)loanProduct.getId(), command);
            this.fineractEntityAccessUtil.checkConfigurationAndAddProductResrictionsForUserOffice(FineractEntityAccessType.OFFICE_ACCESS_TO_LOAN_PRODUCTS, (Long)loanProduct.getId());
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanProductCreateBusinessEvent(loanProduct));
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loanProduct.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private Fund findFundByIdIfProvided(Long fundId) {
        Fund fund = null;
        if (fundId != null) {
            fund = (Fund)this.fundRepository.findById((Object)fundId).orElseThrow(() -> new FundNotFoundException(fundId));
        }
        return fund;
    }

    private DelinquencyBucket findDelinquencyBucketIdIfProvided(Long delinquencyBucketId) {
        DelinquencyBucket delinquencyBucket = null;
        if (delinquencyBucketId != null) {
            delinquencyBucket = (DelinquencyBucket)this.delinquencyBucketRepository.findById((Object)delinquencyBucketId).orElseThrow(() -> DelinquencyBucketNotFoundException.notFound((Long)delinquencyBucketId, (Throwable[])new Throwable[0]));
        }
        return delinquencyBucket;
    }

    @Transactional
    public CommandProcessingResult updateLoanProduct(Long loanProductId, JsonCommand command) {
        try {
            List productRates;
            boolean updated;
            List productCharges;
            boolean updated2;
            Map changes;
            this.context.authenticatedUser();
            LoanProduct product = (LoanProduct)this.loanProductRepository.findById((Object)loanProductId).orElseThrow(() -> new LoanProductNotFoundException(loanProductId));
            this.fromApiJsonDeserializer.validateForUpdate(command, product);
            this.validateInputDates(command);
            if (this.anyChangeInCriticalFloatingRateLinkedParams(command, product) && this.loanRepositoryWrapper.doNonClosedLoanAccountsExistForProduct((Long)product.getId())) {
                throw new LoanProductCannotBeModifiedDueToNonClosedLoansException((Long)product.getId());
            }
            FloatingRate floatingRate = null;
            if (command.parameterExists("floatingRatesId")) {
                floatingRate = this.floatingRateRepository.findOneWithNotFoundDetection(command.longValueOfParameterNamed("floatingRatesId"));
            }
            if ((changes = this.loanProductUpdateUtil.update(product, command, this.aprCalculator, floatingRate)).containsKey("fundId")) {
                Long fundId = (Long)changes.get("fundId");
                Fund fund = this.findFundByIdIfProvided(fundId);
                product.setFund(fund);
            }
            if (changes.containsKey("delinquencyBucketId")) {
                product.setDelinquencyBucket(this.findDelinquencyBucketIdIfProvided((Long)changes.get("delinquencyBucketId")));
            }
            if (changes.containsKey("transactionProcessingStrategyCode")) {
                String transactionProcessingStrategyCode = (String)changes.get("transactionProcessingStrategyCode");
                String transactionProcessingStrategyName = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(transactionProcessingStrategyCode).getName();
                product.setTransactionProcessingStrategyCode(transactionProcessingStrategyCode);
                product.setTransactionProcessingStrategyName(transactionProcessingStrategyName);
            }
            if (changes.containsKey("charges") && !(updated2 = product.update(productCharges = this.assembleListOfProductCharges(command, product.getCurrency().getCode())))) {
                changes.remove("charges");
            }
            if (changes.containsKey("paymentAllocation")) {
                List loanProductPaymentAllocationRules = this.advancedPaymentJsonParser.assembleLoanProductPaymentAllocationRules(command, product.getTransactionProcessingStrategyCode());
                loanProductPaymentAllocationRules.forEach(lppar -> lppar.setLoanProduct(product));
                boolean updated3 = this.loanProductPaymentAllocationRuleMerger.updateProductPaymentAllocationRules(product, loanProductPaymentAllocationRules);
                if (!updated3) {
                    changes.remove("paymentAllocation");
                }
            }
            if (changes.containsKey("creditAllocation")) {
                List loanProductCreditAllocationRules = this.creditAllocationsJsonParser.assembleLoanProductCreditAllocationRules(command, product.getTransactionProcessingStrategyCode());
                loanProductCreditAllocationRules.forEach(lpcar -> lpcar.setLoanProduct(product));
                boolean updated4 = this.loanProductCreditAllocationRuleMerger.updateCreditAllocationRules(product, loanProductCreditAllocationRules);
                if (!updated4) {
                    changes.remove("creditAllocation");
                }
            }
            boolean enableIncomeCapitalization = product.getLoanProductRelatedDetail().isEnableIncomeCapitalization();
            if (changes.containsKey("enableIncomeCapitalization")) {
                enableIncomeCapitalization = (Boolean)changes.get("enableIncomeCapitalization");
            }
            boolean enableBuyDownFee = product.getLoanProductRelatedDetail().isEnableBuyDownFee();
            if (changes.containsKey("enableBuyDownFee")) {
                enableBuyDownFee = (Boolean)changes.get("enableBuyDownFee");
            }
            boolean accountingTypeChanged = changes.containsKey("accountingRule");
            Map accountingMappingChanges = this.accountMappingWritePlatformService.updateLoanProductToGLAccountMapping((Long)product.getId(), command, accountingTypeChanged, product.getAccountingRule(), enableIncomeCapitalization, enableBuyDownFee);
            changes.putAll(accountingMappingChanges);
            if (changes.containsKey("rates") && !(updated = product.updateRates(productRates = this.assembleListOfProductRates(command)))) {
                changes.remove("rates");
            }
            if (command.parameterExists("supportedInterestRefundTypes")) {
                JsonArray supportedTransactionsForInterestRefund = command.arrayOfParameterNamed("supportedInterestRefundTypes");
                ArrayList supportedInterestRefundTypes = new ArrayList();
                supportedTransactionsForInterestRefund.iterator().forEachRemaining(value -> supportedInterestRefundTypes.add(LoanSupportedInterestRefundTypes.valueOf((String)value.getAsString())));
                product.getLoanProductRelatedDetail().setSupportedInterestRefundTypes(supportedInterestRefundTypes);
            }
            if (command.parameterExists("chargeOffBehaviour")) {
                product.getLoanProductRelatedDetail().setChargeOffBehaviour((LoanChargeOffBehaviour)command.enumValueOfParameterNamed("chargeOffBehaviour", LoanChargeOffBehaviour.class));
            }
            if (!changes.isEmpty()) {
                product.validateLoanProductPreSave();
                this.loanProductRepository.saveAndFlush((Object)product);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(loanProductId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.resourceResult((Long)-1L);
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private boolean anyChangeInCriticalFloatingRateLinkedParams(JsonCommand command, LoanProduct product) {
        boolean isChangeFromFloatingToFlatOrViceVersa = command.isChangeInBooleanParameterNamed("isLinkedToFloatingInterestRates", Boolean.valueOf(product.isLinkedToFloatingInterestRate()));
        boolean isChangeInCriticalFloatingRateParams = product.getFloatingRates() != null && (command.isChangeInLongParameterNamed("floatingRatesId", (Long)product.getFloatingRates().getFloatingRate().getId()) || command.isChangeInBigDecimalParameterNamed("interestRateDifferential", product.getFloatingRates().getInterestRateDifferential()));
        return isChangeFromFloatingToFlatOrViceVersa || isChangeInCriticalFloatingRateParams;
    }

    private List<Charge> assembleListOfProductCharges(JsonCommand command, String currencyCode) {
        JsonArray chargesArray;
        ArrayList<Charge> charges = new ArrayList<Charge>();
        String loanProductCurrencyCode = command.stringValueOfParameterNamed("currencyCode");
        if (loanProductCurrencyCode == null) {
            loanProductCurrencyCode = currencyCode;
        }
        if (command.parameterExists("charges") && (chargesArray = command.arrayOfParameterNamed("charges")) != null) {
            for (int i = 0; i < chargesArray.size(); ++i) {
                JsonObject jsonObject = chargesArray.get(i).getAsJsonObject();
                if (!jsonObject.has("id")) continue;
                Long id = jsonObject.get("id").getAsLong();
                Charge charge = this.chargeRepository.findOneWithNotFoundDetection(id);
                if (!loanProductCurrencyCode.equals(charge.getCurrencyCode())) {
                    String errorMessage = "Charge and Loan Product must have the same currency.";
                    throw new InvalidCurrencyException("charge", "attach.to.loan.product", "Charge and Loan Product must have the same currency.", new Object[0]);
                }
                charges.add(charge);
            }
        }
        return charges;
    }

    private List<Rate> assembleListOfProductRates(JsonCommand command) {
        JsonArray ratesArray;
        ArrayList<Rate> rates = new ArrayList<Rate>();
        if (command.parameterExists("rates") && (ratesArray = command.arrayOfParameterNamed("rates")) != null) {
            ArrayList<Long> idList = new ArrayList<Long>();
            for (int i = 0; i < ratesArray.size(); ++i) {
                JsonObject jsonObject = ratesArray.get(i).getAsJsonObject();
                if (!jsonObject.has("id")) continue;
                idList.add(jsonObject.get("id").getAsLong());
            }
            rates.addAll(this.rateRepository.findMultipleWithNotFoundDetection(idList));
        }
        return rates;
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("'external_id'")) {
            String externalId = command.stringValueOfParameterNamed("externalId");
            throw new PlatformDataIntegrityException("error.msg.product.loan.duplicate.externalId", "Loan Product with externalId `" + externalId + "` already exists", "externalId", new Object[]{externalId, realCause});
        }
        if (realCause.getMessage().contains("'unq_name'")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.product.loan.duplicate.name", "Loan product with name `" + name + "` already exists", "name", new Object[]{name, realCause});
        }
        if (realCause.getMessage().contains("'unq_short_name'") || LoanProductWritePlatformServiceJpaRepositoryImpl.containsDuplicateShortnameErrorForPostgreSQL((Throwable)realCause) || LoanProductWritePlatformServiceJpaRepositoryImpl.containsDuplicateShortnameErrorForMySQL((Throwable)realCause)) {
            String shortName = command.stringValueOfParameterNamed("shortName");
            throw new PlatformDataIntegrityException("error.msg.product.loan.duplicate.short.name", "Loan product with short name `" + shortName + "` already exists", "shortName", new Object[]{shortName, realCause});
        }
        if (realCause.getMessage().contains("Duplicate entry")) {
            throw new PlatformDataIntegrityException("error.msg.product.loan.duplicate.charge", "Loan product may only have one charge of each type.`", "charges", new Object[]{realCause});
        }
        this.logAsErrorUnexpectedDataIntegrityException(dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.product.loan.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.", null, (Object[])new Object[]{realCause});
    }

    private static boolean containsDuplicateShortnameErrorForPostgreSQL(Throwable realCause) {
        return realCause.getMessage().contains("m_product_loan_short_name_key");
    }

    private static boolean containsDuplicateShortnameErrorForMySQL(Throwable realCause) {
        return realCause.getMessage().contains("short_name") && realCause.getMessage().toLowerCase().contains("duplicate");
    }

    private void validateInputDates(JsonCommand command) {
        LocalDate startDate = command.localDateValueOfParameterNamed("startDate");
        LocalDate closeDate = command.localDateValueOfParameterNamed("closeDate");
        if (closeDate != null && DateUtils.isBefore((LocalDate)closeDate, (LocalDate)startDate)) {
            throw new LoanProductDateException(new Object[]{startDate.toString(), closeDate.toString()});
        }
    }

    private void logAsErrorUnexpectedDataIntegrityException(Exception dve) {
        log.error("Error occurred.", (Throwable)dve);
    }

    @Generated
    public LoanProductWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, LoanProductDataValidator fromApiJsonDeserializer, LoanProductRepository loanProductRepository, AprCalculator aprCalculator, FundRepository fundRepository, ChargeRepositoryWrapper chargeRepository, RateRepositoryWrapper rateRepository, ProductToGLAccountMappingWritePlatformService accountMappingWritePlatformService, FineractEntityAccessUtil fineractEntityAccessUtil, FloatingRateRepositoryWrapper floatingRateRepository, LoanRepositoryWrapper loanRepositoryWrapper, BusinessEventNotifierService businessEventNotifierService, DelinquencyBucketRepository delinquencyBucketRepository, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory, AdvancedPaymentAllocationsJsonParser advancedPaymentJsonParser, CreditAllocationsJsonParser creditAllocationsJsonParser, LoanProductAssembler loanProductAssembler, LoanProductUpdateUtil loanProductUpdateUtil) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.loanProductRepository = loanProductRepository;
        this.aprCalculator = aprCalculator;
        this.fundRepository = fundRepository;
        this.chargeRepository = chargeRepository;
        this.rateRepository = rateRepository;
        this.accountMappingWritePlatformService = accountMappingWritePlatformService;
        this.fineractEntityAccessUtil = fineractEntityAccessUtil;
        this.floatingRateRepository = floatingRateRepository;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.businessEventNotifierService = businessEventNotifierService;
        this.delinquencyBucketRepository = delinquencyBucketRepository;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
        this.advancedPaymentJsonParser = advancedPaymentJsonParser;
        this.creditAllocationsJsonParser = creditAllocationsJsonParser;
        this.loanProductAssembler = loanProductAssembler;
        this.loanProductUpdateUtil = loanProductUpdateUtil;
    }
}

