/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.domain;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatRepositoryWrapper;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.service.AccountNumberGenerator;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarFrequencyType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.savings.DepositAccountOnClosureType;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.SavingsTransactionBooleanValues;
import org.apache.fineract.portfolio.savings.domain.DepositAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.DepositAccountDomainService;
import org.apache.fineract.portfolio.savings.domain.FixedDepositAccount;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountCharge;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.service.SavingsAccountDomainService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DepositAccountDomainServiceJpa
implements DepositAccountDomainService {
    private final SavingsAccountRepositoryWrapper savingsAccountRepository;
    private final JournalEntryWritePlatformService journalEntryWritePlatformService;
    private final AccountNumberGenerator accountNumberGenerator;
    private final DepositAccountAssembler depositAccountAssembler;
    private final SavingsAccountDomainService savingsAccountDomainService;
    private final AccountTransfersWritePlatformService accountTransfersWritePlatformService;
    private final ConfigurationDomainService configurationDomainService;
    private final AccountNumberFormatRepositoryWrapper accountNumberFormatRepository;
    private final CalendarInstanceRepository calendarInstanceRepository;

    @Autowired
    public DepositAccountDomainServiceJpa(SavingsAccountRepositoryWrapper savingsAccountRepository, JournalEntryWritePlatformService journalEntryWritePlatformService, AccountNumberGenerator accountNumberGenerator, DepositAccountAssembler depositAccountAssembler, SavingsAccountDomainService savingsAccountDomainService, AccountTransfersWritePlatformService accountTransfersWritePlatformService, ConfigurationDomainService configurationDomainService, AccountNumberFormatRepositoryWrapper accountNumberFormatRepository, CalendarInstanceRepository calendarInstanceRepository) {
        this.savingsAccountRepository = savingsAccountRepository;
        this.journalEntryWritePlatformService = journalEntryWritePlatformService;
        this.accountNumberGenerator = accountNumberGenerator;
        this.depositAccountAssembler = depositAccountAssembler;
        this.savingsAccountDomainService = savingsAccountDomainService;
        this.accountTransfersWritePlatformService = accountTransfersWritePlatformService;
        this.configurationDomainService = configurationDomainService;
        this.accountNumberFormatRepository = accountNumberFormatRepository;
        this.calendarInstanceRepository = calendarInstanceRepository;
    }

    @Transactional
    public SavingsAccountTransaction handleWithdrawal(SavingsAccount account, DateTimeFormatter fmt, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, boolean applyWithdrawFee, boolean isRegularTransaction) {
        boolean isAccountTransfer = false;
        boolean isInterestTransfer = false;
        boolean isWithdrawBalance = false;
        boolean backdatedTxnsAllowedTill = false;
        SavingsTransactionBooleanValues transactionBooleanValues = new SavingsTransactionBooleanValues(isAccountTransfer, isRegularTransaction, applyWithdrawFee, isInterestTransfer, isWithdrawBalance);
        return this.savingsAccountDomainService.handleWithdrawal(account, fmt, transactionDate, transactionAmount, paymentDetail, transactionBooleanValues, false);
    }

    @Transactional
    public SavingsAccountTransaction handleFDDeposit(FixedDepositAccount account, DateTimeFormatter fmt, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail) {
        boolean isAccountTransfer = false;
        boolean isRegularTransaction = false;
        boolean backdatedTxnsAllowedTill = false;
        return this.savingsAccountDomainService.handleDeposit((SavingsAccount)account, fmt, transactionDate, transactionAmount, paymentDetail, isAccountTransfer, isRegularTransaction, false);
    }

    @Transactional
    public SavingsAccountTransaction handleRDDeposit(RecurringDepositAccount account, DateTimeFormatter fmt, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, boolean isRegularTransaction) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean isAccountTransfer = false;
        boolean isPreMatureClosure = false;
        MathContext mc = MathContext.DECIMAL64;
        account.updateDepositAmount(transactionAmount);
        boolean backdatedTxnsAllowedTill = false;
        SavingsAccountTransaction deposit = this.savingsAccountDomainService.handleDeposit((SavingsAccount)account, fmt, transactionDate, transactionAmount, paymentDetail, isAccountTransfer, isRegularTransaction, false);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        boolean isAnyActivationChargesDue = this.isAnyActivationChargesDue(account);
        if (isAnyActivationChargesDue) {
            this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
            account.processAccountUponActivation(isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
            this.savingsAccountRepository.saveAndFlush((SavingsAccount)account);
        }
        account.handleScheduleInstallments(deposit);
        account.updateMaturityDateAndAmount(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        account.updateOverduePayments(DateUtils.getBusinessLocalDate());
        if (isAnyActivationChargesDue) {
            this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds, isAccountTransfer);
        }
        return deposit;
    }

    @Transactional
    public SavingsAccountTransaction handleSavingDeposit(SavingsAccount account, DateTimeFormatter fmt, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, boolean isRegularTransaction) {
        boolean isAccountTransfer = false;
        boolean backdatedTxnsAllowedTill = false;
        SavingsAccountTransaction deposit = this.savingsAccountDomainService.handleDeposit(account, fmt, transactionDate, transactionAmount, paymentDetail, isAccountTransfer, isRegularTransaction, false);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, isAccountTransfer);
        return deposit;
    }

    private boolean isAnyActivationChargesDue(RecurringDepositAccount account) {
        for (SavingsAccountCharge savingsAccountCharge : account.charges()) {
            if (!savingsAccountCharge.isSavingsActivation() || savingsAccountCharge.amoutOutstanding() == null || savingsAccountCharge.amoutOutstanding().compareTo(BigDecimal.ZERO) <= 0) continue;
            return true;
        }
        return false;
    }

    @Transactional
    public Long handleFDAccountClosure(FixedDepositAccount account, PaymentDetail paymentDetail, AppUser user, JsonCommand command, Map<String, Object> changes) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean isRegularTransaction = false;
        boolean isAccountTransfer = false;
        boolean isPreMatureClosure = false;
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        MathContext mc = MathContext.DECIMAL64;
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate closedDate = command.localDateValueOfParameterNamed("closedOnDate");
        Long savingsTransactionId = null;
        account.postMaturityInterest(isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        Integer onAccountClosureId = command.integerValueOfParameterNamed("onAccountClosureId");
        DepositAccountOnClosureType onClosureType = DepositAccountOnClosureType.fromInt((Integer)onAccountClosureId);
        if (onClosureType.isReinvest()) {
            FixedDepositAccount reinvestedDeposit = account.reInvest(account.getAccountBalance());
            this.depositAccountAssembler.assignSavingAccountHelpers((SavingsAccount)reinvestedDeposit);
            reinvestedDeposit.updateMaturityDateAndAmountBeforeAccountActivation(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
            this.savingsAccountRepository.save((SavingsAccount)reinvestedDeposit);
            this.autoGenerateAccountNumber((SavingsAccount)reinvestedDeposit);
            SavingsAccountTransaction withdrawal = this.handleWithdrawal((SavingsAccount)account, fmt, closedDate, account.getAccountBalance(), paymentDetail, false, isRegularTransaction);
            savingsTransactionId = (Long)withdrawal.getId();
        } else if (onClosureType.isTransferToSavings()) {
            Long toSavingsId = command.longValueOfParameterNamed("toSavingsAccountId");
            String transferDescription = command.stringValueOfParameterNamed("transferDescription");
            SavingsAccount toSavingsAccount = this.depositAccountAssembler.assembleFrom(toSavingsId, DepositAccountType.SAVINGS_DEPOSIT);
            boolean isExceptionForBalanceCheck = false;
            AccountTransferDTO accountTransferDTO = new AccountTransferDTO(closedDate, account.getAccountBalance(), PortfolioAccountType.SAVINGS, PortfolioAccountType.SAVINGS, null, null, transferDescription, locale, fmt, null, null, null, null, null, AccountTransferType.ACCOUNT_TRANSFER.getValue(), null, null, ExternalId.empty(), null, toSavingsAccount, (SavingsAccount)account, Boolean.valueOf(isAccountTransfer), Boolean.valueOf(false));
            this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
            this.updateAlreadyPostedTransactions(existingTransactionIds, (SavingsAccount)account);
            this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds, isAccountTransfer);
        } else {
            SavingsAccountTransaction withdrawal = this.handleWithdrawal((SavingsAccount)account, fmt, closedDate, account.getAccountBalance(), paymentDetail, false, isRegularTransaction);
            savingsTransactionId = (Long)withdrawal.getId();
        }
        account.close(user, command, changes);
        this.savingsAccountRepository.save((SavingsAccount)account);
        return savingsTransactionId;
    }

    @Transactional
    public Long handleFDAccountMaturityClosure(FixedDepositAccount account, PaymentDetail paymentDetail, AppUser user, DateTimeFormatter fmt, LocalDate closedDate, Integer onAccountClosureId, Long toSavingsId, String transferDescription, Map<String, Object> changes) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean isRegularTransaction = false;
        boolean isAccountTransfer = false;
        boolean isPreMatureClosure = false;
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        MathContext mc = MathContext.DECIMAL64;
        Long savingsTransactionId = null;
        account.postMaturityInterest(isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        DepositAccountOnClosureType onClosureType = DepositAccountOnClosureType.fromInt((Integer)onAccountClosureId);
        if (onClosureType.isReinvest()) {
            BigDecimal reInvestAmount = onClosureType.isReinvestPrincipal() ? account.getDepositAmount() : account.getAccountBalance();
            FixedDepositAccount reinvestedDeposit = account.reInvest(reInvestAmount);
            this.depositAccountAssembler.assignSavingAccountHelpers((SavingsAccount)reinvestedDeposit);
            reinvestedDeposit.updateMaturityDateAndAmountBeforeAccountActivation(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
            this.savingsAccountRepository.save((SavingsAccount)reinvestedDeposit);
            this.autoGenerateAccountNumber((SavingsAccount)reinvestedDeposit);
            SavingsAccountTransaction withdrawal = this.handleWithdrawal((SavingsAccount)account, fmt, closedDate, reInvestAmount, paymentDetail, false, isRegularTransaction);
            savingsTransactionId = (Long)withdrawal.getId();
            if (onClosureType.isReinvestPrincipalAndInterest()) {
                account.updateClosedStatus();
                account.updateOnAccountClosureStatus(onClosureType);
            }
            changes.put("reinvestedDepositId", reinvestedDeposit.getId());
            reinvestedDeposit.approveAndActivateApplication(closedDate, user);
            this.savingsAccountRepository.save((SavingsAccount)reinvestedDeposit);
        } else if (onClosureType.isTransferToSavings()) {
            SavingsAccount toSavingsAccount = this.depositAccountAssembler.assembleFrom(toSavingsId, DepositAccountType.SAVINGS_DEPOSIT);
            boolean isExceptionForBalanceCheck = false;
            AccountTransferDTO accountTransferDTO = new AccountTransferDTO(closedDate, account.getAccountBalance(), PortfolioAccountType.SAVINGS, PortfolioAccountType.SAVINGS, null, null, transferDescription, null, fmt, null, null, null, null, null, AccountTransferType.ACCOUNT_TRANSFER.getValue(), null, null, ExternalId.empty(), null, toSavingsAccount, (SavingsAccount)account, Boolean.valueOf(isAccountTransfer), Boolean.valueOf(false));
            this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
            this.updateAlreadyPostedTransactions(existingTransactionIds, (SavingsAccount)account);
            account.updateClosedStatus();
            account.updateOnAccountClosureStatus(onClosureType);
        } else {
            SavingsAccountTransaction withdrawal = this.handleWithdrawal((SavingsAccount)account, fmt, closedDate, account.getAccountBalance(), paymentDetail, false, isRegularTransaction);
            savingsTransactionId = (Long)withdrawal.getId();
        }
        this.savingsAccountRepository.save((SavingsAccount)account);
        this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds, isAccountTransfer);
        return savingsTransactionId;
    }

    @Transactional
    public Long handleRDAccountClosure(RecurringDepositAccount account, PaymentDetail paymentDetail, AppUser user, JsonCommand command, Map<String, Object> changes) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean postReversals = false;
        boolean isRegularTransaction = false;
        boolean isAccountTransfer = false;
        boolean isPreMatureClosure = false;
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        MathContext mc = MathContext.DECIMAL64;
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate closedDate = command.localDateValueOfParameterNamed("closedOnDate");
        Long savingsTransactionId = null;
        account.postMaturityInterest(isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, closedDate, false);
        BigDecimal transactionAmount = account.getAccountBalance();
        Integer onAccountClosureId = command.integerValueOfParameterNamed("onAccountClosureId");
        DepositAccountOnClosureType onClosureType = DepositAccountOnClosureType.fromInt((Integer)onAccountClosureId);
        if (onClosureType.isReinvest()) {
            BigDecimal reInvestAmount = onClosureType.isReinvestPrincipal() ? account.getDepositAmount() : account.getAccountBalance();
            RecurringDepositAccount reinvestedDeposit = account.reInvest(reInvestAmount);
            this.depositAccountAssembler.assignSavingAccountHelpers((SavingsAccount)reinvestedDeposit);
            this.savingsAccountRepository.save((SavingsAccount)reinvestedDeposit);
            CalendarInstance calendarInstance = this.getCalendarInstance(account, reinvestedDeposit);
            this.calendarInstanceRepository.save(calendarInstance);
            Calendar calendar = calendarInstance.getCalendar();
            PeriodFrequencyType frequencyType = CalendarFrequencyType.from((CalendarFrequencyType)CalendarUtils.getFrequency((String)calendar.getRecurrence()));
            Integer frequency = CalendarUtils.getInterval((String)calendar.getRecurrence());
            frequency = frequency == -1 ? 1 : frequency;
            reinvestedDeposit.generateSchedule(frequencyType, frequency, calendar);
            reinvestedDeposit.processAccountUponActivation(fmt, false);
            reinvestedDeposit.updateMaturityDateAndAmount(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
            this.savingsAccountRepository.save((SavingsAccount)reinvestedDeposit);
            this.autoGenerateAccountNumber((SavingsAccount)reinvestedDeposit);
            SavingsAccountTransaction withdrawal = this.handleWithdrawal((SavingsAccount)account, fmt, closedDate, account.getAccountBalance(), paymentDetail, false, isRegularTransaction);
            savingsTransactionId = (Long)withdrawal.getId();
        } else if (onClosureType.isTransferToSavings()) {
            Long toSavingsId = command.longValueOfParameterNamed("toSavingsAccountId");
            String transferDescription = command.stringValueOfParameterNamed("transferDescription");
            SavingsAccount toSavingsAccount = this.depositAccountAssembler.assembleFrom(toSavingsId, DepositAccountType.SAVINGS_DEPOSIT);
            boolean isExceptionForBalanceCheck = false;
            AccountTransferDTO accountTransferDTO = new AccountTransferDTO(closedDate, transactionAmount, PortfolioAccountType.SAVINGS, PortfolioAccountType.SAVINGS, null, null, transferDescription, locale, fmt, null, null, null, null, null, AccountTransferType.ACCOUNT_TRANSFER.getValue(), null, null, ExternalId.empty(), null, toSavingsAccount, (SavingsAccount)account, Boolean.valueOf(isRegularTransaction), Boolean.valueOf(false));
            this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
            this.updateAlreadyPostedTransactions(existingTransactionIds, (SavingsAccount)account);
        } else {
            SavingsAccountTransaction withdrawal = this.handleWithdrawal((SavingsAccount)account, fmt, closedDate, account.getAccountBalance(), paymentDetail, false, isRegularTransaction);
            savingsTransactionId = (Long)withdrawal.getId();
        }
        account.close(user, command, changes);
        this.savingsAccountRepository.save((SavingsAccount)account);
        this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds, isAccountTransfer);
        return savingsTransactionId;
    }

    private CalendarInstance getCalendarInstance(RecurringDepositAccount account, RecurringDepositAccount reinvestedDeposit) {
        CalendarInstance calendarInstance = null;
        CalendarInstance parentCalendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId((Long)account.getId(), CalendarEntityType.SAVINGS.getValue(), CalendarType.COLLECTION.getValue());
        if (account.isCalendarInherited()) {
            calendarInstance = CalendarInstance.from((Calendar)parentCalendarInstance.getCalendar(), (Long)((Long)account.getId()), (Integer)CalendarEntityType.SAVINGS.getValue());
        } else {
            LocalDate calendarStartDate = reinvestedDeposit.depositStartDate();
            Calendar parentCalendar = parentCalendarInstance.getCalendar();
            String recurrence = parentCalendar.getRecurrence();
            String title = "recurring_savings_" + String.valueOf(reinvestedDeposit.getId());
            Calendar calendar = Calendar.createRepeatingCalendar((String)title, (LocalDate)calendarStartDate, (Integer)CalendarType.COLLECTION.getValue(), (String)recurrence);
            calendarInstance = CalendarInstance.from((Calendar)calendar, (Long)((Long)reinvestedDeposit.getId()), (Integer)CalendarEntityType.SAVINGS.getValue());
        }
        if (calendarInstance == null) {
            String defaultUserMessage = "No valid recurring details available for recurring depost account creation.";
            throw new GeneralPlatformDomainRuleException("error.msg.recurring.deposit.account.cannot.create.no.valid.recurring.details.available", "No valid recurring details available for recurring depost account creation.", new Object[]{account.clientId()});
        }
        return calendarInstance;
    }

    private void autoGenerateAccountNumber(SavingsAccount account) {
        if (account.isAccountNumberRequiresAutoGeneration()) {
            AccountNumberFormat accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(EntityAccountType.SAVINGS);
            account.updateAccountNo(this.accountNumberGenerator.generate(account, accountNumberFormat));
            this.savingsAccountRepository.save(account);
        }
    }

    @Transactional
    public Long handleFDAccountPreMatureClosure(FixedDepositAccount account, PaymentDetail paymentDetail, AppUser user, JsonCommand command, Map<String, Object> changes) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean isAccountTransfer = false;
        boolean isRegularTransaction = false;
        boolean isPreMatureClosure = true;
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        LocalDate closedDate = command.localDateValueOfParameterNamed("closedOnDate");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        Long savingsTransactionId = null;
        account.postPreMaturityInterest(closedDate, true, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        Integer closureTypeValue = command.integerValueOfParameterNamed("onAccountClosureId");
        DepositAccountOnClosureType closureType = DepositAccountOnClosureType.fromInt((Integer)closureTypeValue);
        if (closureType.isTransferToSavings()) {
            boolean isExceptionForBalanceCheck = false;
            Long toSavingsId = command.longValueOfParameterNamed("toSavingsAccountId");
            String transferDescription = command.stringValueOfParameterNamed("transferDescription");
            SavingsAccount toSavingsAccount = this.depositAccountAssembler.assembleFrom(toSavingsId, DepositAccountType.SAVINGS_DEPOSIT);
            AccountTransferDTO accountTransferDTO = new AccountTransferDTO(closedDate, account.getAccountBalance(), PortfolioAccountType.SAVINGS, PortfolioAccountType.SAVINGS, null, null, transferDescription, locale, fmt, null, null, null, null, null, AccountTransferType.ACCOUNT_TRANSFER.getValue(), null, null, ExternalId.empty(), null, toSavingsAccount, (SavingsAccount)account, Boolean.valueOf(isRegularTransaction), Boolean.valueOf(false));
            this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
            this.updateAlreadyPostedTransactions(existingTransactionIds, (SavingsAccount)account);
        } else {
            SavingsAccountTransaction withdrawal = this.handleWithdrawal((SavingsAccount)account, fmt, closedDate, account.getAccountBalance(), paymentDetail, false, isRegularTransaction);
            savingsTransactionId = (Long)withdrawal.getId();
        }
        account.prematureClosure(user, command, changes);
        this.savingsAccountRepository.save((SavingsAccount)account);
        this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds, isAccountTransfer);
        return savingsTransactionId;
    }

    @Transactional
    public Long handleRDAccountPreMatureClosure(RecurringDepositAccount account, PaymentDetail paymentDetail, AppUser user, JsonCommand command, Map<String, Object> changes) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean postReversals = false;
        boolean isAccountTransfer = false;
        boolean isPreMatureClosure = true;
        boolean isRegularTransaction = false;
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        LocalDate closedDate = command.localDateValueOfParameterNamed("closedOnDate");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        Long savingsTransactionId = null;
        account.postPreMaturityInterest(closedDate, true, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, false);
        Integer closureTypeValue = command.integerValueOfParameterNamed("onAccountClosureId");
        DepositAccountOnClosureType closureType = DepositAccountOnClosureType.fromInt((Integer)closureTypeValue);
        if (closureType.isTransferToSavings()) {
            boolean isExceptionForBalanceCheck = false;
            Long toSavingsId = command.longValueOfParameterNamed("toSavingsAccountId");
            String transferDescription = command.stringValueOfParameterNamed("transferDescription");
            SavingsAccount toSavingsAccount = this.depositAccountAssembler.assembleFrom(toSavingsId, DepositAccountType.SAVINGS_DEPOSIT);
            AccountTransferDTO accountTransferDTO = new AccountTransferDTO(closedDate, account.getAccountBalance(), PortfolioAccountType.SAVINGS, PortfolioAccountType.SAVINGS, null, null, transferDescription, locale, fmt, null, null, null, null, null, AccountTransferType.ACCOUNT_TRANSFER.getValue(), null, null, ExternalId.empty(), null, toSavingsAccount, (SavingsAccount)account, Boolean.valueOf(isRegularTransaction), Boolean.valueOf(false));
            this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
            this.updateAlreadyPostedTransactions(existingTransactionIds, (SavingsAccount)account);
        } else {
            SavingsAccountTransaction withdrawal = this.handleWithdrawal((SavingsAccount)account, fmt, closedDate, account.getAccountBalance(), paymentDetail, false, isRegularTransaction);
            savingsTransactionId = (Long)withdrawal.getId();
        }
        account.prematureClosure(user, command, changes);
        this.savingsAccountRepository.save((SavingsAccount)account);
        this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds, isAccountTransfer);
        return savingsTransactionId;
    }

    private void updateExistingTransactionsDetails(SavingsAccount account, Set<Long> existingTransactionIds, Set<Long> existingReversedTransactionIds) {
        existingTransactionIds.addAll(account.findExistingTransactionIds());
        existingReversedTransactionIds.addAll(account.findExistingReversedTransactionIds());
    }

    private void postJournalEntries(SavingsAccount savingsAccount, Set<Long> existingTransactionIds, Set<Long> existingReversedTransactionIds, boolean isAccountTransfer) {
        boolean backdatedTxnsAllowedTill = false;
        Map accountingBridgeData = savingsAccount.deriveAccountingBridgeData(savingsAccount.getCurrency().getCode(), existingTransactionIds, existingReversedTransactionIds, isAccountTransfer, false);
        this.journalEntryWritePlatformService.createJournalEntriesForSavings(accountingBridgeData);
    }

    private void updateAlreadyPostedTransactions(Set<Long> existingTransactionIds, SavingsAccount savingsAccount) {
        SavingsAccountTransaction transaction;
        List transactions = savingsAccount.getTransactions();
        int size = transactions.size();
        int i = size - 1;
        while ((transaction = (SavingsAccountTransaction)transactions.get(i)).isWithdrawal() || transaction.isWithdrawalFee()) {
            existingTransactionIds.add((Long)transaction.getId());
            --i;
        }
    }
}

