/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.infrastructure.bulkimport.constants;

public final class GuarantorConstants {

    private GuarantorConstants() {

    }

    public static final int OFFICE_NAME_COL = 0;
    public static final int CLIENT_NAME_COL = 1;
    public static final int LOAN_ACCOUNT_NO_COL = 2;
    public static final int GUARANTO_TYPE_COL = 3;
    public static final int CLIENT_RELATIONSHIP_TYPE_COL = 4;
    public static final int ENTITY_OFFICE_NAME_COL = 5;
    public static final int ENTITY_ID_COL = 6;
    public static final int FIRST_NAME_COL = 7;
    public static final int LAST_NAME_COL = 8;
    public static final int ADDRESS_LINE_1_COL = 9;
    public static final int ADDRESS_LINE_2_COL = 10;
    public static final int CITY_COL = 11;
    public static final int DOB_COL = 12;
    public static final int ZIP_COL = 13;
    public static final int SAVINGS_ID_COL = 14;
    public static final int AMOUNT = 15;
    public static final int STATUS_COL = 18;
    public static final int LOOKUP_CLIENT_NAME_COL = 81;
    public static final int LOOKUP_ACCOUNT_NO_COL = 82;
    public static final int LOOKUP_SAVINGS_CLIENT_NAME_COL = 83;
    public static final int LOOKUP_SAVINGS_ACCOUNT_NO_COL = 84;
    public static final int LOOKUP_GUARANTOR_RELATIONSHIPS = 85;
}
