/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.fineract.client.models.GetLoansLoanIdCurrency;
import org.apache.fineract.client.models.GetLoansLoanIdDisbursementDetails;
import org.apache.fineract.client.models.GetLoansLoanIdLinkedAccount;
import org.apache.fineract.client.models.GetLoansLoanIdOverdueCharges;

/**
 * GetLoansLoanIdSummary
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GetLoansLoanIdSummary {
  public static final String SERIALIZED_NAME_CAN_DISBURSE = "canDisburse";
  @SerializedName(SERIALIZED_NAME_CAN_DISBURSE)
  private Boolean canDisburse;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON = "chargeOffReason";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON)
  private String chargeOffReason;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON_ID = "chargeOffReasonId";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON_ID)
  private Long chargeOffReasonId;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private GetLoansLoanIdCurrency currency;

  public static final String SERIALIZED_NAME_DISBURSEMENT_DETAILS = "disbursementDetails";
  @SerializedName(SERIALIZED_NAME_DISBURSEMENT_DETAILS)
  private Set<GetLoansLoanIdDisbursementDetails> disbursementDetails;

  public static final String SERIALIZED_NAME_FEE_ADJUSTMENTS = "feeAdjustments";
  @SerializedName(SERIALIZED_NAME_FEE_ADJUSTMENTS)
  private BigDecimal feeAdjustments;

  public static final String SERIALIZED_NAME_FEE_CHARGES_CHARGED = "feeChargesCharged";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_CHARGED)
  private BigDecimal feeChargesCharged;

  public static final String SERIALIZED_NAME_FEE_CHARGES_DUE_AT_DISBURSEMENT_CHARGED = "feeChargesDueAtDisbursementCharged";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_DUE_AT_DISBURSEMENT_CHARGED)
  private BigDecimal feeChargesDueAtDisbursementCharged;

  public static final String SERIALIZED_NAME_FEE_CHARGES_OUTSTANDING = "feeChargesOutstanding";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_OUTSTANDING)
  private BigDecimal feeChargesOutstanding;

  public static final String SERIALIZED_NAME_FEE_CHARGES_OVERDUE = "feeChargesOverdue";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_OVERDUE)
  private BigDecimal feeChargesOverdue;

  public static final String SERIALIZED_NAME_FEE_CHARGES_PAID = "feeChargesPaid";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_PAID)
  private BigDecimal feeChargesPaid;

  public static final String SERIALIZED_NAME_FEE_CHARGES_WAIVED = "feeChargesWaived";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_WAIVED)
  private BigDecimal feeChargesWaived;

  public static final String SERIALIZED_NAME_FEE_CHARGES_WRITTEN_OFF = "feeChargesWrittenOff";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_WRITTEN_OFF)
  private BigDecimal feeChargesWrittenOff;

  public static final String SERIALIZED_NAME_FIXED_EMI_AMOUNT = "fixedEmiAmount";
  @SerializedName(SERIALIZED_NAME_FIXED_EMI_AMOUNT)
  private BigDecimal fixedEmiAmount;

  public static final String SERIALIZED_NAME_IN_ARREARS = "inArrears";
  @SerializedName(SERIALIZED_NAME_IN_ARREARS)
  private Boolean inArrears;

  public static final String SERIALIZED_NAME_INTEREST_CHARGED = "interestCharged";
  @SerializedName(SERIALIZED_NAME_INTEREST_CHARGED)
  private BigDecimal interestCharged;

  public static final String SERIALIZED_NAME_INTEREST_OUTSTANDING = "interestOutstanding";
  @SerializedName(SERIALIZED_NAME_INTEREST_OUTSTANDING)
  private BigDecimal interestOutstanding;

  public static final String SERIALIZED_NAME_INTEREST_OVERDUE = "interestOverdue";
  @SerializedName(SERIALIZED_NAME_INTEREST_OVERDUE)
  private BigDecimal interestOverdue;

  public static final String SERIALIZED_NAME_INTEREST_PAID = "interestPaid";
  @SerializedName(SERIALIZED_NAME_INTEREST_PAID)
  private BigDecimal interestPaid;

  public static final String SERIALIZED_NAME_INTEREST_WAIVED = "interestWaived";
  @SerializedName(SERIALIZED_NAME_INTEREST_WAIVED)
  private BigDecimal interestWaived;

  public static final String SERIALIZED_NAME_INTEREST_WRITTEN_OFF = "interestWrittenOff";
  @SerializedName(SERIALIZED_NAME_INTEREST_WRITTEN_OFF)
  private BigDecimal interestWrittenOff;

  public static final String SERIALIZED_NAME_IS_N_P_A = "isNPA";
  @SerializedName(SERIALIZED_NAME_IS_N_P_A)
  private Boolean isNPA;

  public static final String SERIALIZED_NAME_LINKED_ACCOUNT = "linkedAccount";
  @SerializedName(SERIALIZED_NAME_LINKED_ACCOUNT)
  private GetLoansLoanIdLinkedAccount linkedAccount;

  public static final String SERIALIZED_NAME_MAX_OUTSTANDING_LOAN_BALANCE = "maxOutstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_MAX_OUTSTANDING_LOAN_BALANCE)
  private BigDecimal maxOutstandingLoanBalance;

  public static final String SERIALIZED_NAME_OVERDUE_CHARGES = "overdueCharges";
  @SerializedName(SERIALIZED_NAME_OVERDUE_CHARGES)
  private Set<GetLoansLoanIdOverdueCharges> overdueCharges;

  public static final String SERIALIZED_NAME_OVERDUE_SINCE_DATE = "overdueSinceDate";
  @SerializedName(SERIALIZED_NAME_OVERDUE_SINCE_DATE)
  private LocalDate overdueSinceDate;

  public static final String SERIALIZED_NAME_PENALTY_ADJUSTMENTS = "penaltyAdjustments";
  @SerializedName(SERIALIZED_NAME_PENALTY_ADJUSTMENTS)
  private BigDecimal penaltyAdjustments;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_CHARGED = "penaltyChargesCharged";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_CHARGED)
  private BigDecimal penaltyChargesCharged;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_OUTSTANDING = "penaltyChargesOutstanding";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_OUTSTANDING)
  private BigDecimal penaltyChargesOutstanding;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_OVERDUE = "penaltyChargesOverdue";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_OVERDUE)
  private BigDecimal penaltyChargesOverdue;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_PAID = "penaltyChargesPaid";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_PAID)
  private BigDecimal penaltyChargesPaid;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_WAIVED = "penaltyChargesWaived";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_WAIVED)
  private BigDecimal penaltyChargesWaived;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_WRITTEN_OFF = "penaltyChargesWrittenOff";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_WRITTEN_OFF)
  private BigDecimal penaltyChargesWrittenOff;

  public static final String SERIALIZED_NAME_PRINCIPAL_ADJUSTMENTS = "principalAdjustments";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_ADJUSTMENTS)
  private BigDecimal principalAdjustments;

  public static final String SERIALIZED_NAME_PRINCIPAL_DISBURSED = "principalDisbursed";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_DISBURSED)
  private BigDecimal principalDisbursed;

  public static final String SERIALIZED_NAME_PRINCIPAL_OUTSTANDING = "principalOutstanding";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_OUTSTANDING)
  private BigDecimal principalOutstanding;

  public static final String SERIALIZED_NAME_PRINCIPAL_OVERDUE = "principalOverdue";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_OVERDUE)
  private BigDecimal principalOverdue;

  public static final String SERIALIZED_NAME_PRINCIPAL_PAID = "principalPaid";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_PAID)
  private BigDecimal principalPaid;

  public static final String SERIALIZED_NAME_PRINCIPAL_WRITTEN_OFF = "principalWrittenOff";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_WRITTEN_OFF)
  private BigDecimal principalWrittenOff;

  public static final String SERIALIZED_NAME_TOTAL_CAPITALIZED_INCOME = "totalCapitalizedIncome";
  @SerializedName(SERIALIZED_NAME_TOTAL_CAPITALIZED_INCOME)
  private BigDecimal totalCapitalizedIncome;

  public static final String SERIALIZED_NAME_TOTAL_CHARGE_ADJUSTMENT = "totalChargeAdjustment";
  @SerializedName(SERIALIZED_NAME_TOTAL_CHARGE_ADJUSTMENT)
  private BigDecimal totalChargeAdjustment;

  public static final String SERIALIZED_NAME_TOTAL_CHARGE_ADJUSTMENT_REVERSED = "totalChargeAdjustmentReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_CHARGE_ADJUSTMENT_REVERSED)
  private BigDecimal totalChargeAdjustmentReversed;

  public static final String SERIALIZED_NAME_TOTAL_CHARGEBACK = "totalChargeback";
  @SerializedName(SERIALIZED_NAME_TOTAL_CHARGEBACK)
  private BigDecimal totalChargeback;

  public static final String SERIALIZED_NAME_TOTAL_COST_OF_LOAN = "totalCostOfLoan";
  @SerializedName(SERIALIZED_NAME_TOTAL_COST_OF_LOAN)
  private BigDecimal totalCostOfLoan;

  public static final String SERIALIZED_NAME_TOTAL_CREDIT_BALANCE_REFUND = "totalCreditBalanceRefund";
  @SerializedName(SERIALIZED_NAME_TOTAL_CREDIT_BALANCE_REFUND)
  private BigDecimal totalCreditBalanceRefund;

  public static final String SERIALIZED_NAME_TOTAL_CREDIT_BALANCE_REFUND_REVERSED = "totalCreditBalanceRefundReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_CREDIT_BALANCE_REFUND_REVERSED)
  private BigDecimal totalCreditBalanceRefundReversed;

  public static final String SERIALIZED_NAME_TOTAL_EXPECTED_COST_OF_LOAN = "totalExpectedCostOfLoan";
  @SerializedName(SERIALIZED_NAME_TOTAL_EXPECTED_COST_OF_LOAN)
  private BigDecimal totalExpectedCostOfLoan;

  public static final String SERIALIZED_NAME_TOTAL_EXPECTED_REPAYMENT = "totalExpectedRepayment";
  @SerializedName(SERIALIZED_NAME_TOTAL_EXPECTED_REPAYMENT)
  private BigDecimal totalExpectedRepayment;

  public static final String SERIALIZED_NAME_TOTAL_GOODWILL_CREDIT = "totalGoodwillCredit";
  @SerializedName(SERIALIZED_NAME_TOTAL_GOODWILL_CREDIT)
  private BigDecimal totalGoodwillCredit;

  public static final String SERIALIZED_NAME_TOTAL_GOODWILL_CREDIT_REVERSED = "totalGoodwillCreditReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_GOODWILL_CREDIT_REVERSED)
  private BigDecimal totalGoodwillCreditReversed;

  public static final String SERIALIZED_NAME_TOTAL_INTEREST_PAYMENT_WAIVER = "totalInterestPaymentWaiver";
  @SerializedName(SERIALIZED_NAME_TOTAL_INTEREST_PAYMENT_WAIVER)
  private BigDecimal totalInterestPaymentWaiver;

  public static final String SERIALIZED_NAME_TOTAL_INTEREST_REFUND = "totalInterestRefund";
  @SerializedName(SERIALIZED_NAME_TOTAL_INTEREST_REFUND)
  private BigDecimal totalInterestRefund;

  public static final String SERIALIZED_NAME_TOTAL_MERCHANT_REFUND = "totalMerchantRefund";
  @SerializedName(SERIALIZED_NAME_TOTAL_MERCHANT_REFUND)
  private BigDecimal totalMerchantRefund;

  public static final String SERIALIZED_NAME_TOTAL_MERCHANT_REFUND_REVERSED = "totalMerchantRefundReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_MERCHANT_REFUND_REVERSED)
  private BigDecimal totalMerchantRefundReversed;

  public static final String SERIALIZED_NAME_TOTAL_OUTSTANDING = "totalOutstanding";
  @SerializedName(SERIALIZED_NAME_TOTAL_OUTSTANDING)
  private BigDecimal totalOutstanding;

  public static final String SERIALIZED_NAME_TOTAL_OVERDUE = "totalOverdue";
  @SerializedName(SERIALIZED_NAME_TOTAL_OVERDUE)
  private BigDecimal totalOverdue;

  public static final String SERIALIZED_NAME_TOTAL_PAYOUT_REFUND = "totalPayoutRefund";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAYOUT_REFUND)
  private BigDecimal totalPayoutRefund;

  public static final String SERIALIZED_NAME_TOTAL_PAYOUT_REFUND_REVERSED = "totalPayoutRefundReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAYOUT_REFUND_REVERSED)
  private BigDecimal totalPayoutRefundReversed;

  public static final String SERIALIZED_NAME_TOTAL_PRINCIPAL = "totalPrincipal";
  @SerializedName(SERIALIZED_NAME_TOTAL_PRINCIPAL)
  private BigDecimal totalPrincipal;

  public static final String SERIALIZED_NAME_TOTAL_RECOVERED = "totalRecovered";
  @SerializedName(SERIALIZED_NAME_TOTAL_RECOVERED)
  private BigDecimal totalRecovered;

  public static final String SERIALIZED_NAME_TOTAL_REPAYMENT = "totalRepayment";
  @SerializedName(SERIALIZED_NAME_TOTAL_REPAYMENT)
  private BigDecimal totalRepayment;

  public static final String SERIALIZED_NAME_TOTAL_REPAYMENT_TRANSACTION = "totalRepaymentTransaction";
  @SerializedName(SERIALIZED_NAME_TOTAL_REPAYMENT_TRANSACTION)
  private BigDecimal totalRepaymentTransaction;

  public static final String SERIALIZED_NAME_TOTAL_REPAYMENT_TRANSACTION_REVERSED = "totalRepaymentTransactionReversed";
  @SerializedName(SERIALIZED_NAME_TOTAL_REPAYMENT_TRANSACTION_REVERSED)
  private BigDecimal totalRepaymentTransactionReversed;

  public static final String SERIALIZED_NAME_TOTAL_UNPAID_PAYABLE_DUE_INTEREST = "totalUnpaidPayableDueInterest";
  @SerializedName(SERIALIZED_NAME_TOTAL_UNPAID_PAYABLE_DUE_INTEREST)
  private BigDecimal totalUnpaidPayableDueInterest;

  public static final String SERIALIZED_NAME_TOTAL_UNPAID_PAYABLE_NOT_DUE_INTEREST = "totalUnpaidPayableNotDueInterest";
  @SerializedName(SERIALIZED_NAME_TOTAL_UNPAID_PAYABLE_NOT_DUE_INTEREST)
  private BigDecimal totalUnpaidPayableNotDueInterest;

  public static final String SERIALIZED_NAME_TOTAL_WAIVED = "totalWaived";
  @SerializedName(SERIALIZED_NAME_TOTAL_WAIVED)
  private BigDecimal totalWaived;

  public static final String SERIALIZED_NAME_TOTAL_WRITTEN_OFF = "totalWrittenOff";
  @SerializedName(SERIALIZED_NAME_TOTAL_WRITTEN_OFF)
  private BigDecimal totalWrittenOff;

  public static final String SERIALIZED_NAME_WRITEOFF_REASON = "writeoffReason";
  @SerializedName(SERIALIZED_NAME_WRITEOFF_REASON)
  private String writeoffReason;

  public static final String SERIALIZED_NAME_WRITEOFF_REASON_ID = "writeoffReasonId";
  @SerializedName(SERIALIZED_NAME_WRITEOFF_REASON_ID)
  private Long writeoffReasonId;

  public GetLoansLoanIdSummary() {
  }

  public GetLoansLoanIdSummary canDisburse(Boolean canDisburse) {
    
    this.canDisburse = canDisburse;
    return this;
  }

  /**
   * Get canDisburse
   * @return canDisburse
   */
  @javax.annotation.Nullable

  public Boolean getCanDisburse() {
    return canDisburse;
  }


  public void setCanDisburse(Boolean canDisburse) {
    this.canDisburse = canDisburse;
  }

  public GetLoansLoanIdSummary chargeOffReason(String chargeOffReason) {
    
    this.chargeOffReason = chargeOffReason;
    return this;
  }

  /**
   * Get chargeOffReason
   * @return chargeOffReason
   */
  @javax.annotation.Nullable

  public String getChargeOffReason() {
    return chargeOffReason;
  }


  public void setChargeOffReason(String chargeOffReason) {
    this.chargeOffReason = chargeOffReason;
  }

  public GetLoansLoanIdSummary chargeOffReasonId(Long chargeOffReasonId) {
    
    this.chargeOffReasonId = chargeOffReasonId;
    return this;
  }

  /**
   * Get chargeOffReasonId
   * @return chargeOffReasonId
   */
  @javax.annotation.Nullable

  public Long getChargeOffReasonId() {
    return chargeOffReasonId;
  }


  public void setChargeOffReasonId(Long chargeOffReasonId) {
    this.chargeOffReasonId = chargeOffReasonId;
  }

  public GetLoansLoanIdSummary currency(GetLoansLoanIdCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(GetLoansLoanIdCurrency currency) {
    this.currency = currency;
  }

  public GetLoansLoanIdSummary disbursementDetails(Set<GetLoansLoanIdDisbursementDetails> disbursementDetails) {
    
    this.disbursementDetails = disbursementDetails;
    return this;
  }

  public GetLoansLoanIdSummary addDisbursementDetailsItem(GetLoansLoanIdDisbursementDetails disbursementDetailsItem) {
    if (this.disbursementDetails == null) {
      this.disbursementDetails = new LinkedHashSet<>();
    }
    this.disbursementDetails.add(disbursementDetailsItem);
    return this;
  }

  /**
   * Get disbursementDetails
   * @return disbursementDetails
   */
  @javax.annotation.Nullable

  public Set<GetLoansLoanIdDisbursementDetails> getDisbursementDetails() {
    return disbursementDetails;
  }


  public void setDisbursementDetails(Set<GetLoansLoanIdDisbursementDetails> disbursementDetails) {
    this.disbursementDetails = disbursementDetails;
  }

  public GetLoansLoanIdSummary feeAdjustments(BigDecimal feeAdjustments) {
    
    this.feeAdjustments = feeAdjustments;
    return this;
  }

  /**
   * Get feeAdjustments
   * @return feeAdjustments
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeAdjustments() {
    return feeAdjustments;
  }


  public void setFeeAdjustments(BigDecimal feeAdjustments) {
    this.feeAdjustments = feeAdjustments;
  }

  public GetLoansLoanIdSummary feeChargesCharged(BigDecimal feeChargesCharged) {
    
    this.feeChargesCharged = feeChargesCharged;
    return this;
  }

  /**
   * Get feeChargesCharged
   * @return feeChargesCharged
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesCharged() {
    return feeChargesCharged;
  }


  public void setFeeChargesCharged(BigDecimal feeChargesCharged) {
    this.feeChargesCharged = feeChargesCharged;
  }

  public GetLoansLoanIdSummary feeChargesDueAtDisbursementCharged(BigDecimal feeChargesDueAtDisbursementCharged) {
    
    this.feeChargesDueAtDisbursementCharged = feeChargesDueAtDisbursementCharged;
    return this;
  }

  /**
   * Get feeChargesDueAtDisbursementCharged
   * @return feeChargesDueAtDisbursementCharged
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesDueAtDisbursementCharged() {
    return feeChargesDueAtDisbursementCharged;
  }


  public void setFeeChargesDueAtDisbursementCharged(BigDecimal feeChargesDueAtDisbursementCharged) {
    this.feeChargesDueAtDisbursementCharged = feeChargesDueAtDisbursementCharged;
  }

  public GetLoansLoanIdSummary feeChargesOutstanding(BigDecimal feeChargesOutstanding) {
    
    this.feeChargesOutstanding = feeChargesOutstanding;
    return this;
  }

  /**
   * Get feeChargesOutstanding
   * @return feeChargesOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesOutstanding() {
    return feeChargesOutstanding;
  }


  public void setFeeChargesOutstanding(BigDecimal feeChargesOutstanding) {
    this.feeChargesOutstanding = feeChargesOutstanding;
  }

  public GetLoansLoanIdSummary feeChargesOverdue(BigDecimal feeChargesOverdue) {
    
    this.feeChargesOverdue = feeChargesOverdue;
    return this;
  }

  /**
   * Get feeChargesOverdue
   * @return feeChargesOverdue
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesOverdue() {
    return feeChargesOverdue;
  }


  public void setFeeChargesOverdue(BigDecimal feeChargesOverdue) {
    this.feeChargesOverdue = feeChargesOverdue;
  }

  public GetLoansLoanIdSummary feeChargesPaid(BigDecimal feeChargesPaid) {
    
    this.feeChargesPaid = feeChargesPaid;
    return this;
  }

  /**
   * Get feeChargesPaid
   * @return feeChargesPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesPaid() {
    return feeChargesPaid;
  }


  public void setFeeChargesPaid(BigDecimal feeChargesPaid) {
    this.feeChargesPaid = feeChargesPaid;
  }

  public GetLoansLoanIdSummary feeChargesWaived(BigDecimal feeChargesWaived) {
    
    this.feeChargesWaived = feeChargesWaived;
    return this;
  }

  /**
   * Get feeChargesWaived
   * @return feeChargesWaived
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesWaived() {
    return feeChargesWaived;
  }


  public void setFeeChargesWaived(BigDecimal feeChargesWaived) {
    this.feeChargesWaived = feeChargesWaived;
  }

  public GetLoansLoanIdSummary feeChargesWrittenOff(BigDecimal feeChargesWrittenOff) {
    
    this.feeChargesWrittenOff = feeChargesWrittenOff;
    return this;
  }

  /**
   * Get feeChargesWrittenOff
   * @return feeChargesWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesWrittenOff() {
    return feeChargesWrittenOff;
  }


  public void setFeeChargesWrittenOff(BigDecimal feeChargesWrittenOff) {
    this.feeChargesWrittenOff = feeChargesWrittenOff;
  }

  public GetLoansLoanIdSummary fixedEmiAmount(BigDecimal fixedEmiAmount) {
    
    this.fixedEmiAmount = fixedEmiAmount;
    return this;
  }

  /**
   * Get fixedEmiAmount
   * @return fixedEmiAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedEmiAmount() {
    return fixedEmiAmount;
  }


  public void setFixedEmiAmount(BigDecimal fixedEmiAmount) {
    this.fixedEmiAmount = fixedEmiAmount;
  }

  public GetLoansLoanIdSummary inArrears(Boolean inArrears) {
    
    this.inArrears = inArrears;
    return this;
  }

  /**
   * Get inArrears
   * @return inArrears
   */
  @javax.annotation.Nullable

  public Boolean getInArrears() {
    return inArrears;
  }


  public void setInArrears(Boolean inArrears) {
    this.inArrears = inArrears;
  }

  public GetLoansLoanIdSummary interestCharged(BigDecimal interestCharged) {
    
    this.interestCharged = interestCharged;
    return this;
  }

  /**
   * Get interestCharged
   * @return interestCharged
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestCharged() {
    return interestCharged;
  }


  public void setInterestCharged(BigDecimal interestCharged) {
    this.interestCharged = interestCharged;
  }

  public GetLoansLoanIdSummary interestOutstanding(BigDecimal interestOutstanding) {
    
    this.interestOutstanding = interestOutstanding;
    return this;
  }

  /**
   * Get interestOutstanding
   * @return interestOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestOutstanding() {
    return interestOutstanding;
  }


  public void setInterestOutstanding(BigDecimal interestOutstanding) {
    this.interestOutstanding = interestOutstanding;
  }

  public GetLoansLoanIdSummary interestOverdue(BigDecimal interestOverdue) {
    
    this.interestOverdue = interestOverdue;
    return this;
  }

  /**
   * Get interestOverdue
   * @return interestOverdue
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestOverdue() {
    return interestOverdue;
  }


  public void setInterestOverdue(BigDecimal interestOverdue) {
    this.interestOverdue = interestOverdue;
  }

  public GetLoansLoanIdSummary interestPaid(BigDecimal interestPaid) {
    
    this.interestPaid = interestPaid;
    return this;
  }

  /**
   * Get interestPaid
   * @return interestPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestPaid() {
    return interestPaid;
  }


  public void setInterestPaid(BigDecimal interestPaid) {
    this.interestPaid = interestPaid;
  }

  public GetLoansLoanIdSummary interestWaived(BigDecimal interestWaived) {
    
    this.interestWaived = interestWaived;
    return this;
  }

  /**
   * Get interestWaived
   * @return interestWaived
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestWaived() {
    return interestWaived;
  }


  public void setInterestWaived(BigDecimal interestWaived) {
    this.interestWaived = interestWaived;
  }

  public GetLoansLoanIdSummary interestWrittenOff(BigDecimal interestWrittenOff) {
    
    this.interestWrittenOff = interestWrittenOff;
    return this;
  }

  /**
   * Get interestWrittenOff
   * @return interestWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestWrittenOff() {
    return interestWrittenOff;
  }


  public void setInterestWrittenOff(BigDecimal interestWrittenOff) {
    this.interestWrittenOff = interestWrittenOff;
  }

  public GetLoansLoanIdSummary isNPA(Boolean isNPA) {
    
    this.isNPA = isNPA;
    return this;
  }

  /**
   * Get isNPA
   * @return isNPA
   */
  @javax.annotation.Nullable

  public Boolean getIsNPA() {
    return isNPA;
  }


  public void setIsNPA(Boolean isNPA) {
    this.isNPA = isNPA;
  }

  public GetLoansLoanIdSummary linkedAccount(GetLoansLoanIdLinkedAccount linkedAccount) {
    
    this.linkedAccount = linkedAccount;
    return this;
  }

  /**
   * Get linkedAccount
   * @return linkedAccount
   */
  @javax.annotation.Nullable

  public GetLoansLoanIdLinkedAccount getLinkedAccount() {
    return linkedAccount;
  }


  public void setLinkedAccount(GetLoansLoanIdLinkedAccount linkedAccount) {
    this.linkedAccount = linkedAccount;
  }

  public GetLoansLoanIdSummary maxOutstandingLoanBalance(BigDecimal maxOutstandingLoanBalance) {
    
    this.maxOutstandingLoanBalance = maxOutstandingLoanBalance;
    return this;
  }

  /**
   * Get maxOutstandingLoanBalance
   * @return maxOutstandingLoanBalance
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxOutstandingLoanBalance() {
    return maxOutstandingLoanBalance;
  }


  public void setMaxOutstandingLoanBalance(BigDecimal maxOutstandingLoanBalance) {
    this.maxOutstandingLoanBalance = maxOutstandingLoanBalance;
  }

  public GetLoansLoanIdSummary overdueCharges(Set<GetLoansLoanIdOverdueCharges> overdueCharges) {
    
    this.overdueCharges = overdueCharges;
    return this;
  }

  public GetLoansLoanIdSummary addOverdueChargesItem(GetLoansLoanIdOverdueCharges overdueChargesItem) {
    if (this.overdueCharges == null) {
      this.overdueCharges = new LinkedHashSet<>();
    }
    this.overdueCharges.add(overdueChargesItem);
    return this;
  }

  /**
   * Get overdueCharges
   * @return overdueCharges
   */
  @javax.annotation.Nullable

  public Set<GetLoansLoanIdOverdueCharges> getOverdueCharges() {
    return overdueCharges;
  }


  public void setOverdueCharges(Set<GetLoansLoanIdOverdueCharges> overdueCharges) {
    this.overdueCharges = overdueCharges;
  }

  public GetLoansLoanIdSummary overdueSinceDate(LocalDate overdueSinceDate) {
    
    this.overdueSinceDate = overdueSinceDate;
    return this;
  }

  /**
   * Get overdueSinceDate
   * @return overdueSinceDate
   */
  @javax.annotation.Nullable

  public LocalDate getOverdueSinceDate() {
    return overdueSinceDate;
  }


  public void setOverdueSinceDate(LocalDate overdueSinceDate) {
    this.overdueSinceDate = overdueSinceDate;
  }

  public GetLoansLoanIdSummary penaltyAdjustments(BigDecimal penaltyAdjustments) {
    
    this.penaltyAdjustments = penaltyAdjustments;
    return this;
  }

  /**
   * Get penaltyAdjustments
   * @return penaltyAdjustments
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyAdjustments() {
    return penaltyAdjustments;
  }


  public void setPenaltyAdjustments(BigDecimal penaltyAdjustments) {
    this.penaltyAdjustments = penaltyAdjustments;
  }

  public GetLoansLoanIdSummary penaltyChargesCharged(BigDecimal penaltyChargesCharged) {
    
    this.penaltyChargesCharged = penaltyChargesCharged;
    return this;
  }

  /**
   * Get penaltyChargesCharged
   * @return penaltyChargesCharged
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesCharged() {
    return penaltyChargesCharged;
  }


  public void setPenaltyChargesCharged(BigDecimal penaltyChargesCharged) {
    this.penaltyChargesCharged = penaltyChargesCharged;
  }

  public GetLoansLoanIdSummary penaltyChargesOutstanding(BigDecimal penaltyChargesOutstanding) {
    
    this.penaltyChargesOutstanding = penaltyChargesOutstanding;
    return this;
  }

  /**
   * Get penaltyChargesOutstanding
   * @return penaltyChargesOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesOutstanding() {
    return penaltyChargesOutstanding;
  }


  public void setPenaltyChargesOutstanding(BigDecimal penaltyChargesOutstanding) {
    this.penaltyChargesOutstanding = penaltyChargesOutstanding;
  }

  public GetLoansLoanIdSummary penaltyChargesOverdue(BigDecimal penaltyChargesOverdue) {
    
    this.penaltyChargesOverdue = penaltyChargesOverdue;
    return this;
  }

  /**
   * Get penaltyChargesOverdue
   * @return penaltyChargesOverdue
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesOverdue() {
    return penaltyChargesOverdue;
  }


  public void setPenaltyChargesOverdue(BigDecimal penaltyChargesOverdue) {
    this.penaltyChargesOverdue = penaltyChargesOverdue;
  }

  public GetLoansLoanIdSummary penaltyChargesPaid(BigDecimal penaltyChargesPaid) {
    
    this.penaltyChargesPaid = penaltyChargesPaid;
    return this;
  }

  /**
   * Get penaltyChargesPaid
   * @return penaltyChargesPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesPaid() {
    return penaltyChargesPaid;
  }


  public void setPenaltyChargesPaid(BigDecimal penaltyChargesPaid) {
    this.penaltyChargesPaid = penaltyChargesPaid;
  }

  public GetLoansLoanIdSummary penaltyChargesWaived(BigDecimal penaltyChargesWaived) {
    
    this.penaltyChargesWaived = penaltyChargesWaived;
    return this;
  }

  /**
   * Get penaltyChargesWaived
   * @return penaltyChargesWaived
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesWaived() {
    return penaltyChargesWaived;
  }


  public void setPenaltyChargesWaived(BigDecimal penaltyChargesWaived) {
    this.penaltyChargesWaived = penaltyChargesWaived;
  }

  public GetLoansLoanIdSummary penaltyChargesWrittenOff(BigDecimal penaltyChargesWrittenOff) {
    
    this.penaltyChargesWrittenOff = penaltyChargesWrittenOff;
    return this;
  }

  /**
   * Get penaltyChargesWrittenOff
   * @return penaltyChargesWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesWrittenOff() {
    return penaltyChargesWrittenOff;
  }


  public void setPenaltyChargesWrittenOff(BigDecimal penaltyChargesWrittenOff) {
    this.penaltyChargesWrittenOff = penaltyChargesWrittenOff;
  }

  public GetLoansLoanIdSummary principalAdjustments(BigDecimal principalAdjustments) {
    
    this.principalAdjustments = principalAdjustments;
    return this;
  }

  /**
   * Get principalAdjustments
   * @return principalAdjustments
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalAdjustments() {
    return principalAdjustments;
  }


  public void setPrincipalAdjustments(BigDecimal principalAdjustments) {
    this.principalAdjustments = principalAdjustments;
  }

  public GetLoansLoanIdSummary principalDisbursed(BigDecimal principalDisbursed) {
    
    this.principalDisbursed = principalDisbursed;
    return this;
  }

  /**
   * Get principalDisbursed
   * @return principalDisbursed
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalDisbursed() {
    return principalDisbursed;
  }


  public void setPrincipalDisbursed(BigDecimal principalDisbursed) {
    this.principalDisbursed = principalDisbursed;
  }

  public GetLoansLoanIdSummary principalOutstanding(BigDecimal principalOutstanding) {
    
    this.principalOutstanding = principalOutstanding;
    return this;
  }

  /**
   * Get principalOutstanding
   * @return principalOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalOutstanding() {
    return principalOutstanding;
  }


  public void setPrincipalOutstanding(BigDecimal principalOutstanding) {
    this.principalOutstanding = principalOutstanding;
  }

  public GetLoansLoanIdSummary principalOverdue(BigDecimal principalOverdue) {
    
    this.principalOverdue = principalOverdue;
    return this;
  }

  /**
   * Get principalOverdue
   * @return principalOverdue
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalOverdue() {
    return principalOverdue;
  }


  public void setPrincipalOverdue(BigDecimal principalOverdue) {
    this.principalOverdue = principalOverdue;
  }

  public GetLoansLoanIdSummary principalPaid(BigDecimal principalPaid) {
    
    this.principalPaid = principalPaid;
    return this;
  }

  /**
   * Get principalPaid
   * @return principalPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalPaid() {
    return principalPaid;
  }


  public void setPrincipalPaid(BigDecimal principalPaid) {
    this.principalPaid = principalPaid;
  }

  public GetLoansLoanIdSummary principalWrittenOff(BigDecimal principalWrittenOff) {
    
    this.principalWrittenOff = principalWrittenOff;
    return this;
  }

  /**
   * Get principalWrittenOff
   * @return principalWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalWrittenOff() {
    return principalWrittenOff;
  }


  public void setPrincipalWrittenOff(BigDecimal principalWrittenOff) {
    this.principalWrittenOff = principalWrittenOff;
  }

  public GetLoansLoanIdSummary totalCapitalizedIncome(BigDecimal totalCapitalizedIncome) {
    
    this.totalCapitalizedIncome = totalCapitalizedIncome;
    return this;
  }

  /**
   * Get totalCapitalizedIncome
   * @return totalCapitalizedIncome
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalCapitalizedIncome() {
    return totalCapitalizedIncome;
  }


  public void setTotalCapitalizedIncome(BigDecimal totalCapitalizedIncome) {
    this.totalCapitalizedIncome = totalCapitalizedIncome;
  }

  public GetLoansLoanIdSummary totalChargeAdjustment(BigDecimal totalChargeAdjustment) {
    
    this.totalChargeAdjustment = totalChargeAdjustment;
    return this;
  }

  /**
   * Get totalChargeAdjustment
   * @return totalChargeAdjustment
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalChargeAdjustment() {
    return totalChargeAdjustment;
  }


  public void setTotalChargeAdjustment(BigDecimal totalChargeAdjustment) {
    this.totalChargeAdjustment = totalChargeAdjustment;
  }

  public GetLoansLoanIdSummary totalChargeAdjustmentReversed(BigDecimal totalChargeAdjustmentReversed) {
    
    this.totalChargeAdjustmentReversed = totalChargeAdjustmentReversed;
    return this;
  }

  /**
   * Get totalChargeAdjustmentReversed
   * @return totalChargeAdjustmentReversed
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalChargeAdjustmentReversed() {
    return totalChargeAdjustmentReversed;
  }


  public void setTotalChargeAdjustmentReversed(BigDecimal totalChargeAdjustmentReversed) {
    this.totalChargeAdjustmentReversed = totalChargeAdjustmentReversed;
  }

  public GetLoansLoanIdSummary totalChargeback(BigDecimal totalChargeback) {
    
    this.totalChargeback = totalChargeback;
    return this;
  }

  /**
   * Get totalChargeback
   * @return totalChargeback
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalChargeback() {
    return totalChargeback;
  }


  public void setTotalChargeback(BigDecimal totalChargeback) {
    this.totalChargeback = totalChargeback;
  }

  public GetLoansLoanIdSummary totalCostOfLoan(BigDecimal totalCostOfLoan) {
    
    this.totalCostOfLoan = totalCostOfLoan;
    return this;
  }

  /**
   * Get totalCostOfLoan
   * @return totalCostOfLoan
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalCostOfLoan() {
    return totalCostOfLoan;
  }


  public void setTotalCostOfLoan(BigDecimal totalCostOfLoan) {
    this.totalCostOfLoan = totalCostOfLoan;
  }

  public GetLoansLoanIdSummary totalCreditBalanceRefund(BigDecimal totalCreditBalanceRefund) {
    
    this.totalCreditBalanceRefund = totalCreditBalanceRefund;
    return this;
  }

  /**
   * Get totalCreditBalanceRefund
   * @return totalCreditBalanceRefund
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalCreditBalanceRefund() {
    return totalCreditBalanceRefund;
  }


  public void setTotalCreditBalanceRefund(BigDecimal totalCreditBalanceRefund) {
    this.totalCreditBalanceRefund = totalCreditBalanceRefund;
  }

  public GetLoansLoanIdSummary totalCreditBalanceRefundReversed(BigDecimal totalCreditBalanceRefundReversed) {
    
    this.totalCreditBalanceRefundReversed = totalCreditBalanceRefundReversed;
    return this;
  }

  /**
   * Get totalCreditBalanceRefundReversed
   * @return totalCreditBalanceRefundReversed
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalCreditBalanceRefundReversed() {
    return totalCreditBalanceRefundReversed;
  }


  public void setTotalCreditBalanceRefundReversed(BigDecimal totalCreditBalanceRefundReversed) {
    this.totalCreditBalanceRefundReversed = totalCreditBalanceRefundReversed;
  }

  public GetLoansLoanIdSummary totalExpectedCostOfLoan(BigDecimal totalExpectedCostOfLoan) {
    
    this.totalExpectedCostOfLoan = totalExpectedCostOfLoan;
    return this;
  }

  /**
   * Get totalExpectedCostOfLoan
   * @return totalExpectedCostOfLoan
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalExpectedCostOfLoan() {
    return totalExpectedCostOfLoan;
  }


  public void setTotalExpectedCostOfLoan(BigDecimal totalExpectedCostOfLoan) {
    this.totalExpectedCostOfLoan = totalExpectedCostOfLoan;
  }

  public GetLoansLoanIdSummary totalExpectedRepayment(BigDecimal totalExpectedRepayment) {
    
    this.totalExpectedRepayment = totalExpectedRepayment;
    return this;
  }

  /**
   * Get totalExpectedRepayment
   * @return totalExpectedRepayment
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalExpectedRepayment() {
    return totalExpectedRepayment;
  }


  public void setTotalExpectedRepayment(BigDecimal totalExpectedRepayment) {
    this.totalExpectedRepayment = totalExpectedRepayment;
  }

  public GetLoansLoanIdSummary totalGoodwillCredit(BigDecimal totalGoodwillCredit) {
    
    this.totalGoodwillCredit = totalGoodwillCredit;
    return this;
  }

  /**
   * Get totalGoodwillCredit
   * @return totalGoodwillCredit
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalGoodwillCredit() {
    return totalGoodwillCredit;
  }


  public void setTotalGoodwillCredit(BigDecimal totalGoodwillCredit) {
    this.totalGoodwillCredit = totalGoodwillCredit;
  }

  public GetLoansLoanIdSummary totalGoodwillCreditReversed(BigDecimal totalGoodwillCreditReversed) {
    
    this.totalGoodwillCreditReversed = totalGoodwillCreditReversed;
    return this;
  }

  /**
   * Get totalGoodwillCreditReversed
   * @return totalGoodwillCreditReversed
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalGoodwillCreditReversed() {
    return totalGoodwillCreditReversed;
  }


  public void setTotalGoodwillCreditReversed(BigDecimal totalGoodwillCreditReversed) {
    this.totalGoodwillCreditReversed = totalGoodwillCreditReversed;
  }

  public GetLoansLoanIdSummary totalInterestPaymentWaiver(BigDecimal totalInterestPaymentWaiver) {
    
    this.totalInterestPaymentWaiver = totalInterestPaymentWaiver;
    return this;
  }

  /**
   * Get totalInterestPaymentWaiver
   * @return totalInterestPaymentWaiver
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalInterestPaymentWaiver() {
    return totalInterestPaymentWaiver;
  }


  public void setTotalInterestPaymentWaiver(BigDecimal totalInterestPaymentWaiver) {
    this.totalInterestPaymentWaiver = totalInterestPaymentWaiver;
  }

  public GetLoansLoanIdSummary totalInterestRefund(BigDecimal totalInterestRefund) {
    
    this.totalInterestRefund = totalInterestRefund;
    return this;
  }

  /**
   * Get totalInterestRefund
   * @return totalInterestRefund
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalInterestRefund() {
    return totalInterestRefund;
  }


  public void setTotalInterestRefund(BigDecimal totalInterestRefund) {
    this.totalInterestRefund = totalInterestRefund;
  }

  public GetLoansLoanIdSummary totalMerchantRefund(BigDecimal totalMerchantRefund) {
    
    this.totalMerchantRefund = totalMerchantRefund;
    return this;
  }

  /**
   * Get totalMerchantRefund
   * @return totalMerchantRefund
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalMerchantRefund() {
    return totalMerchantRefund;
  }


  public void setTotalMerchantRefund(BigDecimal totalMerchantRefund) {
    this.totalMerchantRefund = totalMerchantRefund;
  }

  public GetLoansLoanIdSummary totalMerchantRefundReversed(BigDecimal totalMerchantRefundReversed) {
    
    this.totalMerchantRefundReversed = totalMerchantRefundReversed;
    return this;
  }

  /**
   * Get totalMerchantRefundReversed
   * @return totalMerchantRefundReversed
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalMerchantRefundReversed() {
    return totalMerchantRefundReversed;
  }


  public void setTotalMerchantRefundReversed(BigDecimal totalMerchantRefundReversed) {
    this.totalMerchantRefundReversed = totalMerchantRefundReversed;
  }

  public GetLoansLoanIdSummary totalOutstanding(BigDecimal totalOutstanding) {
    
    this.totalOutstanding = totalOutstanding;
    return this;
  }

  /**
   * Get totalOutstanding
   * @return totalOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalOutstanding() {
    return totalOutstanding;
  }


  public void setTotalOutstanding(BigDecimal totalOutstanding) {
    this.totalOutstanding = totalOutstanding;
  }

  public GetLoansLoanIdSummary totalOverdue(BigDecimal totalOverdue) {
    
    this.totalOverdue = totalOverdue;
    return this;
  }

  /**
   * Get totalOverdue
   * @return totalOverdue
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalOverdue() {
    return totalOverdue;
  }


  public void setTotalOverdue(BigDecimal totalOverdue) {
    this.totalOverdue = totalOverdue;
  }

  public GetLoansLoanIdSummary totalPayoutRefund(BigDecimal totalPayoutRefund) {
    
    this.totalPayoutRefund = totalPayoutRefund;
    return this;
  }

  /**
   * Get totalPayoutRefund
   * @return totalPayoutRefund
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPayoutRefund() {
    return totalPayoutRefund;
  }


  public void setTotalPayoutRefund(BigDecimal totalPayoutRefund) {
    this.totalPayoutRefund = totalPayoutRefund;
  }

  public GetLoansLoanIdSummary totalPayoutRefundReversed(BigDecimal totalPayoutRefundReversed) {
    
    this.totalPayoutRefundReversed = totalPayoutRefundReversed;
    return this;
  }

  /**
   * Get totalPayoutRefundReversed
   * @return totalPayoutRefundReversed
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPayoutRefundReversed() {
    return totalPayoutRefundReversed;
  }


  public void setTotalPayoutRefundReversed(BigDecimal totalPayoutRefundReversed) {
    this.totalPayoutRefundReversed = totalPayoutRefundReversed;
  }

  public GetLoansLoanIdSummary totalPrincipal(BigDecimal totalPrincipal) {
    
    this.totalPrincipal = totalPrincipal;
    return this;
  }

  /**
   * Get totalPrincipal
   * @return totalPrincipal
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPrincipal() {
    return totalPrincipal;
  }


  public void setTotalPrincipal(BigDecimal totalPrincipal) {
    this.totalPrincipal = totalPrincipal;
  }

  public GetLoansLoanIdSummary totalRecovered(BigDecimal totalRecovered) {
    
    this.totalRecovered = totalRecovered;
    return this;
  }

  /**
   * Get totalRecovered
   * @return totalRecovered
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalRecovered() {
    return totalRecovered;
  }


  public void setTotalRecovered(BigDecimal totalRecovered) {
    this.totalRecovered = totalRecovered;
  }

  public GetLoansLoanIdSummary totalRepayment(BigDecimal totalRepayment) {
    
    this.totalRepayment = totalRepayment;
    return this;
  }

  /**
   * Get totalRepayment
   * @return totalRepayment
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalRepayment() {
    return totalRepayment;
  }


  public void setTotalRepayment(BigDecimal totalRepayment) {
    this.totalRepayment = totalRepayment;
  }

  public GetLoansLoanIdSummary totalRepaymentTransaction(BigDecimal totalRepaymentTransaction) {
    
    this.totalRepaymentTransaction = totalRepaymentTransaction;
    return this;
  }

  /**
   * Get totalRepaymentTransaction
   * @return totalRepaymentTransaction
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalRepaymentTransaction() {
    return totalRepaymentTransaction;
  }


  public void setTotalRepaymentTransaction(BigDecimal totalRepaymentTransaction) {
    this.totalRepaymentTransaction = totalRepaymentTransaction;
  }

  public GetLoansLoanIdSummary totalRepaymentTransactionReversed(BigDecimal totalRepaymentTransactionReversed) {
    
    this.totalRepaymentTransactionReversed = totalRepaymentTransactionReversed;
    return this;
  }

  /**
   * Get totalRepaymentTransactionReversed
   * @return totalRepaymentTransactionReversed
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalRepaymentTransactionReversed() {
    return totalRepaymentTransactionReversed;
  }


  public void setTotalRepaymentTransactionReversed(BigDecimal totalRepaymentTransactionReversed) {
    this.totalRepaymentTransactionReversed = totalRepaymentTransactionReversed;
  }

  public GetLoansLoanIdSummary totalUnpaidPayableDueInterest(BigDecimal totalUnpaidPayableDueInterest) {
    
    this.totalUnpaidPayableDueInterest = totalUnpaidPayableDueInterest;
    return this;
  }

  /**
   * Get totalUnpaidPayableDueInterest
   * @return totalUnpaidPayableDueInterest
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalUnpaidPayableDueInterest() {
    return totalUnpaidPayableDueInterest;
  }


  public void setTotalUnpaidPayableDueInterest(BigDecimal totalUnpaidPayableDueInterest) {
    this.totalUnpaidPayableDueInterest = totalUnpaidPayableDueInterest;
  }

  public GetLoansLoanIdSummary totalUnpaidPayableNotDueInterest(BigDecimal totalUnpaidPayableNotDueInterest) {
    
    this.totalUnpaidPayableNotDueInterest = totalUnpaidPayableNotDueInterest;
    return this;
  }

  /**
   * Get totalUnpaidPayableNotDueInterest
   * @return totalUnpaidPayableNotDueInterest
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalUnpaidPayableNotDueInterest() {
    return totalUnpaidPayableNotDueInterest;
  }


  public void setTotalUnpaidPayableNotDueInterest(BigDecimal totalUnpaidPayableNotDueInterest) {
    this.totalUnpaidPayableNotDueInterest = totalUnpaidPayableNotDueInterest;
  }

  public GetLoansLoanIdSummary totalWaived(BigDecimal totalWaived) {
    
    this.totalWaived = totalWaived;
    return this;
  }

  /**
   * Get totalWaived
   * @return totalWaived
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalWaived() {
    return totalWaived;
  }


  public void setTotalWaived(BigDecimal totalWaived) {
    this.totalWaived = totalWaived;
  }

  public GetLoansLoanIdSummary totalWrittenOff(BigDecimal totalWrittenOff) {
    
    this.totalWrittenOff = totalWrittenOff;
    return this;
  }

  /**
   * Get totalWrittenOff
   * @return totalWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalWrittenOff() {
    return totalWrittenOff;
  }


  public void setTotalWrittenOff(BigDecimal totalWrittenOff) {
    this.totalWrittenOff = totalWrittenOff;
  }

  public GetLoansLoanIdSummary writeoffReason(String writeoffReason) {
    
    this.writeoffReason = writeoffReason;
    return this;
  }

  /**
   * Get writeoffReason
   * @return writeoffReason
   */
  @javax.annotation.Nullable

  public String getWriteoffReason() {
    return writeoffReason;
  }


  public void setWriteoffReason(String writeoffReason) {
    this.writeoffReason = writeoffReason;
  }

  public GetLoansLoanIdSummary writeoffReasonId(Long writeoffReasonId) {
    
    this.writeoffReasonId = writeoffReasonId;
    return this;
  }

  /**
   * Get writeoffReasonId
   * @return writeoffReasonId
   */
  @javax.annotation.Nullable

  public Long getWriteoffReasonId() {
    return writeoffReasonId;
  }


  public void setWriteoffReasonId(Long writeoffReasonId) {
    this.writeoffReasonId = writeoffReasonId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetLoansLoanIdSummary getLoansLoanIdSummary = (GetLoansLoanIdSummary) o;
    return Objects.equals(this.canDisburse, getLoansLoanIdSummary.canDisburse) &&
        Objects.equals(this.chargeOffReason, getLoansLoanIdSummary.chargeOffReason) &&
        Objects.equals(this.chargeOffReasonId, getLoansLoanIdSummary.chargeOffReasonId) &&
        Objects.equals(this.currency, getLoansLoanIdSummary.currency) &&
        Objects.equals(this.disbursementDetails, getLoansLoanIdSummary.disbursementDetails) &&
        Objects.equals(this.feeAdjustments, getLoansLoanIdSummary.feeAdjustments) &&
        Objects.equals(this.feeChargesCharged, getLoansLoanIdSummary.feeChargesCharged) &&
        Objects.equals(this.feeChargesDueAtDisbursementCharged, getLoansLoanIdSummary.feeChargesDueAtDisbursementCharged) &&
        Objects.equals(this.feeChargesOutstanding, getLoansLoanIdSummary.feeChargesOutstanding) &&
        Objects.equals(this.feeChargesOverdue, getLoansLoanIdSummary.feeChargesOverdue) &&
        Objects.equals(this.feeChargesPaid, getLoansLoanIdSummary.feeChargesPaid) &&
        Objects.equals(this.feeChargesWaived, getLoansLoanIdSummary.feeChargesWaived) &&
        Objects.equals(this.feeChargesWrittenOff, getLoansLoanIdSummary.feeChargesWrittenOff) &&
        Objects.equals(this.fixedEmiAmount, getLoansLoanIdSummary.fixedEmiAmount) &&
        Objects.equals(this.inArrears, getLoansLoanIdSummary.inArrears) &&
        Objects.equals(this.interestCharged, getLoansLoanIdSummary.interestCharged) &&
        Objects.equals(this.interestOutstanding, getLoansLoanIdSummary.interestOutstanding) &&
        Objects.equals(this.interestOverdue, getLoansLoanIdSummary.interestOverdue) &&
        Objects.equals(this.interestPaid, getLoansLoanIdSummary.interestPaid) &&
        Objects.equals(this.interestWaived, getLoansLoanIdSummary.interestWaived) &&
        Objects.equals(this.interestWrittenOff, getLoansLoanIdSummary.interestWrittenOff) &&
        Objects.equals(this.isNPA, getLoansLoanIdSummary.isNPA) &&
        Objects.equals(this.linkedAccount, getLoansLoanIdSummary.linkedAccount) &&
        Objects.equals(this.maxOutstandingLoanBalance, getLoansLoanIdSummary.maxOutstandingLoanBalance) &&
        Objects.equals(this.overdueCharges, getLoansLoanIdSummary.overdueCharges) &&
        Objects.equals(this.overdueSinceDate, getLoansLoanIdSummary.overdueSinceDate) &&
        Objects.equals(this.penaltyAdjustments, getLoansLoanIdSummary.penaltyAdjustments) &&
        Objects.equals(this.penaltyChargesCharged, getLoansLoanIdSummary.penaltyChargesCharged) &&
        Objects.equals(this.penaltyChargesOutstanding, getLoansLoanIdSummary.penaltyChargesOutstanding) &&
        Objects.equals(this.penaltyChargesOverdue, getLoansLoanIdSummary.penaltyChargesOverdue) &&
        Objects.equals(this.penaltyChargesPaid, getLoansLoanIdSummary.penaltyChargesPaid) &&
        Objects.equals(this.penaltyChargesWaived, getLoansLoanIdSummary.penaltyChargesWaived) &&
        Objects.equals(this.penaltyChargesWrittenOff, getLoansLoanIdSummary.penaltyChargesWrittenOff) &&
        Objects.equals(this.principalAdjustments, getLoansLoanIdSummary.principalAdjustments) &&
        Objects.equals(this.principalDisbursed, getLoansLoanIdSummary.principalDisbursed) &&
        Objects.equals(this.principalOutstanding, getLoansLoanIdSummary.principalOutstanding) &&
        Objects.equals(this.principalOverdue, getLoansLoanIdSummary.principalOverdue) &&
        Objects.equals(this.principalPaid, getLoansLoanIdSummary.principalPaid) &&
        Objects.equals(this.principalWrittenOff, getLoansLoanIdSummary.principalWrittenOff) &&
        Objects.equals(this.totalCapitalizedIncome, getLoansLoanIdSummary.totalCapitalizedIncome) &&
        Objects.equals(this.totalChargeAdjustment, getLoansLoanIdSummary.totalChargeAdjustment) &&
        Objects.equals(this.totalChargeAdjustmentReversed, getLoansLoanIdSummary.totalChargeAdjustmentReversed) &&
        Objects.equals(this.totalChargeback, getLoansLoanIdSummary.totalChargeback) &&
        Objects.equals(this.totalCostOfLoan, getLoansLoanIdSummary.totalCostOfLoan) &&
        Objects.equals(this.totalCreditBalanceRefund, getLoansLoanIdSummary.totalCreditBalanceRefund) &&
        Objects.equals(this.totalCreditBalanceRefundReversed, getLoansLoanIdSummary.totalCreditBalanceRefundReversed) &&
        Objects.equals(this.totalExpectedCostOfLoan, getLoansLoanIdSummary.totalExpectedCostOfLoan) &&
        Objects.equals(this.totalExpectedRepayment, getLoansLoanIdSummary.totalExpectedRepayment) &&
        Objects.equals(this.totalGoodwillCredit, getLoansLoanIdSummary.totalGoodwillCredit) &&
        Objects.equals(this.totalGoodwillCreditReversed, getLoansLoanIdSummary.totalGoodwillCreditReversed) &&
        Objects.equals(this.totalInterestPaymentWaiver, getLoansLoanIdSummary.totalInterestPaymentWaiver) &&
        Objects.equals(this.totalInterestRefund, getLoansLoanIdSummary.totalInterestRefund) &&
        Objects.equals(this.totalMerchantRefund, getLoansLoanIdSummary.totalMerchantRefund) &&
        Objects.equals(this.totalMerchantRefundReversed, getLoansLoanIdSummary.totalMerchantRefundReversed) &&
        Objects.equals(this.totalOutstanding, getLoansLoanIdSummary.totalOutstanding) &&
        Objects.equals(this.totalOverdue, getLoansLoanIdSummary.totalOverdue) &&
        Objects.equals(this.totalPayoutRefund, getLoansLoanIdSummary.totalPayoutRefund) &&
        Objects.equals(this.totalPayoutRefundReversed, getLoansLoanIdSummary.totalPayoutRefundReversed) &&
        Objects.equals(this.totalPrincipal, getLoansLoanIdSummary.totalPrincipal) &&
        Objects.equals(this.totalRecovered, getLoansLoanIdSummary.totalRecovered) &&
        Objects.equals(this.totalRepayment, getLoansLoanIdSummary.totalRepayment) &&
        Objects.equals(this.totalRepaymentTransaction, getLoansLoanIdSummary.totalRepaymentTransaction) &&
        Objects.equals(this.totalRepaymentTransactionReversed, getLoansLoanIdSummary.totalRepaymentTransactionReversed) &&
        Objects.equals(this.totalUnpaidPayableDueInterest, getLoansLoanIdSummary.totalUnpaidPayableDueInterest) &&
        Objects.equals(this.totalUnpaidPayableNotDueInterest, getLoansLoanIdSummary.totalUnpaidPayableNotDueInterest) &&
        Objects.equals(this.totalWaived, getLoansLoanIdSummary.totalWaived) &&
        Objects.equals(this.totalWrittenOff, getLoansLoanIdSummary.totalWrittenOff) &&
        Objects.equals(this.writeoffReason, getLoansLoanIdSummary.writeoffReason) &&
        Objects.equals(this.writeoffReasonId, getLoansLoanIdSummary.writeoffReasonId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(canDisburse, chargeOffReason, chargeOffReasonId, currency, disbursementDetails, feeAdjustments, feeChargesCharged, feeChargesDueAtDisbursementCharged, feeChargesOutstanding, feeChargesOverdue, feeChargesPaid, feeChargesWaived, feeChargesWrittenOff, fixedEmiAmount, inArrears, interestCharged, interestOutstanding, interestOverdue, interestPaid, interestWaived, interestWrittenOff, isNPA, linkedAccount, maxOutstandingLoanBalance, overdueCharges, overdueSinceDate, penaltyAdjustments, penaltyChargesCharged, penaltyChargesOutstanding, penaltyChargesOverdue, penaltyChargesPaid, penaltyChargesWaived, penaltyChargesWrittenOff, principalAdjustments, principalDisbursed, principalOutstanding, principalOverdue, principalPaid, principalWrittenOff, totalCapitalizedIncome, totalChargeAdjustment, totalChargeAdjustmentReversed, totalChargeback, totalCostOfLoan, totalCreditBalanceRefund, totalCreditBalanceRefundReversed, totalExpectedCostOfLoan, totalExpectedRepayment, totalGoodwillCredit, totalGoodwillCreditReversed, totalInterestPaymentWaiver, totalInterestRefund, totalMerchantRefund, totalMerchantRefundReversed, totalOutstanding, totalOverdue, totalPayoutRefund, totalPayoutRefundReversed, totalPrincipal, totalRecovered, totalRepayment, totalRepaymentTransaction, totalRepaymentTransactionReversed, totalUnpaidPayableDueInterest, totalUnpaidPayableNotDueInterest, totalWaived, totalWrittenOff, writeoffReason, writeoffReasonId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetLoansLoanIdSummary {\n");
    sb.append("    canDisburse: ").append(toIndentedString(canDisburse)).append("\n");
    sb.append("    chargeOffReason: ").append(toIndentedString(chargeOffReason)).append("\n");
    sb.append("    chargeOffReasonId: ").append(toIndentedString(chargeOffReasonId)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    disbursementDetails: ").append(toIndentedString(disbursementDetails)).append("\n");
    sb.append("    feeAdjustments: ").append(toIndentedString(feeAdjustments)).append("\n");
    sb.append("    feeChargesCharged: ").append(toIndentedString(feeChargesCharged)).append("\n");
    sb.append("    feeChargesDueAtDisbursementCharged: ").append(toIndentedString(feeChargesDueAtDisbursementCharged)).append("\n");
    sb.append("    feeChargesOutstanding: ").append(toIndentedString(feeChargesOutstanding)).append("\n");
    sb.append("    feeChargesOverdue: ").append(toIndentedString(feeChargesOverdue)).append("\n");
    sb.append("    feeChargesPaid: ").append(toIndentedString(feeChargesPaid)).append("\n");
    sb.append("    feeChargesWaived: ").append(toIndentedString(feeChargesWaived)).append("\n");
    sb.append("    feeChargesWrittenOff: ").append(toIndentedString(feeChargesWrittenOff)).append("\n");
    sb.append("    fixedEmiAmount: ").append(toIndentedString(fixedEmiAmount)).append("\n");
    sb.append("    inArrears: ").append(toIndentedString(inArrears)).append("\n");
    sb.append("    interestCharged: ").append(toIndentedString(interestCharged)).append("\n");
    sb.append("    interestOutstanding: ").append(toIndentedString(interestOutstanding)).append("\n");
    sb.append("    interestOverdue: ").append(toIndentedString(interestOverdue)).append("\n");
    sb.append("    interestPaid: ").append(toIndentedString(interestPaid)).append("\n");
    sb.append("    interestWaived: ").append(toIndentedString(interestWaived)).append("\n");
    sb.append("    interestWrittenOff: ").append(toIndentedString(interestWrittenOff)).append("\n");
    sb.append("    isNPA: ").append(toIndentedString(isNPA)).append("\n");
    sb.append("    linkedAccount: ").append(toIndentedString(linkedAccount)).append("\n");
    sb.append("    maxOutstandingLoanBalance: ").append(toIndentedString(maxOutstandingLoanBalance)).append("\n");
    sb.append("    overdueCharges: ").append(toIndentedString(overdueCharges)).append("\n");
    sb.append("    overdueSinceDate: ").append(toIndentedString(overdueSinceDate)).append("\n");
    sb.append("    penaltyAdjustments: ").append(toIndentedString(penaltyAdjustments)).append("\n");
    sb.append("    penaltyChargesCharged: ").append(toIndentedString(penaltyChargesCharged)).append("\n");
    sb.append("    penaltyChargesOutstanding: ").append(toIndentedString(penaltyChargesOutstanding)).append("\n");
    sb.append("    penaltyChargesOverdue: ").append(toIndentedString(penaltyChargesOverdue)).append("\n");
    sb.append("    penaltyChargesPaid: ").append(toIndentedString(penaltyChargesPaid)).append("\n");
    sb.append("    penaltyChargesWaived: ").append(toIndentedString(penaltyChargesWaived)).append("\n");
    sb.append("    penaltyChargesWrittenOff: ").append(toIndentedString(penaltyChargesWrittenOff)).append("\n");
    sb.append("    principalAdjustments: ").append(toIndentedString(principalAdjustments)).append("\n");
    sb.append("    principalDisbursed: ").append(toIndentedString(principalDisbursed)).append("\n");
    sb.append("    principalOutstanding: ").append(toIndentedString(principalOutstanding)).append("\n");
    sb.append("    principalOverdue: ").append(toIndentedString(principalOverdue)).append("\n");
    sb.append("    principalPaid: ").append(toIndentedString(principalPaid)).append("\n");
    sb.append("    principalWrittenOff: ").append(toIndentedString(principalWrittenOff)).append("\n");
    sb.append("    totalCapitalizedIncome: ").append(toIndentedString(totalCapitalizedIncome)).append("\n");
    sb.append("    totalChargeAdjustment: ").append(toIndentedString(totalChargeAdjustment)).append("\n");
    sb.append("    totalChargeAdjustmentReversed: ").append(toIndentedString(totalChargeAdjustmentReversed)).append("\n");
    sb.append("    totalChargeback: ").append(toIndentedString(totalChargeback)).append("\n");
    sb.append("    totalCostOfLoan: ").append(toIndentedString(totalCostOfLoan)).append("\n");
    sb.append("    totalCreditBalanceRefund: ").append(toIndentedString(totalCreditBalanceRefund)).append("\n");
    sb.append("    totalCreditBalanceRefundReversed: ").append(toIndentedString(totalCreditBalanceRefundReversed)).append("\n");
    sb.append("    totalExpectedCostOfLoan: ").append(toIndentedString(totalExpectedCostOfLoan)).append("\n");
    sb.append("    totalExpectedRepayment: ").append(toIndentedString(totalExpectedRepayment)).append("\n");
    sb.append("    totalGoodwillCredit: ").append(toIndentedString(totalGoodwillCredit)).append("\n");
    sb.append("    totalGoodwillCreditReversed: ").append(toIndentedString(totalGoodwillCreditReversed)).append("\n");
    sb.append("    totalInterestPaymentWaiver: ").append(toIndentedString(totalInterestPaymentWaiver)).append("\n");
    sb.append("    totalInterestRefund: ").append(toIndentedString(totalInterestRefund)).append("\n");
    sb.append("    totalMerchantRefund: ").append(toIndentedString(totalMerchantRefund)).append("\n");
    sb.append("    totalMerchantRefundReversed: ").append(toIndentedString(totalMerchantRefundReversed)).append("\n");
    sb.append("    totalOutstanding: ").append(toIndentedString(totalOutstanding)).append("\n");
    sb.append("    totalOverdue: ").append(toIndentedString(totalOverdue)).append("\n");
    sb.append("    totalPayoutRefund: ").append(toIndentedString(totalPayoutRefund)).append("\n");
    sb.append("    totalPayoutRefundReversed: ").append(toIndentedString(totalPayoutRefundReversed)).append("\n");
    sb.append("    totalPrincipal: ").append(toIndentedString(totalPrincipal)).append("\n");
    sb.append("    totalRecovered: ").append(toIndentedString(totalRecovered)).append("\n");
    sb.append("    totalRepayment: ").append(toIndentedString(totalRepayment)).append("\n");
    sb.append("    totalRepaymentTransaction: ").append(toIndentedString(totalRepaymentTransaction)).append("\n");
    sb.append("    totalRepaymentTransactionReversed: ").append(toIndentedString(totalRepaymentTransactionReversed)).append("\n");
    sb.append("    totalUnpaidPayableDueInterest: ").append(toIndentedString(totalUnpaidPayableDueInterest)).append("\n");
    sb.append("    totalUnpaidPayableNotDueInterest: ").append(toIndentedString(totalUnpaidPayableNotDueInterest)).append("\n");
    sb.append("    totalWaived: ").append(toIndentedString(totalWaived)).append("\n");
    sb.append("    totalWrittenOff: ").append(toIndentedString(totalWrittenOff)).append("\n");
    sb.append("    writeoffReason: ").append(toIndentedString(writeoffReason)).append("\n");
    sb.append("    writeoffReasonId: ").append(toIndentedString(writeoffReasonId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

