/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.CodeValueData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GuarantorFundingData;
import org.apache.fineract.client.models.PortfolioAccountData;

/**
 * GuarantorData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GuarantorData {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private Long accountId;

  public static final String SERIALIZED_NAME_ACCOUNT_LINKING_OPTIONS = "accountLinkingOptions";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_LINKING_OPTIONS)
  private List<PortfolioAccountData> accountLinkingOptions;

  public static final String SERIALIZED_NAME_ADDRESS_LINE1 = "addressLine1";
  @SerializedName(SERIALIZED_NAME_ADDRESS_LINE1)
  private String addressLine1;

  public static final String SERIALIZED_NAME_ADDRESS_LINE2 = "addressLine2";
  @SerializedName(SERIALIZED_NAME_ADDRESS_LINE2)
  private String addressLine2;

  public static final String SERIALIZED_NAME_ALLOWED_CLIENT_RELATIONSHIP_TYPES = "allowedClientRelationshipTypes";
  @SerializedName(SERIALIZED_NAME_ALLOWED_CLIENT_RELATIONSHIP_TYPES)
  private List<CodeValueData> allowedClientRelationshipTypes;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_CITY = "city";
  @SerializedName(SERIALIZED_NAME_CITY)
  private String city;

  public static final String SERIALIZED_NAME_CLIENT_RELATIONSHIP_TYPE = "clientRelationshipType";
  @SerializedName(SERIALIZED_NAME_CLIENT_RELATIONSHIP_TYPE)
  private CodeValueData clientRelationshipType;

  public static final String SERIALIZED_NAME_CLIENT_RELATIONSHIP_TYPE_ID = "clientRelationshipTypeId";
  @SerializedName(SERIALIZED_NAME_CLIENT_RELATIONSHIP_TYPE_ID)
  private Integer clientRelationshipTypeId;

  public static final String SERIALIZED_NAME_COMMENT = "comment";
  @SerializedName(SERIALIZED_NAME_COMMENT)
  private String comment;

  public static final String SERIALIZED_NAME_COUNTRY = "country";
  @SerializedName(SERIALIZED_NAME_COUNTRY)
  private String country;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_DOB = "dob";
  @SerializedName(SERIALIZED_NAME_DOB)
  private LocalDate dob;

  public static final String SERIALIZED_NAME_ENTITY_ID = "entityId";
  @SerializedName(SERIALIZED_NAME_ENTITY_ID)
  private Long entityId;

  public static final String SERIALIZED_NAME_EXISTING_CLIENT = "existingClient";
  @SerializedName(SERIALIZED_NAME_EXISTING_CLIENT)
  private Boolean existingClient;

  public static final String SERIALIZED_NAME_EXTERNAL_GUARANTOR = "externalGuarantor";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_GUARANTOR)
  private Boolean externalGuarantor;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_FIRSTNAME = "firstname";
  @SerializedName(SERIALIZED_NAME_FIRSTNAME)
  private String firstname;

  public static final String SERIALIZED_NAME_GUARANTOR_FUNDING_DETAILS = "guarantorFundingDetails";
  @SerializedName(SERIALIZED_NAME_GUARANTOR_FUNDING_DETAILS)
  private List<GuarantorFundingData> guarantorFundingDetails;

  public static final String SERIALIZED_NAME_GUARANTOR_TYPE = "guarantorType";
  @SerializedName(SERIALIZED_NAME_GUARANTOR_TYPE)
  private EnumOptionData guarantorType;

  public static final String SERIALIZED_NAME_GUARANTOR_TYPE_ID = "guarantorTypeId";
  @SerializedName(SERIALIZED_NAME_GUARANTOR_TYPE_ID)
  private Integer guarantorTypeId;

  public static final String SERIALIZED_NAME_GUARANTOR_TYPE_OPTIONS = "guarantorTypeOptions";
  @SerializedName(SERIALIZED_NAME_GUARANTOR_TYPE_OPTIONS)
  private List<EnumOptionData> guarantorTypeOptions;

  public static final String SERIALIZED_NAME_HOUSE_PHONE_NUMBER = "housePhoneNumber";
  @SerializedName(SERIALIZED_NAME_HOUSE_PHONE_NUMBER)
  private String housePhoneNumber;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_JOINED_DATE = "joinedDate";
  @SerializedName(SERIALIZED_NAME_JOINED_DATE)
  private LocalDate joinedDate;

  public static final String SERIALIZED_NAME_LASTNAME = "lastname";
  @SerializedName(SERIALIZED_NAME_LASTNAME)
  private String lastname;

  public static final String SERIALIZED_NAME_LOAN_ID = "loanId";
  @SerializedName(SERIALIZED_NAME_LOAN_ID)
  private Long loanId;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_MOBILE_NUMBER = "mobileNumber";
  @SerializedName(SERIALIZED_NAME_MOBILE_NUMBER)
  private String mobileNumber;

  public static final String SERIALIZED_NAME_OFFICE_NAME = "officeName";
  @SerializedName(SERIALIZED_NAME_OFFICE_NAME)
  private String officeName;

  public static final String SERIALIZED_NAME_ROW_INDEX = "rowIndex";
  @SerializedName(SERIALIZED_NAME_ROW_INDEX)
  private Integer rowIndex;

  public static final String SERIALIZED_NAME_SAVINGS_ID = "savingsId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ID)
  private Integer savingsId;

  public static final String SERIALIZED_NAME_STAFF_MEMBER = "staffMember";
  @SerializedName(SERIALIZED_NAME_STAFF_MEMBER)
  private Boolean staffMember;

  public static final String SERIALIZED_NAME_STATE = "state";
  @SerializedName(SERIALIZED_NAME_STATE)
  private String state;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private Boolean status;

  public static final String SERIALIZED_NAME_ZIP = "zip";
  @SerializedName(SERIALIZED_NAME_ZIP)
  private String zip;

  public GuarantorData() {
  }

  public GuarantorData accountId(Long accountId) {
    
    this.accountId = accountId;
    return this;
  }

  /**
   * Get accountId
   * @return accountId
   */
  @javax.annotation.Nullable

  public Long getAccountId() {
    return accountId;
  }


  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  public GuarantorData accountLinkingOptions(List<PortfolioAccountData> accountLinkingOptions) {
    
    this.accountLinkingOptions = accountLinkingOptions;
    return this;
  }

  public GuarantorData addAccountLinkingOptionsItem(PortfolioAccountData accountLinkingOptionsItem) {
    if (this.accountLinkingOptions == null) {
      this.accountLinkingOptions = new ArrayList<>();
    }
    this.accountLinkingOptions.add(accountLinkingOptionsItem);
    return this;
  }

  /**
   * Get accountLinkingOptions
   * @return accountLinkingOptions
   */
  @javax.annotation.Nullable

  public List<PortfolioAccountData> getAccountLinkingOptions() {
    return accountLinkingOptions;
  }


  public void setAccountLinkingOptions(List<PortfolioAccountData> accountLinkingOptions) {
    this.accountLinkingOptions = accountLinkingOptions;
  }

  public GuarantorData addressLine1(String addressLine1) {
    
    this.addressLine1 = addressLine1;
    return this;
  }

  /**
   * Get addressLine1
   * @return addressLine1
   */
  @javax.annotation.Nullable

  public String getAddressLine1() {
    return addressLine1;
  }


  public void setAddressLine1(String addressLine1) {
    this.addressLine1 = addressLine1;
  }

  public GuarantorData addressLine2(String addressLine2) {
    
    this.addressLine2 = addressLine2;
    return this;
  }

  /**
   * Get addressLine2
   * @return addressLine2
   */
  @javax.annotation.Nullable

  public String getAddressLine2() {
    return addressLine2;
  }


  public void setAddressLine2(String addressLine2) {
    this.addressLine2 = addressLine2;
  }

  public GuarantorData allowedClientRelationshipTypes(List<CodeValueData> allowedClientRelationshipTypes) {
    
    this.allowedClientRelationshipTypes = allowedClientRelationshipTypes;
    return this;
  }

  public GuarantorData addAllowedClientRelationshipTypesItem(CodeValueData allowedClientRelationshipTypesItem) {
    if (this.allowedClientRelationshipTypes == null) {
      this.allowedClientRelationshipTypes = new ArrayList<>();
    }
    this.allowedClientRelationshipTypes.add(allowedClientRelationshipTypesItem);
    return this;
  }

  /**
   * Get allowedClientRelationshipTypes
   * @return allowedClientRelationshipTypes
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getAllowedClientRelationshipTypes() {
    return allowedClientRelationshipTypes;
  }


  public void setAllowedClientRelationshipTypes(List<CodeValueData> allowedClientRelationshipTypes) {
    this.allowedClientRelationshipTypes = allowedClientRelationshipTypes;
  }

  public GuarantorData amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public GuarantorData city(String city) {
    
    this.city = city;
    return this;
  }

  /**
   * Get city
   * @return city
   */
  @javax.annotation.Nullable

  public String getCity() {
    return city;
  }


  public void setCity(String city) {
    this.city = city;
  }

  public GuarantorData clientRelationshipType(CodeValueData clientRelationshipType) {
    
    this.clientRelationshipType = clientRelationshipType;
    return this;
  }

  /**
   * Get clientRelationshipType
   * @return clientRelationshipType
   */
  @javax.annotation.Nullable

  public CodeValueData getClientRelationshipType() {
    return clientRelationshipType;
  }


  public void setClientRelationshipType(CodeValueData clientRelationshipType) {
    this.clientRelationshipType = clientRelationshipType;
  }

  public GuarantorData clientRelationshipTypeId(Integer clientRelationshipTypeId) {
    
    this.clientRelationshipTypeId = clientRelationshipTypeId;
    return this;
  }

  /**
   * Get clientRelationshipTypeId
   * @return clientRelationshipTypeId
   */
  @javax.annotation.Nullable

  public Integer getClientRelationshipTypeId() {
    return clientRelationshipTypeId;
  }


  public void setClientRelationshipTypeId(Integer clientRelationshipTypeId) {
    this.clientRelationshipTypeId = clientRelationshipTypeId;
  }

  public GuarantorData comment(String comment) {
    
    this.comment = comment;
    return this;
  }

  /**
   * Get comment
   * @return comment
   */
  @javax.annotation.Nullable

  public String getComment() {
    return comment;
  }


  public void setComment(String comment) {
    this.comment = comment;
  }

  public GuarantorData country(String country) {
    
    this.country = country;
    return this;
  }

  /**
   * Get country
   * @return country
   */
  @javax.annotation.Nullable

  public String getCountry() {
    return country;
  }


  public void setCountry(String country) {
    this.country = country;
  }

  public GuarantorData dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public GuarantorData dob(LocalDate dob) {
    
    this.dob = dob;
    return this;
  }

  /**
   * Get dob
   * @return dob
   */
  @javax.annotation.Nullable

  public LocalDate getDob() {
    return dob;
  }


  public void setDob(LocalDate dob) {
    this.dob = dob;
  }

  public GuarantorData entityId(Long entityId) {
    
    this.entityId = entityId;
    return this;
  }

  /**
   * Get entityId
   * @return entityId
   */
  @javax.annotation.Nullable

  public Long getEntityId() {
    return entityId;
  }


  public void setEntityId(Long entityId) {
    this.entityId = entityId;
  }

  public GuarantorData existingClient(Boolean existingClient) {
    
    this.existingClient = existingClient;
    return this;
  }

  /**
   * Get existingClient
   * @return existingClient
   */
  @javax.annotation.Nullable

  public Boolean getExistingClient() {
    return existingClient;
  }


  public void setExistingClient(Boolean existingClient) {
    this.existingClient = existingClient;
  }

  public GuarantorData externalGuarantor(Boolean externalGuarantor) {
    
    this.externalGuarantor = externalGuarantor;
    return this;
  }

  /**
   * Get externalGuarantor
   * @return externalGuarantor
   */
  @javax.annotation.Nullable

  public Boolean getExternalGuarantor() {
    return externalGuarantor;
  }


  public void setExternalGuarantor(Boolean externalGuarantor) {
    this.externalGuarantor = externalGuarantor;
  }

  public GuarantorData externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public GuarantorData firstname(String firstname) {
    
    this.firstname = firstname;
    return this;
  }

  /**
   * Get firstname
   * @return firstname
   */
  @javax.annotation.Nullable

  public String getFirstname() {
    return firstname;
  }


  public void setFirstname(String firstname) {
    this.firstname = firstname;
  }

  public GuarantorData guarantorFundingDetails(List<GuarantorFundingData> guarantorFundingDetails) {
    
    this.guarantorFundingDetails = guarantorFundingDetails;
    return this;
  }

  public GuarantorData addGuarantorFundingDetailsItem(GuarantorFundingData guarantorFundingDetailsItem) {
    if (this.guarantorFundingDetails == null) {
      this.guarantorFundingDetails = new ArrayList<>();
    }
    this.guarantorFundingDetails.add(guarantorFundingDetailsItem);
    return this;
  }

  /**
   * Get guarantorFundingDetails
   * @return guarantorFundingDetails
   */
  @javax.annotation.Nullable

  public List<GuarantorFundingData> getGuarantorFundingDetails() {
    return guarantorFundingDetails;
  }


  public void setGuarantorFundingDetails(List<GuarantorFundingData> guarantorFundingDetails) {
    this.guarantorFundingDetails = guarantorFundingDetails;
  }

  public GuarantorData guarantorType(EnumOptionData guarantorType) {
    
    this.guarantorType = guarantorType;
    return this;
  }

  /**
   * Get guarantorType
   * @return guarantorType
   */
  @javax.annotation.Nullable

  public EnumOptionData getGuarantorType() {
    return guarantorType;
  }


  public void setGuarantorType(EnumOptionData guarantorType) {
    this.guarantorType = guarantorType;
  }

  public GuarantorData guarantorTypeId(Integer guarantorTypeId) {
    
    this.guarantorTypeId = guarantorTypeId;
    return this;
  }

  /**
   * Get guarantorTypeId
   * @return guarantorTypeId
   */
  @javax.annotation.Nullable

  public Integer getGuarantorTypeId() {
    return guarantorTypeId;
  }


  public void setGuarantorTypeId(Integer guarantorTypeId) {
    this.guarantorTypeId = guarantorTypeId;
  }

  public GuarantorData guarantorTypeOptions(List<EnumOptionData> guarantorTypeOptions) {
    
    this.guarantorTypeOptions = guarantorTypeOptions;
    return this;
  }

  public GuarantorData addGuarantorTypeOptionsItem(EnumOptionData guarantorTypeOptionsItem) {
    if (this.guarantorTypeOptions == null) {
      this.guarantorTypeOptions = new ArrayList<>();
    }
    this.guarantorTypeOptions.add(guarantorTypeOptionsItem);
    return this;
  }

  /**
   * Get guarantorTypeOptions
   * @return guarantorTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getGuarantorTypeOptions() {
    return guarantorTypeOptions;
  }


  public void setGuarantorTypeOptions(List<EnumOptionData> guarantorTypeOptions) {
    this.guarantorTypeOptions = guarantorTypeOptions;
  }

  public GuarantorData housePhoneNumber(String housePhoneNumber) {
    
    this.housePhoneNumber = housePhoneNumber;
    return this;
  }

  /**
   * Get housePhoneNumber
   * @return housePhoneNumber
   */
  @javax.annotation.Nullable

  public String getHousePhoneNumber() {
    return housePhoneNumber;
  }


  public void setHousePhoneNumber(String housePhoneNumber) {
    this.housePhoneNumber = housePhoneNumber;
  }

  public GuarantorData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public GuarantorData joinedDate(LocalDate joinedDate) {
    
    this.joinedDate = joinedDate;
    return this;
  }

  /**
   * Get joinedDate
   * @return joinedDate
   */
  @javax.annotation.Nullable

  public LocalDate getJoinedDate() {
    return joinedDate;
  }


  public void setJoinedDate(LocalDate joinedDate) {
    this.joinedDate = joinedDate;
  }

  public GuarantorData lastname(String lastname) {
    
    this.lastname = lastname;
    return this;
  }

  /**
   * Get lastname
   * @return lastname
   */
  @javax.annotation.Nullable

  public String getLastname() {
    return lastname;
  }


  public void setLastname(String lastname) {
    this.lastname = lastname;
  }

  public GuarantorData loanId(Long loanId) {
    
    this.loanId = loanId;
    return this;
  }

  /**
   * Get loanId
   * @return loanId
   */
  @javax.annotation.Nullable

  public Long getLoanId() {
    return loanId;
  }


  public void setLoanId(Long loanId) {
    this.loanId = loanId;
  }

  public GuarantorData locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public GuarantorData mobileNumber(String mobileNumber) {
    
    this.mobileNumber = mobileNumber;
    return this;
  }

  /**
   * Get mobileNumber
   * @return mobileNumber
   */
  @javax.annotation.Nullable

  public String getMobileNumber() {
    return mobileNumber;
  }


  public void setMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
  }

  public GuarantorData officeName(String officeName) {
    
    this.officeName = officeName;
    return this;
  }

  /**
   * Get officeName
   * @return officeName
   */
  @javax.annotation.Nullable

  public String getOfficeName() {
    return officeName;
  }


  public void setOfficeName(String officeName) {
    this.officeName = officeName;
  }

  public GuarantorData rowIndex(Integer rowIndex) {
    
    this.rowIndex = rowIndex;
    return this;
  }

  /**
   * Get rowIndex
   * @return rowIndex
   */
  @javax.annotation.Nullable

  public Integer getRowIndex() {
    return rowIndex;
  }


  public void setRowIndex(Integer rowIndex) {
    this.rowIndex = rowIndex;
  }

  public GuarantorData savingsId(Integer savingsId) {
    
    this.savingsId = savingsId;
    return this;
  }

  /**
   * Get savingsId
   * @return savingsId
   */
  @javax.annotation.Nullable

  public Integer getSavingsId() {
    return savingsId;
  }


  public void setSavingsId(Integer savingsId) {
    this.savingsId = savingsId;
  }

  public GuarantorData staffMember(Boolean staffMember) {
    
    this.staffMember = staffMember;
    return this;
  }

  /**
   * Get staffMember
   * @return staffMember
   */
  @javax.annotation.Nullable

  public Boolean getStaffMember() {
    return staffMember;
  }


  public void setStaffMember(Boolean staffMember) {
    this.staffMember = staffMember;
  }

  public GuarantorData state(String state) {
    
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @javax.annotation.Nullable

  public String getState() {
    return state;
  }


  public void setState(String state) {
    this.state = state;
  }

  public GuarantorData status(Boolean status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public Boolean getStatus() {
    return status;
  }


  public void setStatus(Boolean status) {
    this.status = status;
  }

  public GuarantorData zip(String zip) {
    
    this.zip = zip;
    return this;
  }

  /**
   * Get zip
   * @return zip
   */
  @javax.annotation.Nullable

  public String getZip() {
    return zip;
  }


  public void setZip(String zip) {
    this.zip = zip;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GuarantorData guarantorData = (GuarantorData) o;
    return Objects.equals(this.accountId, guarantorData.accountId) &&
        Objects.equals(this.accountLinkingOptions, guarantorData.accountLinkingOptions) &&
        Objects.equals(this.addressLine1, guarantorData.addressLine1) &&
        Objects.equals(this.addressLine2, guarantorData.addressLine2) &&
        Objects.equals(this.allowedClientRelationshipTypes, guarantorData.allowedClientRelationshipTypes) &&
        Objects.equals(this.amount, guarantorData.amount) &&
        Objects.equals(this.city, guarantorData.city) &&
        Objects.equals(this.clientRelationshipType, guarantorData.clientRelationshipType) &&
        Objects.equals(this.clientRelationshipTypeId, guarantorData.clientRelationshipTypeId) &&
        Objects.equals(this.comment, guarantorData.comment) &&
        Objects.equals(this.country, guarantorData.country) &&
        Objects.equals(this.dateFormat, guarantorData.dateFormat) &&
        Objects.equals(this.dob, guarantorData.dob) &&
        Objects.equals(this.entityId, guarantorData.entityId) &&
        Objects.equals(this.existingClient, guarantorData.existingClient) &&
        Objects.equals(this.externalGuarantor, guarantorData.externalGuarantor) &&
        Objects.equals(this.externalId, guarantorData.externalId) &&
        Objects.equals(this.firstname, guarantorData.firstname) &&
        Objects.equals(this.guarantorFundingDetails, guarantorData.guarantorFundingDetails) &&
        Objects.equals(this.guarantorType, guarantorData.guarantorType) &&
        Objects.equals(this.guarantorTypeId, guarantorData.guarantorTypeId) &&
        Objects.equals(this.guarantorTypeOptions, guarantorData.guarantorTypeOptions) &&
        Objects.equals(this.housePhoneNumber, guarantorData.housePhoneNumber) &&
        Objects.equals(this.id, guarantorData.id) &&
        Objects.equals(this.joinedDate, guarantorData.joinedDate) &&
        Objects.equals(this.lastname, guarantorData.lastname) &&
        Objects.equals(this.loanId, guarantorData.loanId) &&
        Objects.equals(this.locale, guarantorData.locale) &&
        Objects.equals(this.mobileNumber, guarantorData.mobileNumber) &&
        Objects.equals(this.officeName, guarantorData.officeName) &&
        Objects.equals(this.rowIndex, guarantorData.rowIndex) &&
        Objects.equals(this.savingsId, guarantorData.savingsId) &&
        Objects.equals(this.staffMember, guarantorData.staffMember) &&
        Objects.equals(this.state, guarantorData.state) &&
        Objects.equals(this.status, guarantorData.status) &&
        Objects.equals(this.zip, guarantorData.zip);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, accountLinkingOptions, addressLine1, addressLine2, allowedClientRelationshipTypes, amount, city, clientRelationshipType, clientRelationshipTypeId, comment, country, dateFormat, dob, entityId, existingClient, externalGuarantor, externalId, firstname, guarantorFundingDetails, guarantorType, guarantorTypeId, guarantorTypeOptions, housePhoneNumber, id, joinedDate, lastname, loanId, locale, mobileNumber, officeName, rowIndex, savingsId, staffMember, state, status, zip);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GuarantorData {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountLinkingOptions: ").append(toIndentedString(accountLinkingOptions)).append("\n");
    sb.append("    addressLine1: ").append(toIndentedString(addressLine1)).append("\n");
    sb.append("    addressLine2: ").append(toIndentedString(addressLine2)).append("\n");
    sb.append("    allowedClientRelationshipTypes: ").append(toIndentedString(allowedClientRelationshipTypes)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    clientRelationshipType: ").append(toIndentedString(clientRelationshipType)).append("\n");
    sb.append("    clientRelationshipTypeId: ").append(toIndentedString(clientRelationshipTypeId)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    dob: ").append(toIndentedString(dob)).append("\n");
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    existingClient: ").append(toIndentedString(existingClient)).append("\n");
    sb.append("    externalGuarantor: ").append(toIndentedString(externalGuarantor)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    firstname: ").append(toIndentedString(firstname)).append("\n");
    sb.append("    guarantorFundingDetails: ").append(toIndentedString(guarantorFundingDetails)).append("\n");
    sb.append("    guarantorType: ").append(toIndentedString(guarantorType)).append("\n");
    sb.append("    guarantorTypeId: ").append(toIndentedString(guarantorTypeId)).append("\n");
    sb.append("    guarantorTypeOptions: ").append(toIndentedString(guarantorTypeOptions)).append("\n");
    sb.append("    housePhoneNumber: ").append(toIndentedString(housePhoneNumber)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    joinedDate: ").append(toIndentedString(joinedDate)).append("\n");
    sb.append("    lastname: ").append(toIndentedString(lastname)).append("\n");
    sb.append("    loanId: ").append(toIndentedString(loanId)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    mobileNumber: ").append(toIndentedString(mobileNumber)).append("\n");
    sb.append("    officeName: ").append(toIndentedString(officeName)).append("\n");
    sb.append("    rowIndex: ").append(toIndentedString(rowIndex)).append("\n");
    sb.append("    savingsId: ").append(toIndentedString(savingsId)).append("\n");
    sb.append("    staffMember: ").append(toIndentedString(staffMember)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    zip: ").append(toIndentedString(zip)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

