/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.client.models.ExtensionData;
import org.apache.fineract.client.models.ExternalId;
import org.apache.fineract.client.models.MoneyData;

/**
 * InteropQuoteResponseData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class InteropQuoteResponseData {
  public static final String SERIALIZED_NAME_CHANGES = "changes";
  @SerializedName(SERIALIZED_NAME_CHANGES)
  private Map<String, Object> changes;

  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_COMMAND_ID = "commandId";
  @SerializedName(SERIALIZED_NAME_COMMAND_ID)
  private Long commandId;

  public static final String SERIALIZED_NAME_CREDIT_BUREAU_REPORT_DATA = "creditBureauReportData";
  @SerializedName(SERIALIZED_NAME_CREDIT_BUREAU_REPORT_DATA)
  private Map<String, Object> creditBureauReportData;

  public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
  @SerializedName(SERIALIZED_NAME_EXPIRATION)
  private String expiration;

  public static final String SERIALIZED_NAME_EXTENSION_LIST = "extensionList";
  @SerializedName(SERIALIZED_NAME_EXTENSION_LIST)
  private List<ExtensionData> extensionList;

  public static final String SERIALIZED_NAME_EXTERNAL_ID_OR_NULL = "externalIdOrNull";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID_OR_NULL)
  private ExternalId externalIdOrNull;

  public static final String SERIALIZED_NAME_FSP_COMMISSION = "fspCommission";
  @SerializedName(SERIALIZED_NAME_FSP_COMMISSION)
  private MoneyData fspCommission;

  public static final String SERIALIZED_NAME_FSP_FEE = "fspFee";
  @SerializedName(SERIALIZED_NAME_FSP_FEE)
  private MoneyData fspFee;

  public static final String SERIALIZED_NAME_GLIM_ID = "glimId";
  @SerializedName(SERIALIZED_NAME_GLIM_ID)
  private Long glimId;

  public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
  @SerializedName(SERIALIZED_NAME_GROUP_ID)
  private Long groupId;

  public static final String SERIALIZED_NAME_GSIM_ID = "gsimId";
  @SerializedName(SERIALIZED_NAME_GSIM_ID)
  private Long gsimId;

  public static final String SERIALIZED_NAME_LOAN_EXTERNAL_ID = "loanExternalId";
  @SerializedName(SERIALIZED_NAME_LOAN_EXTERNAL_ID)
  private ExternalId loanExternalId;

  public static final String SERIALIZED_NAME_LOAN_ID = "loanId";
  @SerializedName(SERIALIZED_NAME_LOAN_ID)
  private Long loanId;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_PRODUCT_ID = "productId";
  @SerializedName(SERIALIZED_NAME_PRODUCT_ID)
  private Long productId;

  public static final String SERIALIZED_NAME_QUOTE_CODE = "quoteCode";
  @SerializedName(SERIALIZED_NAME_QUOTE_CODE)
  private String quoteCode;

  public static final String SERIALIZED_NAME_RESOURCE_EXTERNAL_ID = "resourceExternalId";
  @SerializedName(SERIALIZED_NAME_RESOURCE_EXTERNAL_ID)
  private ExternalId resourceExternalId;

  public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
  @SerializedName(SERIALIZED_NAME_RESOURCE_ID)
  private Long resourceId;

  public static final String SERIALIZED_NAME_RESOURCE_IDENTIFIER = "resourceIdentifier";
  @SerializedName(SERIALIZED_NAME_RESOURCE_IDENTIFIER)
  private String resourceIdentifier;

  public static final String SERIALIZED_NAME_ROLLBACK_TRANSACTION = "rollbackTransaction";
  @SerializedName(SERIALIZED_NAME_ROLLBACK_TRANSACTION)
  private Boolean rollbackTransaction;

  public static final String SERIALIZED_NAME_SAVINGS_ID = "savingsId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ID)
  private Long savingsId;

  /**
   * Gets or Sets state
   */
  @JsonAdapter(StateEnum.Adapter.class)
  public enum StateEnum {
    ACCEPTED("ACCEPTED"),
    
    REJECTED("REJECTED");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StateEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StateEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StateEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StateEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATE = "state";
  @SerializedName(SERIALIZED_NAME_STATE)
  private StateEnum state;

  public static final String SERIALIZED_NAME_SUB_RESOURCE_EXTERNAL_ID = "subResourceExternalId";
  @SerializedName(SERIALIZED_NAME_SUB_RESOURCE_EXTERNAL_ID)
  private ExternalId subResourceExternalId;

  public static final String SERIALIZED_NAME_SUB_RESOURCE_ID = "subResourceId";
  @SerializedName(SERIALIZED_NAME_SUB_RESOURCE_ID)
  private Long subResourceId;

  public static final String SERIALIZED_NAME_TRANSACTION_CODE = "transactionCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_CODE)
  private String transactionCode;

  public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_ID)
  private String transactionId;

  public InteropQuoteResponseData() {
  }

  public InteropQuoteResponseData changes(Map<String, Object> changes) {
    
    this.changes = changes;
    return this;
  }

  public InteropQuoteResponseData putChangesItem(String key, Object changesItem) {
    if (this.changes == null) {
      this.changes = new HashMap<>();
    }
    this.changes.put(key, changesItem);
    return this;
  }

  /**
   * Get changes
   * @return changes
   */
  @javax.annotation.Nullable

  public Map<String, Object> getChanges() {
    return changes;
  }


  public void setChanges(Map<String, Object> changes) {
    this.changes = changes;
  }

  public InteropQuoteResponseData clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public InteropQuoteResponseData commandId(Long commandId) {
    
    this.commandId = commandId;
    return this;
  }

  /**
   * Get commandId
   * @return commandId
   */
  @javax.annotation.Nullable

  public Long getCommandId() {
    return commandId;
  }


  public void setCommandId(Long commandId) {
    this.commandId = commandId;
  }

  public InteropQuoteResponseData creditBureauReportData(Map<String, Object> creditBureauReportData) {
    
    this.creditBureauReportData = creditBureauReportData;
    return this;
  }

  public InteropQuoteResponseData putCreditBureauReportDataItem(String key, Object creditBureauReportDataItem) {
    if (this.creditBureauReportData == null) {
      this.creditBureauReportData = new HashMap<>();
    }
    this.creditBureauReportData.put(key, creditBureauReportDataItem);
    return this;
  }

  /**
   * Get creditBureauReportData
   * @return creditBureauReportData
   */
  @javax.annotation.Nullable

  public Map<String, Object> getCreditBureauReportData() {
    return creditBureauReportData;
  }


  public void setCreditBureauReportData(Map<String, Object> creditBureauReportData) {
    this.creditBureauReportData = creditBureauReportData;
  }

  public InteropQuoteResponseData expiration(String expiration) {
    
    this.expiration = expiration;
    return this;
  }

  /**
   * Get expiration
   * @return expiration
   */
  @javax.annotation.Nullable

  public String getExpiration() {
    return expiration;
  }


  public void setExpiration(String expiration) {
    this.expiration = expiration;
  }

  public InteropQuoteResponseData extensionList(List<ExtensionData> extensionList) {
    
    this.extensionList = extensionList;
    return this;
  }

  public InteropQuoteResponseData addExtensionListItem(ExtensionData extensionListItem) {
    if (this.extensionList == null) {
      this.extensionList = new ArrayList<>();
    }
    this.extensionList.add(extensionListItem);
    return this;
  }

  /**
   * Get extensionList
   * @return extensionList
   */
  @javax.annotation.Nullable

  public List<ExtensionData> getExtensionList() {
    return extensionList;
  }


  public void setExtensionList(List<ExtensionData> extensionList) {
    this.extensionList = extensionList;
  }

  public InteropQuoteResponseData externalIdOrNull(ExternalId externalIdOrNull) {
    
    this.externalIdOrNull = externalIdOrNull;
    return this;
  }

  /**
   * Get externalIdOrNull
   * @return externalIdOrNull
   */
  @javax.annotation.Nullable

  public ExternalId getExternalIdOrNull() {
    return externalIdOrNull;
  }


  public void setExternalIdOrNull(ExternalId externalIdOrNull) {
    this.externalIdOrNull = externalIdOrNull;
  }

  public InteropQuoteResponseData fspCommission(MoneyData fspCommission) {
    
    this.fspCommission = fspCommission;
    return this;
  }

  /**
   * Get fspCommission
   * @return fspCommission
   */
  @javax.annotation.Nullable

  public MoneyData getFspCommission() {
    return fspCommission;
  }


  public void setFspCommission(MoneyData fspCommission) {
    this.fspCommission = fspCommission;
  }

  public InteropQuoteResponseData fspFee(MoneyData fspFee) {
    
    this.fspFee = fspFee;
    return this;
  }

  /**
   * Get fspFee
   * @return fspFee
   */
  @javax.annotation.Nullable

  public MoneyData getFspFee() {
    return fspFee;
  }


  public void setFspFee(MoneyData fspFee) {
    this.fspFee = fspFee;
  }

  public InteropQuoteResponseData glimId(Long glimId) {
    
    this.glimId = glimId;
    return this;
  }

  /**
   * Get glimId
   * @return glimId
   */
  @javax.annotation.Nullable

  public Long getGlimId() {
    return glimId;
  }


  public void setGlimId(Long glimId) {
    this.glimId = glimId;
  }

  public InteropQuoteResponseData groupId(Long groupId) {
    
    this.groupId = groupId;
    return this;
  }

  /**
   * Get groupId
   * @return groupId
   */
  @javax.annotation.Nullable

  public Long getGroupId() {
    return groupId;
  }


  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  public InteropQuoteResponseData gsimId(Long gsimId) {
    
    this.gsimId = gsimId;
    return this;
  }

  /**
   * Get gsimId
   * @return gsimId
   */
  @javax.annotation.Nullable

  public Long getGsimId() {
    return gsimId;
  }


  public void setGsimId(Long gsimId) {
    this.gsimId = gsimId;
  }

  public InteropQuoteResponseData loanExternalId(ExternalId loanExternalId) {
    
    this.loanExternalId = loanExternalId;
    return this;
  }

  /**
   * Get loanExternalId
   * @return loanExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getLoanExternalId() {
    return loanExternalId;
  }


  public void setLoanExternalId(ExternalId loanExternalId) {
    this.loanExternalId = loanExternalId;
  }

  public InteropQuoteResponseData loanId(Long loanId) {
    
    this.loanId = loanId;
    return this;
  }

  /**
   * Get loanId
   * @return loanId
   */
  @javax.annotation.Nullable

  public Long getLoanId() {
    return loanId;
  }


  public void setLoanId(Long loanId) {
    this.loanId = loanId;
  }

  public InteropQuoteResponseData officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public InteropQuoteResponseData productId(Long productId) {
    
    this.productId = productId;
    return this;
  }

  /**
   * Get productId
   * @return productId
   */
  @javax.annotation.Nullable

  public Long getProductId() {
    return productId;
  }


  public void setProductId(Long productId) {
    this.productId = productId;
  }

  public InteropQuoteResponseData quoteCode(String quoteCode) {
    
    this.quoteCode = quoteCode;
    return this;
  }

  /**
   * Get quoteCode
   * @return quoteCode
   */
  @javax.annotation.Nonnull

  public String getQuoteCode() {
    return quoteCode;
  }


  public void setQuoteCode(String quoteCode) {
    this.quoteCode = quoteCode;
  }

  public InteropQuoteResponseData resourceExternalId(ExternalId resourceExternalId) {
    
    this.resourceExternalId = resourceExternalId;
    return this;
  }

  /**
   * Get resourceExternalId
   * @return resourceExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getResourceExternalId() {
    return resourceExternalId;
  }


  public void setResourceExternalId(ExternalId resourceExternalId) {
    this.resourceExternalId = resourceExternalId;
  }

  public InteropQuoteResponseData resourceId(Long resourceId) {
    
    this.resourceId = resourceId;
    return this;
  }

  /**
   * Get resourceId
   * @return resourceId
   */
  @javax.annotation.Nullable

  public Long getResourceId() {
    return resourceId;
  }


  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  public InteropQuoteResponseData resourceIdentifier(String resourceIdentifier) {
    
    this.resourceIdentifier = resourceIdentifier;
    return this;
  }

  /**
   * Get resourceIdentifier
   * @return resourceIdentifier
   */
  @javax.annotation.Nullable

  public String getResourceIdentifier() {
    return resourceIdentifier;
  }


  public void setResourceIdentifier(String resourceIdentifier) {
    this.resourceIdentifier = resourceIdentifier;
  }

  public InteropQuoteResponseData rollbackTransaction(Boolean rollbackTransaction) {
    
    this.rollbackTransaction = rollbackTransaction;
    return this;
  }

  /**
   * Get rollbackTransaction
   * @return rollbackTransaction
   */
  @javax.annotation.Nullable

  public Boolean getRollbackTransaction() {
    return rollbackTransaction;
  }


  public void setRollbackTransaction(Boolean rollbackTransaction) {
    this.rollbackTransaction = rollbackTransaction;
  }

  public InteropQuoteResponseData savingsId(Long savingsId) {
    
    this.savingsId = savingsId;
    return this;
  }

  /**
   * Get savingsId
   * @return savingsId
   */
  @javax.annotation.Nullable

  public Long getSavingsId() {
    return savingsId;
  }


  public void setSavingsId(Long savingsId) {
    this.savingsId = savingsId;
  }

  public InteropQuoteResponseData state(StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @javax.annotation.Nonnull

  public StateEnum getState() {
    return state;
  }


  public void setState(StateEnum state) {
    this.state = state;
  }

  public InteropQuoteResponseData subResourceExternalId(ExternalId subResourceExternalId) {
    
    this.subResourceExternalId = subResourceExternalId;
    return this;
  }

  /**
   * Get subResourceExternalId
   * @return subResourceExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getSubResourceExternalId() {
    return subResourceExternalId;
  }


  public void setSubResourceExternalId(ExternalId subResourceExternalId) {
    this.subResourceExternalId = subResourceExternalId;
  }

  public InteropQuoteResponseData subResourceId(Long subResourceId) {
    
    this.subResourceId = subResourceId;
    return this;
  }

  /**
   * Get subResourceId
   * @return subResourceId
   */
  @javax.annotation.Nullable

  public Long getSubResourceId() {
    return subResourceId;
  }


  public void setSubResourceId(Long subResourceId) {
    this.subResourceId = subResourceId;
  }

  public InteropQuoteResponseData transactionCode(String transactionCode) {
    
    this.transactionCode = transactionCode;
    return this;
  }

  /**
   * Get transactionCode
   * @return transactionCode
   */
  @javax.annotation.Nonnull

  public String getTransactionCode() {
    return transactionCode;
  }


  public void setTransactionCode(String transactionCode) {
    this.transactionCode = transactionCode;
  }

  public InteropQuoteResponseData transactionId(String transactionId) {
    
    this.transactionId = transactionId;
    return this;
  }

  /**
   * Get transactionId
   * @return transactionId
   */
  @javax.annotation.Nullable

  public String getTransactionId() {
    return transactionId;
  }


  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InteropQuoteResponseData interopQuoteResponseData = (InteropQuoteResponseData) o;
    return Objects.equals(this.changes, interopQuoteResponseData.changes) &&
        Objects.equals(this.clientId, interopQuoteResponseData.clientId) &&
        Objects.equals(this.commandId, interopQuoteResponseData.commandId) &&
        Objects.equals(this.creditBureauReportData, interopQuoteResponseData.creditBureauReportData) &&
        Objects.equals(this.expiration, interopQuoteResponseData.expiration) &&
        Objects.equals(this.extensionList, interopQuoteResponseData.extensionList) &&
        Objects.equals(this.externalIdOrNull, interopQuoteResponseData.externalIdOrNull) &&
        Objects.equals(this.fspCommission, interopQuoteResponseData.fspCommission) &&
        Objects.equals(this.fspFee, interopQuoteResponseData.fspFee) &&
        Objects.equals(this.glimId, interopQuoteResponseData.glimId) &&
        Objects.equals(this.groupId, interopQuoteResponseData.groupId) &&
        Objects.equals(this.gsimId, interopQuoteResponseData.gsimId) &&
        Objects.equals(this.loanExternalId, interopQuoteResponseData.loanExternalId) &&
        Objects.equals(this.loanId, interopQuoteResponseData.loanId) &&
        Objects.equals(this.officeId, interopQuoteResponseData.officeId) &&
        Objects.equals(this.productId, interopQuoteResponseData.productId) &&
        Objects.equals(this.quoteCode, interopQuoteResponseData.quoteCode) &&
        Objects.equals(this.resourceExternalId, interopQuoteResponseData.resourceExternalId) &&
        Objects.equals(this.resourceId, interopQuoteResponseData.resourceId) &&
        Objects.equals(this.resourceIdentifier, interopQuoteResponseData.resourceIdentifier) &&
        Objects.equals(this.rollbackTransaction, interopQuoteResponseData.rollbackTransaction) &&
        Objects.equals(this.savingsId, interopQuoteResponseData.savingsId) &&
        Objects.equals(this.state, interopQuoteResponseData.state) &&
        Objects.equals(this.subResourceExternalId, interopQuoteResponseData.subResourceExternalId) &&
        Objects.equals(this.subResourceId, interopQuoteResponseData.subResourceId) &&
        Objects.equals(this.transactionCode, interopQuoteResponseData.transactionCode) &&
        Objects.equals(this.transactionId, interopQuoteResponseData.transactionId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changes, clientId, commandId, creditBureauReportData, expiration, extensionList, externalIdOrNull, fspCommission, fspFee, glimId, groupId, gsimId, loanExternalId, loanId, officeId, productId, quoteCode, resourceExternalId, resourceId, resourceIdentifier, rollbackTransaction, savingsId, state, subResourceExternalId, subResourceId, transactionCode, transactionId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InteropQuoteResponseData {\n");
    sb.append("    changes: ").append(toIndentedString(changes)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    commandId: ").append(toIndentedString(commandId)).append("\n");
    sb.append("    creditBureauReportData: ").append(toIndentedString(creditBureauReportData)).append("\n");
    sb.append("    expiration: ").append(toIndentedString(expiration)).append("\n");
    sb.append("    extensionList: ").append(toIndentedString(extensionList)).append("\n");
    sb.append("    externalIdOrNull: ").append(toIndentedString(externalIdOrNull)).append("\n");
    sb.append("    fspCommission: ").append(toIndentedString(fspCommission)).append("\n");
    sb.append("    fspFee: ").append(toIndentedString(fspFee)).append("\n");
    sb.append("    glimId: ").append(toIndentedString(glimId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    gsimId: ").append(toIndentedString(gsimId)).append("\n");
    sb.append("    loanExternalId: ").append(toIndentedString(loanExternalId)).append("\n");
    sb.append("    loanId: ").append(toIndentedString(loanId)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    quoteCode: ").append(toIndentedString(quoteCode)).append("\n");
    sb.append("    resourceExternalId: ").append(toIndentedString(resourceExternalId)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    resourceIdentifier: ").append(toIndentedString(resourceIdentifier)).append("\n");
    sb.append("    rollbackTransaction: ").append(toIndentedString(rollbackTransaction)).append("\n");
    sb.append("    savingsId: ").append(toIndentedString(savingsId)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    subResourceExternalId: ").append(toIndentedString(subResourceExternalId)).append("\n");
    sb.append("    subResourceId: ").append(toIndentedString(subResourceId)).append("\n");
    sb.append("    transactionCode: ").append(toIndentedString(transactionCode)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

