/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.AdvancedPaymentData;
import org.apache.fineract.client.models.AllowAttributeOverrides;
import org.apache.fineract.client.models.CreditAllocationData;
import org.apache.fineract.client.models.GetLoanPaymentChannelToFundSourceMappings;
import org.apache.fineract.client.models.LoanProductChargeData;
import org.apache.fineract.client.models.LoanProductChargeToGLAccountMapper;
import org.apache.fineract.client.models.PostChargeOffReasonToExpenseAccountMappings;
import org.apache.fineract.client.models.RateData;

/**
 * PutLoanProductsProductIdRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class PutLoanProductsProductIdRequest {
  public static final String SERIALIZED_NAME_ACCOUNT_MOVES_OUT_OF_N_P_A_ONLY_ON_ARREARS_COMPLETION = "accountMovesOutOfNPAOnlyOnArrearsCompletion";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_MOVES_OUT_OF_N_P_A_ONLY_ON_ARREARS_COMPLETION)
  private Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion;

  public static final String SERIALIZED_NAME_ACCOUNTING_RULE = "accountingRule";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_RULE)
  private Integer accountingRule;

  public static final String SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED = "allowApprovedDisbursedAmountsOverApplied";
  @SerializedName(SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED)
  private Boolean allowApprovedDisbursedAmountsOverApplied;

  public static final String SERIALIZED_NAME_ALLOW_ATTRIBUTE_OVERRIDES = "allowAttributeOverrides";
  @SerializedName(SERIALIZED_NAME_ALLOW_ATTRIBUTE_OVERRIDES)
  private AllowAttributeOverrides allowAttributeOverrides;

  public static final String SERIALIZED_NAME_ALLOW_COMPOUNDING_ON_EOD = "allowCompoundingOnEod";
  @SerializedName(SERIALIZED_NAME_ALLOW_COMPOUNDING_ON_EOD)
  private Boolean allowCompoundingOnEod;

  public static final String SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCUALTION = "allowPartialPeriodInterestCalcualtion";
  @SerializedName(SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCUALTION)
  private Boolean allowPartialPeriodInterestCalcualtion;

  public static final String SERIALIZED_NAME_ALLOW_VARIABLE_INSTALLMENTS = "allowVariableInstallments";
  @SerializedName(SERIALIZED_NAME_ALLOW_VARIABLE_INSTALLMENTS)
  private Boolean allowVariableInstallments;

  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE = "amortizationType";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE)
  private Integer amortizationType;

  public static final String SERIALIZED_NAME_BUY_DOWN_EXPENSE_ACCOUNT_ID = "buyDownExpenseAccountId";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_EXPENSE_ACCOUNT_ID)
  private Long buyDownExpenseAccountId;

  /**
   * Gets or Sets buyDownFeeCalculationType
   */
  @JsonAdapter(BuyDownFeeCalculationTypeEnum.Adapter.class)
  public enum BuyDownFeeCalculationTypeEnum {
    FLAT("FLAT");

    private String value;

    BuyDownFeeCalculationTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BuyDownFeeCalculationTypeEnum fromValue(String value) {
      for (BuyDownFeeCalculationTypeEnum b : BuyDownFeeCalculationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BuyDownFeeCalculationTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BuyDownFeeCalculationTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BuyDownFeeCalculationTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BuyDownFeeCalculationTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE = "buyDownFeeCalculationType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE)
  private BuyDownFeeCalculationTypeEnum buyDownFeeCalculationType;

  /**
   * Gets or Sets buyDownFeeIncomeType
   */
  @JsonAdapter(BuyDownFeeIncomeTypeEnum.Adapter.class)
  public enum BuyDownFeeIncomeTypeEnum {
    FEE("FEE"),
    
    INTEREST("INTEREST");

    private String value;

    BuyDownFeeIncomeTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BuyDownFeeIncomeTypeEnum fromValue(String value) {
      for (BuyDownFeeIncomeTypeEnum b : BuyDownFeeIncomeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BuyDownFeeIncomeTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BuyDownFeeIncomeTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BuyDownFeeIncomeTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BuyDownFeeIncomeTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE = "buyDownFeeIncomeType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE)
  private BuyDownFeeIncomeTypeEnum buyDownFeeIncomeType;

  /**
   * Gets or Sets buyDownFeeStrategy
   */
  @JsonAdapter(BuyDownFeeStrategyEnum.Adapter.class)
  public enum BuyDownFeeStrategyEnum {
    EQUAL_AMORTIZATION("EQUAL_AMORTIZATION");

    private String value;

    BuyDownFeeStrategyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BuyDownFeeStrategyEnum fromValue(String value) {
      for (BuyDownFeeStrategyEnum b : BuyDownFeeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BuyDownFeeStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BuyDownFeeStrategyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BuyDownFeeStrategyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BuyDownFeeStrategyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY = "buyDownFeeStrategy";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY)
  private BuyDownFeeStrategyEnum buyDownFeeStrategy;

  public static final String SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT = "canDefineInstallmentAmount";
  @SerializedName(SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT)
  private Boolean canDefineInstallmentAmount;

  public static final String SERIALIZED_NAME_CAN_USE_FOR_TOPUP = "canUseForTopup";
  @SerializedName(SERIALIZED_NAME_CAN_USE_FOR_TOPUP)
  private Boolean canUseForTopup;

  /**
   * Gets or Sets capitalizedIncomeCalculationType
   */
  @JsonAdapter(CapitalizedIncomeCalculationTypeEnum.Adapter.class)
  public enum CapitalizedIncomeCalculationTypeEnum {
    FLAT("FLAT");

    private String value;

    CapitalizedIncomeCalculationTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CapitalizedIncomeCalculationTypeEnum fromValue(String value) {
      for (CapitalizedIncomeCalculationTypeEnum b : CapitalizedIncomeCalculationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CapitalizedIncomeCalculationTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CapitalizedIncomeCalculationTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CapitalizedIncomeCalculationTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CapitalizedIncomeCalculationTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE = "capitalizedIncomeCalculationType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE)
  private CapitalizedIncomeCalculationTypeEnum capitalizedIncomeCalculationType;

  /**
   * Gets or Sets capitalizedIncomeStrategy
   */
  @JsonAdapter(CapitalizedIncomeStrategyEnum.Adapter.class)
  public enum CapitalizedIncomeStrategyEnum {
    EQUAL_AMORTIZATION("EQUAL_AMORTIZATION");

    private String value;

    CapitalizedIncomeStrategyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CapitalizedIncomeStrategyEnum fromValue(String value) {
      for (CapitalizedIncomeStrategyEnum b : CapitalizedIncomeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CapitalizedIncomeStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CapitalizedIncomeStrategyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CapitalizedIncomeStrategyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CapitalizedIncomeStrategyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY = "capitalizedIncomeStrategy";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY)
  private CapitalizedIncomeStrategyEnum capitalizedIncomeStrategy;

  /**
   * Gets or Sets capitalizedIncomeType
   */
  @JsonAdapter(CapitalizedIncomeTypeEnum.Adapter.class)
  public enum CapitalizedIncomeTypeEnum {
    FEE("FEE"),
    
    INTEREST("INTEREST");

    private String value;

    CapitalizedIncomeTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CapitalizedIncomeTypeEnum fromValue(String value) {
      for (CapitalizedIncomeTypeEnum b : CapitalizedIncomeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CapitalizedIncomeTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CapitalizedIncomeTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CapitalizedIncomeTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CapitalizedIncomeTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE = "capitalizedIncomeType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE)
  private CapitalizedIncomeTypeEnum capitalizedIncomeType;

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR = "chargeOffBehaviour";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR)
  private String chargeOffBehaviour;

  public static final String SERIALIZED_NAME_CHARGE_OFF_EXPENSE_ACCOUNT_ID = "chargeOffExpenseAccountId";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_EXPENSE_ACCOUNT_ID)
  private Long chargeOffExpenseAccountId;

  public static final String SERIALIZED_NAME_CHARGE_OFF_FRAUD_EXPENSE_ACCOUNT_ID = "chargeOffFraudExpenseAccountId";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_FRAUD_EXPENSE_ACCOUNT_ID)
  private Long chargeOffFraudExpenseAccountId;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS = "chargeOffReasonToExpenseAccountMappings";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS)
  private List<PostChargeOffReasonToExpenseAccountMappings> chargeOffReasonToExpenseAccountMappings;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<LoanProductChargeData> charges;

  public static final String SERIALIZED_NAME_CLOSE_DATE = "closeDate";
  @SerializedName(SERIALIZED_NAME_CLOSE_DATE)
  private String closeDate;

  public static final String SERIALIZED_NAME_CREDIT_ALLOCATION = "creditAllocation";
  @SerializedName(SERIALIZED_NAME_CREDIT_ALLOCATION)
  private List<CreditAllocationData> creditAllocation;

  public static final String SERIALIZED_NAME_CURRENCY_CODE = "currencyCode";
  @SerializedName(SERIALIZED_NAME_CURRENCY_CODE)
  private String currencyCode;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE = "daysInMonthType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE)
  private Long daysInMonthType;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY = "daysInYearCustomStrategy";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY)
  private String daysInYearCustomStrategy;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE = "daysInYearType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE)
  private Long daysInYearType;

  public static final String SERIALIZED_NAME_DEFERRED_INCOME_LIABILITY_ACCOUNT_ID = "deferredIncomeLiabilityAccountId";
  @SerializedName(SERIALIZED_NAME_DEFERRED_INCOME_LIABILITY_ACCOUNT_ID)
  private Long deferredIncomeLiabilityAccountId;

  public static final String SERIALIZED_NAME_DELINQUENCY_BUCKET_ID = "delinquencyBucketId";
  @SerializedName(SERIALIZED_NAME_DELINQUENCY_BUCKET_ID)
  private Long delinquencyBucketId;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_DIGITS_AFTER_DECIMAL = "digitsAfterDecimal";
  @SerializedName(SERIALIZED_NAME_DIGITS_AFTER_DECIMAL)
  private Integer digitsAfterDecimal;

  public static final String SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS = "disallowExpectedDisbursements";
  @SerializedName(SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS)
  private Boolean disallowExpectedDisbursements;

  public static final String SERIALIZED_NAME_DISALLOW_INTEREST_CALCULATION_ON_PAST_DUE = "disallowInterestCalculationOnPastDue";
  @SerializedName(SERIALIZED_NAME_DISALLOW_INTEREST_CALCULATION_ON_PAST_DUE)
  private Boolean disallowInterestCalculationOnPastDue;

  public static final String SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT = "disbursedAmountPercentageForDownPayment";
  @SerializedName(SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT)
  private BigDecimal disbursedAmountPercentageForDownPayment;

  public static final String SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT = "dueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer dueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING = "enableAccrualActivityPosting";
  @SerializedName(SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING)
  private Boolean enableAccrualActivityPosting;

  public static final String SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT = "enableAutoRepaymentForDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT)
  private Boolean enableAutoRepaymentForDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE = "enableBuyDownFee";
  @SerializedName(SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE)
  private Boolean enableBuyDownFee;

  public static final String SERIALIZED_NAME_ENABLE_DOWN_PAYMENT = "enableDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_DOWN_PAYMENT)
  private Boolean enableDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION = "enableIncomeCapitalization";
  @SerializedName(SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION)
  private Boolean enableIncomeCapitalization;

  public static final String SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY = "enableInstallmentLevelDelinquency";
  @SerializedName(SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY)
  private Boolean enableInstallmentLevelDelinquency;

  public static final String SERIALIZED_NAME_FEE_TO_INCOME_ACCOUNT_MAPPINGS = "feeToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_FEE_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<LoanProductChargeToGLAccountMapper> feeToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_FIXED_LENGTH = "fixedLength";
  @SerializedName(SERIALIZED_NAME_FIXED_LENGTH)
  private Integer fixedLength;

  public static final String SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT = "fixedPrincipalPercentagePerInstallment";
  @SerializedName(SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT)
  private BigDecimal fixedPrincipalPercentagePerInstallment;

  public static final String SERIALIZED_NAME_FUND_ID = "fundId";
  @SerializedName(SERIALIZED_NAME_FUND_ID)
  private Long fundId;

  public static final String SERIALIZED_NAME_FUND_SOURCE_ACCOUNT_ID = "fundSourceAccountId";
  @SerializedName(SERIALIZED_NAME_FUND_SOURCE_ACCOUNT_ID)
  private Long fundSourceAccountId;

  public static final String SERIALIZED_NAME_GOODWILL_CREDIT_ACCOUNT_ID = "goodwillCreditAccountId";
  @SerializedName(SERIALIZED_NAME_GOODWILL_CREDIT_ACCOUNT_ID)
  private Long goodwillCreditAccountId;

  public static final String SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING = "graceOnArrearsAgeing";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING)
  private Integer graceOnArrearsAgeing;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT = "graceOnInterestPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT)
  private Integer graceOnInterestPayment;

  public static final String SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT = "graceOnPrincipalPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT)
  private Integer graceOnPrincipalPayment;

  public static final String SERIALIZED_NAME_HOLD_GUARANTEE_FUNDS = "holdGuaranteeFunds";
  @SerializedName(SERIALIZED_NAME_HOLD_GUARANTEE_FUNDS)
  private Boolean holdGuaranteeFunds;

  public static final String SERIALIZED_NAME_IN_ARREARS_TOLERANCE = "inArrearsTolerance";
  @SerializedName(SERIALIZED_NAME_IN_ARREARS_TOLERANCE)
  private Integer inArrearsTolerance;

  public static final String SERIALIZED_NAME_IN_MULTIPLES_OF = "inMultiplesOf";
  @SerializedName(SERIALIZED_NAME_IN_MULTIPLES_OF)
  private Integer inMultiplesOf;

  public static final String SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE = "includeInBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE)
  private Boolean includeInBorrowerCycle;

  public static final String SERIALIZED_NAME_INCOME_FROM_BUY_DOWN_ACCOUNT_ID = "incomeFromBuyDownAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_BUY_DOWN_ACCOUNT_ID)
  private Long incomeFromBuyDownAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_CAPITALIZATION_ACCOUNT_ID = "incomeFromCapitalizationAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_CAPITALIZATION_ACCOUNT_ID)
  private Long incomeFromCapitalizationAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_FEES_ACCOUNT_ID = "incomeFromChargeOffFeesAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_FEES_ACCOUNT_ID)
  private Long incomeFromChargeOffFeesAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_INTEREST_ACCOUNT_ID = "incomeFromChargeOffInterestAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_INTEREST_ACCOUNT_ID)
  private Long incomeFromChargeOffInterestAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_PENALTY_ACCOUNT_ID = "incomeFromChargeOffPenaltyAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_PENALTY_ACCOUNT_ID)
  private Long incomeFromChargeOffPenaltyAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_FEE_ACCOUNT_ID = "incomeFromFeeAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_FEE_ACCOUNT_ID)
  private Long incomeFromFeeAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_FEES_ACCOUNT_ID = "incomeFromGoodwillCreditFeesAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_FEES_ACCOUNT_ID)
  private Long incomeFromGoodwillCreditFeesAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_INTEREST_ACCOUNT_ID = "incomeFromGoodwillCreditInterestAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_INTEREST_ACCOUNT_ID)
  private Long incomeFromGoodwillCreditInterestAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_PENALTY_ACCOUNT_ID = "incomeFromGoodwillCreditPenaltyAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_PENALTY_ACCOUNT_ID)
  private Long incomeFromGoodwillCreditPenaltyAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_PENALTY_ACCOUNT_ID = "incomeFromPenaltyAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_PENALTY_ACCOUNT_ID)
  private Long incomeFromPenaltyAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_RECOVERY_ACCOUNT_ID = "incomeFromRecoveryAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_RECOVERY_ACCOUNT_ID)
  private Long incomeFromRecoveryAccountId;

  public static final String SERIALIZED_NAME_INSTALLMENT_AMOUNT_IN_MULTIPLES_OF = "installmentAmountInMultiplesOf";
  @SerializedName(SERIALIZED_NAME_INSTALLMENT_AMOUNT_IN_MULTIPLES_OF)
  private Integer installmentAmountInMultiplesOf;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE)
  private Integer interestCalculationPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_ON_LOAN_ACCOUNT_ID = "interestOnLoanAccountId";
  @SerializedName(SERIALIZED_NAME_INTEREST_ON_LOAN_ACCOUNT_ID)
  private Long interestOnLoanAccountId;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE)
  private Integer interestRateFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD = "interestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD)
  private Double interestRatePerPeriod;

  public static final String SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE = "interestRateVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> interestRateVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_COMPOUNDING_METHOD = "interestRecalculationCompoundingMethod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_COMPOUNDING_METHOD)
  private Integer interestRecalculationCompoundingMethod;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  public static final String SERIALIZED_NAME_INTEREST_TYPE = "interestType";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE)
  private Integer interestType;

  public static final String SERIALIZED_NAME_IS_ARREARS_BASED_ON_ORIGINAL_SCHEDULE = "isArrearsBasedOnOriginalSchedule";
  @SerializedName(SERIALIZED_NAME_IS_ARREARS_BASED_ON_ORIGINAL_SCHEDULE)
  private Boolean isArrearsBasedOnOriginalSchedule;

  public static final String SERIALIZED_NAME_IS_COMPOUNDING_TO_BE_POSTED_AS_TRANSACTION = "isCompoundingToBePostedAsTransaction";
  @SerializedName(SERIALIZED_NAME_IS_COMPOUNDING_TO_BE_POSTED_AS_TRANSACTION)
  private Boolean isCompoundingToBePostedAsTransaction;

  public static final String SERIALIZED_NAME_IS_EQUAL_AMORTIZATION = "isEqualAmortization";
  @SerializedName(SERIALIZED_NAME_IS_EQUAL_AMORTIZATION)
  private Boolean isEqualAmortization;

  public static final String SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED = "isInterestRecalculationEnabled";
  @SerializedName(SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED)
  private Boolean isInterestRecalculationEnabled;

  public static final String SERIALIZED_NAME_IS_LINKED_TO_FLOATING_INTEREST_RATES = "isLinkedToFloatingInterestRates";
  @SerializedName(SERIALIZED_NAME_IS_LINKED_TO_FLOATING_INTEREST_RATES)
  private Boolean isLinkedToFloatingInterestRates;

  public static final String SERIALIZED_NAME_LOAN_PORTFOLIO_ACCOUNT_ID = "loanPortfolioAccountId";
  @SerializedName(SERIALIZED_NAME_LOAN_PORTFOLIO_ACCOUNT_ID)
  private Long loanPortfolioAccountId;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE = "loanScheduleProcessingType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE)
  private String loanScheduleProcessingType;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_TYPE = "loanScheduleType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_TYPE)
  private String loanScheduleType;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_MAX_INTEREST_RATE_PER_PERIOD = "maxInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MAX_INTEREST_RATE_PER_PERIOD)
  private Double maxInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS = "maxNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS)
  private Integer maxNumberOfRepayments;

  public static final String SERIALIZED_NAME_MAX_PRINCIPAL = "maxPrincipal";
  @SerializedName(SERIALIZED_NAME_MAX_PRINCIPAL)
  private Double maxPrincipal;

  public static final String SERIALIZED_NAME_MAX_TRANCHE_COUNT = "maxTrancheCount";
  @SerializedName(SERIALIZED_NAME_MAX_TRANCHE_COUNT)
  private Integer maxTrancheCount;

  public static final String SERIALIZED_NAME_MIN_INTEREST_RATE_PER_PERIOD = "minInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MIN_INTEREST_RATE_PER_PERIOD)
  private Double minInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS = "minNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS)
  private Integer minNumberOfRepayments;

  public static final String SERIALIZED_NAME_MIN_PRINCIPAL = "minPrincipal";
  @SerializedName(SERIALIZED_NAME_MIN_PRINCIPAL)
  private Double minPrincipal;

  public static final String SERIALIZED_NAME_MINIMUM_DAYS_BETWEEN_DISBURSAL_AND_FIRST_REPAYMENT = "minimumDaysBetweenDisbursalAndFirstRepayment";
  @SerializedName(SERIALIZED_NAME_MINIMUM_DAYS_BETWEEN_DISBURSAL_AND_FIRST_REPAYMENT)
  private Integer minimumDaysBetweenDisbursalAndFirstRepayment;

  public static final String SERIALIZED_NAME_MULTI_DISBURSE_LOAN = "multiDisburseLoan";
  @SerializedName(SERIALIZED_NAME_MULTI_DISBURSE_LOAN)
  private Boolean multiDisburseLoan;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE = "numberOfRepaymentVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> numberOfRepaymentVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE = "outstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE)
  private Double outstandingLoanBalance;

  public static final String SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE = "overAppliedCalculationType";
  @SerializedName(SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE)
  private String overAppliedCalculationType;

  public static final String SERIALIZED_NAME_OVER_APPLIED_NUMBER = "overAppliedNumber";
  @SerializedName(SERIALIZED_NAME_OVER_APPLIED_NUMBER)
  private Integer overAppliedNumber;

  public static final String SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT = "overDueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer overDueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A = "overdueDaysForNPA";
  @SerializedName(SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A)
  private Integer overdueDaysForNPA;

  public static final String SERIALIZED_NAME_OVERPAYMENT_LIABILITY_ACCOUNT_ID = "overpaymentLiabilityAccountId";
  @SerializedName(SERIALIZED_NAME_OVERPAYMENT_LIABILITY_ACCOUNT_ID)
  private Long overpaymentLiabilityAccountId;

  public static final String SERIALIZED_NAME_PAYMENT_ALLOCATION = "paymentAllocation";
  @SerializedName(SERIALIZED_NAME_PAYMENT_ALLOCATION)
  private List<AdvancedPaymentData> paymentAllocation;

  public static final String SERIALIZED_NAME_PAYMENT_CHANNEL_TO_FUND_SOURCE_MAPPINGS = "paymentChannelToFundSourceMappings";
  @SerializedName(SERIALIZED_NAME_PAYMENT_CHANNEL_TO_FUND_SOURCE_MAPPINGS)
  private List<GetLoanPaymentChannelToFundSourceMappings> paymentChannelToFundSourceMappings;

  public static final String SERIALIZED_NAME_PENALTY_TO_INCOME_ACCOUNT_MAPPINGS = "penaltyToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_PENALTY_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<LoanProductChargeToGLAccountMapper> penaltyToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_PRE_CLOSURE_INTEREST_CALCULATION_STRATEGY = "preClosureInterestCalculationStrategy";
  @SerializedName(SERIALIZED_NAME_PRE_CLOSURE_INTEREST_CALCULATION_STRATEGY)
  private Integer preClosureInterestCalculationStrategy;

  public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL)
  private Double principal;

  public static final String SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALLMENT = "principalThresholdForLastInstallment";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALLMENT)
  private Integer principalThresholdForLastInstallment;

  public static final String SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE = "principalVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> principalVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_RATES = "rates";
  @SerializedName(SERIALIZED_NAME_RATES)
  private List<RateData> rates;

  public static final String SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_INTERVAL = "recalculationCompoundingFrequencyInterval";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_INTERVAL)
  private Integer recalculationCompoundingFrequencyInterval;

  public static final String SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_ON_DAY_TYPE = "recalculationCompoundingFrequencyOnDayType";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_ON_DAY_TYPE)
  private Integer recalculationCompoundingFrequencyOnDayType;

  public static final String SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_TYPE = "recalculationCompoundingFrequencyType";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_TYPE)
  private Integer recalculationCompoundingFrequencyType;

  public static final String SERIALIZED_NAME_RECALCULATION_REST_FREQUENCY_INTERVAL = "recalculationRestFrequencyInterval";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_REST_FREQUENCY_INTERVAL)
  private Integer recalculationRestFrequencyInterval;

  public static final String SERIALIZED_NAME_RECALCULATION_REST_FREQUENCY_TYPE = "recalculationRestFrequencyType";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_REST_FREQUENCY_TYPE)
  private Integer recalculationRestFrequencyType;

  public static final String SERIALIZED_NAME_RECEIVABLE_FEE_ACCOUNT_ID = "receivableFeeAccountId";
  @SerializedName(SERIALIZED_NAME_RECEIVABLE_FEE_ACCOUNT_ID)
  private Long receivableFeeAccountId;

  public static final String SERIALIZED_NAME_RECEIVABLE_INTEREST_ACCOUNT_ID = "receivableInterestAccountId";
  @SerializedName(SERIALIZED_NAME_RECEIVABLE_INTEREST_ACCOUNT_ID)
  private Long receivableInterestAccountId;

  public static final String SERIALIZED_NAME_RECEIVABLE_PENALTY_ACCOUNT_ID = "receivablePenaltyAccountId";
  @SerializedName(SERIALIZED_NAME_RECEIVABLE_PENALTY_ACCOUNT_ID)
  private Long receivablePenaltyAccountId;

  public static final String SERIALIZED_NAME_REPAYMENT_EVERY = "repaymentEvery";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_EVERY)
  private Integer repaymentEvery;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE)
  private Integer repaymentFrequencyType;

  public static final String SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE = "repaymentStartDateType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE)
  private Integer repaymentStartDateType;

  public static final String SERIALIZED_NAME_RESCHEDULE_STRATEGY_METHOD = "rescheduleStrategyMethod";
  @SerializedName(SERIALIZED_NAME_RESCHEDULE_STRATEGY_METHOD)
  private Integer rescheduleStrategyMethod;

  public static final String SERIALIZED_NAME_SHORT_NAME = "shortName";
  @SerializedName(SERIALIZED_NAME_SHORT_NAME)
  private String shortName;

  public static final String SERIALIZED_NAME_START_DATE = "startDate";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private String startDate;

  public static final String SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES = "supportedInterestRefundTypes";
  @SerializedName(SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES)
  private List<String> supportedInterestRefundTypes;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE = "transactionProcessingStrategyCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE)
  private String transactionProcessingStrategyCode;

  public static final String SERIALIZED_NAME_TRANSFERS_IN_SUSPENSE_ACCOUNT_ID = "transfersInSuspenseAccountId";
  @SerializedName(SERIALIZED_NAME_TRANSFERS_IN_SUSPENSE_ACCOUNT_ID)
  private Long transfersInSuspenseAccountId;

  public static final String SERIALIZED_NAME_USE_BORROWER_CYCLE = "useBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_USE_BORROWER_CYCLE)
  private Boolean useBorrowerCycle;

  public static final String SERIALIZED_NAME_WRITE_OFF_ACCOUNT_ID = "writeOffAccountId";
  @SerializedName(SERIALIZED_NAME_WRITE_OFF_ACCOUNT_ID)
  private Long writeOffAccountId;

  public PutLoanProductsProductIdRequest() {
  }

  public PutLoanProductsProductIdRequest accountMovesOutOfNPAOnlyOnArrearsCompletion(Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion) {
    
    this.accountMovesOutOfNPAOnlyOnArrearsCompletion = accountMovesOutOfNPAOnlyOnArrearsCompletion;
    return this;
  }

  /**
   * Get accountMovesOutOfNPAOnlyOnArrearsCompletion
   * @return accountMovesOutOfNPAOnlyOnArrearsCompletion
   */
  @javax.annotation.Nullable

  public Boolean getAccountMovesOutOfNPAOnlyOnArrearsCompletion() {
    return accountMovesOutOfNPAOnlyOnArrearsCompletion;
  }


  public void setAccountMovesOutOfNPAOnlyOnArrearsCompletion(Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion) {
    this.accountMovesOutOfNPAOnlyOnArrearsCompletion = accountMovesOutOfNPAOnlyOnArrearsCompletion;
  }

  public PutLoanProductsProductIdRequest accountingRule(Integer accountingRule) {
    
    this.accountingRule = accountingRule;
    return this;
  }

  /**
   * Get accountingRule
   * @return accountingRule
   */
  @javax.annotation.Nullable

  public Integer getAccountingRule() {
    return accountingRule;
  }


  public void setAccountingRule(Integer accountingRule) {
    this.accountingRule = accountingRule;
  }

  public PutLoanProductsProductIdRequest allowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
    return this;
  }

  /**
   * Get allowApprovedDisbursedAmountsOverApplied
   * @return allowApprovedDisbursedAmountsOverApplied
   */
  @javax.annotation.Nullable

  public Boolean getAllowApprovedDisbursedAmountsOverApplied() {
    return allowApprovedDisbursedAmountsOverApplied;
  }


  public void setAllowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
  }

  public PutLoanProductsProductIdRequest allowAttributeOverrides(AllowAttributeOverrides allowAttributeOverrides) {
    
    this.allowAttributeOverrides = allowAttributeOverrides;
    return this;
  }

  /**
   * Get allowAttributeOverrides
   * @return allowAttributeOverrides
   */
  @javax.annotation.Nullable

  public AllowAttributeOverrides getAllowAttributeOverrides() {
    return allowAttributeOverrides;
  }


  public void setAllowAttributeOverrides(AllowAttributeOverrides allowAttributeOverrides) {
    this.allowAttributeOverrides = allowAttributeOverrides;
  }

  public PutLoanProductsProductIdRequest allowCompoundingOnEod(Boolean allowCompoundingOnEod) {
    
    this.allowCompoundingOnEod = allowCompoundingOnEod;
    return this;
  }

  /**
   * Get allowCompoundingOnEod
   * @return allowCompoundingOnEod
   */
  @javax.annotation.Nullable

  public Boolean getAllowCompoundingOnEod() {
    return allowCompoundingOnEod;
  }


  public void setAllowCompoundingOnEod(Boolean allowCompoundingOnEod) {
    this.allowCompoundingOnEod = allowCompoundingOnEod;
  }

  public PutLoanProductsProductIdRequest allowPartialPeriodInterestCalcualtion(Boolean allowPartialPeriodInterestCalcualtion) {
    
    this.allowPartialPeriodInterestCalcualtion = allowPartialPeriodInterestCalcualtion;
    return this;
  }

  /**
   * Get allowPartialPeriodInterestCalcualtion
   * @return allowPartialPeriodInterestCalcualtion
   */
  @javax.annotation.Nullable

  public Boolean getAllowPartialPeriodInterestCalcualtion() {
    return allowPartialPeriodInterestCalcualtion;
  }


  public void setAllowPartialPeriodInterestCalcualtion(Boolean allowPartialPeriodInterestCalcualtion) {
    this.allowPartialPeriodInterestCalcualtion = allowPartialPeriodInterestCalcualtion;
  }

  public PutLoanProductsProductIdRequest allowVariableInstallments(Boolean allowVariableInstallments) {
    
    this.allowVariableInstallments = allowVariableInstallments;
    return this;
  }

  /**
   * Get allowVariableInstallments
   * @return allowVariableInstallments
   */
  @javax.annotation.Nullable

  public Boolean getAllowVariableInstallments() {
    return allowVariableInstallments;
  }


  public void setAllowVariableInstallments(Boolean allowVariableInstallments) {
    this.allowVariableInstallments = allowVariableInstallments;
  }

  public PutLoanProductsProductIdRequest amortizationType(Integer amortizationType) {
    
    this.amortizationType = amortizationType;
    return this;
  }

  /**
   * Get amortizationType
   * @return amortizationType
   */
  @javax.annotation.Nullable

  public Integer getAmortizationType() {
    return amortizationType;
  }


  public void setAmortizationType(Integer amortizationType) {
    this.amortizationType = amortizationType;
  }

  public PutLoanProductsProductIdRequest buyDownExpenseAccountId(Long buyDownExpenseAccountId) {
    
    this.buyDownExpenseAccountId = buyDownExpenseAccountId;
    return this;
  }

  /**
   * Get buyDownExpenseAccountId
   * @return buyDownExpenseAccountId
   */
  @javax.annotation.Nullable

  public Long getBuyDownExpenseAccountId() {
    return buyDownExpenseAccountId;
  }


  public void setBuyDownExpenseAccountId(Long buyDownExpenseAccountId) {
    this.buyDownExpenseAccountId = buyDownExpenseAccountId;
  }

  public PutLoanProductsProductIdRequest buyDownFeeCalculationType(BuyDownFeeCalculationTypeEnum buyDownFeeCalculationType) {
    
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
    return this;
  }

  /**
   * Get buyDownFeeCalculationType
   * @return buyDownFeeCalculationType
   */
  @javax.annotation.Nullable

  public BuyDownFeeCalculationTypeEnum getBuyDownFeeCalculationType() {
    return buyDownFeeCalculationType;
  }


  public void setBuyDownFeeCalculationType(BuyDownFeeCalculationTypeEnum buyDownFeeCalculationType) {
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
  }

  public PutLoanProductsProductIdRequest buyDownFeeIncomeType(BuyDownFeeIncomeTypeEnum buyDownFeeIncomeType) {
    
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
    return this;
  }

  /**
   * Get buyDownFeeIncomeType
   * @return buyDownFeeIncomeType
   */
  @javax.annotation.Nullable

  public BuyDownFeeIncomeTypeEnum getBuyDownFeeIncomeType() {
    return buyDownFeeIncomeType;
  }


  public void setBuyDownFeeIncomeType(BuyDownFeeIncomeTypeEnum buyDownFeeIncomeType) {
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
  }

  public PutLoanProductsProductIdRequest buyDownFeeStrategy(BuyDownFeeStrategyEnum buyDownFeeStrategy) {
    
    this.buyDownFeeStrategy = buyDownFeeStrategy;
    return this;
  }

  /**
   * Get buyDownFeeStrategy
   * @return buyDownFeeStrategy
   */
  @javax.annotation.Nullable

  public BuyDownFeeStrategyEnum getBuyDownFeeStrategy() {
    return buyDownFeeStrategy;
  }


  public void setBuyDownFeeStrategy(BuyDownFeeStrategyEnum buyDownFeeStrategy) {
    this.buyDownFeeStrategy = buyDownFeeStrategy;
  }

  public PutLoanProductsProductIdRequest canDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
    return this;
  }

  /**
   * Get canDefineInstallmentAmount
   * @return canDefineInstallmentAmount
   */
  @javax.annotation.Nullable

  public Boolean getCanDefineInstallmentAmount() {
    return canDefineInstallmentAmount;
  }


  public void setCanDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
  }

  public PutLoanProductsProductIdRequest canUseForTopup(Boolean canUseForTopup) {
    
    this.canUseForTopup = canUseForTopup;
    return this;
  }

  /**
   * Get canUseForTopup
   * @return canUseForTopup
   */
  @javax.annotation.Nullable

  public Boolean getCanUseForTopup() {
    return canUseForTopup;
  }


  public void setCanUseForTopup(Boolean canUseForTopup) {
    this.canUseForTopup = canUseForTopup;
  }

  public PutLoanProductsProductIdRequest capitalizedIncomeCalculationType(CapitalizedIncomeCalculationTypeEnum capitalizedIncomeCalculationType) {
    
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
    return this;
  }

  /**
   * Get capitalizedIncomeCalculationType
   * @return capitalizedIncomeCalculationType
   */
  @javax.annotation.Nullable

  public CapitalizedIncomeCalculationTypeEnum getCapitalizedIncomeCalculationType() {
    return capitalizedIncomeCalculationType;
  }


  public void setCapitalizedIncomeCalculationType(CapitalizedIncomeCalculationTypeEnum capitalizedIncomeCalculationType) {
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
  }

  public PutLoanProductsProductIdRequest capitalizedIncomeStrategy(CapitalizedIncomeStrategyEnum capitalizedIncomeStrategy) {
    
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
    return this;
  }

  /**
   * Get capitalizedIncomeStrategy
   * @return capitalizedIncomeStrategy
   */
  @javax.annotation.Nullable

  public CapitalizedIncomeStrategyEnum getCapitalizedIncomeStrategy() {
    return capitalizedIncomeStrategy;
  }


  public void setCapitalizedIncomeStrategy(CapitalizedIncomeStrategyEnum capitalizedIncomeStrategy) {
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
  }

  public PutLoanProductsProductIdRequest capitalizedIncomeType(CapitalizedIncomeTypeEnum capitalizedIncomeType) {
    
    this.capitalizedIncomeType = capitalizedIncomeType;
    return this;
  }

  /**
   * Get capitalizedIncomeType
   * @return capitalizedIncomeType
   */
  @javax.annotation.Nullable

  public CapitalizedIncomeTypeEnum getCapitalizedIncomeType() {
    return capitalizedIncomeType;
  }


  public void setCapitalizedIncomeType(CapitalizedIncomeTypeEnum capitalizedIncomeType) {
    this.capitalizedIncomeType = capitalizedIncomeType;
  }

  public PutLoanProductsProductIdRequest chargeOffBehaviour(String chargeOffBehaviour) {
    
    this.chargeOffBehaviour = chargeOffBehaviour;
    return this;
  }

  /**
   * Get chargeOffBehaviour
   * @return chargeOffBehaviour
   */
  @javax.annotation.Nullable

  public String getChargeOffBehaviour() {
    return chargeOffBehaviour;
  }


  public void setChargeOffBehaviour(String chargeOffBehaviour) {
    this.chargeOffBehaviour = chargeOffBehaviour;
  }

  public PutLoanProductsProductIdRequest chargeOffExpenseAccountId(Long chargeOffExpenseAccountId) {
    
    this.chargeOffExpenseAccountId = chargeOffExpenseAccountId;
    return this;
  }

  /**
   * Get chargeOffExpenseAccountId
   * @return chargeOffExpenseAccountId
   */
  @javax.annotation.Nullable

  public Long getChargeOffExpenseAccountId() {
    return chargeOffExpenseAccountId;
  }


  public void setChargeOffExpenseAccountId(Long chargeOffExpenseAccountId) {
    this.chargeOffExpenseAccountId = chargeOffExpenseAccountId;
  }

  public PutLoanProductsProductIdRequest chargeOffFraudExpenseAccountId(Long chargeOffFraudExpenseAccountId) {
    
    this.chargeOffFraudExpenseAccountId = chargeOffFraudExpenseAccountId;
    return this;
  }

  /**
   * Get chargeOffFraudExpenseAccountId
   * @return chargeOffFraudExpenseAccountId
   */
  @javax.annotation.Nullable

  public Long getChargeOffFraudExpenseAccountId() {
    return chargeOffFraudExpenseAccountId;
  }


  public void setChargeOffFraudExpenseAccountId(Long chargeOffFraudExpenseAccountId) {
    this.chargeOffFraudExpenseAccountId = chargeOffFraudExpenseAccountId;
  }

  public PutLoanProductsProductIdRequest chargeOffReasonToExpenseAccountMappings(List<PostChargeOffReasonToExpenseAccountMappings> chargeOffReasonToExpenseAccountMappings) {
    
    this.chargeOffReasonToExpenseAccountMappings = chargeOffReasonToExpenseAccountMappings;
    return this;
  }

  public PutLoanProductsProductIdRequest addChargeOffReasonToExpenseAccountMappingsItem(PostChargeOffReasonToExpenseAccountMappings chargeOffReasonToExpenseAccountMappingsItem) {
    if (this.chargeOffReasonToExpenseAccountMappings == null) {
      this.chargeOffReasonToExpenseAccountMappings = new ArrayList<>();
    }
    this.chargeOffReasonToExpenseAccountMappings.add(chargeOffReasonToExpenseAccountMappingsItem);
    return this;
  }

  /**
   * Get chargeOffReasonToExpenseAccountMappings
   * @return chargeOffReasonToExpenseAccountMappings
   */
  @javax.annotation.Nullable

  public List<PostChargeOffReasonToExpenseAccountMappings> getChargeOffReasonToExpenseAccountMappings() {
    return chargeOffReasonToExpenseAccountMappings;
  }


  public void setChargeOffReasonToExpenseAccountMappings(List<PostChargeOffReasonToExpenseAccountMappings> chargeOffReasonToExpenseAccountMappings) {
    this.chargeOffReasonToExpenseAccountMappings = chargeOffReasonToExpenseAccountMappings;
  }

  public PutLoanProductsProductIdRequest charges(List<LoanProductChargeData> charges) {
    
    this.charges = charges;
    return this;
  }

  public PutLoanProductsProductIdRequest addChargesItem(LoanProductChargeData chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<LoanProductChargeData> getCharges() {
    return charges;
  }


  public void setCharges(List<LoanProductChargeData> charges) {
    this.charges = charges;
  }

  public PutLoanProductsProductIdRequest closeDate(String closeDate) {
    
    this.closeDate = closeDate;
    return this;
  }

  /**
   * Get closeDate
   * @return closeDate
   */
  @javax.annotation.Nullable

  public String getCloseDate() {
    return closeDate;
  }


  public void setCloseDate(String closeDate) {
    this.closeDate = closeDate;
  }

  public PutLoanProductsProductIdRequest creditAllocation(List<CreditAllocationData> creditAllocation) {
    
    this.creditAllocation = creditAllocation;
    return this;
  }

  public PutLoanProductsProductIdRequest addCreditAllocationItem(CreditAllocationData creditAllocationItem) {
    if (this.creditAllocation == null) {
      this.creditAllocation = new ArrayList<>();
    }
    this.creditAllocation.add(creditAllocationItem);
    return this;
  }

  /**
   * Get creditAllocation
   * @return creditAllocation
   */
  @javax.annotation.Nullable

  public List<CreditAllocationData> getCreditAllocation() {
    return creditAllocation;
  }


  public void setCreditAllocation(List<CreditAllocationData> creditAllocation) {
    this.creditAllocation = creditAllocation;
  }

  public PutLoanProductsProductIdRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Get currencyCode
   * @return currencyCode
   */
  @javax.annotation.Nullable

  public String getCurrencyCode() {
    return currencyCode;
  }


  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public PutLoanProductsProductIdRequest dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public PutLoanProductsProductIdRequest daysInMonthType(Long daysInMonthType) {
    
    this.daysInMonthType = daysInMonthType;
    return this;
  }

  /**
   * Get daysInMonthType
   * @return daysInMonthType
   */
  @javax.annotation.Nullable

  public Long getDaysInMonthType() {
    return daysInMonthType;
  }


  public void setDaysInMonthType(Long daysInMonthType) {
    this.daysInMonthType = daysInMonthType;
  }

  public PutLoanProductsProductIdRequest daysInYearCustomStrategy(String daysInYearCustomStrategy) {
    
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
    return this;
  }

  /**
   * Get daysInYearCustomStrategy
   * @return daysInYearCustomStrategy
   */
  @javax.annotation.Nullable

  public String getDaysInYearCustomStrategy() {
    return daysInYearCustomStrategy;
  }


  public void setDaysInYearCustomStrategy(String daysInYearCustomStrategy) {
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
  }

  public PutLoanProductsProductIdRequest daysInYearType(Long daysInYearType) {
    
    this.daysInYearType = daysInYearType;
    return this;
  }

  /**
   * Get daysInYearType
   * @return daysInYearType
   */
  @javax.annotation.Nullable

  public Long getDaysInYearType() {
    return daysInYearType;
  }


  public void setDaysInYearType(Long daysInYearType) {
    this.daysInYearType = daysInYearType;
  }

  public PutLoanProductsProductIdRequest deferredIncomeLiabilityAccountId(Long deferredIncomeLiabilityAccountId) {
    
    this.deferredIncomeLiabilityAccountId = deferredIncomeLiabilityAccountId;
    return this;
  }

  /**
   * Get deferredIncomeLiabilityAccountId
   * @return deferredIncomeLiabilityAccountId
   */
  @javax.annotation.Nullable

  public Long getDeferredIncomeLiabilityAccountId() {
    return deferredIncomeLiabilityAccountId;
  }


  public void setDeferredIncomeLiabilityAccountId(Long deferredIncomeLiabilityAccountId) {
    this.deferredIncomeLiabilityAccountId = deferredIncomeLiabilityAccountId;
  }

  public PutLoanProductsProductIdRequest delinquencyBucketId(Long delinquencyBucketId) {
    
    this.delinquencyBucketId = delinquencyBucketId;
    return this;
  }

  /**
   * Get delinquencyBucketId
   * @return delinquencyBucketId
   */
  @javax.annotation.Nullable

  public Long getDelinquencyBucketId() {
    return delinquencyBucketId;
  }


  public void setDelinquencyBucketId(Long delinquencyBucketId) {
    this.delinquencyBucketId = delinquencyBucketId;
  }

  public PutLoanProductsProductIdRequest description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }

  public PutLoanProductsProductIdRequest digitsAfterDecimal(Integer digitsAfterDecimal) {
    
    this.digitsAfterDecimal = digitsAfterDecimal;
    return this;
  }

  /**
   * Get digitsAfterDecimal
   * @return digitsAfterDecimal
   */
  @javax.annotation.Nullable

  public Integer getDigitsAfterDecimal() {
    return digitsAfterDecimal;
  }


  public void setDigitsAfterDecimal(Integer digitsAfterDecimal) {
    this.digitsAfterDecimal = digitsAfterDecimal;
  }

  public PutLoanProductsProductIdRequest disallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
    return this;
  }

  /**
   * Get disallowExpectedDisbursements
   * @return disallowExpectedDisbursements
   */
  @javax.annotation.Nullable

  public Boolean getDisallowExpectedDisbursements() {
    return disallowExpectedDisbursements;
  }


  public void setDisallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
  }

  public PutLoanProductsProductIdRequest disallowInterestCalculationOnPastDue(Boolean disallowInterestCalculationOnPastDue) {
    
    this.disallowInterestCalculationOnPastDue = disallowInterestCalculationOnPastDue;
    return this;
  }

  /**
   * Get disallowInterestCalculationOnPastDue
   * @return disallowInterestCalculationOnPastDue
   */
  @javax.annotation.Nullable

  public Boolean getDisallowInterestCalculationOnPastDue() {
    return disallowInterestCalculationOnPastDue;
  }


  public void setDisallowInterestCalculationOnPastDue(Boolean disallowInterestCalculationOnPastDue) {
    this.disallowInterestCalculationOnPastDue = disallowInterestCalculationOnPastDue;
  }

  public PutLoanProductsProductIdRequest disbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
    return this;
  }

  /**
   * Get disbursedAmountPercentageForDownPayment
   * @return disbursedAmountPercentageForDownPayment
   */
  @javax.annotation.Nullable

  public BigDecimal getDisbursedAmountPercentageForDownPayment() {
    return disbursedAmountPercentageForDownPayment;
  }


  public void setDisbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
  }

  public PutLoanProductsProductIdRequest dueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get dueDaysForRepaymentEvent
   * @return dueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getDueDaysForRepaymentEvent() {
    return dueDaysForRepaymentEvent;
  }


  public void setDueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
  }

  public PutLoanProductsProductIdRequest enableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
    return this;
  }

  /**
   * Get enableAccrualActivityPosting
   * @return enableAccrualActivityPosting
   */
  @javax.annotation.Nullable

  public Boolean getEnableAccrualActivityPosting() {
    return enableAccrualActivityPosting;
  }


  public void setEnableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
  }

  public PutLoanProductsProductIdRequest enableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
    return this;
  }

  /**
   * Get enableAutoRepaymentForDownPayment
   * @return enableAutoRepaymentForDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableAutoRepaymentForDownPayment() {
    return enableAutoRepaymentForDownPayment;
  }


  public void setEnableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
  }

  public PutLoanProductsProductIdRequest enableBuyDownFee(Boolean enableBuyDownFee) {
    
    this.enableBuyDownFee = enableBuyDownFee;
    return this;
  }

  /**
   * Get enableBuyDownFee
   * @return enableBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getEnableBuyDownFee() {
    return enableBuyDownFee;
  }


  public void setEnableBuyDownFee(Boolean enableBuyDownFee) {
    this.enableBuyDownFee = enableBuyDownFee;
  }

  public PutLoanProductsProductIdRequest enableDownPayment(Boolean enableDownPayment) {
    
    this.enableDownPayment = enableDownPayment;
    return this;
  }

  /**
   * Get enableDownPayment
   * @return enableDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableDownPayment() {
    return enableDownPayment;
  }


  public void setEnableDownPayment(Boolean enableDownPayment) {
    this.enableDownPayment = enableDownPayment;
  }

  public PutLoanProductsProductIdRequest enableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    
    this.enableIncomeCapitalization = enableIncomeCapitalization;
    return this;
  }

  /**
   * Get enableIncomeCapitalization
   * @return enableIncomeCapitalization
   */
  @javax.annotation.Nullable

  public Boolean getEnableIncomeCapitalization() {
    return enableIncomeCapitalization;
  }


  public void setEnableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    this.enableIncomeCapitalization = enableIncomeCapitalization;
  }

  public PutLoanProductsProductIdRequest enableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
    return this;
  }

  /**
   * Get enableInstallmentLevelDelinquency
   * @return enableInstallmentLevelDelinquency
   */
  @javax.annotation.Nullable

  public Boolean getEnableInstallmentLevelDelinquency() {
    return enableInstallmentLevelDelinquency;
  }


  public void setEnableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
  }

  public PutLoanProductsProductIdRequest feeToIncomeAccountMappings(List<LoanProductChargeToGLAccountMapper> feeToIncomeAccountMappings) {
    
    this.feeToIncomeAccountMappings = feeToIncomeAccountMappings;
    return this;
  }

  public PutLoanProductsProductIdRequest addFeeToIncomeAccountMappingsItem(LoanProductChargeToGLAccountMapper feeToIncomeAccountMappingsItem) {
    if (this.feeToIncomeAccountMappings == null) {
      this.feeToIncomeAccountMappings = new ArrayList<>();
    }
    this.feeToIncomeAccountMappings.add(feeToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get feeToIncomeAccountMappings
   * @return feeToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<LoanProductChargeToGLAccountMapper> getFeeToIncomeAccountMappings() {
    return feeToIncomeAccountMappings;
  }


  public void setFeeToIncomeAccountMappings(List<LoanProductChargeToGLAccountMapper> feeToIncomeAccountMappings) {
    this.feeToIncomeAccountMappings = feeToIncomeAccountMappings;
  }

  public PutLoanProductsProductIdRequest fixedLength(Integer fixedLength) {
    
    this.fixedLength = fixedLength;
    return this;
  }

  /**
   * Get fixedLength
   * @return fixedLength
   */
  @javax.annotation.Nullable

  public Integer getFixedLength() {
    return fixedLength;
  }


  public void setFixedLength(Integer fixedLength) {
    this.fixedLength = fixedLength;
  }

  public PutLoanProductsProductIdRequest fixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
    return this;
  }

  /**
   * Get fixedPrincipalPercentagePerInstallment
   * @return fixedPrincipalPercentagePerInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedPrincipalPercentagePerInstallment() {
    return fixedPrincipalPercentagePerInstallment;
  }


  public void setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
  }

  public PutLoanProductsProductIdRequest fundId(Long fundId) {
    
    this.fundId = fundId;
    return this;
  }

  /**
   * Get fundId
   * @return fundId
   */
  @javax.annotation.Nullable

  public Long getFundId() {
    return fundId;
  }


  public void setFundId(Long fundId) {
    this.fundId = fundId;
  }

  public PutLoanProductsProductIdRequest fundSourceAccountId(Long fundSourceAccountId) {
    
    this.fundSourceAccountId = fundSourceAccountId;
    return this;
  }

  /**
   * Get fundSourceAccountId
   * @return fundSourceAccountId
   */
  @javax.annotation.Nullable

  public Long getFundSourceAccountId() {
    return fundSourceAccountId;
  }


  public void setFundSourceAccountId(Long fundSourceAccountId) {
    this.fundSourceAccountId = fundSourceAccountId;
  }

  public PutLoanProductsProductIdRequest goodwillCreditAccountId(Long goodwillCreditAccountId) {
    
    this.goodwillCreditAccountId = goodwillCreditAccountId;
    return this;
  }

  /**
   * Get goodwillCreditAccountId
   * @return goodwillCreditAccountId
   */
  @javax.annotation.Nullable

  public Long getGoodwillCreditAccountId() {
    return goodwillCreditAccountId;
  }


  public void setGoodwillCreditAccountId(Long goodwillCreditAccountId) {
    this.goodwillCreditAccountId = goodwillCreditAccountId;
  }

  public PutLoanProductsProductIdRequest graceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
    return this;
  }

  /**
   * Get graceOnArrearsAgeing
   * @return graceOnArrearsAgeing
   */
  @javax.annotation.Nullable

  public Integer getGraceOnArrearsAgeing() {
    return graceOnArrearsAgeing;
  }


  public void setGraceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
  }

  public PutLoanProductsProductIdRequest graceOnInterestPayment(Integer graceOnInterestPayment) {
    
    this.graceOnInterestPayment = graceOnInterestPayment;
    return this;
  }

  /**
   * Get graceOnInterestPayment
   * @return graceOnInterestPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestPayment() {
    return graceOnInterestPayment;
  }


  public void setGraceOnInterestPayment(Integer graceOnInterestPayment) {
    this.graceOnInterestPayment = graceOnInterestPayment;
  }

  public PutLoanProductsProductIdRequest graceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
    return this;
  }

  /**
   * Get graceOnPrincipalPayment
   * @return graceOnPrincipalPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnPrincipalPayment() {
    return graceOnPrincipalPayment;
  }


  public void setGraceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
  }

  public PutLoanProductsProductIdRequest holdGuaranteeFunds(Boolean holdGuaranteeFunds) {
    
    this.holdGuaranteeFunds = holdGuaranteeFunds;
    return this;
  }

  /**
   * Get holdGuaranteeFunds
   * @return holdGuaranteeFunds
   */
  @javax.annotation.Nullable

  public Boolean getHoldGuaranteeFunds() {
    return holdGuaranteeFunds;
  }


  public void setHoldGuaranteeFunds(Boolean holdGuaranteeFunds) {
    this.holdGuaranteeFunds = holdGuaranteeFunds;
  }

  public PutLoanProductsProductIdRequest inArrearsTolerance(Integer inArrearsTolerance) {
    
    this.inArrearsTolerance = inArrearsTolerance;
    return this;
  }

  /**
   * Get inArrearsTolerance
   * @return inArrearsTolerance
   */
  @javax.annotation.Nullable

  public Integer getInArrearsTolerance() {
    return inArrearsTolerance;
  }


  public void setInArrearsTolerance(Integer inArrearsTolerance) {
    this.inArrearsTolerance = inArrearsTolerance;
  }

  public PutLoanProductsProductIdRequest inMultiplesOf(Integer inMultiplesOf) {
    
    this.inMultiplesOf = inMultiplesOf;
    return this;
  }

  /**
   * Get inMultiplesOf
   * @return inMultiplesOf
   */
  @javax.annotation.Nullable

  public Integer getInMultiplesOf() {
    return inMultiplesOf;
  }


  public void setInMultiplesOf(Integer inMultiplesOf) {
    this.inMultiplesOf = inMultiplesOf;
  }

  public PutLoanProductsProductIdRequest includeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    
    this.includeInBorrowerCycle = includeInBorrowerCycle;
    return this;
  }

  /**
   * Get includeInBorrowerCycle
   * @return includeInBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getIncludeInBorrowerCycle() {
    return includeInBorrowerCycle;
  }


  public void setIncludeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    this.includeInBorrowerCycle = includeInBorrowerCycle;
  }

  public PutLoanProductsProductIdRequest incomeFromBuyDownAccountId(Long incomeFromBuyDownAccountId) {
    
    this.incomeFromBuyDownAccountId = incomeFromBuyDownAccountId;
    return this;
  }

  /**
   * Get incomeFromBuyDownAccountId
   * @return incomeFromBuyDownAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromBuyDownAccountId() {
    return incomeFromBuyDownAccountId;
  }


  public void setIncomeFromBuyDownAccountId(Long incomeFromBuyDownAccountId) {
    this.incomeFromBuyDownAccountId = incomeFromBuyDownAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromCapitalizationAccountId(Long incomeFromCapitalizationAccountId) {
    
    this.incomeFromCapitalizationAccountId = incomeFromCapitalizationAccountId;
    return this;
  }

  /**
   * Get incomeFromCapitalizationAccountId
   * @return incomeFromCapitalizationAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromCapitalizationAccountId() {
    return incomeFromCapitalizationAccountId;
  }


  public void setIncomeFromCapitalizationAccountId(Long incomeFromCapitalizationAccountId) {
    this.incomeFromCapitalizationAccountId = incomeFromCapitalizationAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromChargeOffFeesAccountId(Long incomeFromChargeOffFeesAccountId) {
    
    this.incomeFromChargeOffFeesAccountId = incomeFromChargeOffFeesAccountId;
    return this;
  }

  /**
   * Get incomeFromChargeOffFeesAccountId
   * @return incomeFromChargeOffFeesAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromChargeOffFeesAccountId() {
    return incomeFromChargeOffFeesAccountId;
  }


  public void setIncomeFromChargeOffFeesAccountId(Long incomeFromChargeOffFeesAccountId) {
    this.incomeFromChargeOffFeesAccountId = incomeFromChargeOffFeesAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromChargeOffInterestAccountId(Long incomeFromChargeOffInterestAccountId) {
    
    this.incomeFromChargeOffInterestAccountId = incomeFromChargeOffInterestAccountId;
    return this;
  }

  /**
   * Get incomeFromChargeOffInterestAccountId
   * @return incomeFromChargeOffInterestAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromChargeOffInterestAccountId() {
    return incomeFromChargeOffInterestAccountId;
  }


  public void setIncomeFromChargeOffInterestAccountId(Long incomeFromChargeOffInterestAccountId) {
    this.incomeFromChargeOffInterestAccountId = incomeFromChargeOffInterestAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromChargeOffPenaltyAccountId(Long incomeFromChargeOffPenaltyAccountId) {
    
    this.incomeFromChargeOffPenaltyAccountId = incomeFromChargeOffPenaltyAccountId;
    return this;
  }

  /**
   * Get incomeFromChargeOffPenaltyAccountId
   * @return incomeFromChargeOffPenaltyAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromChargeOffPenaltyAccountId() {
    return incomeFromChargeOffPenaltyAccountId;
  }


  public void setIncomeFromChargeOffPenaltyAccountId(Long incomeFromChargeOffPenaltyAccountId) {
    this.incomeFromChargeOffPenaltyAccountId = incomeFromChargeOffPenaltyAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromFeeAccountId(Long incomeFromFeeAccountId) {
    
    this.incomeFromFeeAccountId = incomeFromFeeAccountId;
    return this;
  }

  /**
   * Get incomeFromFeeAccountId
   * @return incomeFromFeeAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromFeeAccountId() {
    return incomeFromFeeAccountId;
  }


  public void setIncomeFromFeeAccountId(Long incomeFromFeeAccountId) {
    this.incomeFromFeeAccountId = incomeFromFeeAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromGoodwillCreditFeesAccountId(Long incomeFromGoodwillCreditFeesAccountId) {
    
    this.incomeFromGoodwillCreditFeesAccountId = incomeFromGoodwillCreditFeesAccountId;
    return this;
  }

  /**
   * Get incomeFromGoodwillCreditFeesAccountId
   * @return incomeFromGoodwillCreditFeesAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromGoodwillCreditFeesAccountId() {
    return incomeFromGoodwillCreditFeesAccountId;
  }


  public void setIncomeFromGoodwillCreditFeesAccountId(Long incomeFromGoodwillCreditFeesAccountId) {
    this.incomeFromGoodwillCreditFeesAccountId = incomeFromGoodwillCreditFeesAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromGoodwillCreditInterestAccountId(Long incomeFromGoodwillCreditInterestAccountId) {
    
    this.incomeFromGoodwillCreditInterestAccountId = incomeFromGoodwillCreditInterestAccountId;
    return this;
  }

  /**
   * Get incomeFromGoodwillCreditInterestAccountId
   * @return incomeFromGoodwillCreditInterestAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromGoodwillCreditInterestAccountId() {
    return incomeFromGoodwillCreditInterestAccountId;
  }


  public void setIncomeFromGoodwillCreditInterestAccountId(Long incomeFromGoodwillCreditInterestAccountId) {
    this.incomeFromGoodwillCreditInterestAccountId = incomeFromGoodwillCreditInterestAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromGoodwillCreditPenaltyAccountId(Long incomeFromGoodwillCreditPenaltyAccountId) {
    
    this.incomeFromGoodwillCreditPenaltyAccountId = incomeFromGoodwillCreditPenaltyAccountId;
    return this;
  }

  /**
   * Get incomeFromGoodwillCreditPenaltyAccountId
   * @return incomeFromGoodwillCreditPenaltyAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromGoodwillCreditPenaltyAccountId() {
    return incomeFromGoodwillCreditPenaltyAccountId;
  }


  public void setIncomeFromGoodwillCreditPenaltyAccountId(Long incomeFromGoodwillCreditPenaltyAccountId) {
    this.incomeFromGoodwillCreditPenaltyAccountId = incomeFromGoodwillCreditPenaltyAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromPenaltyAccountId(Long incomeFromPenaltyAccountId) {
    
    this.incomeFromPenaltyAccountId = incomeFromPenaltyAccountId;
    return this;
  }

  /**
   * Get incomeFromPenaltyAccountId
   * @return incomeFromPenaltyAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromPenaltyAccountId() {
    return incomeFromPenaltyAccountId;
  }


  public void setIncomeFromPenaltyAccountId(Long incomeFromPenaltyAccountId) {
    this.incomeFromPenaltyAccountId = incomeFromPenaltyAccountId;
  }

  public PutLoanProductsProductIdRequest incomeFromRecoveryAccountId(Long incomeFromRecoveryAccountId) {
    
    this.incomeFromRecoveryAccountId = incomeFromRecoveryAccountId;
    return this;
  }

  /**
   * Get incomeFromRecoveryAccountId
   * @return incomeFromRecoveryAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromRecoveryAccountId() {
    return incomeFromRecoveryAccountId;
  }


  public void setIncomeFromRecoveryAccountId(Long incomeFromRecoveryAccountId) {
    this.incomeFromRecoveryAccountId = incomeFromRecoveryAccountId;
  }

  public PutLoanProductsProductIdRequest installmentAmountInMultiplesOf(Integer installmentAmountInMultiplesOf) {
    
    this.installmentAmountInMultiplesOf = installmentAmountInMultiplesOf;
    return this;
  }

  /**
   * Get installmentAmountInMultiplesOf
   * @return installmentAmountInMultiplesOf
   */
  @javax.annotation.Nullable

  public Integer getInstallmentAmountInMultiplesOf() {
    return installmentAmountInMultiplesOf;
  }


  public void setInstallmentAmountInMultiplesOf(Integer installmentAmountInMultiplesOf) {
    this.installmentAmountInMultiplesOf = installmentAmountInMultiplesOf;
  }

  public PutLoanProductsProductIdRequest interestCalculationPeriodType(Integer interestCalculationPeriodType) {
    
    this.interestCalculationPeriodType = interestCalculationPeriodType;
    return this;
  }

  /**
   * Get interestCalculationPeriodType
   * @return interestCalculationPeriodType
   */
  @javax.annotation.Nullable

  public Integer getInterestCalculationPeriodType() {
    return interestCalculationPeriodType;
  }


  public void setInterestCalculationPeriodType(Integer interestCalculationPeriodType) {
    this.interestCalculationPeriodType = interestCalculationPeriodType;
  }

  public PutLoanProductsProductIdRequest interestOnLoanAccountId(Long interestOnLoanAccountId) {
    
    this.interestOnLoanAccountId = interestOnLoanAccountId;
    return this;
  }

  /**
   * Get interestOnLoanAccountId
   * @return interestOnLoanAccountId
   */
  @javax.annotation.Nullable

  public Long getInterestOnLoanAccountId() {
    return interestOnLoanAccountId;
  }


  public void setInterestOnLoanAccountId(Long interestOnLoanAccountId) {
    this.interestOnLoanAccountId = interestOnLoanAccountId;
  }

  public PutLoanProductsProductIdRequest interestRateFrequencyType(Integer interestRateFrequencyType) {
    
    this.interestRateFrequencyType = interestRateFrequencyType;
    return this;
  }

  /**
   * Get interestRateFrequencyType
   * @return interestRateFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getInterestRateFrequencyType() {
    return interestRateFrequencyType;
  }


  public void setInterestRateFrequencyType(Integer interestRateFrequencyType) {
    this.interestRateFrequencyType = interestRateFrequencyType;
  }

  public PutLoanProductsProductIdRequest interestRatePerPeriod(Double interestRatePerPeriod) {
    
    this.interestRatePerPeriod = interestRatePerPeriod;
    return this;
  }

  /**
   * Get interestRatePerPeriod
   * @return interestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getInterestRatePerPeriod() {
    return interestRatePerPeriod;
  }


  public void setInterestRatePerPeriod(Double interestRatePerPeriod) {
    this.interestRatePerPeriod = interestRatePerPeriod;
  }

  public PutLoanProductsProductIdRequest interestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
    return this;
  }

  public PutLoanProductsProductIdRequest addInterestRateVariationsForBorrowerCycleItem(Integer interestRateVariationsForBorrowerCycleItem) {
    if (this.interestRateVariationsForBorrowerCycle == null) {
      this.interestRateVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.interestRateVariationsForBorrowerCycle.add(interestRateVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get interestRateVariationsForBorrowerCycle
   * @return interestRateVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getInterestRateVariationsForBorrowerCycle() {
    return interestRateVariationsForBorrowerCycle;
  }


  public void setInterestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
  }

  public PutLoanProductsProductIdRequest interestRecalculationCompoundingMethod(Integer interestRecalculationCompoundingMethod) {
    
    this.interestRecalculationCompoundingMethod = interestRecalculationCompoundingMethod;
    return this;
  }

  /**
   * Get interestRecalculationCompoundingMethod
   * @return interestRecalculationCompoundingMethod
   */
  @javax.annotation.Nullable

  public Integer getInterestRecalculationCompoundingMethod() {
    return interestRecalculationCompoundingMethod;
  }


  public void setInterestRecalculationCompoundingMethod(Integer interestRecalculationCompoundingMethod) {
    this.interestRecalculationCompoundingMethod = interestRecalculationCompoundingMethod;
  }

  public PutLoanProductsProductIdRequest interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public PutLoanProductsProductIdRequest interestType(Integer interestType) {
    
    this.interestType = interestType;
    return this;
  }

  /**
   * Get interestType
   * @return interestType
   */
  @javax.annotation.Nullable

  public Integer getInterestType() {
    return interestType;
  }


  public void setInterestType(Integer interestType) {
    this.interestType = interestType;
  }

  public PutLoanProductsProductIdRequest isArrearsBasedOnOriginalSchedule(Boolean isArrearsBasedOnOriginalSchedule) {
    
    this.isArrearsBasedOnOriginalSchedule = isArrearsBasedOnOriginalSchedule;
    return this;
  }

  /**
   * Get isArrearsBasedOnOriginalSchedule
   * @return isArrearsBasedOnOriginalSchedule
   */
  @javax.annotation.Nullable

  public Boolean getIsArrearsBasedOnOriginalSchedule() {
    return isArrearsBasedOnOriginalSchedule;
  }


  public void setIsArrearsBasedOnOriginalSchedule(Boolean isArrearsBasedOnOriginalSchedule) {
    this.isArrearsBasedOnOriginalSchedule = isArrearsBasedOnOriginalSchedule;
  }

  public PutLoanProductsProductIdRequest isCompoundingToBePostedAsTransaction(Boolean isCompoundingToBePostedAsTransaction) {
    
    this.isCompoundingToBePostedAsTransaction = isCompoundingToBePostedAsTransaction;
    return this;
  }

  /**
   * Get isCompoundingToBePostedAsTransaction
   * @return isCompoundingToBePostedAsTransaction
   */
  @javax.annotation.Nullable

  public Boolean getIsCompoundingToBePostedAsTransaction() {
    return isCompoundingToBePostedAsTransaction;
  }


  public void setIsCompoundingToBePostedAsTransaction(Boolean isCompoundingToBePostedAsTransaction) {
    this.isCompoundingToBePostedAsTransaction = isCompoundingToBePostedAsTransaction;
  }

  public PutLoanProductsProductIdRequest isEqualAmortization(Boolean isEqualAmortization) {
    
    this.isEqualAmortization = isEqualAmortization;
    return this;
  }

  /**
   * Get isEqualAmortization
   * @return isEqualAmortization
   */
  @javax.annotation.Nullable

  public Boolean getIsEqualAmortization() {
    return isEqualAmortization;
  }


  public void setIsEqualAmortization(Boolean isEqualAmortization) {
    this.isEqualAmortization = isEqualAmortization;
  }

  public PutLoanProductsProductIdRequest isInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
    return this;
  }

  /**
   * Get isInterestRecalculationEnabled
   * @return isInterestRecalculationEnabled
   */
  @javax.annotation.Nullable

  public Boolean getIsInterestRecalculationEnabled() {
    return isInterestRecalculationEnabled;
  }


  public void setIsInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
  }

  public PutLoanProductsProductIdRequest isLinkedToFloatingInterestRates(Boolean isLinkedToFloatingInterestRates) {
    
    this.isLinkedToFloatingInterestRates = isLinkedToFloatingInterestRates;
    return this;
  }

  /**
   * Get isLinkedToFloatingInterestRates
   * @return isLinkedToFloatingInterestRates
   */
  @javax.annotation.Nullable

  public Boolean getIsLinkedToFloatingInterestRates() {
    return isLinkedToFloatingInterestRates;
  }


  public void setIsLinkedToFloatingInterestRates(Boolean isLinkedToFloatingInterestRates) {
    this.isLinkedToFloatingInterestRates = isLinkedToFloatingInterestRates;
  }

  public PutLoanProductsProductIdRequest loanPortfolioAccountId(Long loanPortfolioAccountId) {
    
    this.loanPortfolioAccountId = loanPortfolioAccountId;
    return this;
  }

  /**
   * Get loanPortfolioAccountId
   * @return loanPortfolioAccountId
   */
  @javax.annotation.Nullable

  public Long getLoanPortfolioAccountId() {
    return loanPortfolioAccountId;
  }


  public void setLoanPortfolioAccountId(Long loanPortfolioAccountId) {
    this.loanPortfolioAccountId = loanPortfolioAccountId;
  }

  public PutLoanProductsProductIdRequest loanScheduleProcessingType(String loanScheduleProcessingType) {
    
    this.loanScheduleProcessingType = loanScheduleProcessingType;
    return this;
  }

  /**
   * Get loanScheduleProcessingType
   * @return loanScheduleProcessingType
   */
  @javax.annotation.Nullable

  public String getLoanScheduleProcessingType() {
    return loanScheduleProcessingType;
  }


  public void setLoanScheduleProcessingType(String loanScheduleProcessingType) {
    this.loanScheduleProcessingType = loanScheduleProcessingType;
  }

  public PutLoanProductsProductIdRequest loanScheduleType(String loanScheduleType) {
    
    this.loanScheduleType = loanScheduleType;
    return this;
  }

  /**
   * Get loanScheduleType
   * @return loanScheduleType
   */
  @javax.annotation.Nullable

  public String getLoanScheduleType() {
    return loanScheduleType;
  }


  public void setLoanScheduleType(String loanScheduleType) {
    this.loanScheduleType = loanScheduleType;
  }

  public PutLoanProductsProductIdRequest locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public PutLoanProductsProductIdRequest maxInterestRatePerPeriod(Double maxInterestRatePerPeriod) {
    
    this.maxInterestRatePerPeriod = maxInterestRatePerPeriod;
    return this;
  }

  /**
   * Get maxInterestRatePerPeriod
   * @return maxInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getMaxInterestRatePerPeriod() {
    return maxInterestRatePerPeriod;
  }


  public void setMaxInterestRatePerPeriod(Double maxInterestRatePerPeriod) {
    this.maxInterestRatePerPeriod = maxInterestRatePerPeriod;
  }

  public PutLoanProductsProductIdRequest maxNumberOfRepayments(Integer maxNumberOfRepayments) {
    
    this.maxNumberOfRepayments = maxNumberOfRepayments;
    return this;
  }

  /**
   * Get maxNumberOfRepayments
   * @return maxNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMaxNumberOfRepayments() {
    return maxNumberOfRepayments;
  }


  public void setMaxNumberOfRepayments(Integer maxNumberOfRepayments) {
    this.maxNumberOfRepayments = maxNumberOfRepayments;
  }

  public PutLoanProductsProductIdRequest maxPrincipal(Double maxPrincipal) {
    
    this.maxPrincipal = maxPrincipal;
    return this;
  }

  /**
   * Get maxPrincipal
   * @return maxPrincipal
   */
  @javax.annotation.Nullable

  public Double getMaxPrincipal() {
    return maxPrincipal;
  }


  public void setMaxPrincipal(Double maxPrincipal) {
    this.maxPrincipal = maxPrincipal;
  }

  public PutLoanProductsProductIdRequest maxTrancheCount(Integer maxTrancheCount) {
    
    this.maxTrancheCount = maxTrancheCount;
    return this;
  }

  /**
   * Get maxTrancheCount
   * @return maxTrancheCount
   */
  @javax.annotation.Nullable

  public Integer getMaxTrancheCount() {
    return maxTrancheCount;
  }


  public void setMaxTrancheCount(Integer maxTrancheCount) {
    this.maxTrancheCount = maxTrancheCount;
  }

  public PutLoanProductsProductIdRequest minInterestRatePerPeriod(Double minInterestRatePerPeriod) {
    
    this.minInterestRatePerPeriod = minInterestRatePerPeriod;
    return this;
  }

  /**
   * Get minInterestRatePerPeriod
   * @return minInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getMinInterestRatePerPeriod() {
    return minInterestRatePerPeriod;
  }


  public void setMinInterestRatePerPeriod(Double minInterestRatePerPeriod) {
    this.minInterestRatePerPeriod = minInterestRatePerPeriod;
  }

  public PutLoanProductsProductIdRequest minNumberOfRepayments(Integer minNumberOfRepayments) {
    
    this.minNumberOfRepayments = minNumberOfRepayments;
    return this;
  }

  /**
   * Get minNumberOfRepayments
   * @return minNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMinNumberOfRepayments() {
    return minNumberOfRepayments;
  }


  public void setMinNumberOfRepayments(Integer minNumberOfRepayments) {
    this.minNumberOfRepayments = minNumberOfRepayments;
  }

  public PutLoanProductsProductIdRequest minPrincipal(Double minPrincipal) {
    
    this.minPrincipal = minPrincipal;
    return this;
  }

  /**
   * Get minPrincipal
   * @return minPrincipal
   */
  @javax.annotation.Nullable

  public Double getMinPrincipal() {
    return minPrincipal;
  }


  public void setMinPrincipal(Double minPrincipal) {
    this.minPrincipal = minPrincipal;
  }

  public PutLoanProductsProductIdRequest minimumDaysBetweenDisbursalAndFirstRepayment(Integer minimumDaysBetweenDisbursalAndFirstRepayment) {
    
    this.minimumDaysBetweenDisbursalAndFirstRepayment = minimumDaysBetweenDisbursalAndFirstRepayment;
    return this;
  }

  /**
   * Get minimumDaysBetweenDisbursalAndFirstRepayment
   * @return minimumDaysBetweenDisbursalAndFirstRepayment
   */
  @javax.annotation.Nullable

  public Integer getMinimumDaysBetweenDisbursalAndFirstRepayment() {
    return minimumDaysBetweenDisbursalAndFirstRepayment;
  }


  public void setMinimumDaysBetweenDisbursalAndFirstRepayment(Integer minimumDaysBetweenDisbursalAndFirstRepayment) {
    this.minimumDaysBetweenDisbursalAndFirstRepayment = minimumDaysBetweenDisbursalAndFirstRepayment;
  }

  public PutLoanProductsProductIdRequest multiDisburseLoan(Boolean multiDisburseLoan) {
    
    this.multiDisburseLoan = multiDisburseLoan;
    return this;
  }

  /**
   * Get multiDisburseLoan
   * @return multiDisburseLoan
   */
  @javax.annotation.Nullable

  public Boolean getMultiDisburseLoan() {
    return multiDisburseLoan;
  }


  public void setMultiDisburseLoan(Boolean multiDisburseLoan) {
    this.multiDisburseLoan = multiDisburseLoan;
  }

  public PutLoanProductsProductIdRequest name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public PutLoanProductsProductIdRequest numberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
    return this;
  }

  public PutLoanProductsProductIdRequest addNumberOfRepaymentVariationsForBorrowerCycleItem(Integer numberOfRepaymentVariationsForBorrowerCycleItem) {
    if (this.numberOfRepaymentVariationsForBorrowerCycle == null) {
      this.numberOfRepaymentVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.numberOfRepaymentVariationsForBorrowerCycle.add(numberOfRepaymentVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get numberOfRepaymentVariationsForBorrowerCycle
   * @return numberOfRepaymentVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getNumberOfRepaymentVariationsForBorrowerCycle() {
    return numberOfRepaymentVariationsForBorrowerCycle;
  }


  public void setNumberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
  }

  public PutLoanProductsProductIdRequest numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public PutLoanProductsProductIdRequest outstandingLoanBalance(Double outstandingLoanBalance) {
    
    this.outstandingLoanBalance = outstandingLoanBalance;
    return this;
  }

  /**
   * Get outstandingLoanBalance
   * @return outstandingLoanBalance
   */
  @javax.annotation.Nullable

  public Double getOutstandingLoanBalance() {
    return outstandingLoanBalance;
  }


  public void setOutstandingLoanBalance(Double outstandingLoanBalance) {
    this.outstandingLoanBalance = outstandingLoanBalance;
  }

  public PutLoanProductsProductIdRequest overAppliedCalculationType(String overAppliedCalculationType) {
    
    this.overAppliedCalculationType = overAppliedCalculationType;
    return this;
  }

  /**
   * Get overAppliedCalculationType
   * @return overAppliedCalculationType
   */
  @javax.annotation.Nullable

  public String getOverAppliedCalculationType() {
    return overAppliedCalculationType;
  }


  public void setOverAppliedCalculationType(String overAppliedCalculationType) {
    this.overAppliedCalculationType = overAppliedCalculationType;
  }

  public PutLoanProductsProductIdRequest overAppliedNumber(Integer overAppliedNumber) {
    
    this.overAppliedNumber = overAppliedNumber;
    return this;
  }

  /**
   * Get overAppliedNumber
   * @return overAppliedNumber
   */
  @javax.annotation.Nullable

  public Integer getOverAppliedNumber() {
    return overAppliedNumber;
  }


  public void setOverAppliedNumber(Integer overAppliedNumber) {
    this.overAppliedNumber = overAppliedNumber;
  }

  public PutLoanProductsProductIdRequest overDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get overDueDaysForRepaymentEvent
   * @return overDueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getOverDueDaysForRepaymentEvent() {
    return overDueDaysForRepaymentEvent;
  }


  public void setOverDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
  }

  public PutLoanProductsProductIdRequest overdueDaysForNPA(Integer overdueDaysForNPA) {
    
    this.overdueDaysForNPA = overdueDaysForNPA;
    return this;
  }

  /**
   * Get overdueDaysForNPA
   * @return overdueDaysForNPA
   */
  @javax.annotation.Nullable

  public Integer getOverdueDaysForNPA() {
    return overdueDaysForNPA;
  }


  public void setOverdueDaysForNPA(Integer overdueDaysForNPA) {
    this.overdueDaysForNPA = overdueDaysForNPA;
  }

  public PutLoanProductsProductIdRequest overpaymentLiabilityAccountId(Long overpaymentLiabilityAccountId) {
    
    this.overpaymentLiabilityAccountId = overpaymentLiabilityAccountId;
    return this;
  }

  /**
   * Get overpaymentLiabilityAccountId
   * @return overpaymentLiabilityAccountId
   */
  @javax.annotation.Nullable

  public Long getOverpaymentLiabilityAccountId() {
    return overpaymentLiabilityAccountId;
  }


  public void setOverpaymentLiabilityAccountId(Long overpaymentLiabilityAccountId) {
    this.overpaymentLiabilityAccountId = overpaymentLiabilityAccountId;
  }

  public PutLoanProductsProductIdRequest paymentAllocation(List<AdvancedPaymentData> paymentAllocation) {
    
    this.paymentAllocation = paymentAllocation;
    return this;
  }

  public PutLoanProductsProductIdRequest addPaymentAllocationItem(AdvancedPaymentData paymentAllocationItem) {
    if (this.paymentAllocation == null) {
      this.paymentAllocation = new ArrayList<>();
    }
    this.paymentAllocation.add(paymentAllocationItem);
    return this;
  }

  /**
   * Get paymentAllocation
   * @return paymentAllocation
   */
  @javax.annotation.Nullable

  public List<AdvancedPaymentData> getPaymentAllocation() {
    return paymentAllocation;
  }


  public void setPaymentAllocation(List<AdvancedPaymentData> paymentAllocation) {
    this.paymentAllocation = paymentAllocation;
  }

  public PutLoanProductsProductIdRequest paymentChannelToFundSourceMappings(List<GetLoanPaymentChannelToFundSourceMappings> paymentChannelToFundSourceMappings) {
    
    this.paymentChannelToFundSourceMappings = paymentChannelToFundSourceMappings;
    return this;
  }

  public PutLoanProductsProductIdRequest addPaymentChannelToFundSourceMappingsItem(GetLoanPaymentChannelToFundSourceMappings paymentChannelToFundSourceMappingsItem) {
    if (this.paymentChannelToFundSourceMappings == null) {
      this.paymentChannelToFundSourceMappings = new ArrayList<>();
    }
    this.paymentChannelToFundSourceMappings.add(paymentChannelToFundSourceMappingsItem);
    return this;
  }

  /**
   * Get paymentChannelToFundSourceMappings
   * @return paymentChannelToFundSourceMappings
   */
  @javax.annotation.Nullable

  public List<GetLoanPaymentChannelToFundSourceMappings> getPaymentChannelToFundSourceMappings() {
    return paymentChannelToFundSourceMappings;
  }


  public void setPaymentChannelToFundSourceMappings(List<GetLoanPaymentChannelToFundSourceMappings> paymentChannelToFundSourceMappings) {
    this.paymentChannelToFundSourceMappings = paymentChannelToFundSourceMappings;
  }

  public PutLoanProductsProductIdRequest penaltyToIncomeAccountMappings(List<LoanProductChargeToGLAccountMapper> penaltyToIncomeAccountMappings) {
    
    this.penaltyToIncomeAccountMappings = penaltyToIncomeAccountMappings;
    return this;
  }

  public PutLoanProductsProductIdRequest addPenaltyToIncomeAccountMappingsItem(LoanProductChargeToGLAccountMapper penaltyToIncomeAccountMappingsItem) {
    if (this.penaltyToIncomeAccountMappings == null) {
      this.penaltyToIncomeAccountMappings = new ArrayList<>();
    }
    this.penaltyToIncomeAccountMappings.add(penaltyToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get penaltyToIncomeAccountMappings
   * @return penaltyToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<LoanProductChargeToGLAccountMapper> getPenaltyToIncomeAccountMappings() {
    return penaltyToIncomeAccountMappings;
  }


  public void setPenaltyToIncomeAccountMappings(List<LoanProductChargeToGLAccountMapper> penaltyToIncomeAccountMappings) {
    this.penaltyToIncomeAccountMappings = penaltyToIncomeAccountMappings;
  }

  public PutLoanProductsProductIdRequest preClosureInterestCalculationStrategy(Integer preClosureInterestCalculationStrategy) {
    
    this.preClosureInterestCalculationStrategy = preClosureInterestCalculationStrategy;
    return this;
  }

  /**
   * Get preClosureInterestCalculationStrategy
   * @return preClosureInterestCalculationStrategy
   */
  @javax.annotation.Nullable

  public Integer getPreClosureInterestCalculationStrategy() {
    return preClosureInterestCalculationStrategy;
  }


  public void setPreClosureInterestCalculationStrategy(Integer preClosureInterestCalculationStrategy) {
    this.preClosureInterestCalculationStrategy = preClosureInterestCalculationStrategy;
  }

  public PutLoanProductsProductIdRequest principal(Double principal) {
    
    this.principal = principal;
    return this;
  }

  /**
   * Get principal
   * @return principal
   */
  @javax.annotation.Nullable

  public Double getPrincipal() {
    return principal;
  }


  public void setPrincipal(Double principal) {
    this.principal = principal;
  }

  public PutLoanProductsProductIdRequest principalThresholdForLastInstallment(Integer principalThresholdForLastInstallment) {
    
    this.principalThresholdForLastInstallment = principalThresholdForLastInstallment;
    return this;
  }

  /**
   * Get principalThresholdForLastInstallment
   * @return principalThresholdForLastInstallment
   */
  @javax.annotation.Nullable

  public Integer getPrincipalThresholdForLastInstallment() {
    return principalThresholdForLastInstallment;
  }


  public void setPrincipalThresholdForLastInstallment(Integer principalThresholdForLastInstallment) {
    this.principalThresholdForLastInstallment = principalThresholdForLastInstallment;
  }

  public PutLoanProductsProductIdRequest principalVariationsForBorrowerCycle(List<Integer> principalVariationsForBorrowerCycle) {
    
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
    return this;
  }

  public PutLoanProductsProductIdRequest addPrincipalVariationsForBorrowerCycleItem(Integer principalVariationsForBorrowerCycleItem) {
    if (this.principalVariationsForBorrowerCycle == null) {
      this.principalVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.principalVariationsForBorrowerCycle.add(principalVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get principalVariationsForBorrowerCycle
   * @return principalVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getPrincipalVariationsForBorrowerCycle() {
    return principalVariationsForBorrowerCycle;
  }


  public void setPrincipalVariationsForBorrowerCycle(List<Integer> principalVariationsForBorrowerCycle) {
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
  }

  public PutLoanProductsProductIdRequest rates(List<RateData> rates) {
    
    this.rates = rates;
    return this;
  }

  public PutLoanProductsProductIdRequest addRatesItem(RateData ratesItem) {
    if (this.rates == null) {
      this.rates = new ArrayList<>();
    }
    this.rates.add(ratesItem);
    return this;
  }

  /**
   * Get rates
   * @return rates
   */
  @javax.annotation.Nullable

  public List<RateData> getRates() {
    return rates;
  }


  public void setRates(List<RateData> rates) {
    this.rates = rates;
  }

  public PutLoanProductsProductIdRequest recalculationCompoundingFrequencyInterval(Integer recalculationCompoundingFrequencyInterval) {
    
    this.recalculationCompoundingFrequencyInterval = recalculationCompoundingFrequencyInterval;
    return this;
  }

  /**
   * Get recalculationCompoundingFrequencyInterval
   * @return recalculationCompoundingFrequencyInterval
   */
  @javax.annotation.Nullable

  public Integer getRecalculationCompoundingFrequencyInterval() {
    return recalculationCompoundingFrequencyInterval;
  }


  public void setRecalculationCompoundingFrequencyInterval(Integer recalculationCompoundingFrequencyInterval) {
    this.recalculationCompoundingFrequencyInterval = recalculationCompoundingFrequencyInterval;
  }

  public PutLoanProductsProductIdRequest recalculationCompoundingFrequencyOnDayType(Integer recalculationCompoundingFrequencyOnDayType) {
    
    this.recalculationCompoundingFrequencyOnDayType = recalculationCompoundingFrequencyOnDayType;
    return this;
  }

  /**
   * Get recalculationCompoundingFrequencyOnDayType
   * @return recalculationCompoundingFrequencyOnDayType
   */
  @javax.annotation.Nullable

  public Integer getRecalculationCompoundingFrequencyOnDayType() {
    return recalculationCompoundingFrequencyOnDayType;
  }


  public void setRecalculationCompoundingFrequencyOnDayType(Integer recalculationCompoundingFrequencyOnDayType) {
    this.recalculationCompoundingFrequencyOnDayType = recalculationCompoundingFrequencyOnDayType;
  }

  public PutLoanProductsProductIdRequest recalculationCompoundingFrequencyType(Integer recalculationCompoundingFrequencyType) {
    
    this.recalculationCompoundingFrequencyType = recalculationCompoundingFrequencyType;
    return this;
  }

  /**
   * Get recalculationCompoundingFrequencyType
   * @return recalculationCompoundingFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getRecalculationCompoundingFrequencyType() {
    return recalculationCompoundingFrequencyType;
  }


  public void setRecalculationCompoundingFrequencyType(Integer recalculationCompoundingFrequencyType) {
    this.recalculationCompoundingFrequencyType = recalculationCompoundingFrequencyType;
  }

  public PutLoanProductsProductIdRequest recalculationRestFrequencyInterval(Integer recalculationRestFrequencyInterval) {
    
    this.recalculationRestFrequencyInterval = recalculationRestFrequencyInterval;
    return this;
  }

  /**
   * Get recalculationRestFrequencyInterval
   * @return recalculationRestFrequencyInterval
   */
  @javax.annotation.Nullable

  public Integer getRecalculationRestFrequencyInterval() {
    return recalculationRestFrequencyInterval;
  }


  public void setRecalculationRestFrequencyInterval(Integer recalculationRestFrequencyInterval) {
    this.recalculationRestFrequencyInterval = recalculationRestFrequencyInterval;
  }

  public PutLoanProductsProductIdRequest recalculationRestFrequencyType(Integer recalculationRestFrequencyType) {
    
    this.recalculationRestFrequencyType = recalculationRestFrequencyType;
    return this;
  }

  /**
   * Get recalculationRestFrequencyType
   * @return recalculationRestFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getRecalculationRestFrequencyType() {
    return recalculationRestFrequencyType;
  }


  public void setRecalculationRestFrequencyType(Integer recalculationRestFrequencyType) {
    this.recalculationRestFrequencyType = recalculationRestFrequencyType;
  }

  public PutLoanProductsProductIdRequest receivableFeeAccountId(Long receivableFeeAccountId) {
    
    this.receivableFeeAccountId = receivableFeeAccountId;
    return this;
  }

  /**
   * Get receivableFeeAccountId
   * @return receivableFeeAccountId
   */
  @javax.annotation.Nullable

  public Long getReceivableFeeAccountId() {
    return receivableFeeAccountId;
  }


  public void setReceivableFeeAccountId(Long receivableFeeAccountId) {
    this.receivableFeeAccountId = receivableFeeAccountId;
  }

  public PutLoanProductsProductIdRequest receivableInterestAccountId(Long receivableInterestAccountId) {
    
    this.receivableInterestAccountId = receivableInterestAccountId;
    return this;
  }

  /**
   * Get receivableInterestAccountId
   * @return receivableInterestAccountId
   */
  @javax.annotation.Nullable

  public Long getReceivableInterestAccountId() {
    return receivableInterestAccountId;
  }


  public void setReceivableInterestAccountId(Long receivableInterestAccountId) {
    this.receivableInterestAccountId = receivableInterestAccountId;
  }

  public PutLoanProductsProductIdRequest receivablePenaltyAccountId(Long receivablePenaltyAccountId) {
    
    this.receivablePenaltyAccountId = receivablePenaltyAccountId;
    return this;
  }

  /**
   * Get receivablePenaltyAccountId
   * @return receivablePenaltyAccountId
   */
  @javax.annotation.Nullable

  public Long getReceivablePenaltyAccountId() {
    return receivablePenaltyAccountId;
  }


  public void setReceivablePenaltyAccountId(Long receivablePenaltyAccountId) {
    this.receivablePenaltyAccountId = receivablePenaltyAccountId;
  }

  public PutLoanProductsProductIdRequest repaymentEvery(Integer repaymentEvery) {
    
    this.repaymentEvery = repaymentEvery;
    return this;
  }

  /**
   * Get repaymentEvery
   * @return repaymentEvery
   */
  @javax.annotation.Nullable

  public Integer getRepaymentEvery() {
    return repaymentEvery;
  }


  public void setRepaymentEvery(Integer repaymentEvery) {
    this.repaymentEvery = repaymentEvery;
  }

  public PutLoanProductsProductIdRequest repaymentFrequencyType(Integer repaymentFrequencyType) {
    
    this.repaymentFrequencyType = repaymentFrequencyType;
    return this;
  }

  /**
   * Get repaymentFrequencyType
   * @return repaymentFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getRepaymentFrequencyType() {
    return repaymentFrequencyType;
  }


  public void setRepaymentFrequencyType(Integer repaymentFrequencyType) {
    this.repaymentFrequencyType = repaymentFrequencyType;
  }

  public PutLoanProductsProductIdRequest repaymentStartDateType(Integer repaymentStartDateType) {
    
    this.repaymentStartDateType = repaymentStartDateType;
    return this;
  }

  /**
   * Get repaymentStartDateType
   * @return repaymentStartDateType
   */
  @javax.annotation.Nullable

  public Integer getRepaymentStartDateType() {
    return repaymentStartDateType;
  }


  public void setRepaymentStartDateType(Integer repaymentStartDateType) {
    this.repaymentStartDateType = repaymentStartDateType;
  }

  public PutLoanProductsProductIdRequest rescheduleStrategyMethod(Integer rescheduleStrategyMethod) {
    
    this.rescheduleStrategyMethod = rescheduleStrategyMethod;
    return this;
  }

  /**
   * Get rescheduleStrategyMethod
   * @return rescheduleStrategyMethod
   */
  @javax.annotation.Nullable

  public Integer getRescheduleStrategyMethod() {
    return rescheduleStrategyMethod;
  }


  public void setRescheduleStrategyMethod(Integer rescheduleStrategyMethod) {
    this.rescheduleStrategyMethod = rescheduleStrategyMethod;
  }

  public PutLoanProductsProductIdRequest shortName(String shortName) {
    
    this.shortName = shortName;
    return this;
  }

  /**
   * Get shortName
   * @return shortName
   */
  @javax.annotation.Nullable

  public String getShortName() {
    return shortName;
  }


  public void setShortName(String shortName) {
    this.shortName = shortName;
  }

  public PutLoanProductsProductIdRequest startDate(String startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @javax.annotation.Nullable

  public String getStartDate() {
    return startDate;
  }


  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  public PutLoanProductsProductIdRequest supportedInterestRefundTypes(List<String> supportedInterestRefundTypes) {
    
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
    return this;
  }

  public PutLoanProductsProductIdRequest addSupportedInterestRefundTypesItem(String supportedInterestRefundTypesItem) {
    if (this.supportedInterestRefundTypes == null) {
      this.supportedInterestRefundTypes = new ArrayList<>();
    }
    this.supportedInterestRefundTypes.add(supportedInterestRefundTypesItem);
    return this;
  }

  /**
   * Get supportedInterestRefundTypes
   * @return supportedInterestRefundTypes
   */
  @javax.annotation.Nullable

  public List<String> getSupportedInterestRefundTypes() {
    return supportedInterestRefundTypes;
  }


  public void setSupportedInterestRefundTypes(List<String> supportedInterestRefundTypes) {
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
  }

  public PutLoanProductsProductIdRequest transactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
    return this;
  }

  /**
   * Get transactionProcessingStrategyCode
   * @return transactionProcessingStrategyCode
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyCode() {
    return transactionProcessingStrategyCode;
  }


  public void setTransactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
  }

  public PutLoanProductsProductIdRequest transfersInSuspenseAccountId(Long transfersInSuspenseAccountId) {
    
    this.transfersInSuspenseAccountId = transfersInSuspenseAccountId;
    return this;
  }

  /**
   * Get transfersInSuspenseAccountId
   * @return transfersInSuspenseAccountId
   */
  @javax.annotation.Nullable

  public Long getTransfersInSuspenseAccountId() {
    return transfersInSuspenseAccountId;
  }


  public void setTransfersInSuspenseAccountId(Long transfersInSuspenseAccountId) {
    this.transfersInSuspenseAccountId = transfersInSuspenseAccountId;
  }

  public PutLoanProductsProductIdRequest useBorrowerCycle(Boolean useBorrowerCycle) {
    
    this.useBorrowerCycle = useBorrowerCycle;
    return this;
  }

  /**
   * Get useBorrowerCycle
   * @return useBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getUseBorrowerCycle() {
    return useBorrowerCycle;
  }


  public void setUseBorrowerCycle(Boolean useBorrowerCycle) {
    this.useBorrowerCycle = useBorrowerCycle;
  }

  public PutLoanProductsProductIdRequest writeOffAccountId(Long writeOffAccountId) {
    
    this.writeOffAccountId = writeOffAccountId;
    return this;
  }

  /**
   * Get writeOffAccountId
   * @return writeOffAccountId
   */
  @javax.annotation.Nullable

  public Long getWriteOffAccountId() {
    return writeOffAccountId;
  }


  public void setWriteOffAccountId(Long writeOffAccountId) {
    this.writeOffAccountId = writeOffAccountId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PutLoanProductsProductIdRequest putLoanProductsProductIdRequest = (PutLoanProductsProductIdRequest) o;
    return Objects.equals(this.accountMovesOutOfNPAOnlyOnArrearsCompletion, putLoanProductsProductIdRequest.accountMovesOutOfNPAOnlyOnArrearsCompletion) &&
        Objects.equals(this.accountingRule, putLoanProductsProductIdRequest.accountingRule) &&
        Objects.equals(this.allowApprovedDisbursedAmountsOverApplied, putLoanProductsProductIdRequest.allowApprovedDisbursedAmountsOverApplied) &&
        Objects.equals(this.allowAttributeOverrides, putLoanProductsProductIdRequest.allowAttributeOverrides) &&
        Objects.equals(this.allowCompoundingOnEod, putLoanProductsProductIdRequest.allowCompoundingOnEod) &&
        Objects.equals(this.allowPartialPeriodInterestCalcualtion, putLoanProductsProductIdRequest.allowPartialPeriodInterestCalcualtion) &&
        Objects.equals(this.allowVariableInstallments, putLoanProductsProductIdRequest.allowVariableInstallments) &&
        Objects.equals(this.amortizationType, putLoanProductsProductIdRequest.amortizationType) &&
        Objects.equals(this.buyDownExpenseAccountId, putLoanProductsProductIdRequest.buyDownExpenseAccountId) &&
        Objects.equals(this.buyDownFeeCalculationType, putLoanProductsProductIdRequest.buyDownFeeCalculationType) &&
        Objects.equals(this.buyDownFeeIncomeType, putLoanProductsProductIdRequest.buyDownFeeIncomeType) &&
        Objects.equals(this.buyDownFeeStrategy, putLoanProductsProductIdRequest.buyDownFeeStrategy) &&
        Objects.equals(this.canDefineInstallmentAmount, putLoanProductsProductIdRequest.canDefineInstallmentAmount) &&
        Objects.equals(this.canUseForTopup, putLoanProductsProductIdRequest.canUseForTopup) &&
        Objects.equals(this.capitalizedIncomeCalculationType, putLoanProductsProductIdRequest.capitalizedIncomeCalculationType) &&
        Objects.equals(this.capitalizedIncomeStrategy, putLoanProductsProductIdRequest.capitalizedIncomeStrategy) &&
        Objects.equals(this.capitalizedIncomeType, putLoanProductsProductIdRequest.capitalizedIncomeType) &&
        Objects.equals(this.chargeOffBehaviour, putLoanProductsProductIdRequest.chargeOffBehaviour) &&
        Objects.equals(this.chargeOffExpenseAccountId, putLoanProductsProductIdRequest.chargeOffExpenseAccountId) &&
        Objects.equals(this.chargeOffFraudExpenseAccountId, putLoanProductsProductIdRequest.chargeOffFraudExpenseAccountId) &&
        Objects.equals(this.chargeOffReasonToExpenseAccountMappings, putLoanProductsProductIdRequest.chargeOffReasonToExpenseAccountMappings) &&
        Objects.equals(this.charges, putLoanProductsProductIdRequest.charges) &&
        Objects.equals(this.closeDate, putLoanProductsProductIdRequest.closeDate) &&
        Objects.equals(this.creditAllocation, putLoanProductsProductIdRequest.creditAllocation) &&
        Objects.equals(this.currencyCode, putLoanProductsProductIdRequest.currencyCode) &&
        Objects.equals(this.dateFormat, putLoanProductsProductIdRequest.dateFormat) &&
        Objects.equals(this.daysInMonthType, putLoanProductsProductIdRequest.daysInMonthType) &&
        Objects.equals(this.daysInYearCustomStrategy, putLoanProductsProductIdRequest.daysInYearCustomStrategy) &&
        Objects.equals(this.daysInYearType, putLoanProductsProductIdRequest.daysInYearType) &&
        Objects.equals(this.deferredIncomeLiabilityAccountId, putLoanProductsProductIdRequest.deferredIncomeLiabilityAccountId) &&
        Objects.equals(this.delinquencyBucketId, putLoanProductsProductIdRequest.delinquencyBucketId) &&
        Objects.equals(this.description, putLoanProductsProductIdRequest.description) &&
        Objects.equals(this.digitsAfterDecimal, putLoanProductsProductIdRequest.digitsAfterDecimal) &&
        Objects.equals(this.disallowExpectedDisbursements, putLoanProductsProductIdRequest.disallowExpectedDisbursements) &&
        Objects.equals(this.disallowInterestCalculationOnPastDue, putLoanProductsProductIdRequest.disallowInterestCalculationOnPastDue) &&
        Objects.equals(this.disbursedAmountPercentageForDownPayment, putLoanProductsProductIdRequest.disbursedAmountPercentageForDownPayment) &&
        Objects.equals(this.dueDaysForRepaymentEvent, putLoanProductsProductIdRequest.dueDaysForRepaymentEvent) &&
        Objects.equals(this.enableAccrualActivityPosting, putLoanProductsProductIdRequest.enableAccrualActivityPosting) &&
        Objects.equals(this.enableAutoRepaymentForDownPayment, putLoanProductsProductIdRequest.enableAutoRepaymentForDownPayment) &&
        Objects.equals(this.enableBuyDownFee, putLoanProductsProductIdRequest.enableBuyDownFee) &&
        Objects.equals(this.enableDownPayment, putLoanProductsProductIdRequest.enableDownPayment) &&
        Objects.equals(this.enableIncomeCapitalization, putLoanProductsProductIdRequest.enableIncomeCapitalization) &&
        Objects.equals(this.enableInstallmentLevelDelinquency, putLoanProductsProductIdRequest.enableInstallmentLevelDelinquency) &&
        Objects.equals(this.feeToIncomeAccountMappings, putLoanProductsProductIdRequest.feeToIncomeAccountMappings) &&
        Objects.equals(this.fixedLength, putLoanProductsProductIdRequest.fixedLength) &&
        Objects.equals(this.fixedPrincipalPercentagePerInstallment, putLoanProductsProductIdRequest.fixedPrincipalPercentagePerInstallment) &&
        Objects.equals(this.fundId, putLoanProductsProductIdRequest.fundId) &&
        Objects.equals(this.fundSourceAccountId, putLoanProductsProductIdRequest.fundSourceAccountId) &&
        Objects.equals(this.goodwillCreditAccountId, putLoanProductsProductIdRequest.goodwillCreditAccountId) &&
        Objects.equals(this.graceOnArrearsAgeing, putLoanProductsProductIdRequest.graceOnArrearsAgeing) &&
        Objects.equals(this.graceOnInterestPayment, putLoanProductsProductIdRequest.graceOnInterestPayment) &&
        Objects.equals(this.graceOnPrincipalPayment, putLoanProductsProductIdRequest.graceOnPrincipalPayment) &&
        Objects.equals(this.holdGuaranteeFunds, putLoanProductsProductIdRequest.holdGuaranteeFunds) &&
        Objects.equals(this.inArrearsTolerance, putLoanProductsProductIdRequest.inArrearsTolerance) &&
        Objects.equals(this.inMultiplesOf, putLoanProductsProductIdRequest.inMultiplesOf) &&
        Objects.equals(this.includeInBorrowerCycle, putLoanProductsProductIdRequest.includeInBorrowerCycle) &&
        Objects.equals(this.incomeFromBuyDownAccountId, putLoanProductsProductIdRequest.incomeFromBuyDownAccountId) &&
        Objects.equals(this.incomeFromCapitalizationAccountId, putLoanProductsProductIdRequest.incomeFromCapitalizationAccountId) &&
        Objects.equals(this.incomeFromChargeOffFeesAccountId, putLoanProductsProductIdRequest.incomeFromChargeOffFeesAccountId) &&
        Objects.equals(this.incomeFromChargeOffInterestAccountId, putLoanProductsProductIdRequest.incomeFromChargeOffInterestAccountId) &&
        Objects.equals(this.incomeFromChargeOffPenaltyAccountId, putLoanProductsProductIdRequest.incomeFromChargeOffPenaltyAccountId) &&
        Objects.equals(this.incomeFromFeeAccountId, putLoanProductsProductIdRequest.incomeFromFeeAccountId) &&
        Objects.equals(this.incomeFromGoodwillCreditFeesAccountId, putLoanProductsProductIdRequest.incomeFromGoodwillCreditFeesAccountId) &&
        Objects.equals(this.incomeFromGoodwillCreditInterestAccountId, putLoanProductsProductIdRequest.incomeFromGoodwillCreditInterestAccountId) &&
        Objects.equals(this.incomeFromGoodwillCreditPenaltyAccountId, putLoanProductsProductIdRequest.incomeFromGoodwillCreditPenaltyAccountId) &&
        Objects.equals(this.incomeFromPenaltyAccountId, putLoanProductsProductIdRequest.incomeFromPenaltyAccountId) &&
        Objects.equals(this.incomeFromRecoveryAccountId, putLoanProductsProductIdRequest.incomeFromRecoveryAccountId) &&
        Objects.equals(this.installmentAmountInMultiplesOf, putLoanProductsProductIdRequest.installmentAmountInMultiplesOf) &&
        Objects.equals(this.interestCalculationPeriodType, putLoanProductsProductIdRequest.interestCalculationPeriodType) &&
        Objects.equals(this.interestOnLoanAccountId, putLoanProductsProductIdRequest.interestOnLoanAccountId) &&
        Objects.equals(this.interestRateFrequencyType, putLoanProductsProductIdRequest.interestRateFrequencyType) &&
        Objects.equals(this.interestRatePerPeriod, putLoanProductsProductIdRequest.interestRatePerPeriod) &&
        Objects.equals(this.interestRateVariationsForBorrowerCycle, putLoanProductsProductIdRequest.interestRateVariationsForBorrowerCycle) &&
        Objects.equals(this.interestRecalculationCompoundingMethod, putLoanProductsProductIdRequest.interestRecalculationCompoundingMethod) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, putLoanProductsProductIdRequest.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.interestType, putLoanProductsProductIdRequest.interestType) &&
        Objects.equals(this.isArrearsBasedOnOriginalSchedule, putLoanProductsProductIdRequest.isArrearsBasedOnOriginalSchedule) &&
        Objects.equals(this.isCompoundingToBePostedAsTransaction, putLoanProductsProductIdRequest.isCompoundingToBePostedAsTransaction) &&
        Objects.equals(this.isEqualAmortization, putLoanProductsProductIdRequest.isEqualAmortization) &&
        Objects.equals(this.isInterestRecalculationEnabled, putLoanProductsProductIdRequest.isInterestRecalculationEnabled) &&
        Objects.equals(this.isLinkedToFloatingInterestRates, putLoanProductsProductIdRequest.isLinkedToFloatingInterestRates) &&
        Objects.equals(this.loanPortfolioAccountId, putLoanProductsProductIdRequest.loanPortfolioAccountId) &&
        Objects.equals(this.loanScheduleProcessingType, putLoanProductsProductIdRequest.loanScheduleProcessingType) &&
        Objects.equals(this.loanScheduleType, putLoanProductsProductIdRequest.loanScheduleType) &&
        Objects.equals(this.locale, putLoanProductsProductIdRequest.locale) &&
        Objects.equals(this.maxInterestRatePerPeriod, putLoanProductsProductIdRequest.maxInterestRatePerPeriod) &&
        Objects.equals(this.maxNumberOfRepayments, putLoanProductsProductIdRequest.maxNumberOfRepayments) &&
        Objects.equals(this.maxPrincipal, putLoanProductsProductIdRequest.maxPrincipal) &&
        Objects.equals(this.maxTrancheCount, putLoanProductsProductIdRequest.maxTrancheCount) &&
        Objects.equals(this.minInterestRatePerPeriod, putLoanProductsProductIdRequest.minInterestRatePerPeriod) &&
        Objects.equals(this.minNumberOfRepayments, putLoanProductsProductIdRequest.minNumberOfRepayments) &&
        Objects.equals(this.minPrincipal, putLoanProductsProductIdRequest.minPrincipal) &&
        Objects.equals(this.minimumDaysBetweenDisbursalAndFirstRepayment, putLoanProductsProductIdRequest.minimumDaysBetweenDisbursalAndFirstRepayment) &&
        Objects.equals(this.multiDisburseLoan, putLoanProductsProductIdRequest.multiDisburseLoan) &&
        Objects.equals(this.name, putLoanProductsProductIdRequest.name) &&
        Objects.equals(this.numberOfRepaymentVariationsForBorrowerCycle, putLoanProductsProductIdRequest.numberOfRepaymentVariationsForBorrowerCycle) &&
        Objects.equals(this.numberOfRepayments, putLoanProductsProductIdRequest.numberOfRepayments) &&
        Objects.equals(this.outstandingLoanBalance, putLoanProductsProductIdRequest.outstandingLoanBalance) &&
        Objects.equals(this.overAppliedCalculationType, putLoanProductsProductIdRequest.overAppliedCalculationType) &&
        Objects.equals(this.overAppliedNumber, putLoanProductsProductIdRequest.overAppliedNumber) &&
        Objects.equals(this.overDueDaysForRepaymentEvent, putLoanProductsProductIdRequest.overDueDaysForRepaymentEvent) &&
        Objects.equals(this.overdueDaysForNPA, putLoanProductsProductIdRequest.overdueDaysForNPA) &&
        Objects.equals(this.overpaymentLiabilityAccountId, putLoanProductsProductIdRequest.overpaymentLiabilityAccountId) &&
        Objects.equals(this.paymentAllocation, putLoanProductsProductIdRequest.paymentAllocation) &&
        Objects.equals(this.paymentChannelToFundSourceMappings, putLoanProductsProductIdRequest.paymentChannelToFundSourceMappings) &&
        Objects.equals(this.penaltyToIncomeAccountMappings, putLoanProductsProductIdRequest.penaltyToIncomeAccountMappings) &&
        Objects.equals(this.preClosureInterestCalculationStrategy, putLoanProductsProductIdRequest.preClosureInterestCalculationStrategy) &&
        Objects.equals(this.principal, putLoanProductsProductIdRequest.principal) &&
        Objects.equals(this.principalThresholdForLastInstallment, putLoanProductsProductIdRequest.principalThresholdForLastInstallment) &&
        Objects.equals(this.principalVariationsForBorrowerCycle, putLoanProductsProductIdRequest.principalVariationsForBorrowerCycle) &&
        Objects.equals(this.rates, putLoanProductsProductIdRequest.rates) &&
        Objects.equals(this.recalculationCompoundingFrequencyInterval, putLoanProductsProductIdRequest.recalculationCompoundingFrequencyInterval) &&
        Objects.equals(this.recalculationCompoundingFrequencyOnDayType, putLoanProductsProductIdRequest.recalculationCompoundingFrequencyOnDayType) &&
        Objects.equals(this.recalculationCompoundingFrequencyType, putLoanProductsProductIdRequest.recalculationCompoundingFrequencyType) &&
        Objects.equals(this.recalculationRestFrequencyInterval, putLoanProductsProductIdRequest.recalculationRestFrequencyInterval) &&
        Objects.equals(this.recalculationRestFrequencyType, putLoanProductsProductIdRequest.recalculationRestFrequencyType) &&
        Objects.equals(this.receivableFeeAccountId, putLoanProductsProductIdRequest.receivableFeeAccountId) &&
        Objects.equals(this.receivableInterestAccountId, putLoanProductsProductIdRequest.receivableInterestAccountId) &&
        Objects.equals(this.receivablePenaltyAccountId, putLoanProductsProductIdRequest.receivablePenaltyAccountId) &&
        Objects.equals(this.repaymentEvery, putLoanProductsProductIdRequest.repaymentEvery) &&
        Objects.equals(this.repaymentFrequencyType, putLoanProductsProductIdRequest.repaymentFrequencyType) &&
        Objects.equals(this.repaymentStartDateType, putLoanProductsProductIdRequest.repaymentStartDateType) &&
        Objects.equals(this.rescheduleStrategyMethod, putLoanProductsProductIdRequest.rescheduleStrategyMethod) &&
        Objects.equals(this.shortName, putLoanProductsProductIdRequest.shortName) &&
        Objects.equals(this.startDate, putLoanProductsProductIdRequest.startDate) &&
        Objects.equals(this.supportedInterestRefundTypes, putLoanProductsProductIdRequest.supportedInterestRefundTypes) &&
        Objects.equals(this.transactionProcessingStrategyCode, putLoanProductsProductIdRequest.transactionProcessingStrategyCode) &&
        Objects.equals(this.transfersInSuspenseAccountId, putLoanProductsProductIdRequest.transfersInSuspenseAccountId) &&
        Objects.equals(this.useBorrowerCycle, putLoanProductsProductIdRequest.useBorrowerCycle) &&
        Objects.equals(this.writeOffAccountId, putLoanProductsProductIdRequest.writeOffAccountId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountMovesOutOfNPAOnlyOnArrearsCompletion, accountingRule, allowApprovedDisbursedAmountsOverApplied, allowAttributeOverrides, allowCompoundingOnEod, allowPartialPeriodInterestCalcualtion, allowVariableInstallments, amortizationType, buyDownExpenseAccountId, buyDownFeeCalculationType, buyDownFeeIncomeType, buyDownFeeStrategy, canDefineInstallmentAmount, canUseForTopup, capitalizedIncomeCalculationType, capitalizedIncomeStrategy, capitalizedIncomeType, chargeOffBehaviour, chargeOffExpenseAccountId, chargeOffFraudExpenseAccountId, chargeOffReasonToExpenseAccountMappings, charges, closeDate, creditAllocation, currencyCode, dateFormat, daysInMonthType, daysInYearCustomStrategy, daysInYearType, deferredIncomeLiabilityAccountId, delinquencyBucketId, description, digitsAfterDecimal, disallowExpectedDisbursements, disallowInterestCalculationOnPastDue, disbursedAmountPercentageForDownPayment, dueDaysForRepaymentEvent, enableAccrualActivityPosting, enableAutoRepaymentForDownPayment, enableBuyDownFee, enableDownPayment, enableIncomeCapitalization, enableInstallmentLevelDelinquency, feeToIncomeAccountMappings, fixedLength, fixedPrincipalPercentagePerInstallment, fundId, fundSourceAccountId, goodwillCreditAccountId, graceOnArrearsAgeing, graceOnInterestPayment, graceOnPrincipalPayment, holdGuaranteeFunds, inArrearsTolerance, inMultiplesOf, includeInBorrowerCycle, incomeFromBuyDownAccountId, incomeFromCapitalizationAccountId, incomeFromChargeOffFeesAccountId, incomeFromChargeOffInterestAccountId, incomeFromChargeOffPenaltyAccountId, incomeFromFeeAccountId, incomeFromGoodwillCreditFeesAccountId, incomeFromGoodwillCreditInterestAccountId, incomeFromGoodwillCreditPenaltyAccountId, incomeFromPenaltyAccountId, incomeFromRecoveryAccountId, installmentAmountInMultiplesOf, interestCalculationPeriodType, interestOnLoanAccountId, interestRateFrequencyType, interestRatePerPeriod, interestRateVariationsForBorrowerCycle, interestRecalculationCompoundingMethod, interestRecognitionOnDisbursementDate, interestType, isArrearsBasedOnOriginalSchedule, isCompoundingToBePostedAsTransaction, isEqualAmortization, isInterestRecalculationEnabled, isLinkedToFloatingInterestRates, loanPortfolioAccountId, loanScheduleProcessingType, loanScheduleType, locale, maxInterestRatePerPeriod, maxNumberOfRepayments, maxPrincipal, maxTrancheCount, minInterestRatePerPeriod, minNumberOfRepayments, minPrincipal, minimumDaysBetweenDisbursalAndFirstRepayment, multiDisburseLoan, name, numberOfRepaymentVariationsForBorrowerCycle, numberOfRepayments, outstandingLoanBalance, overAppliedCalculationType, overAppliedNumber, overDueDaysForRepaymentEvent, overdueDaysForNPA, overpaymentLiabilityAccountId, paymentAllocation, paymentChannelToFundSourceMappings, penaltyToIncomeAccountMappings, preClosureInterestCalculationStrategy, principal, principalThresholdForLastInstallment, principalVariationsForBorrowerCycle, rates, recalculationCompoundingFrequencyInterval, recalculationCompoundingFrequencyOnDayType, recalculationCompoundingFrequencyType, recalculationRestFrequencyInterval, recalculationRestFrequencyType, receivableFeeAccountId, receivableInterestAccountId, receivablePenaltyAccountId, repaymentEvery, repaymentFrequencyType, repaymentStartDateType, rescheduleStrategyMethod, shortName, startDate, supportedInterestRefundTypes, transactionProcessingStrategyCode, transfersInSuspenseAccountId, useBorrowerCycle, writeOffAccountId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PutLoanProductsProductIdRequest {\n");
    sb.append("    accountMovesOutOfNPAOnlyOnArrearsCompletion: ").append(toIndentedString(accountMovesOutOfNPAOnlyOnArrearsCompletion)).append("\n");
    sb.append("    accountingRule: ").append(toIndentedString(accountingRule)).append("\n");
    sb.append("    allowApprovedDisbursedAmountsOverApplied: ").append(toIndentedString(allowApprovedDisbursedAmountsOverApplied)).append("\n");
    sb.append("    allowAttributeOverrides: ").append(toIndentedString(allowAttributeOverrides)).append("\n");
    sb.append("    allowCompoundingOnEod: ").append(toIndentedString(allowCompoundingOnEod)).append("\n");
    sb.append("    allowPartialPeriodInterestCalcualtion: ").append(toIndentedString(allowPartialPeriodInterestCalcualtion)).append("\n");
    sb.append("    allowVariableInstallments: ").append(toIndentedString(allowVariableInstallments)).append("\n");
    sb.append("    amortizationType: ").append(toIndentedString(amortizationType)).append("\n");
    sb.append("    buyDownExpenseAccountId: ").append(toIndentedString(buyDownExpenseAccountId)).append("\n");
    sb.append("    buyDownFeeCalculationType: ").append(toIndentedString(buyDownFeeCalculationType)).append("\n");
    sb.append("    buyDownFeeIncomeType: ").append(toIndentedString(buyDownFeeIncomeType)).append("\n");
    sb.append("    buyDownFeeStrategy: ").append(toIndentedString(buyDownFeeStrategy)).append("\n");
    sb.append("    canDefineInstallmentAmount: ").append(toIndentedString(canDefineInstallmentAmount)).append("\n");
    sb.append("    canUseForTopup: ").append(toIndentedString(canUseForTopup)).append("\n");
    sb.append("    capitalizedIncomeCalculationType: ").append(toIndentedString(capitalizedIncomeCalculationType)).append("\n");
    sb.append("    capitalizedIncomeStrategy: ").append(toIndentedString(capitalizedIncomeStrategy)).append("\n");
    sb.append("    capitalizedIncomeType: ").append(toIndentedString(capitalizedIncomeType)).append("\n");
    sb.append("    chargeOffBehaviour: ").append(toIndentedString(chargeOffBehaviour)).append("\n");
    sb.append("    chargeOffExpenseAccountId: ").append(toIndentedString(chargeOffExpenseAccountId)).append("\n");
    sb.append("    chargeOffFraudExpenseAccountId: ").append(toIndentedString(chargeOffFraudExpenseAccountId)).append("\n");
    sb.append("    chargeOffReasonToExpenseAccountMappings: ").append(toIndentedString(chargeOffReasonToExpenseAccountMappings)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    closeDate: ").append(toIndentedString(closeDate)).append("\n");
    sb.append("    creditAllocation: ").append(toIndentedString(creditAllocation)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    daysInMonthType: ").append(toIndentedString(daysInMonthType)).append("\n");
    sb.append("    daysInYearCustomStrategy: ").append(toIndentedString(daysInYearCustomStrategy)).append("\n");
    sb.append("    daysInYearType: ").append(toIndentedString(daysInYearType)).append("\n");
    sb.append("    deferredIncomeLiabilityAccountId: ").append(toIndentedString(deferredIncomeLiabilityAccountId)).append("\n");
    sb.append("    delinquencyBucketId: ").append(toIndentedString(delinquencyBucketId)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    digitsAfterDecimal: ").append(toIndentedString(digitsAfterDecimal)).append("\n");
    sb.append("    disallowExpectedDisbursements: ").append(toIndentedString(disallowExpectedDisbursements)).append("\n");
    sb.append("    disallowInterestCalculationOnPastDue: ").append(toIndentedString(disallowInterestCalculationOnPastDue)).append("\n");
    sb.append("    disbursedAmountPercentageForDownPayment: ").append(toIndentedString(disbursedAmountPercentageForDownPayment)).append("\n");
    sb.append("    dueDaysForRepaymentEvent: ").append(toIndentedString(dueDaysForRepaymentEvent)).append("\n");
    sb.append("    enableAccrualActivityPosting: ").append(toIndentedString(enableAccrualActivityPosting)).append("\n");
    sb.append("    enableAutoRepaymentForDownPayment: ").append(toIndentedString(enableAutoRepaymentForDownPayment)).append("\n");
    sb.append("    enableBuyDownFee: ").append(toIndentedString(enableBuyDownFee)).append("\n");
    sb.append("    enableDownPayment: ").append(toIndentedString(enableDownPayment)).append("\n");
    sb.append("    enableIncomeCapitalization: ").append(toIndentedString(enableIncomeCapitalization)).append("\n");
    sb.append("    enableInstallmentLevelDelinquency: ").append(toIndentedString(enableInstallmentLevelDelinquency)).append("\n");
    sb.append("    feeToIncomeAccountMappings: ").append(toIndentedString(feeToIncomeAccountMappings)).append("\n");
    sb.append("    fixedLength: ").append(toIndentedString(fixedLength)).append("\n");
    sb.append("    fixedPrincipalPercentagePerInstallment: ").append(toIndentedString(fixedPrincipalPercentagePerInstallment)).append("\n");
    sb.append("    fundId: ").append(toIndentedString(fundId)).append("\n");
    sb.append("    fundSourceAccountId: ").append(toIndentedString(fundSourceAccountId)).append("\n");
    sb.append("    goodwillCreditAccountId: ").append(toIndentedString(goodwillCreditAccountId)).append("\n");
    sb.append("    graceOnArrearsAgeing: ").append(toIndentedString(graceOnArrearsAgeing)).append("\n");
    sb.append("    graceOnInterestPayment: ").append(toIndentedString(graceOnInterestPayment)).append("\n");
    sb.append("    graceOnPrincipalPayment: ").append(toIndentedString(graceOnPrincipalPayment)).append("\n");
    sb.append("    holdGuaranteeFunds: ").append(toIndentedString(holdGuaranteeFunds)).append("\n");
    sb.append("    inArrearsTolerance: ").append(toIndentedString(inArrearsTolerance)).append("\n");
    sb.append("    inMultiplesOf: ").append(toIndentedString(inMultiplesOf)).append("\n");
    sb.append("    includeInBorrowerCycle: ").append(toIndentedString(includeInBorrowerCycle)).append("\n");
    sb.append("    incomeFromBuyDownAccountId: ").append(toIndentedString(incomeFromBuyDownAccountId)).append("\n");
    sb.append("    incomeFromCapitalizationAccountId: ").append(toIndentedString(incomeFromCapitalizationAccountId)).append("\n");
    sb.append("    incomeFromChargeOffFeesAccountId: ").append(toIndentedString(incomeFromChargeOffFeesAccountId)).append("\n");
    sb.append("    incomeFromChargeOffInterestAccountId: ").append(toIndentedString(incomeFromChargeOffInterestAccountId)).append("\n");
    sb.append("    incomeFromChargeOffPenaltyAccountId: ").append(toIndentedString(incomeFromChargeOffPenaltyAccountId)).append("\n");
    sb.append("    incomeFromFeeAccountId: ").append(toIndentedString(incomeFromFeeAccountId)).append("\n");
    sb.append("    incomeFromGoodwillCreditFeesAccountId: ").append(toIndentedString(incomeFromGoodwillCreditFeesAccountId)).append("\n");
    sb.append("    incomeFromGoodwillCreditInterestAccountId: ").append(toIndentedString(incomeFromGoodwillCreditInterestAccountId)).append("\n");
    sb.append("    incomeFromGoodwillCreditPenaltyAccountId: ").append(toIndentedString(incomeFromGoodwillCreditPenaltyAccountId)).append("\n");
    sb.append("    incomeFromPenaltyAccountId: ").append(toIndentedString(incomeFromPenaltyAccountId)).append("\n");
    sb.append("    incomeFromRecoveryAccountId: ").append(toIndentedString(incomeFromRecoveryAccountId)).append("\n");
    sb.append("    installmentAmountInMultiplesOf: ").append(toIndentedString(installmentAmountInMultiplesOf)).append("\n");
    sb.append("    interestCalculationPeriodType: ").append(toIndentedString(interestCalculationPeriodType)).append("\n");
    sb.append("    interestOnLoanAccountId: ").append(toIndentedString(interestOnLoanAccountId)).append("\n");
    sb.append("    interestRateFrequencyType: ").append(toIndentedString(interestRateFrequencyType)).append("\n");
    sb.append("    interestRatePerPeriod: ").append(toIndentedString(interestRatePerPeriod)).append("\n");
    sb.append("    interestRateVariationsForBorrowerCycle: ").append(toIndentedString(interestRateVariationsForBorrowerCycle)).append("\n");
    sb.append("    interestRecalculationCompoundingMethod: ").append(toIndentedString(interestRecalculationCompoundingMethod)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    interestType: ").append(toIndentedString(interestType)).append("\n");
    sb.append("    isArrearsBasedOnOriginalSchedule: ").append(toIndentedString(isArrearsBasedOnOriginalSchedule)).append("\n");
    sb.append("    isCompoundingToBePostedAsTransaction: ").append(toIndentedString(isCompoundingToBePostedAsTransaction)).append("\n");
    sb.append("    isEqualAmortization: ").append(toIndentedString(isEqualAmortization)).append("\n");
    sb.append("    isInterestRecalculationEnabled: ").append(toIndentedString(isInterestRecalculationEnabled)).append("\n");
    sb.append("    isLinkedToFloatingInterestRates: ").append(toIndentedString(isLinkedToFloatingInterestRates)).append("\n");
    sb.append("    loanPortfolioAccountId: ").append(toIndentedString(loanPortfolioAccountId)).append("\n");
    sb.append("    loanScheduleProcessingType: ").append(toIndentedString(loanScheduleProcessingType)).append("\n");
    sb.append("    loanScheduleType: ").append(toIndentedString(loanScheduleType)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    maxInterestRatePerPeriod: ").append(toIndentedString(maxInterestRatePerPeriod)).append("\n");
    sb.append("    maxNumberOfRepayments: ").append(toIndentedString(maxNumberOfRepayments)).append("\n");
    sb.append("    maxPrincipal: ").append(toIndentedString(maxPrincipal)).append("\n");
    sb.append("    maxTrancheCount: ").append(toIndentedString(maxTrancheCount)).append("\n");
    sb.append("    minInterestRatePerPeriod: ").append(toIndentedString(minInterestRatePerPeriod)).append("\n");
    sb.append("    minNumberOfRepayments: ").append(toIndentedString(minNumberOfRepayments)).append("\n");
    sb.append("    minPrincipal: ").append(toIndentedString(minPrincipal)).append("\n");
    sb.append("    minimumDaysBetweenDisbursalAndFirstRepayment: ").append(toIndentedString(minimumDaysBetweenDisbursalAndFirstRepayment)).append("\n");
    sb.append("    multiDisburseLoan: ").append(toIndentedString(multiDisburseLoan)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    numberOfRepaymentVariationsForBorrowerCycle: ").append(toIndentedString(numberOfRepaymentVariationsForBorrowerCycle)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    outstandingLoanBalance: ").append(toIndentedString(outstandingLoanBalance)).append("\n");
    sb.append("    overAppliedCalculationType: ").append(toIndentedString(overAppliedCalculationType)).append("\n");
    sb.append("    overAppliedNumber: ").append(toIndentedString(overAppliedNumber)).append("\n");
    sb.append("    overDueDaysForRepaymentEvent: ").append(toIndentedString(overDueDaysForRepaymentEvent)).append("\n");
    sb.append("    overdueDaysForNPA: ").append(toIndentedString(overdueDaysForNPA)).append("\n");
    sb.append("    overpaymentLiabilityAccountId: ").append(toIndentedString(overpaymentLiabilityAccountId)).append("\n");
    sb.append("    paymentAllocation: ").append(toIndentedString(paymentAllocation)).append("\n");
    sb.append("    paymentChannelToFundSourceMappings: ").append(toIndentedString(paymentChannelToFundSourceMappings)).append("\n");
    sb.append("    penaltyToIncomeAccountMappings: ").append(toIndentedString(penaltyToIncomeAccountMappings)).append("\n");
    sb.append("    preClosureInterestCalculationStrategy: ").append(toIndentedString(preClosureInterestCalculationStrategy)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    principalThresholdForLastInstallment: ").append(toIndentedString(principalThresholdForLastInstallment)).append("\n");
    sb.append("    principalVariationsForBorrowerCycle: ").append(toIndentedString(principalVariationsForBorrowerCycle)).append("\n");
    sb.append("    rates: ").append(toIndentedString(rates)).append("\n");
    sb.append("    recalculationCompoundingFrequencyInterval: ").append(toIndentedString(recalculationCompoundingFrequencyInterval)).append("\n");
    sb.append("    recalculationCompoundingFrequencyOnDayType: ").append(toIndentedString(recalculationCompoundingFrequencyOnDayType)).append("\n");
    sb.append("    recalculationCompoundingFrequencyType: ").append(toIndentedString(recalculationCompoundingFrequencyType)).append("\n");
    sb.append("    recalculationRestFrequencyInterval: ").append(toIndentedString(recalculationRestFrequencyInterval)).append("\n");
    sb.append("    recalculationRestFrequencyType: ").append(toIndentedString(recalculationRestFrequencyType)).append("\n");
    sb.append("    receivableFeeAccountId: ").append(toIndentedString(receivableFeeAccountId)).append("\n");
    sb.append("    receivableInterestAccountId: ").append(toIndentedString(receivableInterestAccountId)).append("\n");
    sb.append("    receivablePenaltyAccountId: ").append(toIndentedString(receivablePenaltyAccountId)).append("\n");
    sb.append("    repaymentEvery: ").append(toIndentedString(repaymentEvery)).append("\n");
    sb.append("    repaymentFrequencyType: ").append(toIndentedString(repaymentFrequencyType)).append("\n");
    sb.append("    repaymentStartDateType: ").append(toIndentedString(repaymentStartDateType)).append("\n");
    sb.append("    rescheduleStrategyMethod: ").append(toIndentedString(rescheduleStrategyMethod)).append("\n");
    sb.append("    shortName: ").append(toIndentedString(shortName)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    supportedInterestRefundTypes: ").append(toIndentedString(supportedInterestRefundTypes)).append("\n");
    sb.append("    transactionProcessingStrategyCode: ").append(toIndentedString(transactionProcessingStrategyCode)).append("\n");
    sb.append("    transfersInSuspenseAccountId: ").append(toIndentedString(transfersInSuspenseAccountId)).append("\n");
    sb.append("    useBorrowerCycle: ").append(toIndentedString(useBorrowerCycle)).append("\n");
    sb.append("    writeOffAccountId: ").append(toIndentedString(writeOffAccountId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

