/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.InterestPeriod;
import org.apache.fineract.client.models.LoanProductMinimumRepaymentScheduleRelatedDetail;
import org.apache.fineract.client.models.Money;

/**
 * RepaymentPeriod
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class RepaymentPeriod {
  public static final String SERIALIZED_NAME_CALCULATED_DUE_INTEREST = "calculatedDueInterest";
  @SerializedName(SERIALIZED_NAME_CALCULATED_DUE_INTEREST)
  private Money calculatedDueInterest;

  public static final String SERIALIZED_NAME_CALCULATED_DUE_PRINCIPAL = "calculatedDuePrincipal";
  @SerializedName(SERIALIZED_NAME_CALCULATED_DUE_PRINCIPAL)
  private Money calculatedDuePrincipal;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_PRINCIPAL = "capitalizedIncomePrincipal";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_PRINCIPAL)
  private Money capitalizedIncomePrincipal;

  public static final String SERIALIZED_NAME_CREDITED_AMOUNTS = "creditedAmounts";
  @SerializedName(SERIALIZED_NAME_CREDITED_AMOUNTS)
  private Money creditedAmounts;

  public static final String SERIALIZED_NAME_CREDITED_INTEREST = "creditedInterest";
  @SerializedName(SERIALIZED_NAME_CREDITED_INTEREST)
  private Money creditedInterest;

  public static final String SERIALIZED_NAME_CREDITED_PRINCIPAL = "creditedPrincipal";
  @SerializedName(SERIALIZED_NAME_CREDITED_PRINCIPAL)
  private Money creditedPrincipal;

  public static final String SERIALIZED_NAME_DUE_DATE = "dueDate";
  @SerializedName(SERIALIZED_NAME_DUE_DATE)
  private LocalDate dueDate;

  public static final String SERIALIZED_NAME_DUE_INTEREST = "dueInterest";
  @SerializedName(SERIALIZED_NAME_DUE_INTEREST)
  private Money dueInterest;

  public static final String SERIALIZED_NAME_DUE_PRINCIPAL = "duePrincipal";
  @SerializedName(SERIALIZED_NAME_DUE_PRINCIPAL)
  private Money duePrincipal;

  public static final String SERIALIZED_NAME_EMI = "emi";
  @SerializedName(SERIALIZED_NAME_EMI)
  private Money emi;

  public static final String SERIALIZED_NAME_EMI_PLUS_CREDITED_AMOUNTS_PLUS_FUTURE_UNRECOGNIZED_INTEREST = "emiPlusCreditedAmountsPlusFutureUnrecognizedInterest";
  @SerializedName(SERIALIZED_NAME_EMI_PLUS_CREDITED_AMOUNTS_PLUS_FUTURE_UNRECOGNIZED_INTEREST)
  private Money emiPlusCreditedAmountsPlusFutureUnrecognizedInterest;

  public static final String SERIALIZED_NAME_FIRST_INTEREST_PERIOD = "firstInterestPeriod";
  @SerializedName(SERIALIZED_NAME_FIRST_INTEREST_PERIOD)
  private InterestPeriod firstInterestPeriod;

  public static final String SERIALIZED_NAME_FIRST_REPAYMENT_PERIOD = "firstRepaymentPeriod";
  @SerializedName(SERIALIZED_NAME_FIRST_REPAYMENT_PERIOD)
  private Boolean firstRepaymentPeriod;

  public static final String SERIALIZED_NAME_FROM_DATE = "fromDate";
  @SerializedName(SERIALIZED_NAME_FROM_DATE)
  private LocalDate fromDate;

  public static final String SERIALIZED_NAME_FULLY_PAID = "fullyPaid";
  @SerializedName(SERIALIZED_NAME_FULLY_PAID)
  private Boolean fullyPaid;

  public static final String SERIALIZED_NAME_FUTURE_UNRECOGNIZED_INTEREST = "futureUnrecognizedInterest";
  @SerializedName(SERIALIZED_NAME_FUTURE_UNRECOGNIZED_INTEREST)
  private Money futureUnrecognizedInterest;

  public static final String SERIALIZED_NAME_INITIAL_BALANCE_FOR_EMI_RECALCULATION = "initialBalanceForEmiRecalculation";
  @SerializedName(SERIALIZED_NAME_INITIAL_BALANCE_FOR_EMI_RECALCULATION)
  private Money initialBalanceForEmiRecalculation;

  public static final String SERIALIZED_NAME_INTEREST_MOVED = "interestMoved";
  @SerializedName(SERIALIZED_NAME_INTEREST_MOVED)
  private Boolean interestMoved;

  public static final String SERIALIZED_NAME_INTEREST_PERIODS = "interestPeriods";
  @SerializedName(SERIALIZED_NAME_INTEREST_PERIODS)
  private List<InterestPeriod> interestPeriods;

  public static final String SERIALIZED_NAME_LAST_INTEREST_PERIOD = "lastInterestPeriod";
  @SerializedName(SERIALIZED_NAME_LAST_INTEREST_PERIOD)
  private InterestPeriod lastInterestPeriod;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_RELATED_DETAIL = "loanProductRelatedDetail";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_RELATED_DETAIL)
  private LoanProductMinimumRepaymentScheduleRelatedDetail loanProductRelatedDetail;

  public static final String SERIALIZED_NAME_ORIGINAL_EMI = "originalEmi";
  @SerializedName(SERIALIZED_NAME_ORIGINAL_EMI)
  private Money originalEmi;

  public static final String SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE = "outstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE)
  private Money outstandingLoanBalance;

  public static final String SERIALIZED_NAME_OUTSTANDING_PRINCIPAL = "outstandingPrincipal";
  @SerializedName(SERIALIZED_NAME_OUTSTANDING_PRINCIPAL)
  private Money outstandingPrincipal;

  public static final String SERIALIZED_NAME_PAID_INTEREST = "paidInterest";
  @SerializedName(SERIALIZED_NAME_PAID_INTEREST)
  private Money paidInterest;

  public static final String SERIALIZED_NAME_PAID_PRINCIPAL = "paidPrincipal";
  @SerializedName(SERIALIZED_NAME_PAID_PRINCIPAL)
  private Money paidPrincipal;

  public static final String SERIALIZED_NAME_PREVIOUS = "previous";
  @SerializedName(SERIALIZED_NAME_PREVIOUS)
  private RepaymentPeriod previous;

  public static final String SERIALIZED_NAME_RATE_FACTOR_PLUS1 = "rateFactorPlus1";
  @SerializedName(SERIALIZED_NAME_RATE_FACTOR_PLUS1)
  private BigDecimal rateFactorPlus1;

  public static final String SERIALIZED_NAME_TOTAL_CREDITED_AMOUNT = "totalCreditedAmount";
  @SerializedName(SERIALIZED_NAME_TOTAL_CREDITED_AMOUNT)
  private Money totalCreditedAmount;

  public static final String SERIALIZED_NAME_TOTAL_DISBURSED_AMOUNT = "totalDisbursedAmount";
  @SerializedName(SERIALIZED_NAME_TOTAL_DISBURSED_AMOUNT)
  private BigDecimal totalDisbursedAmount;

  public static final String SERIALIZED_NAME_TOTAL_PAID_AMOUNT = "totalPaidAmount";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAID_AMOUNT)
  private Money totalPaidAmount;

  public static final String SERIALIZED_NAME_UNRECOGNIZED_INTEREST = "unrecognizedInterest";
  @SerializedName(SERIALIZED_NAME_UNRECOGNIZED_INTEREST)
  private Money unrecognizedInterest;

  public RepaymentPeriod() {
  }

  public RepaymentPeriod calculatedDueInterest(Money calculatedDueInterest) {
    
    this.calculatedDueInterest = calculatedDueInterest;
    return this;
  }

  /**
   * Get calculatedDueInterest
   * @return calculatedDueInterest
   */
  @javax.annotation.Nonnull

  public Money getCalculatedDueInterest() {
    return calculatedDueInterest;
  }


  public void setCalculatedDueInterest(Money calculatedDueInterest) {
    this.calculatedDueInterest = calculatedDueInterest;
  }

  public RepaymentPeriod calculatedDuePrincipal(Money calculatedDuePrincipal) {
    
    this.calculatedDuePrincipal = calculatedDuePrincipal;
    return this;
  }

  /**
   * Get calculatedDuePrincipal
   * @return calculatedDuePrincipal
   */
  @javax.annotation.Nullable

  public Money getCalculatedDuePrincipal() {
    return calculatedDuePrincipal;
  }


  public void setCalculatedDuePrincipal(Money calculatedDuePrincipal) {
    this.calculatedDuePrincipal = calculatedDuePrincipal;
  }

  public RepaymentPeriod capitalizedIncomePrincipal(Money capitalizedIncomePrincipal) {
    
    this.capitalizedIncomePrincipal = capitalizedIncomePrincipal;
    return this;
  }

  /**
   * Get capitalizedIncomePrincipal
   * @return capitalizedIncomePrincipal
   */
  @javax.annotation.Nullable

  public Money getCapitalizedIncomePrincipal() {
    return capitalizedIncomePrincipal;
  }


  public void setCapitalizedIncomePrincipal(Money capitalizedIncomePrincipal) {
    this.capitalizedIncomePrincipal = capitalizedIncomePrincipal;
  }

  public RepaymentPeriod creditedAmounts(Money creditedAmounts) {
    
    this.creditedAmounts = creditedAmounts;
    return this;
  }

  /**
   * Get creditedAmounts
   * @return creditedAmounts
   */
  @javax.annotation.Nullable

  public Money getCreditedAmounts() {
    return creditedAmounts;
  }


  public void setCreditedAmounts(Money creditedAmounts) {
    this.creditedAmounts = creditedAmounts;
  }

  public RepaymentPeriod creditedInterest(Money creditedInterest) {
    
    this.creditedInterest = creditedInterest;
    return this;
  }

  /**
   * Get creditedInterest
   * @return creditedInterest
   */
  @javax.annotation.Nullable

  public Money getCreditedInterest() {
    return creditedInterest;
  }


  public void setCreditedInterest(Money creditedInterest) {
    this.creditedInterest = creditedInterest;
  }

  public RepaymentPeriod creditedPrincipal(Money creditedPrincipal) {
    
    this.creditedPrincipal = creditedPrincipal;
    return this;
  }

  /**
   * Get creditedPrincipal
   * @return creditedPrincipal
   */
  @javax.annotation.Nullable

  public Money getCreditedPrincipal() {
    return creditedPrincipal;
  }


  public void setCreditedPrincipal(Money creditedPrincipal) {
    this.creditedPrincipal = creditedPrincipal;
  }

  public RepaymentPeriod dueDate(LocalDate dueDate) {
    
    this.dueDate = dueDate;
    return this;
  }

  /**
   * Get dueDate
   * @return dueDate
   */
  @javax.annotation.Nullable

  public LocalDate getDueDate() {
    return dueDate;
  }


  public void setDueDate(LocalDate dueDate) {
    this.dueDate = dueDate;
  }

  public RepaymentPeriod dueInterest(Money dueInterest) {
    
    this.dueInterest = dueInterest;
    return this;
  }

  /**
   * Get dueInterest
   * @return dueInterest
   */
  @javax.annotation.Nullable

  public Money getDueInterest() {
    return dueInterest;
  }


  public void setDueInterest(Money dueInterest) {
    this.dueInterest = dueInterest;
  }

  public RepaymentPeriod duePrincipal(Money duePrincipal) {
    
    this.duePrincipal = duePrincipal;
    return this;
  }

  /**
   * Get duePrincipal
   * @return duePrincipal
   */
  @javax.annotation.Nullable

  public Money getDuePrincipal() {
    return duePrincipal;
  }


  public void setDuePrincipal(Money duePrincipal) {
    this.duePrincipal = duePrincipal;
  }

  public RepaymentPeriod emi(Money emi) {
    
    this.emi = emi;
    return this;
  }

  /**
   * Get emi
   * @return emi
   */
  @javax.annotation.Nullable

  public Money getEmi() {
    return emi;
  }


  public void setEmi(Money emi) {
    this.emi = emi;
  }

  public RepaymentPeriod emiPlusCreditedAmountsPlusFutureUnrecognizedInterest(Money emiPlusCreditedAmountsPlusFutureUnrecognizedInterest) {
    
    this.emiPlusCreditedAmountsPlusFutureUnrecognizedInterest = emiPlusCreditedAmountsPlusFutureUnrecognizedInterest;
    return this;
  }

  /**
   * Get emiPlusCreditedAmountsPlusFutureUnrecognizedInterest
   * @return emiPlusCreditedAmountsPlusFutureUnrecognizedInterest
   */
  @javax.annotation.Nullable

  public Money getEmiPlusCreditedAmountsPlusFutureUnrecognizedInterest() {
    return emiPlusCreditedAmountsPlusFutureUnrecognizedInterest;
  }


  public void setEmiPlusCreditedAmountsPlusFutureUnrecognizedInterest(Money emiPlusCreditedAmountsPlusFutureUnrecognizedInterest) {
    this.emiPlusCreditedAmountsPlusFutureUnrecognizedInterest = emiPlusCreditedAmountsPlusFutureUnrecognizedInterest;
  }

  public RepaymentPeriod firstInterestPeriod(InterestPeriod firstInterestPeriod) {
    
    this.firstInterestPeriod = firstInterestPeriod;
    return this;
  }

  /**
   * Get firstInterestPeriod
   * @return firstInterestPeriod
   */
  @javax.annotation.Nullable

  public InterestPeriod getFirstInterestPeriod() {
    return firstInterestPeriod;
  }


  public void setFirstInterestPeriod(InterestPeriod firstInterestPeriod) {
    this.firstInterestPeriod = firstInterestPeriod;
  }

  public RepaymentPeriod firstRepaymentPeriod(Boolean firstRepaymentPeriod) {
    
    this.firstRepaymentPeriod = firstRepaymentPeriod;
    return this;
  }

  /**
   * Get firstRepaymentPeriod
   * @return firstRepaymentPeriod
   */
  @javax.annotation.Nullable

  public Boolean getFirstRepaymentPeriod() {
    return firstRepaymentPeriod;
  }


  public void setFirstRepaymentPeriod(Boolean firstRepaymentPeriod) {
    this.firstRepaymentPeriod = firstRepaymentPeriod;
  }

  public RepaymentPeriod fromDate(LocalDate fromDate) {
    
    this.fromDate = fromDate;
    return this;
  }

  /**
   * Get fromDate
   * @return fromDate
   */
  @javax.annotation.Nullable

  public LocalDate getFromDate() {
    return fromDate;
  }


  public void setFromDate(LocalDate fromDate) {
    this.fromDate = fromDate;
  }

  public RepaymentPeriod fullyPaid(Boolean fullyPaid) {
    
    this.fullyPaid = fullyPaid;
    return this;
  }

  /**
   * Get fullyPaid
   * @return fullyPaid
   */
  @javax.annotation.Nullable

  public Boolean getFullyPaid() {
    return fullyPaid;
  }


  public void setFullyPaid(Boolean fullyPaid) {
    this.fullyPaid = fullyPaid;
  }

  public RepaymentPeriod futureUnrecognizedInterest(Money futureUnrecognizedInterest) {
    
    this.futureUnrecognizedInterest = futureUnrecognizedInterest;
    return this;
  }

  /**
   * Get futureUnrecognizedInterest
   * @return futureUnrecognizedInterest
   */
  @javax.annotation.Nullable

  public Money getFutureUnrecognizedInterest() {
    return futureUnrecognizedInterest;
  }


  public void setFutureUnrecognizedInterest(Money futureUnrecognizedInterest) {
    this.futureUnrecognizedInterest = futureUnrecognizedInterest;
  }

  public RepaymentPeriod initialBalanceForEmiRecalculation(Money initialBalanceForEmiRecalculation) {
    
    this.initialBalanceForEmiRecalculation = initialBalanceForEmiRecalculation;
    return this;
  }

  /**
   * Get initialBalanceForEmiRecalculation
   * @return initialBalanceForEmiRecalculation
   */
  @javax.annotation.Nullable

  public Money getInitialBalanceForEmiRecalculation() {
    return initialBalanceForEmiRecalculation;
  }


  public void setInitialBalanceForEmiRecalculation(Money initialBalanceForEmiRecalculation) {
    this.initialBalanceForEmiRecalculation = initialBalanceForEmiRecalculation;
  }

  public RepaymentPeriod interestMoved(Boolean interestMoved) {
    
    this.interestMoved = interestMoved;
    return this;
  }

  /**
   * Get interestMoved
   * @return interestMoved
   */
  @javax.annotation.Nullable

  public Boolean getInterestMoved() {
    return interestMoved;
  }


  public void setInterestMoved(Boolean interestMoved) {
    this.interestMoved = interestMoved;
  }

  public RepaymentPeriod interestPeriods(List<InterestPeriod> interestPeriods) {
    
    this.interestPeriods = interestPeriods;
    return this;
  }

  public RepaymentPeriod addInterestPeriodsItem(InterestPeriod interestPeriodsItem) {
    if (this.interestPeriods == null) {
      this.interestPeriods = new ArrayList<>();
    }
    this.interestPeriods.add(interestPeriodsItem);
    return this;
  }

  /**
   * Get interestPeriods
   * @return interestPeriods
   */
  @javax.annotation.Nullable

  public List<InterestPeriod> getInterestPeriods() {
    return interestPeriods;
  }


  public void setInterestPeriods(List<InterestPeriod> interestPeriods) {
    this.interestPeriods = interestPeriods;
  }

  public RepaymentPeriod lastInterestPeriod(InterestPeriod lastInterestPeriod) {
    
    this.lastInterestPeriod = lastInterestPeriod;
    return this;
  }

  /**
   * Get lastInterestPeriod
   * @return lastInterestPeriod
   */
  @javax.annotation.Nullable

  public InterestPeriod getLastInterestPeriod() {
    return lastInterestPeriod;
  }


  public void setLastInterestPeriod(InterestPeriod lastInterestPeriod) {
    this.lastInterestPeriod = lastInterestPeriod;
  }

  public RepaymentPeriod loanProductRelatedDetail(LoanProductMinimumRepaymentScheduleRelatedDetail loanProductRelatedDetail) {
    
    this.loanProductRelatedDetail = loanProductRelatedDetail;
    return this;
  }

  /**
   * Get loanProductRelatedDetail
   * @return loanProductRelatedDetail
   */
  @javax.annotation.Nullable

  public LoanProductMinimumRepaymentScheduleRelatedDetail getLoanProductRelatedDetail() {
    return loanProductRelatedDetail;
  }


  public void setLoanProductRelatedDetail(LoanProductMinimumRepaymentScheduleRelatedDetail loanProductRelatedDetail) {
    this.loanProductRelatedDetail = loanProductRelatedDetail;
  }

  public RepaymentPeriod originalEmi(Money originalEmi) {
    
    this.originalEmi = originalEmi;
    return this;
  }

  /**
   * Get originalEmi
   * @return originalEmi
   */
  @javax.annotation.Nullable

  public Money getOriginalEmi() {
    return originalEmi;
  }


  public void setOriginalEmi(Money originalEmi) {
    this.originalEmi = originalEmi;
  }

  public RepaymentPeriod outstandingLoanBalance(Money outstandingLoanBalance) {
    
    this.outstandingLoanBalance = outstandingLoanBalance;
    return this;
  }

  /**
   * Get outstandingLoanBalance
   * @return outstandingLoanBalance
   */
  @javax.annotation.Nullable

  public Money getOutstandingLoanBalance() {
    return outstandingLoanBalance;
  }


  public void setOutstandingLoanBalance(Money outstandingLoanBalance) {
    this.outstandingLoanBalance = outstandingLoanBalance;
  }

  public RepaymentPeriod outstandingPrincipal(Money outstandingPrincipal) {
    
    this.outstandingPrincipal = outstandingPrincipal;
    return this;
  }

  /**
   * Get outstandingPrincipal
   * @return outstandingPrincipal
   */
  @javax.annotation.Nullable

  public Money getOutstandingPrincipal() {
    return outstandingPrincipal;
  }


  public void setOutstandingPrincipal(Money outstandingPrincipal) {
    this.outstandingPrincipal = outstandingPrincipal;
  }

  public RepaymentPeriod paidInterest(Money paidInterest) {
    
    this.paidInterest = paidInterest;
    return this;
  }

  /**
   * Get paidInterest
   * @return paidInterest
   */
  @javax.annotation.Nullable

  public Money getPaidInterest() {
    return paidInterest;
  }


  public void setPaidInterest(Money paidInterest) {
    this.paidInterest = paidInterest;
  }

  public RepaymentPeriod paidPrincipal(Money paidPrincipal) {
    
    this.paidPrincipal = paidPrincipal;
    return this;
  }

  /**
   * Get paidPrincipal
   * @return paidPrincipal
   */
  @javax.annotation.Nullable

  public Money getPaidPrincipal() {
    return paidPrincipal;
  }


  public void setPaidPrincipal(Money paidPrincipal) {
    this.paidPrincipal = paidPrincipal;
  }

  public RepaymentPeriod previous(RepaymentPeriod previous) {
    
    this.previous = previous;
    return this;
  }

  /**
   * Get previous
   * @return previous
   */
  @javax.annotation.Nullable

  public RepaymentPeriod getPrevious() {
    return previous;
  }


  public void setPrevious(RepaymentPeriod previous) {
    this.previous = previous;
  }

  public RepaymentPeriod rateFactorPlus1(BigDecimal rateFactorPlus1) {
    
    this.rateFactorPlus1 = rateFactorPlus1;
    return this;
  }

  /**
   * Get rateFactorPlus1
   * @return rateFactorPlus1
   */
  @javax.annotation.Nullable

  public BigDecimal getRateFactorPlus1() {
    return rateFactorPlus1;
  }


  public void setRateFactorPlus1(BigDecimal rateFactorPlus1) {
    this.rateFactorPlus1 = rateFactorPlus1;
  }

  public RepaymentPeriod totalCreditedAmount(Money totalCreditedAmount) {
    
    this.totalCreditedAmount = totalCreditedAmount;
    return this;
  }

  /**
   * Get totalCreditedAmount
   * @return totalCreditedAmount
   */
  @javax.annotation.Nullable

  public Money getTotalCreditedAmount() {
    return totalCreditedAmount;
  }


  public void setTotalCreditedAmount(Money totalCreditedAmount) {
    this.totalCreditedAmount = totalCreditedAmount;
  }

  public RepaymentPeriod totalDisbursedAmount(BigDecimal totalDisbursedAmount) {
    
    this.totalDisbursedAmount = totalDisbursedAmount;
    return this;
  }

  /**
   * Get totalDisbursedAmount
   * @return totalDisbursedAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalDisbursedAmount() {
    return totalDisbursedAmount;
  }


  public void setTotalDisbursedAmount(BigDecimal totalDisbursedAmount) {
    this.totalDisbursedAmount = totalDisbursedAmount;
  }

  public RepaymentPeriod totalPaidAmount(Money totalPaidAmount) {
    
    this.totalPaidAmount = totalPaidAmount;
    return this;
  }

  /**
   * Get totalPaidAmount
   * @return totalPaidAmount
   */
  @javax.annotation.Nullable

  public Money getTotalPaidAmount() {
    return totalPaidAmount;
  }


  public void setTotalPaidAmount(Money totalPaidAmount) {
    this.totalPaidAmount = totalPaidAmount;
  }

  public RepaymentPeriod unrecognizedInterest(Money unrecognizedInterest) {
    
    this.unrecognizedInterest = unrecognizedInterest;
    return this;
  }

  /**
   * Get unrecognizedInterest
   * @return unrecognizedInterest
   */
  @javax.annotation.Nullable

  public Money getUnrecognizedInterest() {
    return unrecognizedInterest;
  }


  public void setUnrecognizedInterest(Money unrecognizedInterest) {
    this.unrecognizedInterest = unrecognizedInterest;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RepaymentPeriod repaymentPeriod = (RepaymentPeriod) o;
    return Objects.equals(this.calculatedDueInterest, repaymentPeriod.calculatedDueInterest) &&
        Objects.equals(this.calculatedDuePrincipal, repaymentPeriod.calculatedDuePrincipal) &&
        Objects.equals(this.capitalizedIncomePrincipal, repaymentPeriod.capitalizedIncomePrincipal) &&
        Objects.equals(this.creditedAmounts, repaymentPeriod.creditedAmounts) &&
        Objects.equals(this.creditedInterest, repaymentPeriod.creditedInterest) &&
        Objects.equals(this.creditedPrincipal, repaymentPeriod.creditedPrincipal) &&
        Objects.equals(this.dueDate, repaymentPeriod.dueDate) &&
        Objects.equals(this.dueInterest, repaymentPeriod.dueInterest) &&
        Objects.equals(this.duePrincipal, repaymentPeriod.duePrincipal) &&
        Objects.equals(this.emi, repaymentPeriod.emi) &&
        Objects.equals(this.emiPlusCreditedAmountsPlusFutureUnrecognizedInterest, repaymentPeriod.emiPlusCreditedAmountsPlusFutureUnrecognizedInterest) &&
        Objects.equals(this.firstInterestPeriod, repaymentPeriod.firstInterestPeriod) &&
        Objects.equals(this.firstRepaymentPeriod, repaymentPeriod.firstRepaymentPeriod) &&
        Objects.equals(this.fromDate, repaymentPeriod.fromDate) &&
        Objects.equals(this.fullyPaid, repaymentPeriod.fullyPaid) &&
        Objects.equals(this.futureUnrecognizedInterest, repaymentPeriod.futureUnrecognizedInterest) &&
        Objects.equals(this.initialBalanceForEmiRecalculation, repaymentPeriod.initialBalanceForEmiRecalculation) &&
        Objects.equals(this.interestMoved, repaymentPeriod.interestMoved) &&
        Objects.equals(this.interestPeriods, repaymentPeriod.interestPeriods) &&
        Objects.equals(this.lastInterestPeriod, repaymentPeriod.lastInterestPeriod) &&
        Objects.equals(this.loanProductRelatedDetail, repaymentPeriod.loanProductRelatedDetail) &&
        Objects.equals(this.originalEmi, repaymentPeriod.originalEmi) &&
        Objects.equals(this.outstandingLoanBalance, repaymentPeriod.outstandingLoanBalance) &&
        Objects.equals(this.outstandingPrincipal, repaymentPeriod.outstandingPrincipal) &&
        Objects.equals(this.paidInterest, repaymentPeriod.paidInterest) &&
        Objects.equals(this.paidPrincipal, repaymentPeriod.paidPrincipal) &&
        Objects.equals(this.previous, repaymentPeriod.previous) &&
        Objects.equals(this.rateFactorPlus1, repaymentPeriod.rateFactorPlus1) &&
        Objects.equals(this.totalCreditedAmount, repaymentPeriod.totalCreditedAmount) &&
        Objects.equals(this.totalDisbursedAmount, repaymentPeriod.totalDisbursedAmount) &&
        Objects.equals(this.totalPaidAmount, repaymentPeriod.totalPaidAmount) &&
        Objects.equals(this.unrecognizedInterest, repaymentPeriod.unrecognizedInterest);
  }

  @Override
  public int hashCode() {
    return Objects.hash(calculatedDueInterest, calculatedDuePrincipal, capitalizedIncomePrincipal, creditedAmounts, creditedInterest, creditedPrincipal, dueDate, dueInterest, duePrincipal, emi, emiPlusCreditedAmountsPlusFutureUnrecognizedInterest, firstInterestPeriod, firstRepaymentPeriod, fromDate, fullyPaid, futureUnrecognizedInterest, initialBalanceForEmiRecalculation, interestMoved, interestPeriods, lastInterestPeriod, loanProductRelatedDetail, originalEmi, outstandingLoanBalance, outstandingPrincipal, paidInterest, paidPrincipal, previous, rateFactorPlus1, totalCreditedAmount, totalDisbursedAmount, totalPaidAmount, unrecognizedInterest);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RepaymentPeriod {\n");
    sb.append("    calculatedDueInterest: ").append(toIndentedString(calculatedDueInterest)).append("\n");
    sb.append("    calculatedDuePrincipal: ").append(toIndentedString(calculatedDuePrincipal)).append("\n");
    sb.append("    capitalizedIncomePrincipal: ").append(toIndentedString(capitalizedIncomePrincipal)).append("\n");
    sb.append("    creditedAmounts: ").append(toIndentedString(creditedAmounts)).append("\n");
    sb.append("    creditedInterest: ").append(toIndentedString(creditedInterest)).append("\n");
    sb.append("    creditedPrincipal: ").append(toIndentedString(creditedPrincipal)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    dueInterest: ").append(toIndentedString(dueInterest)).append("\n");
    sb.append("    duePrincipal: ").append(toIndentedString(duePrincipal)).append("\n");
    sb.append("    emi: ").append(toIndentedString(emi)).append("\n");
    sb.append("    emiPlusCreditedAmountsPlusFutureUnrecognizedInterest: ").append(toIndentedString(emiPlusCreditedAmountsPlusFutureUnrecognizedInterest)).append("\n");
    sb.append("    firstInterestPeriod: ").append(toIndentedString(firstInterestPeriod)).append("\n");
    sb.append("    firstRepaymentPeriod: ").append(toIndentedString(firstRepaymentPeriod)).append("\n");
    sb.append("    fromDate: ").append(toIndentedString(fromDate)).append("\n");
    sb.append("    fullyPaid: ").append(toIndentedString(fullyPaid)).append("\n");
    sb.append("    futureUnrecognizedInterest: ").append(toIndentedString(futureUnrecognizedInterest)).append("\n");
    sb.append("    initialBalanceForEmiRecalculation: ").append(toIndentedString(initialBalanceForEmiRecalculation)).append("\n");
    sb.append("    interestMoved: ").append(toIndentedString(interestMoved)).append("\n");
    sb.append("    interestPeriods: ").append(toIndentedString(interestPeriods)).append("\n");
    sb.append("    lastInterestPeriod: ").append(toIndentedString(lastInterestPeriod)).append("\n");
    sb.append("    loanProductRelatedDetail: ").append(toIndentedString(loanProductRelatedDetail)).append("\n");
    sb.append("    originalEmi: ").append(toIndentedString(originalEmi)).append("\n");
    sb.append("    outstandingLoanBalance: ").append(toIndentedString(outstandingLoanBalance)).append("\n");
    sb.append("    outstandingPrincipal: ").append(toIndentedString(outstandingPrincipal)).append("\n");
    sb.append("    paidInterest: ").append(toIndentedString(paidInterest)).append("\n");
    sb.append("    paidPrincipal: ").append(toIndentedString(paidPrincipal)).append("\n");
    sb.append("    previous: ").append(toIndentedString(previous)).append("\n");
    sb.append("    rateFactorPlus1: ").append(toIndentedString(rateFactorPlus1)).append("\n");
    sb.append("    totalCreditedAmount: ").append(toIndentedString(totalCreditedAmount)).append("\n");
    sb.append("    totalDisbursedAmount: ").append(toIndentedString(totalDisbursedAmount)).append("\n");
    sb.append("    totalPaidAmount: ").append(toIndentedString(totalPaidAmount)).append("\n");
    sb.append("    unrecognizedInterest: ").append(toIndentedString(unrecognizedInterest)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

