/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.fineract.client.models.AccountTransferData;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.PaymentDetailData;
import org.apache.fineract.client.models.PaymentTypeData;
import org.apache.fineract.client.models.SavingsAccountChargesPaidByData;
import org.apache.fineract.client.models.SavingsAccountTransactionEnumData;
import org.apache.fineract.client.models.TaxDetailsData;

/**
 * SavingsAccountTransactionData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class SavingsAccountTransactionData {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private Long accountId;

  public static final String SERIALIZED_NAME_ACCOUNT_NO = "accountNo";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NO)
  private String accountNo;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "accountNumber";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_AMOUNT_ON_HOLD = "amountOnHold";
  @SerializedName(SERIALIZED_NAME_AMOUNT_ON_HOLD)
  private Boolean amountOnHold;

  public static final String SERIALIZED_NAME_AMOUNT_RELEASE = "amountRelease";
  @SerializedName(SERIALIZED_NAME_AMOUNT_RELEASE)
  private Boolean amountRelease;

  public static final String SERIALIZED_NAME_ANNUAL_FEE = "annualFee";
  @SerializedName(SERIALIZED_NAME_ANNUAL_FEE)
  private Boolean annualFee;

  public static final String SERIALIZED_NAME_ANNUAL_FEE_AND_NOT_REVERSED = "annualFeeAndNotReversed";
  @SerializedName(SERIALIZED_NAME_ANNUAL_FEE_AND_NOT_REVERSED)
  private Boolean annualFeeAndNotReversed;

  public static final String SERIALIZED_NAME_BALANCE_END_DATE = "balanceEndDate";
  @SerializedName(SERIALIZED_NAME_BALANCE_END_DATE)
  private LocalDate balanceEndDate;

  public static final String SERIALIZED_NAME_BALANCE_NUMBER_OF_DAYS = "balanceNumberOfDays";
  @SerializedName(SERIALIZED_NAME_BALANCE_NUMBER_OF_DAYS)
  private Integer balanceNumberOfDays;

  public static final String SERIALIZED_NAME_BANK_NUMBER = "bankNumber";
  @SerializedName(SERIALIZED_NAME_BANK_NUMBER)
  private String bankNumber;

  public static final String SERIALIZED_NAME_CHARGE_TRANSACTION = "chargeTransaction";
  @SerializedName(SERIALIZED_NAME_CHARGE_TRANSACTION)
  private Boolean chargeTransaction;

  public static final String SERIALIZED_NAME_CHARGE_TRANSACTION_AND_NOT_REVERSED = "chargeTransactionAndNotReversed";
  @SerializedName(SERIALIZED_NAME_CHARGE_TRANSACTION_AND_NOT_REVERSED)
  private Boolean chargeTransactionAndNotReversed;

  public static final String SERIALIZED_NAME_CHARGES_PAID_BY_DATA = "chargesPaidByData";
  @SerializedName(SERIALIZED_NAME_CHARGES_PAID_BY_DATA)
  private Set<SavingsAccountChargesPaidByData> chargesPaidByData;

  public static final String SERIALIZED_NAME_CHECK_NUMBER = "checkNumber";
  @SerializedName(SERIALIZED_NAME_CHECK_NUMBER)
  private String checkNumber;

  public static final String SERIALIZED_NAME_CREDIT = "credit";
  @SerializedName(SERIALIZED_NAME_CREDIT)
  private Boolean credit;

  public static final String SERIALIZED_NAME_CUMULATIVE_BALANCE = "cumulativeBalance";
  @SerializedName(SERIALIZED_NAME_CUMULATIVE_BALANCE)
  private BigDecimal cumulativeBalance;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_DATE = "date";
  @SerializedName(SERIALIZED_NAME_DATE)
  private LocalDate date;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_DEBIT = "debit";
  @SerializedName(SERIALIZED_NAME_DEBIT)
  private Boolean debit;

  public static final String SERIALIZED_NAME_DEPOSIT = "deposit";
  @SerializedName(SERIALIZED_NAME_DEPOSIT)
  private Boolean deposit;

  public static final String SERIALIZED_NAME_DEPOSIT_AND_NOT_REVERSED = "depositAndNotReversed";
  @SerializedName(SERIALIZED_NAME_DEPOSIT_AND_NOT_REVERSED)
  private Boolean depositAndNotReversed;

  public static final String SERIALIZED_NAME_DIVIDEND_PAYOUT_AND_NOT_REVERSED = "dividendPayoutAndNotReversed";
  @SerializedName(SERIALIZED_NAME_DIVIDEND_PAYOUT_AND_NOT_REVERSED)
  private Boolean dividendPayoutAndNotReversed;

  public static final String SERIALIZED_NAME_END_OF_BALANCE_LOCAL_DATE = "endOfBalanceLocalDate";
  @SerializedName(SERIALIZED_NAME_END_OF_BALANCE_LOCAL_DATE)
  private LocalDate endOfBalanceLocalDate;

  /**
   * Gets or Sets entryType
   */
  @JsonAdapter(EntryTypeEnum.Adapter.class)
  public enum EntryTypeEnum {
    CREDIT("CREDIT"),
    
    DEBIT("DEBIT");

    private String value;

    EntryTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EntryTypeEnum fromValue(String value) {
      for (EntryTypeEnum b : EntryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<EntryTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EntryTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EntryTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EntryTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entryType";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private EntryTypeEnum entryType;

  public static final String SERIALIZED_NAME_FEE_CHARGE = "feeCharge";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGE)
  private Boolean feeCharge;

  public static final String SERIALIZED_NAME_FEE_CHARGE_AND_NOT_REVERSED = "feeChargeAndNotReversed";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGE_AND_NOT_REVERSED)
  private Boolean feeChargeAndNotReversed;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_INTEREST_POSTING = "interestPosting";
  @SerializedName(SERIALIZED_NAME_INTEREST_POSTING)
  private Boolean interestPosting;

  public static final String SERIALIZED_NAME_INTEREST_POSTING_AND_NOT_REVERSED = "interestPostingAndNotReversed";
  @SerializedName(SERIALIZED_NAME_INTEREST_POSTING_AND_NOT_REVERSED)
  private Boolean interestPostingAndNotReversed;

  public static final String SERIALIZED_NAME_INTERESTED_POSTED_AS_ON = "interestedPostedAsOn";
  @SerializedName(SERIALIZED_NAME_INTERESTED_POSTED_AS_ON)
  private Boolean interestedPostedAsOn;

  public static final String SERIALIZED_NAME_IS_MANUAL_TRANSACTION = "isManualTransaction";
  @SerializedName(SERIALIZED_NAME_IS_MANUAL_TRANSACTION)
  private Boolean isManualTransaction;

  public static final String SERIALIZED_NAME_IS_REVERSAL = "isReversal";
  @SerializedName(SERIALIZED_NAME_IS_REVERSAL)
  private Boolean isReversal;

  public static final String SERIALIZED_NAME_LIEN_TRANSACTION = "lienTransaction";
  @SerializedName(SERIALIZED_NAME_LIEN_TRANSACTION)
  private Boolean lienTransaction;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_MANUAL_TRANSACTION = "manualTransaction";
  @SerializedName(SERIALIZED_NAME_MANUAL_TRANSACTION)
  private Boolean manualTransaction;

  public static final String SERIALIZED_NAME_MODIFIED_ID = "modifiedId";
  @SerializedName(SERIALIZED_NAME_MODIFIED_ID)
  private Long modifiedId;

  public static final String SERIALIZED_NAME_NOT_REVERSED = "notReversed";
  @SerializedName(SERIALIZED_NAME_NOT_REVERSED)
  private Boolean notReversed;

  public static final String SERIALIZED_NAME_NOTE = "note";
  @SerializedName(SERIALIZED_NAME_NOTE)
  private String note;

  public static final String SERIALIZED_NAME_ORIGINAL_TRANSACTION_ID = "originalTransactionId";
  @SerializedName(SERIALIZED_NAME_ORIGINAL_TRANSACTION_ID)
  private Long originalTransactionId;

  public static final String SERIALIZED_NAME_OUTSTANDING_CHARGE_AMOUNT = "outstandingChargeAmount";
  @SerializedName(SERIALIZED_NAME_OUTSTANDING_CHARGE_AMOUNT)
  private BigDecimal outstandingChargeAmount;

  public static final String SERIALIZED_NAME_OVERDRAFT_AMOUNT = "overdraftAmount";
  @SerializedName(SERIALIZED_NAME_OVERDRAFT_AMOUNT)
  private BigDecimal overdraftAmount;

  public static final String SERIALIZED_NAME_OVERDRAFT_INTEREST_AND_NOT_REVERSED = "overdraftInterestAndNotReversed";
  @SerializedName(SERIALIZED_NAME_OVERDRAFT_INTEREST_AND_NOT_REVERSED)
  private Boolean overdraftInterestAndNotReversed;

  public static final String SERIALIZED_NAME_PAY_CHARGE = "payCharge";
  @SerializedName(SERIALIZED_NAME_PAY_CHARGE)
  private Boolean payCharge;

  public static final String SERIALIZED_NAME_PAYMENT_DETAIL_DATA = "paymentDetailData";
  @SerializedName(SERIALIZED_NAME_PAYMENT_DETAIL_DATA)
  private PaymentDetailData paymentDetailData;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE_ID = "paymentTypeId";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE_ID)
  private Long paymentTypeId;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS = "paymentTypeOptions";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS)
  private List<PaymentTypeData> paymentTypeOptions;

  public static final String SERIALIZED_NAME_PENALTY_CHARGE = "penaltyCharge";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGE)
  private Boolean penaltyCharge;

  public static final String SERIALIZED_NAME_PENALTY_CHARGE_AND_NOT_REVERSED = "penaltyChargeAndNotReversed";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGE_AND_NOT_REVERSED)
  private Boolean penaltyChargeAndNotReversed;

  public static final String SERIALIZED_NAME_REASON_FOR_BLOCK = "reasonForBlock";
  @SerializedName(SERIALIZED_NAME_REASON_FOR_BLOCK)
  private String reasonForBlock;

  public static final String SERIALIZED_NAME_RECEIPT_NUMBER = "receiptNumber";
  @SerializedName(SERIALIZED_NAME_RECEIPT_NUMBER)
  private String receiptNumber;

  public static final String SERIALIZED_NAME_REF_NO = "refNo";
  @SerializedName(SERIALIZED_NAME_REF_NO)
  private String refNo;

  public static final String SERIALIZED_NAME_RELEASE_TRANSACTION_ID = "releaseTransactionId";
  @SerializedName(SERIALIZED_NAME_RELEASE_TRANSACTION_ID)
  private Long releaseTransactionId;

  public static final String SERIALIZED_NAME_REVERSAL_TRANSACTION = "reversalTransaction";
  @SerializedName(SERIALIZED_NAME_REVERSAL_TRANSACTION)
  private Boolean reversalTransaction;

  public static final String SERIALIZED_NAME_REVERSED = "reversed";
  @SerializedName(SERIALIZED_NAME_REVERSED)
  private Boolean reversed;

  public static final String SERIALIZED_NAME_ROUTING_CODE = "routingCode";
  @SerializedName(SERIALIZED_NAME_ROUTING_CODE)
  private String routingCode;

  public static final String SERIALIZED_NAME_ROW_INDEX = "rowIndex";
  @SerializedName(SERIALIZED_NAME_ROW_INDEX)
  private Integer rowIndex;

  public static final String SERIALIZED_NAME_RUNNING_BALANCE = "runningBalance";
  @SerializedName(SERIALIZED_NAME_RUNNING_BALANCE)
  private BigDecimal runningBalance;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_CHARGES_PAID = "savingsAccountChargesPaid";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_CHARGES_PAID)
  private Set<SavingsAccountChargesPaidByData> savingsAccountChargesPaid;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_ID = "savingsAccountId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_ID)
  private Long savingsAccountId;

  public static final String SERIALIZED_NAME_SUBMITTED_BY_USERNAME = "submittedByUsername";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_BY_USERNAME)
  private String submittedByUsername;

  public static final String SERIALIZED_NAME_SUBMITTED_ON_DATE = "submittedOnDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_ON_DATE)
  private LocalDate submittedOnDate;

  public static final String SERIALIZED_NAME_TAX_DETAILS = "taxDetails";
  @SerializedName(SERIALIZED_NAME_TAX_DETAILS)
  private List<TaxDetailsData> taxDetails;

  public static final String SERIALIZED_NAME_TRANSACTION_AMOUNT = "transactionAmount";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_AMOUNT)
  private BigDecimal transactionAmount;

  public static final String SERIALIZED_NAME_TRANSACTION_DATE = "transactionDate";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_DATE)
  private LocalDate transactionDate;

  public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TYPE)
  private SavingsAccountTransactionEnumData transactionType;

  public static final String SERIALIZED_NAME_TRANSFER = "transfer";
  @SerializedName(SERIALIZED_NAME_TRANSFER)
  private AccountTransferData transfer;

  public static final String SERIALIZED_NAME_WAIVE_CHARGE = "waiveCharge";
  @SerializedName(SERIALIZED_NAME_WAIVE_CHARGE)
  private Boolean waiveCharge;

  public static final String SERIALIZED_NAME_WAIVE_FEE_CHARGE = "waiveFeeCharge";
  @SerializedName(SERIALIZED_NAME_WAIVE_FEE_CHARGE)
  private Boolean waiveFeeCharge;

  public static final String SERIALIZED_NAME_WAIVE_FEE_CHARGE_AND_NOT_REVERSED = "waiveFeeChargeAndNotReversed";
  @SerializedName(SERIALIZED_NAME_WAIVE_FEE_CHARGE_AND_NOT_REVERSED)
  private Boolean waiveFeeChargeAndNotReversed;

  public static final String SERIALIZED_NAME_WAIVE_PENALTY_CHARGE = "waivePenaltyCharge";
  @SerializedName(SERIALIZED_NAME_WAIVE_PENALTY_CHARGE)
  private Boolean waivePenaltyCharge;

  public static final String SERIALIZED_NAME_WAIVE_PENALTY_CHARGE_AND_NOT_REVERSED = "waivePenaltyChargeAndNotReversed";
  @SerializedName(SERIALIZED_NAME_WAIVE_PENALTY_CHARGE_AND_NOT_REVERSED)
  private Boolean waivePenaltyChargeAndNotReversed;

  public static final String SERIALIZED_NAME_WITH_HOLD_TAX_AND_NOT_REVERSED = "withHoldTaxAndNotReversed";
  @SerializedName(SERIALIZED_NAME_WITH_HOLD_TAX_AND_NOT_REVERSED)
  private Boolean withHoldTaxAndNotReversed;

  public static final String SERIALIZED_NAME_WITHDRAWAL = "withdrawal";
  @SerializedName(SERIALIZED_NAME_WITHDRAWAL)
  private Boolean withdrawal;

  public static final String SERIALIZED_NAME_WITHDRAWAL_FEE_AND_NOT_REVERSED = "withdrawalFeeAndNotReversed";
  @SerializedName(SERIALIZED_NAME_WITHDRAWAL_FEE_AND_NOT_REVERSED)
  private Boolean withdrawalFeeAndNotReversed;

  public SavingsAccountTransactionData() {
  }

  public SavingsAccountTransactionData accountId(Long accountId) {
    
    this.accountId = accountId;
    return this;
  }

  /**
   * Get accountId
   * @return accountId
   */
  @javax.annotation.Nullable

  public Long getAccountId() {
    return accountId;
  }


  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  public SavingsAccountTransactionData accountNo(String accountNo) {
    
    this.accountNo = accountNo;
    return this;
  }

  /**
   * Get accountNo
   * @return accountNo
   */
  @javax.annotation.Nullable

  public String getAccountNo() {
    return accountNo;
  }


  public void setAccountNo(String accountNo) {
    this.accountNo = accountNo;
  }

  public SavingsAccountTransactionData accountNumber(String accountNumber) {
    
    this.accountNumber = accountNumber;
    return this;
  }

  /**
   * Get accountNumber
   * @return accountNumber
   */
  @javax.annotation.Nullable

  public String getAccountNumber() {
    return accountNumber;
  }


  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }

  public SavingsAccountTransactionData amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public SavingsAccountTransactionData amountOnHold(Boolean amountOnHold) {
    
    this.amountOnHold = amountOnHold;
    return this;
  }

  /**
   * Get amountOnHold
   * @return amountOnHold
   */
  @javax.annotation.Nullable

  public Boolean getAmountOnHold() {
    return amountOnHold;
  }


  public void setAmountOnHold(Boolean amountOnHold) {
    this.amountOnHold = amountOnHold;
  }

  public SavingsAccountTransactionData amountRelease(Boolean amountRelease) {
    
    this.amountRelease = amountRelease;
    return this;
  }

  /**
   * Get amountRelease
   * @return amountRelease
   */
  @javax.annotation.Nullable

  public Boolean getAmountRelease() {
    return amountRelease;
  }


  public void setAmountRelease(Boolean amountRelease) {
    this.amountRelease = amountRelease;
  }

  public SavingsAccountTransactionData annualFee(Boolean annualFee) {
    
    this.annualFee = annualFee;
    return this;
  }

  /**
   * Get annualFee
   * @return annualFee
   */
  @javax.annotation.Nullable

  public Boolean getAnnualFee() {
    return annualFee;
  }


  public void setAnnualFee(Boolean annualFee) {
    this.annualFee = annualFee;
  }

  public SavingsAccountTransactionData annualFeeAndNotReversed(Boolean annualFeeAndNotReversed) {
    
    this.annualFeeAndNotReversed = annualFeeAndNotReversed;
    return this;
  }

  /**
   * Get annualFeeAndNotReversed
   * @return annualFeeAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getAnnualFeeAndNotReversed() {
    return annualFeeAndNotReversed;
  }


  public void setAnnualFeeAndNotReversed(Boolean annualFeeAndNotReversed) {
    this.annualFeeAndNotReversed = annualFeeAndNotReversed;
  }

  public SavingsAccountTransactionData balanceEndDate(LocalDate balanceEndDate) {
    
    this.balanceEndDate = balanceEndDate;
    return this;
  }

  /**
   * Get balanceEndDate
   * @return balanceEndDate
   */
  @javax.annotation.Nullable

  public LocalDate getBalanceEndDate() {
    return balanceEndDate;
  }


  public void setBalanceEndDate(LocalDate balanceEndDate) {
    this.balanceEndDate = balanceEndDate;
  }

  public SavingsAccountTransactionData balanceNumberOfDays(Integer balanceNumberOfDays) {
    
    this.balanceNumberOfDays = balanceNumberOfDays;
    return this;
  }

  /**
   * Get balanceNumberOfDays
   * @return balanceNumberOfDays
   */
  @javax.annotation.Nullable

  public Integer getBalanceNumberOfDays() {
    return balanceNumberOfDays;
  }


  public void setBalanceNumberOfDays(Integer balanceNumberOfDays) {
    this.balanceNumberOfDays = balanceNumberOfDays;
  }

  public SavingsAccountTransactionData bankNumber(String bankNumber) {
    
    this.bankNumber = bankNumber;
    return this;
  }

  /**
   * Get bankNumber
   * @return bankNumber
   */
  @javax.annotation.Nullable

  public String getBankNumber() {
    return bankNumber;
  }


  public void setBankNumber(String bankNumber) {
    this.bankNumber = bankNumber;
  }

  public SavingsAccountTransactionData chargeTransaction(Boolean chargeTransaction) {
    
    this.chargeTransaction = chargeTransaction;
    return this;
  }

  /**
   * Get chargeTransaction
   * @return chargeTransaction
   */
  @javax.annotation.Nullable

  public Boolean getChargeTransaction() {
    return chargeTransaction;
  }


  public void setChargeTransaction(Boolean chargeTransaction) {
    this.chargeTransaction = chargeTransaction;
  }

  public SavingsAccountTransactionData chargeTransactionAndNotReversed(Boolean chargeTransactionAndNotReversed) {
    
    this.chargeTransactionAndNotReversed = chargeTransactionAndNotReversed;
    return this;
  }

  /**
   * Get chargeTransactionAndNotReversed
   * @return chargeTransactionAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getChargeTransactionAndNotReversed() {
    return chargeTransactionAndNotReversed;
  }


  public void setChargeTransactionAndNotReversed(Boolean chargeTransactionAndNotReversed) {
    this.chargeTransactionAndNotReversed = chargeTransactionAndNotReversed;
  }

  public SavingsAccountTransactionData chargesPaidByData(Set<SavingsAccountChargesPaidByData> chargesPaidByData) {
    
    this.chargesPaidByData = chargesPaidByData;
    return this;
  }

  public SavingsAccountTransactionData addChargesPaidByDataItem(SavingsAccountChargesPaidByData chargesPaidByDataItem) {
    if (this.chargesPaidByData == null) {
      this.chargesPaidByData = new LinkedHashSet<>();
    }
    this.chargesPaidByData.add(chargesPaidByDataItem);
    return this;
  }

  /**
   * Get chargesPaidByData
   * @return chargesPaidByData
   */
  @javax.annotation.Nullable

  public Set<SavingsAccountChargesPaidByData> getChargesPaidByData() {
    return chargesPaidByData;
  }


  public void setChargesPaidByData(Set<SavingsAccountChargesPaidByData> chargesPaidByData) {
    this.chargesPaidByData = chargesPaidByData;
  }

  public SavingsAccountTransactionData checkNumber(String checkNumber) {
    
    this.checkNumber = checkNumber;
    return this;
  }

  /**
   * Get checkNumber
   * @return checkNumber
   */
  @javax.annotation.Nullable

  public String getCheckNumber() {
    return checkNumber;
  }


  public void setCheckNumber(String checkNumber) {
    this.checkNumber = checkNumber;
  }

  public SavingsAccountTransactionData credit(Boolean credit) {
    
    this.credit = credit;
    return this;
  }

  /**
   * Get credit
   * @return credit
   */
  @javax.annotation.Nullable

  public Boolean getCredit() {
    return credit;
  }


  public void setCredit(Boolean credit) {
    this.credit = credit;
  }

  public SavingsAccountTransactionData cumulativeBalance(BigDecimal cumulativeBalance) {
    
    this.cumulativeBalance = cumulativeBalance;
    return this;
  }

  /**
   * Get cumulativeBalance
   * @return cumulativeBalance
   */
  @javax.annotation.Nullable

  public BigDecimal getCumulativeBalance() {
    return cumulativeBalance;
  }


  public void setCumulativeBalance(BigDecimal cumulativeBalance) {
    this.cumulativeBalance = cumulativeBalance;
  }

  public SavingsAccountTransactionData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public SavingsAccountTransactionData date(LocalDate date) {
    
    this.date = date;
    return this;
  }

  /**
   * Get date
   * @return date
   */
  @javax.annotation.Nullable

  public LocalDate getDate() {
    return date;
  }


  public void setDate(LocalDate date) {
    this.date = date;
  }

  public SavingsAccountTransactionData dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public SavingsAccountTransactionData debit(Boolean debit) {
    
    this.debit = debit;
    return this;
  }

  /**
   * Get debit
   * @return debit
   */
  @javax.annotation.Nullable

  public Boolean getDebit() {
    return debit;
  }


  public void setDebit(Boolean debit) {
    this.debit = debit;
  }

  public SavingsAccountTransactionData deposit(Boolean deposit) {
    
    this.deposit = deposit;
    return this;
  }

  /**
   * Get deposit
   * @return deposit
   */
  @javax.annotation.Nullable

  public Boolean getDeposit() {
    return deposit;
  }


  public void setDeposit(Boolean deposit) {
    this.deposit = deposit;
  }

  public SavingsAccountTransactionData depositAndNotReversed(Boolean depositAndNotReversed) {
    
    this.depositAndNotReversed = depositAndNotReversed;
    return this;
  }

  /**
   * Get depositAndNotReversed
   * @return depositAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getDepositAndNotReversed() {
    return depositAndNotReversed;
  }


  public void setDepositAndNotReversed(Boolean depositAndNotReversed) {
    this.depositAndNotReversed = depositAndNotReversed;
  }

  public SavingsAccountTransactionData dividendPayoutAndNotReversed(Boolean dividendPayoutAndNotReversed) {
    
    this.dividendPayoutAndNotReversed = dividendPayoutAndNotReversed;
    return this;
  }

  /**
   * Get dividendPayoutAndNotReversed
   * @return dividendPayoutAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getDividendPayoutAndNotReversed() {
    return dividendPayoutAndNotReversed;
  }


  public void setDividendPayoutAndNotReversed(Boolean dividendPayoutAndNotReversed) {
    this.dividendPayoutAndNotReversed = dividendPayoutAndNotReversed;
  }

  public SavingsAccountTransactionData endOfBalanceLocalDate(LocalDate endOfBalanceLocalDate) {
    
    this.endOfBalanceLocalDate = endOfBalanceLocalDate;
    return this;
  }

  /**
   * Get endOfBalanceLocalDate
   * @return endOfBalanceLocalDate
   */
  @javax.annotation.Nullable

  public LocalDate getEndOfBalanceLocalDate() {
    return endOfBalanceLocalDate;
  }


  public void setEndOfBalanceLocalDate(LocalDate endOfBalanceLocalDate) {
    this.endOfBalanceLocalDate = endOfBalanceLocalDate;
  }

  public SavingsAccountTransactionData entryType(EntryTypeEnum entryType) {
    
    this.entryType = entryType;
    return this;
  }

  /**
   * Get entryType
   * @return entryType
   */
  @javax.annotation.Nullable

  public EntryTypeEnum getEntryType() {
    return entryType;
  }


  public void setEntryType(EntryTypeEnum entryType) {
    this.entryType = entryType;
  }

  public SavingsAccountTransactionData feeCharge(Boolean feeCharge) {
    
    this.feeCharge = feeCharge;
    return this;
  }

  /**
   * Get feeCharge
   * @return feeCharge
   */
  @javax.annotation.Nullable

  public Boolean getFeeCharge() {
    return feeCharge;
  }


  public void setFeeCharge(Boolean feeCharge) {
    this.feeCharge = feeCharge;
  }

  public SavingsAccountTransactionData feeChargeAndNotReversed(Boolean feeChargeAndNotReversed) {
    
    this.feeChargeAndNotReversed = feeChargeAndNotReversed;
    return this;
  }

  /**
   * Get feeChargeAndNotReversed
   * @return feeChargeAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getFeeChargeAndNotReversed() {
    return feeChargeAndNotReversed;
  }


  public void setFeeChargeAndNotReversed(Boolean feeChargeAndNotReversed) {
    this.feeChargeAndNotReversed = feeChargeAndNotReversed;
  }

  public SavingsAccountTransactionData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public SavingsAccountTransactionData interestPosting(Boolean interestPosting) {
    
    this.interestPosting = interestPosting;
    return this;
  }

  /**
   * Get interestPosting
   * @return interestPosting
   */
  @javax.annotation.Nullable

  public Boolean getInterestPosting() {
    return interestPosting;
  }


  public void setInterestPosting(Boolean interestPosting) {
    this.interestPosting = interestPosting;
  }

  public SavingsAccountTransactionData interestPostingAndNotReversed(Boolean interestPostingAndNotReversed) {
    
    this.interestPostingAndNotReversed = interestPostingAndNotReversed;
    return this;
  }

  /**
   * Get interestPostingAndNotReversed
   * @return interestPostingAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getInterestPostingAndNotReversed() {
    return interestPostingAndNotReversed;
  }


  public void setInterestPostingAndNotReversed(Boolean interestPostingAndNotReversed) {
    this.interestPostingAndNotReversed = interestPostingAndNotReversed;
  }

  public SavingsAccountTransactionData interestedPostedAsOn(Boolean interestedPostedAsOn) {
    
    this.interestedPostedAsOn = interestedPostedAsOn;
    return this;
  }

  /**
   * Get interestedPostedAsOn
   * @return interestedPostedAsOn
   */
  @javax.annotation.Nullable

  public Boolean getInterestedPostedAsOn() {
    return interestedPostedAsOn;
  }


  public void setInterestedPostedAsOn(Boolean interestedPostedAsOn) {
    this.interestedPostedAsOn = interestedPostedAsOn;
  }

  public SavingsAccountTransactionData isManualTransaction(Boolean isManualTransaction) {
    
    this.isManualTransaction = isManualTransaction;
    return this;
  }

  /**
   * Get isManualTransaction
   * @return isManualTransaction
   */
  @javax.annotation.Nullable

  public Boolean getIsManualTransaction() {
    return isManualTransaction;
  }


  public void setIsManualTransaction(Boolean isManualTransaction) {
    this.isManualTransaction = isManualTransaction;
  }

  public SavingsAccountTransactionData isReversal(Boolean isReversal) {
    
    this.isReversal = isReversal;
    return this;
  }

  /**
   * Get isReversal
   * @return isReversal
   */
  @javax.annotation.Nullable

  public Boolean getIsReversal() {
    return isReversal;
  }


  public void setIsReversal(Boolean isReversal) {
    this.isReversal = isReversal;
  }

  public SavingsAccountTransactionData lienTransaction(Boolean lienTransaction) {
    
    this.lienTransaction = lienTransaction;
    return this;
  }

  /**
   * Get lienTransaction
   * @return lienTransaction
   */
  @javax.annotation.Nullable

  public Boolean getLienTransaction() {
    return lienTransaction;
  }


  public void setLienTransaction(Boolean lienTransaction) {
    this.lienTransaction = lienTransaction;
  }

  public SavingsAccountTransactionData locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public SavingsAccountTransactionData manualTransaction(Boolean manualTransaction) {
    
    this.manualTransaction = manualTransaction;
    return this;
  }

  /**
   * Get manualTransaction
   * @return manualTransaction
   */
  @javax.annotation.Nullable

  public Boolean getManualTransaction() {
    return manualTransaction;
  }


  public void setManualTransaction(Boolean manualTransaction) {
    this.manualTransaction = manualTransaction;
  }

  public SavingsAccountTransactionData modifiedId(Long modifiedId) {
    
    this.modifiedId = modifiedId;
    return this;
  }

  /**
   * Get modifiedId
   * @return modifiedId
   */
  @javax.annotation.Nullable

  public Long getModifiedId() {
    return modifiedId;
  }


  public void setModifiedId(Long modifiedId) {
    this.modifiedId = modifiedId;
  }

  public SavingsAccountTransactionData notReversed(Boolean notReversed) {
    
    this.notReversed = notReversed;
    return this;
  }

  /**
   * Get notReversed
   * @return notReversed
   */
  @javax.annotation.Nullable

  public Boolean getNotReversed() {
    return notReversed;
  }


  public void setNotReversed(Boolean notReversed) {
    this.notReversed = notReversed;
  }

  public SavingsAccountTransactionData note(String note) {
    
    this.note = note;
    return this;
  }

  /**
   * Get note
   * @return note
   */
  @javax.annotation.Nullable

  public String getNote() {
    return note;
  }


  public void setNote(String note) {
    this.note = note;
  }

  public SavingsAccountTransactionData originalTransactionId(Long originalTransactionId) {
    
    this.originalTransactionId = originalTransactionId;
    return this;
  }

  /**
   * Get originalTransactionId
   * @return originalTransactionId
   */
  @javax.annotation.Nullable

  public Long getOriginalTransactionId() {
    return originalTransactionId;
  }


  public void setOriginalTransactionId(Long originalTransactionId) {
    this.originalTransactionId = originalTransactionId;
  }

  public SavingsAccountTransactionData outstandingChargeAmount(BigDecimal outstandingChargeAmount) {
    
    this.outstandingChargeAmount = outstandingChargeAmount;
    return this;
  }

  /**
   * Get outstandingChargeAmount
   * @return outstandingChargeAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getOutstandingChargeAmount() {
    return outstandingChargeAmount;
  }


  public void setOutstandingChargeAmount(BigDecimal outstandingChargeAmount) {
    this.outstandingChargeAmount = outstandingChargeAmount;
  }

  public SavingsAccountTransactionData overdraftAmount(BigDecimal overdraftAmount) {
    
    this.overdraftAmount = overdraftAmount;
    return this;
  }

  /**
   * Get overdraftAmount
   * @return overdraftAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getOverdraftAmount() {
    return overdraftAmount;
  }


  public void setOverdraftAmount(BigDecimal overdraftAmount) {
    this.overdraftAmount = overdraftAmount;
  }

  public SavingsAccountTransactionData overdraftInterestAndNotReversed(Boolean overdraftInterestAndNotReversed) {
    
    this.overdraftInterestAndNotReversed = overdraftInterestAndNotReversed;
    return this;
  }

  /**
   * Get overdraftInterestAndNotReversed
   * @return overdraftInterestAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getOverdraftInterestAndNotReversed() {
    return overdraftInterestAndNotReversed;
  }


  public void setOverdraftInterestAndNotReversed(Boolean overdraftInterestAndNotReversed) {
    this.overdraftInterestAndNotReversed = overdraftInterestAndNotReversed;
  }

  public SavingsAccountTransactionData payCharge(Boolean payCharge) {
    
    this.payCharge = payCharge;
    return this;
  }

  /**
   * Get payCharge
   * @return payCharge
   */
  @javax.annotation.Nullable

  public Boolean getPayCharge() {
    return payCharge;
  }


  public void setPayCharge(Boolean payCharge) {
    this.payCharge = payCharge;
  }

  public SavingsAccountTransactionData paymentDetailData(PaymentDetailData paymentDetailData) {
    
    this.paymentDetailData = paymentDetailData;
    return this;
  }

  /**
   * Get paymentDetailData
   * @return paymentDetailData
   */
  @javax.annotation.Nullable

  public PaymentDetailData getPaymentDetailData() {
    return paymentDetailData;
  }


  public void setPaymentDetailData(PaymentDetailData paymentDetailData) {
    this.paymentDetailData = paymentDetailData;
  }

  public SavingsAccountTransactionData paymentTypeId(Long paymentTypeId) {
    
    this.paymentTypeId = paymentTypeId;
    return this;
  }

  /**
   * Get paymentTypeId
   * @return paymentTypeId
   */
  @javax.annotation.Nullable

  public Long getPaymentTypeId() {
    return paymentTypeId;
  }


  public void setPaymentTypeId(Long paymentTypeId) {
    this.paymentTypeId = paymentTypeId;
  }

  public SavingsAccountTransactionData paymentTypeOptions(List<PaymentTypeData> paymentTypeOptions) {
    
    this.paymentTypeOptions = paymentTypeOptions;
    return this;
  }

  public SavingsAccountTransactionData addPaymentTypeOptionsItem(PaymentTypeData paymentTypeOptionsItem) {
    if (this.paymentTypeOptions == null) {
      this.paymentTypeOptions = new ArrayList<>();
    }
    this.paymentTypeOptions.add(paymentTypeOptionsItem);
    return this;
  }

  /**
   * Get paymentTypeOptions
   * @return paymentTypeOptions
   */
  @javax.annotation.Nullable

  public List<PaymentTypeData> getPaymentTypeOptions() {
    return paymentTypeOptions;
  }


  public void setPaymentTypeOptions(List<PaymentTypeData> paymentTypeOptions) {
    this.paymentTypeOptions = paymentTypeOptions;
  }

  public SavingsAccountTransactionData penaltyCharge(Boolean penaltyCharge) {
    
    this.penaltyCharge = penaltyCharge;
    return this;
  }

  /**
   * Get penaltyCharge
   * @return penaltyCharge
   */
  @javax.annotation.Nullable

  public Boolean getPenaltyCharge() {
    return penaltyCharge;
  }


  public void setPenaltyCharge(Boolean penaltyCharge) {
    this.penaltyCharge = penaltyCharge;
  }

  public SavingsAccountTransactionData penaltyChargeAndNotReversed(Boolean penaltyChargeAndNotReversed) {
    
    this.penaltyChargeAndNotReversed = penaltyChargeAndNotReversed;
    return this;
  }

  /**
   * Get penaltyChargeAndNotReversed
   * @return penaltyChargeAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getPenaltyChargeAndNotReversed() {
    return penaltyChargeAndNotReversed;
  }


  public void setPenaltyChargeAndNotReversed(Boolean penaltyChargeAndNotReversed) {
    this.penaltyChargeAndNotReversed = penaltyChargeAndNotReversed;
  }

  public SavingsAccountTransactionData reasonForBlock(String reasonForBlock) {
    
    this.reasonForBlock = reasonForBlock;
    return this;
  }

  /**
   * Get reasonForBlock
   * @return reasonForBlock
   */
  @javax.annotation.Nullable

  public String getReasonForBlock() {
    return reasonForBlock;
  }


  public void setReasonForBlock(String reasonForBlock) {
    this.reasonForBlock = reasonForBlock;
  }

  public SavingsAccountTransactionData receiptNumber(String receiptNumber) {
    
    this.receiptNumber = receiptNumber;
    return this;
  }

  /**
   * Get receiptNumber
   * @return receiptNumber
   */
  @javax.annotation.Nullable

  public String getReceiptNumber() {
    return receiptNumber;
  }


  public void setReceiptNumber(String receiptNumber) {
    this.receiptNumber = receiptNumber;
  }

  public SavingsAccountTransactionData refNo(String refNo) {
    
    this.refNo = refNo;
    return this;
  }

  /**
   * Get refNo
   * @return refNo
   */
  @javax.annotation.Nullable

  public String getRefNo() {
    return refNo;
  }


  public void setRefNo(String refNo) {
    this.refNo = refNo;
  }

  public SavingsAccountTransactionData releaseTransactionId(Long releaseTransactionId) {
    
    this.releaseTransactionId = releaseTransactionId;
    return this;
  }

  /**
   * Get releaseTransactionId
   * @return releaseTransactionId
   */
  @javax.annotation.Nullable

  public Long getReleaseTransactionId() {
    return releaseTransactionId;
  }


  public void setReleaseTransactionId(Long releaseTransactionId) {
    this.releaseTransactionId = releaseTransactionId;
  }

  public SavingsAccountTransactionData reversalTransaction(Boolean reversalTransaction) {
    
    this.reversalTransaction = reversalTransaction;
    return this;
  }

  /**
   * Get reversalTransaction
   * @return reversalTransaction
   */
  @javax.annotation.Nullable

  public Boolean getReversalTransaction() {
    return reversalTransaction;
  }


  public void setReversalTransaction(Boolean reversalTransaction) {
    this.reversalTransaction = reversalTransaction;
  }

  public SavingsAccountTransactionData reversed(Boolean reversed) {
    
    this.reversed = reversed;
    return this;
  }

  /**
   * Get reversed
   * @return reversed
   */
  @javax.annotation.Nullable

  public Boolean getReversed() {
    return reversed;
  }


  public void setReversed(Boolean reversed) {
    this.reversed = reversed;
  }

  public SavingsAccountTransactionData routingCode(String routingCode) {
    
    this.routingCode = routingCode;
    return this;
  }

  /**
   * Get routingCode
   * @return routingCode
   */
  @javax.annotation.Nullable

  public String getRoutingCode() {
    return routingCode;
  }


  public void setRoutingCode(String routingCode) {
    this.routingCode = routingCode;
  }

  public SavingsAccountTransactionData rowIndex(Integer rowIndex) {
    
    this.rowIndex = rowIndex;
    return this;
  }

  /**
   * Get rowIndex
   * @return rowIndex
   */
  @javax.annotation.Nullable

  public Integer getRowIndex() {
    return rowIndex;
  }


  public void setRowIndex(Integer rowIndex) {
    this.rowIndex = rowIndex;
  }

  public SavingsAccountTransactionData runningBalance(BigDecimal runningBalance) {
    
    this.runningBalance = runningBalance;
    return this;
  }

  /**
   * Get runningBalance
   * @return runningBalance
   */
  @javax.annotation.Nullable

  public BigDecimal getRunningBalance() {
    return runningBalance;
  }


  public void setRunningBalance(BigDecimal runningBalance) {
    this.runningBalance = runningBalance;
  }

  public SavingsAccountTransactionData savingsAccountChargesPaid(Set<SavingsAccountChargesPaidByData> savingsAccountChargesPaid) {
    
    this.savingsAccountChargesPaid = savingsAccountChargesPaid;
    return this;
  }

  public SavingsAccountTransactionData addSavingsAccountChargesPaidItem(SavingsAccountChargesPaidByData savingsAccountChargesPaidItem) {
    if (this.savingsAccountChargesPaid == null) {
      this.savingsAccountChargesPaid = new LinkedHashSet<>();
    }
    this.savingsAccountChargesPaid.add(savingsAccountChargesPaidItem);
    return this;
  }

  /**
   * Get savingsAccountChargesPaid
   * @return savingsAccountChargesPaid
   */
  @javax.annotation.Nullable

  public Set<SavingsAccountChargesPaidByData> getSavingsAccountChargesPaid() {
    return savingsAccountChargesPaid;
  }


  public void setSavingsAccountChargesPaid(Set<SavingsAccountChargesPaidByData> savingsAccountChargesPaid) {
    this.savingsAccountChargesPaid = savingsAccountChargesPaid;
  }

  public SavingsAccountTransactionData savingsAccountId(Long savingsAccountId) {
    
    this.savingsAccountId = savingsAccountId;
    return this;
  }

  /**
   * Get savingsAccountId
   * @return savingsAccountId
   */
  @javax.annotation.Nullable

  public Long getSavingsAccountId() {
    return savingsAccountId;
  }


  public void setSavingsAccountId(Long savingsAccountId) {
    this.savingsAccountId = savingsAccountId;
  }

  public SavingsAccountTransactionData submittedByUsername(String submittedByUsername) {
    
    this.submittedByUsername = submittedByUsername;
    return this;
  }

  /**
   * Get submittedByUsername
   * @return submittedByUsername
   */
  @javax.annotation.Nullable

  public String getSubmittedByUsername() {
    return submittedByUsername;
  }


  public void setSubmittedByUsername(String submittedByUsername) {
    this.submittedByUsername = submittedByUsername;
  }

  public SavingsAccountTransactionData submittedOnDate(LocalDate submittedOnDate) {
    
    this.submittedOnDate = submittedOnDate;
    return this;
  }

  /**
   * Get submittedOnDate
   * @return submittedOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getSubmittedOnDate() {
    return submittedOnDate;
  }


  public void setSubmittedOnDate(LocalDate submittedOnDate) {
    this.submittedOnDate = submittedOnDate;
  }

  public SavingsAccountTransactionData taxDetails(List<TaxDetailsData> taxDetails) {
    
    this.taxDetails = taxDetails;
    return this;
  }

  public SavingsAccountTransactionData addTaxDetailsItem(TaxDetailsData taxDetailsItem) {
    if (this.taxDetails == null) {
      this.taxDetails = new ArrayList<>();
    }
    this.taxDetails.add(taxDetailsItem);
    return this;
  }

  /**
   * Get taxDetails
   * @return taxDetails
   */
  @javax.annotation.Nullable

  public List<TaxDetailsData> getTaxDetails() {
    return taxDetails;
  }


  public void setTaxDetails(List<TaxDetailsData> taxDetails) {
    this.taxDetails = taxDetails;
  }

  public SavingsAccountTransactionData transactionAmount(BigDecimal transactionAmount) {
    
    this.transactionAmount = transactionAmount;
    return this;
  }

  /**
   * Get transactionAmount
   * @return transactionAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getTransactionAmount() {
    return transactionAmount;
  }


  public void setTransactionAmount(BigDecimal transactionAmount) {
    this.transactionAmount = transactionAmount;
  }

  public SavingsAccountTransactionData transactionDate(LocalDate transactionDate) {
    
    this.transactionDate = transactionDate;
    return this;
  }

  /**
   * Get transactionDate
   * @return transactionDate
   */
  @javax.annotation.Nullable

  public LocalDate getTransactionDate() {
    return transactionDate;
  }


  public void setTransactionDate(LocalDate transactionDate) {
    this.transactionDate = transactionDate;
  }

  public SavingsAccountTransactionData transactionType(SavingsAccountTransactionEnumData transactionType) {
    
    this.transactionType = transactionType;
    return this;
  }

  /**
   * Get transactionType
   * @return transactionType
   */
  @javax.annotation.Nullable

  public SavingsAccountTransactionEnumData getTransactionType() {
    return transactionType;
  }


  public void setTransactionType(SavingsAccountTransactionEnumData transactionType) {
    this.transactionType = transactionType;
  }

  public SavingsAccountTransactionData transfer(AccountTransferData transfer) {
    
    this.transfer = transfer;
    return this;
  }

  /**
   * Get transfer
   * @return transfer
   */
  @javax.annotation.Nullable

  public AccountTransferData getTransfer() {
    return transfer;
  }


  public void setTransfer(AccountTransferData transfer) {
    this.transfer = transfer;
  }

  public SavingsAccountTransactionData waiveCharge(Boolean waiveCharge) {
    
    this.waiveCharge = waiveCharge;
    return this;
  }

  /**
   * Get waiveCharge
   * @return waiveCharge
   */
  @javax.annotation.Nullable

  public Boolean getWaiveCharge() {
    return waiveCharge;
  }


  public void setWaiveCharge(Boolean waiveCharge) {
    this.waiveCharge = waiveCharge;
  }

  public SavingsAccountTransactionData waiveFeeCharge(Boolean waiveFeeCharge) {
    
    this.waiveFeeCharge = waiveFeeCharge;
    return this;
  }

  /**
   * Get waiveFeeCharge
   * @return waiveFeeCharge
   */
  @javax.annotation.Nullable

  public Boolean getWaiveFeeCharge() {
    return waiveFeeCharge;
  }


  public void setWaiveFeeCharge(Boolean waiveFeeCharge) {
    this.waiveFeeCharge = waiveFeeCharge;
  }

  public SavingsAccountTransactionData waiveFeeChargeAndNotReversed(Boolean waiveFeeChargeAndNotReversed) {
    
    this.waiveFeeChargeAndNotReversed = waiveFeeChargeAndNotReversed;
    return this;
  }

  /**
   * Get waiveFeeChargeAndNotReversed
   * @return waiveFeeChargeAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getWaiveFeeChargeAndNotReversed() {
    return waiveFeeChargeAndNotReversed;
  }


  public void setWaiveFeeChargeAndNotReversed(Boolean waiveFeeChargeAndNotReversed) {
    this.waiveFeeChargeAndNotReversed = waiveFeeChargeAndNotReversed;
  }

  public SavingsAccountTransactionData waivePenaltyCharge(Boolean waivePenaltyCharge) {
    
    this.waivePenaltyCharge = waivePenaltyCharge;
    return this;
  }

  /**
   * Get waivePenaltyCharge
   * @return waivePenaltyCharge
   */
  @javax.annotation.Nullable

  public Boolean getWaivePenaltyCharge() {
    return waivePenaltyCharge;
  }


  public void setWaivePenaltyCharge(Boolean waivePenaltyCharge) {
    this.waivePenaltyCharge = waivePenaltyCharge;
  }

  public SavingsAccountTransactionData waivePenaltyChargeAndNotReversed(Boolean waivePenaltyChargeAndNotReversed) {
    
    this.waivePenaltyChargeAndNotReversed = waivePenaltyChargeAndNotReversed;
    return this;
  }

  /**
   * Get waivePenaltyChargeAndNotReversed
   * @return waivePenaltyChargeAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getWaivePenaltyChargeAndNotReversed() {
    return waivePenaltyChargeAndNotReversed;
  }


  public void setWaivePenaltyChargeAndNotReversed(Boolean waivePenaltyChargeAndNotReversed) {
    this.waivePenaltyChargeAndNotReversed = waivePenaltyChargeAndNotReversed;
  }

  public SavingsAccountTransactionData withHoldTaxAndNotReversed(Boolean withHoldTaxAndNotReversed) {
    
    this.withHoldTaxAndNotReversed = withHoldTaxAndNotReversed;
    return this;
  }

  /**
   * Get withHoldTaxAndNotReversed
   * @return withHoldTaxAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getWithHoldTaxAndNotReversed() {
    return withHoldTaxAndNotReversed;
  }


  public void setWithHoldTaxAndNotReversed(Boolean withHoldTaxAndNotReversed) {
    this.withHoldTaxAndNotReversed = withHoldTaxAndNotReversed;
  }

  public SavingsAccountTransactionData withdrawal(Boolean withdrawal) {
    
    this.withdrawal = withdrawal;
    return this;
  }

  /**
   * Get withdrawal
   * @return withdrawal
   */
  @javax.annotation.Nullable

  public Boolean getWithdrawal() {
    return withdrawal;
  }


  public void setWithdrawal(Boolean withdrawal) {
    this.withdrawal = withdrawal;
  }

  public SavingsAccountTransactionData withdrawalFeeAndNotReversed(Boolean withdrawalFeeAndNotReversed) {
    
    this.withdrawalFeeAndNotReversed = withdrawalFeeAndNotReversed;
    return this;
  }

  /**
   * Get withdrawalFeeAndNotReversed
   * @return withdrawalFeeAndNotReversed
   */
  @javax.annotation.Nullable

  public Boolean getWithdrawalFeeAndNotReversed() {
    return withdrawalFeeAndNotReversed;
  }


  public void setWithdrawalFeeAndNotReversed(Boolean withdrawalFeeAndNotReversed) {
    this.withdrawalFeeAndNotReversed = withdrawalFeeAndNotReversed;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SavingsAccountTransactionData savingsAccountTransactionData = (SavingsAccountTransactionData) o;
    return Objects.equals(this.accountId, savingsAccountTransactionData.accountId) &&
        Objects.equals(this.accountNo, savingsAccountTransactionData.accountNo) &&
        Objects.equals(this.accountNumber, savingsAccountTransactionData.accountNumber) &&
        Objects.equals(this.amount, savingsAccountTransactionData.amount) &&
        Objects.equals(this.amountOnHold, savingsAccountTransactionData.amountOnHold) &&
        Objects.equals(this.amountRelease, savingsAccountTransactionData.amountRelease) &&
        Objects.equals(this.annualFee, savingsAccountTransactionData.annualFee) &&
        Objects.equals(this.annualFeeAndNotReversed, savingsAccountTransactionData.annualFeeAndNotReversed) &&
        Objects.equals(this.balanceEndDate, savingsAccountTransactionData.balanceEndDate) &&
        Objects.equals(this.balanceNumberOfDays, savingsAccountTransactionData.balanceNumberOfDays) &&
        Objects.equals(this.bankNumber, savingsAccountTransactionData.bankNumber) &&
        Objects.equals(this.chargeTransaction, savingsAccountTransactionData.chargeTransaction) &&
        Objects.equals(this.chargeTransactionAndNotReversed, savingsAccountTransactionData.chargeTransactionAndNotReversed) &&
        Objects.equals(this.chargesPaidByData, savingsAccountTransactionData.chargesPaidByData) &&
        Objects.equals(this.checkNumber, savingsAccountTransactionData.checkNumber) &&
        Objects.equals(this.credit, savingsAccountTransactionData.credit) &&
        Objects.equals(this.cumulativeBalance, savingsAccountTransactionData.cumulativeBalance) &&
        Objects.equals(this.currency, savingsAccountTransactionData.currency) &&
        Objects.equals(this.date, savingsAccountTransactionData.date) &&
        Objects.equals(this.dateFormat, savingsAccountTransactionData.dateFormat) &&
        Objects.equals(this.debit, savingsAccountTransactionData.debit) &&
        Objects.equals(this.deposit, savingsAccountTransactionData.deposit) &&
        Objects.equals(this.depositAndNotReversed, savingsAccountTransactionData.depositAndNotReversed) &&
        Objects.equals(this.dividendPayoutAndNotReversed, savingsAccountTransactionData.dividendPayoutAndNotReversed) &&
        Objects.equals(this.endOfBalanceLocalDate, savingsAccountTransactionData.endOfBalanceLocalDate) &&
        Objects.equals(this.entryType, savingsAccountTransactionData.entryType) &&
        Objects.equals(this.feeCharge, savingsAccountTransactionData.feeCharge) &&
        Objects.equals(this.feeChargeAndNotReversed, savingsAccountTransactionData.feeChargeAndNotReversed) &&
        Objects.equals(this.id, savingsAccountTransactionData.id) &&
        Objects.equals(this.interestPosting, savingsAccountTransactionData.interestPosting) &&
        Objects.equals(this.interestPostingAndNotReversed, savingsAccountTransactionData.interestPostingAndNotReversed) &&
        Objects.equals(this.interestedPostedAsOn, savingsAccountTransactionData.interestedPostedAsOn) &&
        Objects.equals(this.isManualTransaction, savingsAccountTransactionData.isManualTransaction) &&
        Objects.equals(this.isReversal, savingsAccountTransactionData.isReversal) &&
        Objects.equals(this.lienTransaction, savingsAccountTransactionData.lienTransaction) &&
        Objects.equals(this.locale, savingsAccountTransactionData.locale) &&
        Objects.equals(this.manualTransaction, savingsAccountTransactionData.manualTransaction) &&
        Objects.equals(this.modifiedId, savingsAccountTransactionData.modifiedId) &&
        Objects.equals(this.notReversed, savingsAccountTransactionData.notReversed) &&
        Objects.equals(this.note, savingsAccountTransactionData.note) &&
        Objects.equals(this.originalTransactionId, savingsAccountTransactionData.originalTransactionId) &&
        Objects.equals(this.outstandingChargeAmount, savingsAccountTransactionData.outstandingChargeAmount) &&
        Objects.equals(this.overdraftAmount, savingsAccountTransactionData.overdraftAmount) &&
        Objects.equals(this.overdraftInterestAndNotReversed, savingsAccountTransactionData.overdraftInterestAndNotReversed) &&
        Objects.equals(this.payCharge, savingsAccountTransactionData.payCharge) &&
        Objects.equals(this.paymentDetailData, savingsAccountTransactionData.paymentDetailData) &&
        Objects.equals(this.paymentTypeId, savingsAccountTransactionData.paymentTypeId) &&
        Objects.equals(this.paymentTypeOptions, savingsAccountTransactionData.paymentTypeOptions) &&
        Objects.equals(this.penaltyCharge, savingsAccountTransactionData.penaltyCharge) &&
        Objects.equals(this.penaltyChargeAndNotReversed, savingsAccountTransactionData.penaltyChargeAndNotReversed) &&
        Objects.equals(this.reasonForBlock, savingsAccountTransactionData.reasonForBlock) &&
        Objects.equals(this.receiptNumber, savingsAccountTransactionData.receiptNumber) &&
        Objects.equals(this.refNo, savingsAccountTransactionData.refNo) &&
        Objects.equals(this.releaseTransactionId, savingsAccountTransactionData.releaseTransactionId) &&
        Objects.equals(this.reversalTransaction, savingsAccountTransactionData.reversalTransaction) &&
        Objects.equals(this.reversed, savingsAccountTransactionData.reversed) &&
        Objects.equals(this.routingCode, savingsAccountTransactionData.routingCode) &&
        Objects.equals(this.rowIndex, savingsAccountTransactionData.rowIndex) &&
        Objects.equals(this.runningBalance, savingsAccountTransactionData.runningBalance) &&
        Objects.equals(this.savingsAccountChargesPaid, savingsAccountTransactionData.savingsAccountChargesPaid) &&
        Objects.equals(this.savingsAccountId, savingsAccountTransactionData.savingsAccountId) &&
        Objects.equals(this.submittedByUsername, savingsAccountTransactionData.submittedByUsername) &&
        Objects.equals(this.submittedOnDate, savingsAccountTransactionData.submittedOnDate) &&
        Objects.equals(this.taxDetails, savingsAccountTransactionData.taxDetails) &&
        Objects.equals(this.transactionAmount, savingsAccountTransactionData.transactionAmount) &&
        Objects.equals(this.transactionDate, savingsAccountTransactionData.transactionDate) &&
        Objects.equals(this.transactionType, savingsAccountTransactionData.transactionType) &&
        Objects.equals(this.transfer, savingsAccountTransactionData.transfer) &&
        Objects.equals(this.waiveCharge, savingsAccountTransactionData.waiveCharge) &&
        Objects.equals(this.waiveFeeCharge, savingsAccountTransactionData.waiveFeeCharge) &&
        Objects.equals(this.waiveFeeChargeAndNotReversed, savingsAccountTransactionData.waiveFeeChargeAndNotReversed) &&
        Objects.equals(this.waivePenaltyCharge, savingsAccountTransactionData.waivePenaltyCharge) &&
        Objects.equals(this.waivePenaltyChargeAndNotReversed, savingsAccountTransactionData.waivePenaltyChargeAndNotReversed) &&
        Objects.equals(this.withHoldTaxAndNotReversed, savingsAccountTransactionData.withHoldTaxAndNotReversed) &&
        Objects.equals(this.withdrawal, savingsAccountTransactionData.withdrawal) &&
        Objects.equals(this.withdrawalFeeAndNotReversed, savingsAccountTransactionData.withdrawalFeeAndNotReversed);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, accountNo, accountNumber, amount, amountOnHold, amountRelease, annualFee, annualFeeAndNotReversed, balanceEndDate, balanceNumberOfDays, bankNumber, chargeTransaction, chargeTransactionAndNotReversed, chargesPaidByData, checkNumber, credit, cumulativeBalance, currency, date, dateFormat, debit, deposit, depositAndNotReversed, dividendPayoutAndNotReversed, endOfBalanceLocalDate, entryType, feeCharge, feeChargeAndNotReversed, id, interestPosting, interestPostingAndNotReversed, interestedPostedAsOn, isManualTransaction, isReversal, lienTransaction, locale, manualTransaction, modifiedId, notReversed, note, originalTransactionId, outstandingChargeAmount, overdraftAmount, overdraftInterestAndNotReversed, payCharge, paymentDetailData, paymentTypeId, paymentTypeOptions, penaltyCharge, penaltyChargeAndNotReversed, reasonForBlock, receiptNumber, refNo, releaseTransactionId, reversalTransaction, reversed, routingCode, rowIndex, runningBalance, savingsAccountChargesPaid, savingsAccountId, submittedByUsername, submittedOnDate, taxDetails, transactionAmount, transactionDate, transactionType, transfer, waiveCharge, waiveFeeCharge, waiveFeeChargeAndNotReversed, waivePenaltyCharge, waivePenaltyChargeAndNotReversed, withHoldTaxAndNotReversed, withdrawal, withdrawalFeeAndNotReversed);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SavingsAccountTransactionData {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountNo: ").append(toIndentedString(accountNo)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    amountOnHold: ").append(toIndentedString(amountOnHold)).append("\n");
    sb.append("    amountRelease: ").append(toIndentedString(amountRelease)).append("\n");
    sb.append("    annualFee: ").append(toIndentedString(annualFee)).append("\n");
    sb.append("    annualFeeAndNotReversed: ").append(toIndentedString(annualFeeAndNotReversed)).append("\n");
    sb.append("    balanceEndDate: ").append(toIndentedString(balanceEndDate)).append("\n");
    sb.append("    balanceNumberOfDays: ").append(toIndentedString(balanceNumberOfDays)).append("\n");
    sb.append("    bankNumber: ").append(toIndentedString(bankNumber)).append("\n");
    sb.append("    chargeTransaction: ").append(toIndentedString(chargeTransaction)).append("\n");
    sb.append("    chargeTransactionAndNotReversed: ").append(toIndentedString(chargeTransactionAndNotReversed)).append("\n");
    sb.append("    chargesPaidByData: ").append(toIndentedString(chargesPaidByData)).append("\n");
    sb.append("    checkNumber: ").append(toIndentedString(checkNumber)).append("\n");
    sb.append("    credit: ").append(toIndentedString(credit)).append("\n");
    sb.append("    cumulativeBalance: ").append(toIndentedString(cumulativeBalance)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    debit: ").append(toIndentedString(debit)).append("\n");
    sb.append("    deposit: ").append(toIndentedString(deposit)).append("\n");
    sb.append("    depositAndNotReversed: ").append(toIndentedString(depositAndNotReversed)).append("\n");
    sb.append("    dividendPayoutAndNotReversed: ").append(toIndentedString(dividendPayoutAndNotReversed)).append("\n");
    sb.append("    endOfBalanceLocalDate: ").append(toIndentedString(endOfBalanceLocalDate)).append("\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    feeCharge: ").append(toIndentedString(feeCharge)).append("\n");
    sb.append("    feeChargeAndNotReversed: ").append(toIndentedString(feeChargeAndNotReversed)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    interestPosting: ").append(toIndentedString(interestPosting)).append("\n");
    sb.append("    interestPostingAndNotReversed: ").append(toIndentedString(interestPostingAndNotReversed)).append("\n");
    sb.append("    interestedPostedAsOn: ").append(toIndentedString(interestedPostedAsOn)).append("\n");
    sb.append("    isManualTransaction: ").append(toIndentedString(isManualTransaction)).append("\n");
    sb.append("    isReversal: ").append(toIndentedString(isReversal)).append("\n");
    sb.append("    lienTransaction: ").append(toIndentedString(lienTransaction)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    manualTransaction: ").append(toIndentedString(manualTransaction)).append("\n");
    sb.append("    modifiedId: ").append(toIndentedString(modifiedId)).append("\n");
    sb.append("    notReversed: ").append(toIndentedString(notReversed)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    originalTransactionId: ").append(toIndentedString(originalTransactionId)).append("\n");
    sb.append("    outstandingChargeAmount: ").append(toIndentedString(outstandingChargeAmount)).append("\n");
    sb.append("    overdraftAmount: ").append(toIndentedString(overdraftAmount)).append("\n");
    sb.append("    overdraftInterestAndNotReversed: ").append(toIndentedString(overdraftInterestAndNotReversed)).append("\n");
    sb.append("    payCharge: ").append(toIndentedString(payCharge)).append("\n");
    sb.append("    paymentDetailData: ").append(toIndentedString(paymentDetailData)).append("\n");
    sb.append("    paymentTypeId: ").append(toIndentedString(paymentTypeId)).append("\n");
    sb.append("    paymentTypeOptions: ").append(toIndentedString(paymentTypeOptions)).append("\n");
    sb.append("    penaltyCharge: ").append(toIndentedString(penaltyCharge)).append("\n");
    sb.append("    penaltyChargeAndNotReversed: ").append(toIndentedString(penaltyChargeAndNotReversed)).append("\n");
    sb.append("    reasonForBlock: ").append(toIndentedString(reasonForBlock)).append("\n");
    sb.append("    receiptNumber: ").append(toIndentedString(receiptNumber)).append("\n");
    sb.append("    refNo: ").append(toIndentedString(refNo)).append("\n");
    sb.append("    releaseTransactionId: ").append(toIndentedString(releaseTransactionId)).append("\n");
    sb.append("    reversalTransaction: ").append(toIndentedString(reversalTransaction)).append("\n");
    sb.append("    reversed: ").append(toIndentedString(reversed)).append("\n");
    sb.append("    routingCode: ").append(toIndentedString(routingCode)).append("\n");
    sb.append("    rowIndex: ").append(toIndentedString(rowIndex)).append("\n");
    sb.append("    runningBalance: ").append(toIndentedString(runningBalance)).append("\n");
    sb.append("    savingsAccountChargesPaid: ").append(toIndentedString(savingsAccountChargesPaid)).append("\n");
    sb.append("    savingsAccountId: ").append(toIndentedString(savingsAccountId)).append("\n");
    sb.append("    submittedByUsername: ").append(toIndentedString(submittedByUsername)).append("\n");
    sb.append("    submittedOnDate: ").append(toIndentedString(submittedOnDate)).append("\n");
    sb.append("    taxDetails: ").append(toIndentedString(taxDetails)).append("\n");
    sb.append("    transactionAmount: ").append(toIndentedString(transactionAmount)).append("\n");
    sb.append("    transactionDate: ").append(toIndentedString(transactionDate)).append("\n");
    sb.append("    transactionType: ").append(toIndentedString(transactionType)).append("\n");
    sb.append("    transfer: ").append(toIndentedString(transfer)).append("\n");
    sb.append("    waiveCharge: ").append(toIndentedString(waiveCharge)).append("\n");
    sb.append("    waiveFeeCharge: ").append(toIndentedString(waiveFeeCharge)).append("\n");
    sb.append("    waiveFeeChargeAndNotReversed: ").append(toIndentedString(waiveFeeChargeAndNotReversed)).append("\n");
    sb.append("    waivePenaltyCharge: ").append(toIndentedString(waivePenaltyCharge)).append("\n");
    sb.append("    waivePenaltyChargeAndNotReversed: ").append(toIndentedString(waivePenaltyChargeAndNotReversed)).append("\n");
    sb.append("    withHoldTaxAndNotReversed: ").append(toIndentedString(withHoldTaxAndNotReversed)).append("\n");
    sb.append("    withdrawal: ").append(toIndentedString(withdrawal)).append("\n");
    sb.append("    withdrawalFeeAndNotReversed: ").append(toIndentedString(withdrawalFeeAndNotReversed)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

