/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0-SNAPSHOT
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.OfficeData;
import org.apache.fineract.client.models.StaffData;

/**
 * TellerData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class TellerData {
  public static final String SERIALIZED_NAME_CREDIT_ACCOUNT_ID = "creditAccountId";
  @SerializedName(SERIALIZED_NAME_CREDIT_ACCOUNT_ID)
  private Long creditAccountId;

  public static final String SERIALIZED_NAME_DEBIT_ACCOUNT_ID = "debitAccountId";
  @SerializedName(SERIALIZED_NAME_DEBIT_ACCOUNT_ID)
  private Long debitAccountId;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_END_DATE = "endDate";
  @SerializedName(SERIALIZED_NAME_END_DATE)
  private LocalDate endDate;

  public static final String SERIALIZED_NAME_HAS_MAPPED_CASHIERS = "hasMappedCashiers";
  @SerializedName(SERIALIZED_NAME_HAS_MAPPED_CASHIERS)
  private Boolean hasMappedCashiers;

  public static final String SERIALIZED_NAME_HAS_TRANSACTIONS = "hasTransactions";
  @SerializedName(SERIALIZED_NAME_HAS_TRANSACTIONS)
  private Boolean hasTransactions;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_OFFICE_NAME = "officeName";
  @SerializedName(SERIALIZED_NAME_OFFICE_NAME)
  private String officeName;

  public static final String SERIALIZED_NAME_OFFICE_OPTIONS = "officeOptions";
  @SerializedName(SERIALIZED_NAME_OFFICE_OPTIONS)
  private List<OfficeData> officeOptions;

  public static final String SERIALIZED_NAME_STAFF_OPTIONS = "staffOptions";
  @SerializedName(SERIALIZED_NAME_STAFF_OPTIONS)
  private List<StaffData> staffOptions;

  public static final String SERIALIZED_NAME_START_DATE = "startDate";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private LocalDate startDate;

  /**
   * Gets or Sets status
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    INVALID("INVALID"),
    
    PENDING("PENDING"),
    
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    CLOSED("CLOSED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public TellerData() {
  }

  public TellerData creditAccountId(Long creditAccountId) {
    
    this.creditAccountId = creditAccountId;
    return this;
  }

  /**
   * Get creditAccountId
   * @return creditAccountId
   */
  @javax.annotation.Nullable

  public Long getCreditAccountId() {
    return creditAccountId;
  }


  public void setCreditAccountId(Long creditAccountId) {
    this.creditAccountId = creditAccountId;
  }

  public TellerData debitAccountId(Long debitAccountId) {
    
    this.debitAccountId = debitAccountId;
    return this;
  }

  /**
   * Get debitAccountId
   * @return debitAccountId
   */
  @javax.annotation.Nullable

  public Long getDebitAccountId() {
    return debitAccountId;
  }


  public void setDebitAccountId(Long debitAccountId) {
    this.debitAccountId = debitAccountId;
  }

  public TellerData description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }

  public TellerData endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Get endDate
   * @return endDate
   */
  @javax.annotation.Nullable

  public LocalDate getEndDate() {
    return endDate;
  }


  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  public TellerData hasMappedCashiers(Boolean hasMappedCashiers) {
    
    this.hasMappedCashiers = hasMappedCashiers;
    return this;
  }

  /**
   * Get hasMappedCashiers
   * @return hasMappedCashiers
   */
  @javax.annotation.Nullable

  public Boolean getHasMappedCashiers() {
    return hasMappedCashiers;
  }


  public void setHasMappedCashiers(Boolean hasMappedCashiers) {
    this.hasMappedCashiers = hasMappedCashiers;
  }

  public TellerData hasTransactions(Boolean hasTransactions) {
    
    this.hasTransactions = hasTransactions;
    return this;
  }

  /**
   * Get hasTransactions
   * @return hasTransactions
   */
  @javax.annotation.Nullable

  public Boolean getHasTransactions() {
    return hasTransactions;
  }


  public void setHasTransactions(Boolean hasTransactions) {
    this.hasTransactions = hasTransactions;
  }

  public TellerData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public TellerData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public TellerData officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public TellerData officeName(String officeName) {
    
    this.officeName = officeName;
    return this;
  }

  /**
   * Get officeName
   * @return officeName
   */
  @javax.annotation.Nullable

  public String getOfficeName() {
    return officeName;
  }


  public void setOfficeName(String officeName) {
    this.officeName = officeName;
  }

  public TellerData officeOptions(List<OfficeData> officeOptions) {
    
    this.officeOptions = officeOptions;
    return this;
  }

  public TellerData addOfficeOptionsItem(OfficeData officeOptionsItem) {
    if (this.officeOptions == null) {
      this.officeOptions = new ArrayList<>();
    }
    this.officeOptions.add(officeOptionsItem);
    return this;
  }

  /**
   * Get officeOptions
   * @return officeOptions
   */
  @javax.annotation.Nullable

  public List<OfficeData> getOfficeOptions() {
    return officeOptions;
  }


  public void setOfficeOptions(List<OfficeData> officeOptions) {
    this.officeOptions = officeOptions;
  }

  public TellerData staffOptions(List<StaffData> staffOptions) {
    
    this.staffOptions = staffOptions;
    return this;
  }

  public TellerData addStaffOptionsItem(StaffData staffOptionsItem) {
    if (this.staffOptions == null) {
      this.staffOptions = new ArrayList<>();
    }
    this.staffOptions.add(staffOptionsItem);
    return this;
  }

  /**
   * Get staffOptions
   * @return staffOptions
   */
  @javax.annotation.Nullable

  public List<StaffData> getStaffOptions() {
    return staffOptions;
  }


  public void setStaffOptions(List<StaffData> staffOptions) {
    this.staffOptions = staffOptions;
  }

  public TellerData startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @javax.annotation.Nullable

  public LocalDate getStartDate() {
    return startDate;
  }


  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  public TellerData status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TellerData tellerData = (TellerData) o;
    return Objects.equals(this.creditAccountId, tellerData.creditAccountId) &&
        Objects.equals(this.debitAccountId, tellerData.debitAccountId) &&
        Objects.equals(this.description, tellerData.description) &&
        Objects.equals(this.endDate, tellerData.endDate) &&
        Objects.equals(this.hasMappedCashiers, tellerData.hasMappedCashiers) &&
        Objects.equals(this.hasTransactions, tellerData.hasTransactions) &&
        Objects.equals(this.id, tellerData.id) &&
        Objects.equals(this.name, tellerData.name) &&
        Objects.equals(this.officeId, tellerData.officeId) &&
        Objects.equals(this.officeName, tellerData.officeName) &&
        Objects.equals(this.officeOptions, tellerData.officeOptions) &&
        Objects.equals(this.staffOptions, tellerData.staffOptions) &&
        Objects.equals(this.startDate, tellerData.startDate) &&
        Objects.equals(this.status, tellerData.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(creditAccountId, debitAccountId, description, endDate, hasMappedCashiers, hasTransactions, id, name, officeId, officeName, officeOptions, staffOptions, startDate, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TellerData {\n");
    sb.append("    creditAccountId: ").append(toIndentedString(creditAccountId)).append("\n");
    sb.append("    debitAccountId: ").append(toIndentedString(debitAccountId)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    hasMappedCashiers: ").append(toIndentedString(hasMappedCashiers)).append("\n");
    sb.append("    hasTransactions: ").append(toIndentedString(hasTransactions)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    officeName: ").append(toIndentedString(officeName)).append("\n");
    sb.append("    officeOptions: ").append(toIndentedString(officeOptions)).append("\n");
    sb.append("    staffOptions: ").append(toIndentedString(staffOptions)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

