/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.DropOperation;

public class DropCatalogOperation
implements DropOperation {
    private final String catalogName;
    private final boolean ifExists;

    public DropCatalogOperation(String catalogName, boolean ifExists) {
        this.catalogName = catalogName;
        this.ifExists = ifExists;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogName", this.catalogName);
        return OperationUtils.formatWithChildren("DROP CATALOG", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getCatalogManager().unregisterCatalog(this.getCatalogName(), this.isIfExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (CatalogException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

