/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;

@Internal
public final class ExternalCatalogTable
implements CatalogTable {
    private final Schema schema;

    public ExternalCatalogTable(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Schema getUnresolvedSchema() {
        return this.schema;
    }

    @Override
    public Map<String, String> getOptions() {
        throw new TableException("A catalog table that is backed by a DataStream or used for TableResult.collect() cannot be expressed with options and can thus also not be persisted.");
    }

    @Override
    public String getComment() {
        return "Inline catalog table";
    }

    @Override
    public CatalogBaseTable copy() {
        return new ExternalCatalogTable(this.schema);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.of(this.getComment());
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return Optional.empty();
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public List<String> getPartitionKeys() {
        return Collections.emptyList();
    }

    @Override
    public CatalogTable copy(Map<String, String> options) {
        throw new TableException("A catalog table that is backed by a DataStream or used for TableResult.collect() cannot be expressed with options and can thus also not be enriched with hints.");
    }
}

