/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.gs.GSFileSystemOptions;
import org.apache.flink.fs.gs.storage.GSBlobIdentifier;
import org.apache.flink.fs.gs.storage.GSBlobStorage;
import org.apache.flink.fs.gs.utils.BlobUtils;
import org.apache.flink.fs.gs.writer.GSChecksumWriteChannel;
import org.apache.flink.fs.gs.writer.GSCommitRecoverable;
import org.apache.flink.fs.gs.writer.GSRecoverableWriterCommitter;
import org.apache.flink.fs.gs.writer.GSResumeRecoverable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSRecoverableFsDataOutputStream
extends RecoverableFsDataOutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSRecoverableFsDataOutputStream.class);
    private final GSBlobStorage storage;
    private final GSFileSystemOptions options;
    private final GSBlobIdentifier finalBlobIdentifier;
    private long position;
    private boolean closed;
    private final ArrayList<UUID> componentObjectIds;
    @Nullable
    private GSChecksumWriteChannel currentWriteChannel;

    GSRecoverableFsDataOutputStream(GSBlobStorage storage, GSFileSystemOptions options, GSBlobIdentifier finalBlobIdentifier) {
        LOGGER.debug("Creating new GSRecoverableFsDataOutputStream for blob {} with options {}", (Object)finalBlobIdentifier, (Object)options);
        this.storage = (GSBlobStorage)Preconditions.checkNotNull((Object)storage);
        this.options = (GSFileSystemOptions)Preconditions.checkNotNull((Object)options);
        this.finalBlobIdentifier = (GSBlobIdentifier)Preconditions.checkNotNull((Object)finalBlobIdentifier);
        this.position = 0L;
        this.closed = false;
        this.componentObjectIds = new ArrayList();
    }

    GSRecoverableFsDataOutputStream(GSBlobStorage storage, GSFileSystemOptions options, GSResumeRecoverable recoverable) {
        LOGGER.debug("Recovering GSRecoverableFsDataOutputStream for blob {} with options {}", (Object)recoverable.finalBlobIdentifier, (Object)options);
        this.storage = (GSBlobStorage)Preconditions.checkNotNull((Object)storage);
        this.options = (GSFileSystemOptions)Preconditions.checkNotNull((Object)options);
        this.finalBlobIdentifier = (GSBlobIdentifier)Preconditions.checkNotNull((Object)recoverable.finalBlobIdentifier);
        Preconditions.checkArgument((recoverable.position >= 0L ? 1 : 0) != 0);
        this.position = recoverable.position;
        this.closed = recoverable.closed;
        this.componentObjectIds = new ArrayList(recoverable.componentObjectIds);
    }

    public long getPos() throws IOException {
        return this.position;
    }

    public void write(int byteValue) throws IOException {
        byte[] bytes = new byte[]{(byte)byteValue};
        this.write(bytes);
    }

    public void write(@Nonnull byte[] content) throws IOException {
        Preconditions.checkNotNull((Object)content);
        this.write(content, 0, content.length);
    }

    public void write(@Nonnull byte[] content, int start, int length) throws IOException {
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
        if (this.closed) {
            throw new IOException("Illegal attempt to write to closed output stream");
        }
        if (this.currentWriteChannel == null) {
            LOGGER.debug("Creating write channel for blob {}", (Object)this.finalBlobIdentifier);
            this.currentWriteChannel = this.createWriteChannel();
        }
        LOGGER.trace("Writing {} bytes", (Object)length);
        int bytesWritten = this.currentWriteChannel.write(content, start, length);
        if (bytesWritten != length) {
            throw new IOException(String.format("WriteChannel.write wrote %d of %d requested bytes, failing.", bytesWritten, length));
        }
        this.position += (long)bytesWritten;
    }

    public void flush() throws IOException {
        LOGGER.trace("Flushing write channel for blob {}", (Object)this.finalBlobIdentifier);
        this.closeWriteChannelIfExists();
    }

    public void sync() throws IOException {
        LOGGER.trace("Syncing write channel for blob {}", (Object)this.finalBlobIdentifier);
        this.closeWriteChannelIfExists();
    }

    public RecoverableWriter.ResumeRecoverable persist() throws IOException {
        LOGGER.trace("Persisting write channel for blob {}", (Object)this.finalBlobIdentifier);
        this.closeWriteChannelIfExists();
        return this.createResumeRecoverable();
    }

    public void close() throws IOException {
        LOGGER.trace("Closing write channel for blob {}", (Object)this.finalBlobIdentifier);
        this.closeWriteChannelIfExists();
        this.closed = true;
    }

    public RecoverableFsDataOutputStream.Committer closeForCommit() throws IOException {
        LOGGER.trace("Closing write channel for commit for blob {}", (Object)this.finalBlobIdentifier);
        this.close();
        return new GSRecoverableWriterCommitter(this.storage, this.options, this.createCommitRecoverable());
    }

    private GSCommitRecoverable createCommitRecoverable() {
        return new GSCommitRecoverable(this.finalBlobIdentifier, this.componentObjectIds);
    }

    private GSResumeRecoverable createResumeRecoverable() {
        return new GSResumeRecoverable(this.finalBlobIdentifier, this.componentObjectIds, this.position, this.closed);
    }

    private GSChecksumWriteChannel createWriteChannel() {
        UUID componentObjectId = UUID.randomUUID();
        this.componentObjectIds.add(componentObjectId);
        GSBlobIdentifier blobIdentifier = BlobUtils.getTemporaryBlobIdentifier(this.finalBlobIdentifier, componentObjectId, this.options);
        Optional<MemorySize> writerChunkSize = this.options.getWriterChunkSize();
        GSBlobStorage.WriteChannel writeChannel = writerChunkSize.isPresent() ? this.storage.writeBlob(blobIdentifier, writerChunkSize.get()) : this.storage.writeBlob(blobIdentifier);
        return new GSChecksumWriteChannel(this.storage, writeChannel, blobIdentifier);
    }

    private void closeWriteChannelIfExists() throws IOException {
        if (this.currentWriteChannel != null) {
            this.currentWriteChannel.close();
            this.currentWriteChannel = null;
        }
    }
}

