/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import java.io.Serializable;
import org.apache.flink.table.data.RowData;

public abstract class RecordCounter
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract boolean recordCountIsZero(RowData var1);

    public static RecordCounter of(int indexOfCountStar) {
        if (indexOfCountStar >= 0) {
            return new RetractionRecordCounter(indexOfCountStar);
        }
        return new AccumulationRecordCounter();
    }

    private static final class RetractionRecordCounter
    extends RecordCounter {
        private static final long serialVersionUID = 6671010224686975916L;
        private final int indexOfCountStar;

        public RetractionRecordCounter(int indexOfCountStar) {
            this.indexOfCountStar = indexOfCountStar;
        }

        @Override
        public boolean recordCountIsZero(RowData acc) {
            return acc == null || acc.getLong(this.indexOfCountStar) == 0L;
        }
    }

    private static final class AccumulationRecordCounter
    extends RecordCounter {
        private static final long serialVersionUID = -7035867949179573822L;

        private AccumulationRecordCounter() {
        }

        @Override
        public boolean recordCountIsZero(RowData acc) {
            return acc == null;
        }
    }
}

