/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.Symbolizable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlJdbcDataTypeName
extends Enum<SqlJdbcDataTypeName>
implements Symbolizable {
    public static final /* enum */ SqlJdbcDataTypeName SQL_CHAR = new SqlJdbcDataTypeName(SqlTypeName.CHAR);
    public static final /* enum */ SqlJdbcDataTypeName SQL_VARCHAR = new SqlJdbcDataTypeName(SqlTypeName.VARCHAR);
    public static final /* enum */ SqlJdbcDataTypeName SQL_DATE = new SqlJdbcDataTypeName(SqlTypeName.DATE);
    public static final /* enum */ SqlJdbcDataTypeName SQL_TIME = new SqlJdbcDataTypeName(SqlTypeName.TIME);
    public static final /* enum */ SqlJdbcDataTypeName SQL_TIME_WITH_LOCAL_TIME_ZONE = new SqlJdbcDataTypeName(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE);
    public static final /* enum */ SqlJdbcDataTypeName SQL_TIMESTAMP = new SqlJdbcDataTypeName(SqlTypeName.TIMESTAMP);
    public static final /* enum */ SqlJdbcDataTypeName SQL_TIMESTAMP_WITH_LOCAL_TIME_ZONE = new SqlJdbcDataTypeName(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
    public static final /* enum */ SqlJdbcDataTypeName SQL_DECIMAL = new SqlJdbcDataTypeName(SqlTypeName.DECIMAL);
    public static final /* enum */ SqlJdbcDataTypeName SQL_NUMERIC = new SqlJdbcDataTypeName(SqlTypeName.DECIMAL);
    public static final /* enum */ SqlJdbcDataTypeName SQL_BOOLEAN = new SqlJdbcDataTypeName(SqlTypeName.BOOLEAN);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTEGER = new SqlJdbcDataTypeName(SqlTypeName.INTEGER);
    public static final /* enum */ SqlJdbcDataTypeName SQL_BINARY = new SqlJdbcDataTypeName(SqlTypeName.BINARY);
    public static final /* enum */ SqlJdbcDataTypeName SQL_VARBINARY = new SqlJdbcDataTypeName(SqlTypeName.VARBINARY);
    public static final /* enum */ SqlJdbcDataTypeName SQL_TINYINT = new SqlJdbcDataTypeName(SqlTypeName.TINYINT);
    public static final /* enum */ SqlJdbcDataTypeName SQL_SMALLINT = new SqlJdbcDataTypeName(SqlTypeName.SMALLINT);
    public static final /* enum */ SqlJdbcDataTypeName SQL_BIGINT = new SqlJdbcDataTypeName(SqlTypeName.BIGINT);
    public static final /* enum */ SqlJdbcDataTypeName SQL_REAL = new SqlJdbcDataTypeName(SqlTypeName.REAL);
    public static final /* enum */ SqlJdbcDataTypeName SQL_DOUBLE = new SqlJdbcDataTypeName(SqlTypeName.DOUBLE);
    public static final /* enum */ SqlJdbcDataTypeName SQL_FLOAT = new SqlJdbcDataTypeName(SqlTypeName.FLOAT);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_YEAR = new SqlJdbcDataTypeName(TimeUnitRange.YEAR);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_YEAR_TO_MONTH = new SqlJdbcDataTypeName(TimeUnitRange.YEAR_TO_MONTH);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_MONTH = new SqlJdbcDataTypeName(TimeUnitRange.MONTH);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_DAY = new SqlJdbcDataTypeName(TimeUnitRange.DAY);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_DAY_TO_HOUR = new SqlJdbcDataTypeName(TimeUnitRange.DAY_TO_HOUR);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_DAY_TO_MINUTE = new SqlJdbcDataTypeName(TimeUnitRange.DAY_TO_MINUTE);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_DAY_TO_SECOND = new SqlJdbcDataTypeName(TimeUnitRange.DAY_TO_SECOND);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_HOUR = new SqlJdbcDataTypeName(TimeUnitRange.HOUR);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_HOUR_TO_MINUTE = new SqlJdbcDataTypeName(TimeUnitRange.HOUR_TO_MINUTE);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_HOUR_TO_SECOND = new SqlJdbcDataTypeName(TimeUnitRange.HOUR_TO_SECOND);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_MINUTE = new SqlJdbcDataTypeName(TimeUnitRange.MINUTE);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_MINUTE_TO_SECOND = new SqlJdbcDataTypeName(TimeUnitRange.MINUTE_TO_SECOND);
    public static final /* enum */ SqlJdbcDataTypeName SQL_INTERVAL_SECOND = new SqlJdbcDataTypeName(TimeUnitRange.SECOND);
    private final @Nullable TimeUnitRange range;
    private final @Nullable SqlTypeName typeName;
    private static final /* synthetic */ SqlJdbcDataTypeName[] $VALUES;

    public static SqlJdbcDataTypeName[] values() {
        return (SqlJdbcDataTypeName[])$VALUES.clone();
    }

    public static SqlJdbcDataTypeName valueOf(String name) {
        return Enum.valueOf(SqlJdbcDataTypeName.class, name);
    }

    private SqlJdbcDataTypeName(SqlTypeName typeName) {
        this(typeName, null);
    }

    private SqlJdbcDataTypeName(TimeUnitRange range) {
        this(null, range);
    }

    private SqlJdbcDataTypeName(SqlTypeName typeName, TimeUnitRange range) {
        assert (typeName == null != (range == null));
        this.typeName = typeName;
        this.range = range;
    }

    public SqlNode createDataType(SqlParserPos pos) {
        if (this.typeName != null) {
            assert (this.range == null);
            return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(this.typeName, pos), pos);
        }
        assert (this.range != null);
        return new SqlIntervalQualifier(this.range.startUnit, this.range.endUnit, pos);
    }

    static {
        $VALUES = new SqlJdbcDataTypeName[]{SQL_CHAR, SQL_VARCHAR, SQL_DATE, SQL_TIME, SQL_TIME_WITH_LOCAL_TIME_ZONE, SQL_TIMESTAMP, SQL_TIMESTAMP_WITH_LOCAL_TIME_ZONE, SQL_DECIMAL, SQL_NUMERIC, SQL_BOOLEAN, SQL_INTEGER, SQL_BINARY, SQL_VARBINARY, SQL_TINYINT, SQL_SMALLINT, SQL_BIGINT, SQL_REAL, SQL_DOUBLE, SQL_FLOAT, SQL_INTERVAL_YEAR, SQL_INTERVAL_YEAR_TO_MONTH, SQL_INTERVAL_MONTH, SQL_INTERVAL_DAY, SQL_INTERVAL_DAY_TO_HOUR, SQL_INTERVAL_DAY_TO_MINUTE, SQL_INTERVAL_DAY_TO_SECOND, SQL_INTERVAL_HOUR, SQL_INTERVAL_HOUR_TO_MINUTE, SQL_INTERVAL_HOUR_TO_SECOND, SQL_INTERVAL_MINUTE, SQL_INTERVAL_MINUTE_TO_SECOND, SQL_INTERVAL_SECOND};
    }
}

