/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlAlterMaterializedTable;

public class SqlAlterMaterializedTableRefresh
extends SqlAlterMaterializedTable {
    private final SqlNodeList partitionSpec;

    public SqlAlterMaterializedTableRefresh(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList partitionSpec) {
        super(pos, tableName);
        this.partitionSpec = partitionSpec;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.getTableName(), this.partitionSpec);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("REFRESH");
        if (!this.partitionSpec.isEmpty()) {
            writer.keyword("PARTITION");
            this.partitionSpec.unparse(writer, this.getOperator().getLeftPrec(), this.getOperator().getRightPrec());
        }
    }

    public SqlNodeList getPartitionSpec() {
        return this.partitionSpec;
    }
}

