/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.StringData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;

class StringToNumericPrimitiveCastRule
extends AbstractExpressionCodeGeneratorCastRule<StringData, Number> {
    static final StringToNumericPrimitiveCastRule INSTANCE = new StringToNumericPrimitiveCastRule();

    private StringToNumericPrimitiveCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.CHARACTER_STRING).target(LogicalTypeFamily.INTEGER_NUMERIC).target(LogicalTypeFamily.APPROXIMATE_NUMERIC).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        String trimmedInputTerm = CastRuleUtils.methodCall(inputTerm, "trim", new Object[0]);
        switch (targetLogicalType.getTypeRoot()) {
            case TINYINT: {
                return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_BYTE(), trimmedInputTerm);
            }
            case SMALLINT: {
                return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_SHORT(), trimmedInputTerm);
            }
            case INTEGER: {
                return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_INT(), trimmedInputTerm);
            }
            case BIGINT: {
                return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_LONG(), trimmedInputTerm);
            }
            case FLOAT: {
                return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_FLOAT(), trimmedInputTerm);
            }
            case DOUBLE: {
                return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_DOUBLE(), trimmedInputTerm);
            }
        }
        throw new IllegalArgumentException("This is a bug. Please file an issue.");
    }

    @Override
    public boolean canFail(LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return true;
    }
}

