/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.synchronization;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.base.source.reader.SourceReaderOptions;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Internal
public class FutureCompletingBlockingQueue<T> {
    public static final CompletableFuture<Void> AVAILABLE = FutureCompletingBlockingQueue.getAvailableFuture();
    private final int capacity;
    private CompletableFuture<Void> currentFuture;
    private final Lock lock;
    @GuardedBy(value="lock")
    private final Queue<T> queue;
    @GuardedBy(value="lock")
    private final Queue<Condition> notFull;
    @GuardedBy(value="lock")
    private ConditionAndFlag[] putConditionAndFlags;

    public FutureCompletingBlockingQueue() {
        this((Integer)SourceReaderOptions.ELEMENT_QUEUE_CAPACITY.defaultValue());
    }

    public FutureCompletingBlockingQueue(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"capacity must be > 0");
        this.capacity = capacity;
        this.queue = new ArrayDeque<T>(capacity);
        this.lock = new ReentrantLock();
        this.putConditionAndFlags = new ConditionAndFlag[1];
        this.notFull = new ArrayDeque<Condition>();
        this.currentFuture = new CompletableFuture();
    }

    public CompletableFuture<Void> getAvailabilityFuture() {
        return this.currentFuture;
    }

    public void notifyAvailable() {
        this.lock.lock();
        try {
            this.moveToAvailable();
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void moveToAvailable() {
        CompletableFuture<Void> current = this.currentFuture;
        if (current != AVAILABLE) {
            this.currentFuture = AVAILABLE;
            current.complete(null);
        }
    }

    @GuardedBy(value="lock")
    private void moveToUnAvailable() {
        if (this.currentFuture == AVAILABLE) {
            this.currentFuture = new CompletableFuture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(int threadIndex, T element) throws InterruptedException {
        if (element == null) {
            throw new NullPointerException();
        }
        this.lock.lockInterruptibly();
        try {
            while (this.queue.size() >= this.capacity) {
                if (this.getAndResetWakeUpFlag(threadIndex)) {
                    boolean bl = false;
                    return bl;
                }
                this.waitOnPut(threadIndex);
            }
            this.enqueue(element);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    public T take() throws InterruptedException {
        T next;
        while ((next = this.poll()) == null) {
            try {
                this.getAvailabilityFuture().get();
            }
            catch (CompletionException | ExecutionException e) {
                throw new FlinkRuntimeException("exception in queue future completion", (Throwable)e);
            }
        }
        return next;
    }

    public T poll() {
        this.lock.lock();
        try {
            if (this.queue.size() == 0) {
                this.moveToUnAvailable();
                T t = null;
                return t;
            }
            T t = this.dequeue();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T peek() {
        this.lock.lock();
        try {
            T t = this.queue.peek();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.queue.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.capacity - this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void wakeUpPuttingThread(int threadIndex) {
        this.lock.lock();
        try {
            this.maybeCreateCondition(threadIndex);
            ConditionAndFlag caf = this.putConditionAndFlags[threadIndex];
            if (caf != null) {
                caf.setWakeUp(true);
                caf.condition().signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void enqueue(T element) {
        int sizeBefore = this.queue.size();
        this.queue.add(element);
        if (sizeBefore == 0) {
            this.moveToAvailable();
        }
        if (sizeBefore < this.capacity - 1 && !this.notFull.isEmpty()) {
            this.signalNextPutter();
        }
    }

    @GuardedBy(value="lock")
    private T dequeue() {
        int sizeBefore = this.queue.size();
        T element = this.queue.poll();
        if (sizeBefore == this.capacity && !this.notFull.isEmpty()) {
            this.signalNextPutter();
        }
        if (this.queue.isEmpty()) {
            this.moveToUnAvailable();
        }
        return element;
    }

    @GuardedBy(value="lock")
    private void waitOnPut(int fetcherIndex) throws InterruptedException {
        this.maybeCreateCondition(fetcherIndex);
        Condition cond = this.putConditionAndFlags[fetcherIndex].condition();
        this.notFull.add(cond);
        cond.await();
    }

    @GuardedBy(value="lock")
    private void signalNextPutter() {
        if (!this.notFull.isEmpty()) {
            this.notFull.poll().signal();
        }
    }

    @GuardedBy(value="lock")
    private void maybeCreateCondition(int threadIndex) {
        if (this.putConditionAndFlags.length < threadIndex + 1) {
            this.putConditionAndFlags = Arrays.copyOf(this.putConditionAndFlags, threadIndex + 1);
        }
        if (this.putConditionAndFlags[threadIndex] == null) {
            this.putConditionAndFlags[threadIndex] = new ConditionAndFlag(this.lock.newCondition());
        }
    }

    @GuardedBy(value="lock")
    private boolean getAndResetWakeUpFlag(int threadIndex) {
        this.maybeCreateCondition(threadIndex);
        if (this.putConditionAndFlags[threadIndex].getWakeUp()) {
            this.putConditionAndFlags[threadIndex].setWakeUp(false);
            return true;
        }
        return false;
    }

    private static CompletableFuture<Void> getAvailableFuture() {
        try {
            Class<?> clazz = Class.forName("org.apache.flink.runtime.io.AvailabilityProvider");
            Field field = clazz.getDeclaredField("AVAILABLE");
            return (CompletableFuture)field.get(null);
        }
        catch (Throwable t) {
            return CompletableFuture.completedFuture(null);
        }
    }

    private static class ConditionAndFlag {
        private final Condition cond;
        private boolean wakeUp;

        private ConditionAndFlag(Condition cond) {
            this.cond = cond;
            this.wakeUp = false;
        }

        private Condition condition() {
            return this.cond;
        }

        private boolean getWakeUp() {
            return this.wakeUp;
        }

        private void setWakeUp(boolean value) {
            this.wakeUp = value;
        }
    }
}

