/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPropertiesUtil;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.expressions.DefaultSqlFactory;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ResolvedCatalogTable
implements ResolvedCatalogBaseTable<CatalogTable>,
CatalogTable {
    private final CatalogTable origin;
    private final ResolvedSchema resolvedSchema;

    public ResolvedCatalogTable(CatalogTable origin, ResolvedSchema resolvedSchema) {
        this.origin = (CatalogTable)Preconditions.checkNotNull((Object)origin, (String)"Original catalog table must not be null.");
        this.resolvedSchema = (ResolvedSchema)Preconditions.checkNotNull((Object)resolvedSchema, (String)"Resolved schema must not be null.");
    }

    @Override
    public CatalogTable getOrigin() {
        return this.origin;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    public Map<String, String> toProperties() {
        return this.toProperties(DefaultSqlFactory.INSTANCE);
    }

    public Map<String, String> toProperties(SqlFactory sqlFactory) {
        return CatalogPropertiesUtil.serializeCatalogTable(this, sqlFactory);
    }

    @Override
    public Map<String, String> getOptions() {
        return this.origin.getOptions();
    }

    @Override
    public Schema getUnresolvedSchema() {
        return this.origin.getUnresolvedSchema();
    }

    @Override
    public String getComment() {
        return this.origin.getComment();
    }

    @Override
    public CatalogBaseTable copy() {
        return new ResolvedCatalogTable((CatalogTable)this.origin.copy(), this.resolvedSchema);
    }

    @Override
    public Optional<String> getDescription() {
        return this.origin.getDescription();
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return this.origin.getDetailedDescription();
    }

    @Override
    public boolean isPartitioned() {
        return this.origin.isPartitioned();
    }

    @Override
    public List<String> getPartitionKeys() {
        return this.origin.getPartitionKeys();
    }

    @Override
    public Optional<Long> getSnapshot() {
        return this.origin.getSnapshot();
    }

    @Override
    public Optional<TableDistribution> getDistribution() {
        return this.origin.getDistribution();
    }

    @Override
    public ResolvedCatalogTable copy(Map<String, String> options) {
        return new ResolvedCatalogTable(this.origin.copy(options), this.resolvedSchema);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedCatalogTable that = (ResolvedCatalogTable)o;
        return Objects.equals(this.origin, that.origin) && Objects.equals(this.resolvedSchema, that.resolvedSchema);
    }

    public int hashCode() {
        return Objects.hash(this.origin, this.resolvedSchema);
    }

    public String toString() {
        return "ResolvedCatalogTable{origin=" + this.origin + ", resolvedSchema=" + this.resolvedSchema + "}";
    }
}

