/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ValueLiteralExpression;

@Internal
public final class ExpressionUtils {
    public static <V> Optional<V> extractValue(Expression expression, Class<V> targetClass) {
        if (expression instanceof ValueLiteralExpression) {
            ValueLiteralExpression valueLiteral = (ValueLiteralExpression)expression;
            return valueLiteral.getValueAs(targetClass);
        }
        return Optional.empty();
    }

    public static String stringValue(Expression expression) {
        return ((ValueLiteralExpression)expression).getValueAs(String.class).orElse(null);
    }

    private ExpressionUtils() {
    }
}

