/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.table;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.datagen.table.DataGenConnectorOptions;
import org.apache.flink.connector.datagen.table.DataGenTableSource;
import org.apache.flink.connector.datagen.table.DataGeneratorContainer;
import org.apache.flink.connector.datagen.table.RandomGeneratorVisitor;
import org.apache.flink.connector.datagen.table.SequenceGeneratorVisitor;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;

@Internal
public class DataGenTableSourceFactory
implements DynamicTableSourceFactory {
    public static final String IDENTIFIER = "datagen";

    @Override
    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(DataGenConnectorOptions.ROWS_PER_SECOND);
        options.add(DataGenConnectorOptions.NUMBER_OF_ROWS);
        options.add(DataGenConnectorOptions.SOURCE_PARALLELISM);
        options.add(DataGenConnectorOptions.FIELD_KIND);
        options.add(DataGenConnectorOptions.FIELD_MIN);
        options.add(DataGenConnectorOptions.FIELD_MAX);
        options.add(DataGenConnectorOptions.FIELD_MAX_PAST);
        options.add(DataGenConnectorOptions.FIELD_LENGTH);
        options.add(DataGenConnectorOptions.FIELD_START);
        options.add(DataGenConnectorOptions.FIELD_END);
        options.add(DataGenConnectorOptions.FIELD_NULL_RATE);
        options.add(DataGenConnectorOptions.FIELD_VAR_LEN);
        return options;
    }

    @Override
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        String name;
        Configuration options = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)options).setString(arg_0, arg_1));
        DataType rowDataType = context.getPhysicalRowDataType();
        DataGenerator[] fieldGenerators = new DataGenerator[DataType.getFieldCount(rowDataType)];
        HashSet optionalOptions = new HashSet();
        List<String> fieldNames = DataType.getFieldNames(rowDataType);
        List<DataType> fieldDataTypes = DataType.getFieldDataTypes(rowDataType);
        for (int i = 0; i < fieldGenerators.length; ++i) {
            name = fieldNames.get(i);
            DataType type = fieldDataTypes.get(i);
            ConfigOption kind = ConfigOptions.key((String)("fields." + name + ".kind")).stringType().defaultValue((Object)"random");
            DataGeneratorContainer container = this.createContainer(name, type, (String)options.get(kind), (ReadableConfig)options);
            fieldGenerators[i] = container.getGenerator();
            optionalOptions.add(kind);
            optionalOptions.addAll(container.getOptions());
        }
        FactoryUtil.validateFactoryOptions(this.requiredOptions(), optionalOptions, (ReadableConfig)options);
        HashSet<String> consumedOptionKeys = new HashSet<String>();
        consumedOptionKeys.add(FactoryUtil.CONNECTOR.key());
        consumedOptionKeys.add(DataGenConnectorOptions.ROWS_PER_SECOND.key());
        consumedOptionKeys.add(DataGenConnectorOptions.NUMBER_OF_ROWS.key());
        consumedOptionKeys.add(DataGenConnectorOptions.SOURCE_PARALLELISM.key());
        optionalOptions.stream().map(ConfigOption::key).forEach(consumedOptionKeys::add);
        FactoryUtil.validateUnconsumedKeys(this.factoryIdentifier(), options.keySet(), consumedOptionKeys);
        name = context.getObjectIdentifier().toString();
        return new DataGenTableSource(fieldGenerators, name, rowDataType, (Long)options.get(DataGenConnectorOptions.ROWS_PER_SECOND), (Long)options.get(DataGenConnectorOptions.NUMBER_OF_ROWS), options.getOptional(DataGenConnectorOptions.SOURCE_PARALLELISM).orElse(null));
    }

    private DataGeneratorContainer createContainer(String name, DataType type, String kind, ReadableConfig options) {
        switch (kind) {
            case "random": {
                this.validateFieldOptions(name, type, options);
                return type.getLogicalType().accept(new RandomGeneratorVisitor(name, options));
            }
            case "sequence": {
                return type.getLogicalType().accept(new SequenceGeneratorVisitor(name, options));
            }
        }
        throw new ValidationException("Unsupported generator kind: " + kind);
    }

    private void validateFieldOptions(String name, DataType type, ReadableConfig options) {
        ConfigOption varLenOption = ConfigOptions.key((String)("fields." + name + ".var-len")).booleanType().defaultValue((Object)false);
        options.getOptional(varLenOption).filter(option -> option).ifPresent(option -> {
            LogicalType logicalType = type.getLogicalType();
            if (!(logicalType instanceof VarCharType) && !(logicalType instanceof VarBinaryType)) {
                throw new ValidationException(String.format("Only supports specifying '%s' option for variable-length types (VARCHAR/STRING/VARBINARY/BYTES). The type of field '%s' is not within this range.", DataGenConnectorOptions.FIELD_VAR_LEN.key(), name));
            }
        });
        ConfigOption lenOption = ConfigOptions.key((String)("fields." + name + ".length")).intType().noDefaultValue();
        options.getOptional(lenOption).ifPresent(option -> {
            LogicalType logicalType = type.getLogicalType();
            if (logicalType instanceof CharType || logicalType instanceof BinaryType) {
                throw new ValidationException(String.format("Custom length for fixed-length type (CHAR/BINARY) field '%s' is not supported.", name));
            }
            if (logicalType instanceof VarCharType || logicalType instanceof VarBinaryType) {
                int length;
                int n = length = logicalType instanceof VarCharType ? ((VarCharType)logicalType).getLength() : ((VarBinaryType)logicalType).getLength();
                if (option > length) {
                    throw new ValidationException(String.format("Custom length '%d' for variable-length type (VARCHAR/STRING/VARBINARY/BYTES) field '%s' should be shorter than '%d' defined in the schema.", option, name, length));
                }
            }
        });
    }
}

